# $Progeny: main.py,v 1.57 2002/03/29 20:30:52 jlicquia Exp $

import gettext
import os
import configlet
import re
import time
import tempfile

#_cat = gettext.Catalog(PACKAGE, LOCALEDIR)
#_ = _cat.gettext
def _(s):
    return s

def update_combo(combo, text):
    for item in combo.list.children():
        if item.children()[0].get() == text:
            combo.list.select_child(item)
            break

#def hour_changed(*args):
#    pass
#
#def minute_changed(*args):
#    TimeConfiglet.fix_time(TimeConfiglet.wtree.get_widget("buttonmin"))
#
#def second_changed(*args):
#    TimeConfiglet.fix_time(TimeConfiglet.wtree.get_widget("buttonsec"))

def update_clock_label(*args):
    TimeConfiglet.update_clock_label()

def set_time(*args):
    TimeConfiglet.set_time()

def set_zones(*args):
    TimeConfiglet.set_zones()

def update_utc(*args):
    TimeConfiglet.update_utc()

def ampm_change(*args):
    TimeConfiglet.ampm = args[-1]

def set_current_timezone(*args):
    TimeConfiglet.set_current_timezone()

class Time(configlet.Configlet):
    def __init__(self, dir):
        self.ignore_list = ["right", "posix", "SystemV", "Mideast"]
        self.region = ""
        self.zone = ""
        self.timer_id = 0
        self.zonelist = {}
        self.ntp = 0

        configlet.Configlet.__init__(self, dir)

    def gnome_setup(self):
        configlet.Configlet.gnome_setup(self)

        global gtk
        import gtk

        global TimeConfiglet
        TimeConfiglet = self

        # shut off DPMS and screen saver functions so time warps don't shut
        # off or blank the screen
        os.system("/usr/bin/X11/xset -dpms s off")

        timer_id = gtk.timeout_add(1000, self.update_clock_label)

        for zonedir in os.listdir("/usr/share/zoneinfo"):
            if zonedir in self.ignore_list:
                continue
            zonedir_path = "/usr/share/zoneinfo/%s" % (zonedir,)
            if not os.path.isdir(zonedir_path):
                continue
            for zonefile in os.listdir(zonedir_path):
                zonefile_path = "%s/%s" % (zonedir_path, zonefile)
                if not os.path.isfile(zonefile_path):
                    continue
                zonedir = re.sub("_", " ", zonedir)
                if not self.zonelist.has_key(zonedir):
                    self.zonelist[zonedir] = []
                self.zonelist[zonedir].append(re.sub("_", " ", zonefile))

        for zonedir in self.zonelist.keys():
            self.zonelist[zonedir].sort()

        self.wtree.signal_autoconnect({
#            "on_buttonmin_changed": minute_changed,
#            "on_buttonsec_changed": second_changed,
            "on_buttonsettime_clicked": set_time,
            "on_entryregion_changed": set_zones,
            "on_utc_checkbox_toggled": update_utc
            })

        self.wtree.get_widget("menuampm").get_menu().children()[0].connect(
            "activate", ampm_change, "am")
        self.wtree.get_widget("menuampm").get_menu().children()[1].connect(
            "activate", ampm_change, "pm")

        zonelist_regions = self.zonelist.keys()
        zonelist_regions.sort()
        self.wtree.get_widget("comboregion").set_popdown_strings(
            zonelist_regions)

        # set up the timezone widgets

        # these are the fallback defaults
        self.region = "US"
        self.zone = "East-Indiana"

##        self.wtree.get_widget("comboregion").entry.set_text(region)
##        self.wtree.get_widget("combozone").entry.set_text(zone)
        self.wtree.get_widget("ntpframe").hide()
        update_combo(self.wtree.get_widget("comboregion"), self.region)
        update_combo(self.wtree.get_widget("combozone"), self.zone)

        self.set_current_timezone()
        self.set_time_widgets()

    def on_gnome_close(self):
        self.settings = {}
        sw = self.wtree
        self.settings["toplevel"] = sw.get_widget("comboregion").entry.get_text()
        self.settings["zone"] = sw.get_widget("combozone").entry.get_text()
        self.settings["ntp"] = sw.get_widget("entryntp").get_text()
        os.system("/usr/bin/X11/xset +dpms s on")

    def load_debconf(self, data):
        for dataline in data:
            (template, question, value) = re.split(r'\s', dataline, 2)
            if value == '""':
                value = ""

            if template == "timezoneconf/toplevel":
                self.debug("Setting timezoneconf/toplevel")
                if value in self.zonelist.keys():
                    value = re.sub("_", " ", value)
                    update_combo(self.wtree.get_widget("comboregion"), value)
                    self.region = value
            if template == "timezoneconf/zone":
                self.debug("Setting timezoneconf/zone to %s" % value)
                key = self.wtree.get_widget("comboregion").entry.get_text()
                if value in self.zonelist[key]:
                    value = re.sub("_", " ", value)
                    update_combo(self.wtree.get_widget("combozone"), value)
                    self.zone = value
            elif template == "shared/ntp/servers":
                self.debug("Setting shared/ntp/servers")
                self.wtree.get_widget("entryntp").set_text(value)
                self.ntp = 1
                self.wtree.get_widget("ntpframe").show()
            else:
                continue

        # whether or not to use UTC is not stored in debconf; shame, shame
        if os.system("grep -qs '^UTC=yes' /etc/default/rcS"):
            self.debug("setting self.utc to 0")
            self.utc = 0
            self.wtree.get_widget("utc_checkbox").set_active(gtk.FALSE)
        else:
            self.debug("setting self.utc to 1")
            self.utc = 1
            self.wtree.get_widget("utc_checkbox").set_active(gtk.TRUE)

        # update our sense of the current timezone
        self.set_current_timezone()
        self.set_time_widgets()

    def report_debconf(self):
        # HACKHACKHACK
        # Debconf runs your config script behind your back when the
        # postinst is called.  The config scripts of the ntp packages
        # clobber shared/ntp/servers with the value found in
        # /etc/default/ntp-servers.  Store the data there too, to make
        # sure everything is still kosher.
        if self.ntp:
            file = open("/etc/default/ntp-servers", "w")
            file.write("NTPSERVERS=\"%s\"\n" % (self.settings["ntp"],))
            file.close()

        results = []

        if self.ntp:
            results.append("shared/ntp/update-conf shared/ntp/update-conf true")
            results.append("shared/ntp/servers shared/ntp/servers %s" %
                           re.sub(" ", "_", self.settings["ntp"]))

        results.append("timezoneconf/toplevel timezoneconf/toplevel %s" %
            re.sub(" ", "_", self.settings["toplevel"]))
        results.append("timezoneconf/zone timezoneconf/zone %s" %
            re.sub(" ", "_", self.settings["zone"]))

        # again, whether or not to use UTC is not stored in debconf; shame, shame

        temp_rcs_name = tempfile.mktemp()
        temp_rcs = open(temp_rcs_name, "w")
        in_rcs = open("/etc/default/rcS")
        rcs_changed = 0

        if self.utc:
            self.debug("setting UTC=yes in /etc/default/rcS")
            utc_from = r'^UTC=no'
            utc_to = "UTC=yes"
        else:
            self.debug("setting UTC=no in /etc/default/rcS")
            utc_from = r'^UTC=yes'
            utc_to = "UTC=no"

        for line in in_rcs.readlines():
            newline = re.sub(utc_from, utc_to, line)
            if line != newline:
                rcs_changed = 1
            temp_rcs.write(newline)

        in_rcs.close()
        temp_rcs.close()

        if rcs_changed:
            # the files differ
            self.debug("replacing existing /etc/default/rcS file")
            configlet.privileged_run("/bin/cp %s /etc/default/rcS" % temp_rcs_name)
        else:
            self.debug("/etc/default/rcS has not changed")

        os.unlink(temp_rcs_name)

        #gtk.timeout_remove(timer_id)
        return results

    def set_time_widgets(self):
        # set widgets to currently reported system time

        (year, month, monthday, hour, minute, second, weekday, day, dst) = \
            time.localtime(time.time())

        # stupid GTK calendar widget has 0-based month index
        self.wtree.get_widget("calendar").select_month(month - 1, year)
        self.wtree.get_widget("calendar").select_day(monthday)

        # mangle hour into 12-hour plus AM/PM
        if hour < 12:
            self.wtree.get_widget("menuampm").set_history(0) # AM
            self.ampm = "am"
            if hour == 0:
                mangled_hour = 12
            else:
                mangled_hour = hour
        else:
            self.wtree.get_widget("menuampm").set_history(1) # PM
            self.ampm = "pm"
            mangled_hour = hour - 12

        self.wtree.get_widget("buttonhour").set_value(mangled_hour)
        self.wtree.get_widget("buttonmin").set_value(minute)
        self.wtree.get_widget("buttonsec").set_value(second)
        # take care of leading zeroes if necessary
        #minute_changed()
        #second_changed()

    def update_clock_label(self):
        self.set_current_timezone()
        self.wtree.get_widget("clock_label").set_text("Local time: " + time.strftime("%A, %B %d, %Y  %I:%M:%S %p", time.localtime(time.time())))
        return gtk.TRUE

    def fix_time(self, widget):
        "do zero padding of single-digit minutes and seconds"
        value = widget.get_value_as_int()
        text = widget.get_text()
        if value < 10 and len(text) < 2:
            widget.set_text("%02i" % (value,))
            # FIXME: (cosmetic) Make set_position work if possible(?)
            widget.set_position(-1)

    def set_time(self):
        "set the system clock according to date, time, and timezone widgets"
        # push timezone to environment
        self.set_current_timezone()
        (year, month, day) = self.wtree.get_widget("calendar").get_date()
        month = month + 1
        hour = self.wtree.get_widget("buttonhour").get_value_as_int()
        minute = self.wtree.get_widget("buttonmin").get_value_as_int()
        second = self.wtree.get_widget("buttonsec").get_value_as_int()
        ampm = self.ampm
        self.debug("setting system clock to TZ=%s "% os.environ["TZ"] + \
                   'date -s "%i-%02i-%02i %i:%02i:%02i%s"' \
                   % (year, month, day, hour, minute, second, ampm))
        configlet.privileged_run('/bin/sh -c \'TZ=%s date -s "%i-%02i-%02i %i:%02i:%02i%s"\'' %
            (os.environ["TZ"], year, month, day, hour, minute, second, ampm))

    def set_zones(self):
        "set list of zones in zone combo widget corresponding to entered region"
        value = self.wtree.get_widget("comboregion").entry.get_text()
        self.wtree.get_widget("combozone").set_popdown_strings(
            self.zonelist[value])

    def update_utc(self):
        "update state of UTC flag"
        self.utc = self.wtree.get_widget("utc_checkbox").get_active()
        self.debug("self.utc is now %d" % self.utc)

    def set_current_timezone(self):
        "set current timezone in TZ environment variable format"
        self.region = self.wtree.get_widget("comboregion").entry.get_text()
        self.zone = self.wtree.get_widget("combozone").entry.get_text()
        #self.debug("setting environment variable TZ to %s" % re.sub(r' ', '_', '%s/%s' % (self.region, self.zone)))
        os.environ["TZ"] = re.sub(r' ', '_', '%s/%s' % (self.region, self.zone))

_attrs = { "name": "timezoneconf",
           "display_title": _("Set Date and Time"),
           "description": _("Select this option to set the date, time, and timezone on your system."),
           "packages": ["timezoneconf", "ntp-refclock", "ntp-simple",
                        "ntpdate"],
           "shared_questions": ["shared/ntp/servers",
                                "shared/ntp/update-conf"]
}

configlet.register_configlet(Time, _attrs)

# vim:ai:et:sts=4:sw=4:tw=0:
