import dbus
import dbus.service

DBUS_INTERFACE_NAMESPACE = 'net.sourceforge.timerapplet.TimerApplet.TimerManager'

class TimerManagerService(dbus.service.Object):
    def __init__(self, bus_name, object_path):
        dbus.service.Object.__init__(self,
                                     dbus.service.BusName(bus_name, bus=dbus.SessionBus()),
                                     object_path)
        self._timer_id_list = []

    def create_and_register_timer_id(self):
        timer_id = str(uuid.uuid4())
        self.register_timer_id(timer_id)
        return timer_id

    def register_timer_id(self, timer_id):
        self._timer_id_list.append(timer_id)

    def unregister_timer_id(self, timer_id):
        self._timer_id_list.remove(timer_id)

    @dbus.service.method(dbus_interface=DBUS_INTERFACE_NAMESPACE, out_signature='as')
    def GetTimerIDList(self):
        return self._timer_id_list
