/*  tilp - a linking program for TI graphing calculators
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "struct.h"
#include "gstruct.h"
#include "defs.h"
#include "files.h"
#include "vars.h"
#include "gxpm.h"
#include "select.h"

/* 
   Note: callbacks are in gtk_tilp_cb.c 
*/

/* Load a TI font */
GdkFont* load_ti_font()
{
  GdkFont *font = NULL;
  
#if defined(__LINUX__)
  font = gdk_font_load("-lpg-tixx-calc-r-expanded--10-100-75-75-m-80-iso8859-1");
#elif defined(__WIN32__)
  /*
    Thank to Timothy Singer for her fonts. Timothy Singer is the developper 
    of FastLink, another linking program for Windows.
  */
  /*
    switch(options.lp.calc_type)
    {
    case CALC_TI82:
    case CALC_TI83:
    case CALC_TI83P:
    font = gdk_font_load("-*-Fastlink TI%2d83-normal-r-normal--*-13-*-*-m-*-iso8859-1");
    break;
    case CALC_TI85:
    case CALC_TI86:
    font = gdk_font_load("-*-Fastlink TI%2d86-normal-r-normal--*-13-*-*-m-*-iso8859-1");
    break;
    case CALC_TI89:
    case CALC_TI92:
    case CALC_TI92P:
    font = gdk_font_load("-*-Fastlink TI%2d89-normal-r-normal--*-13-*-*-m-*-iso8859-1");
    break;
    }
  */
#endif

  return font;
}


/* Refresh the ctree */
void refresh_ctree()
{
  GdkPixmap *pixmap1, *pixmap2, *pixmap3, *pixmap4; 
  GdkPixmap *pixmap5, *pixmap6, *pixmap7;
  GdkBitmap *mask1, *mask2, *mask3, *mask4;
  GdkBitmap *mask5, *mask6, *mask7;
  GtkCTreeNode *vars_node = NULL;
  GtkCTreeNode *apps_node = NULL;
  GtkCTreeNode *parent_node = NULL;
  GtkCTreeNode *child_node = NULL;
  GtkStyle *style;
  GdkFont *font;
  GList *p;
  struct varinfo *q;
  gchar *tab[4] = { 0 };
  int i;
  gchar *prev_app = g_strdup("");

  gchar *vars[] = { N_("Variables"), N_(""), N_(""), N_("") };
  gchar *apps[] = { N_("Applications"), N_(""), N_(""), N_("") };

  // Load font
  tab[1]=NULL;    
  style = gtk_style_copy(GTK_WIDGET(ctree_wnd)->style);
  font = load_ti_font();
  if(font != NULL)
    style->font = font;
  else
    DISPLAY(_("** Warning: unable to load the 'tifont' font. Use default font instead.\n"));  

  // Sort variables
  switch(options.ctree_sort)
    {
    case SORT_BY_NAME:
      sort_cfiles_by_name(ctree_win.varlist);
      break;
    case SORT_BY_INFO:
      sort_cfiles_by_info(ctree_win.varlist);
      break;
    case SORT_BY_TYPE:
      sort_cfiles_by_type(ctree_win.varlist);
      break;
    case SORT_BY_SIZE:
      sort_cfiles_by_size(ctree_win.varlist);
      break;
    }

  gtk_clist_freeze(GTK_CLIST (ctree_wnd));
  gtk_clist_clear(GTK_CLIST (ctree_wnd));
  gtk_widget_realize(main_wnd);

  // Load pixmaps
  open_xpm("dir_closed.xpm",         main_wnd, &pixmap1, &mask1);
  open_xpm("dir_opened.xpm",         main_wnd, &pixmap3, &mask3);
  open_xpm("doc.xpm",           main_wnd, &pixmap2, &mask2);
  open_xpm("locked.xpm",        main_wnd, &pixmap4, &mask4);
  open_xpm("archived.xpm",      main_wnd, &pixmap5, &mask5);
  open_xpm("screen_mini.xpm",   main_wnd, &pixmap6, &mask6);
  open_xpm("keyboard_mini.xpm", main_wnd, &pixmap7, &mask7);

  // Variables
  vars_node=gtk_ctree_insert_node (GTK_CTREE (ctree_wnd), NULL, NULL, vars, 
				   5, pixmap1, mask1, pixmap2, mask2, 
				   FALSE, TRUE);
  gtk_ctree_node_set_row_data (GTK_CTREE(ctree_wnd), vars_node, 
			       (gpointer)NULL);
  gtk_ctree_node_set_selectable(GTK_CTREE(ctree_wnd), vars_node, 0);

  // Applications
  apps_node=gtk_ctree_insert_node (GTK_CTREE (ctree_wnd), NULL, NULL, apps, 
				   5, pixmap1, mask1, pixmap2, mask2, 
				   FALSE, TRUE);
  gtk_ctree_node_set_row_data (GTK_CTREE(ctree_wnd), apps_node, 
			       (gpointer)NULL);
  gtk_ctree_node_set_selectable(GTK_CTREE(ctree_wnd), apps_node, 0);
  
  // Variables tree
  p=ctree_win.varlist;
  parent_node = vars_node;
  while(p != NULL)
    {
      q=(struct varinfo *)(p->data);

      /* Skip varnames with FLASH apps */
      if(q->vartype ==  ticalc_flash_type(options.lp.calc_type))
	{
	  p=p->next;
	  continue;
	}
      tab[0] = g_strdup(q->translate);
      if(q->is_folder == FOLDER)
	{
	  tab[2]=NULL;
	  tab[3]=NULL;
	  parent_node=gtk_ctree_insert_node (GTK_CTREE (ctree_wnd), vars_node,
					     NULL, tab, 5, 
					     pixmap1, mask1, pixmap3, mask3, 
					     FALSE, TRUE);
	  gtk_ctree_node_set_row_data (GTK_CTREE(ctree_wnd), parent_node, 
				       (gpointer)q);
	  gtk_ctree_node_set_selectable(GTK_CTREE(ctree_wnd), parent_node, 0);
	}
      else
	{
	  tab[2] = g_strdup_printf("%s", ti_calc.byte2type(q->vartype));
	  tab[3] = g_strdup_printf("%u", (int)(q->varsize));
	  child_node=gtk_ctree_insert_node(GTK_CTREE (ctree_wnd), parent_node,
					   NULL, tab, 5, 
					   pixmap1, mask1, pixmap2, mask2, 
					   FALSE, TRUE);
	  switch(q->varattr)
	    {
	    case VARATTR_LOCK:
	      gtk_ctree_node_set_pixmap(GTK_CTREE (ctree_wnd), 
					child_node, 1, pixmap4, mask4);
	      break;
	    case VARATTR_ARCH:
	      gtk_ctree_node_set_pixmap(GTK_CTREE (ctree_wnd), 
					child_node, 1, pixmap5, mask5);
	      break;
	    }
	  gtk_ctree_node_set_row_data (GTK_CTREE(ctree_wnd), 
				       child_node, (gpointer)q);
	  gtk_ctree_node_set_cell_style(GTK_CTREE(ctree_wnd), 
					child_node, 0, style);
	}
      
      p = p->next;
      for(i=0; i<4; i++) g_free(tab[i]);
    }

  // Applications tree
  p=ctree_win.varlist;
  parent_node=apps_node;
  while(p != NULL)
    {
      q=(struct varinfo *)(p->data);

      /* Skip varnames which are not FLASH apps */
      if(q->vartype != ticalc_flash_type(options.lp.calc_type))
	{
	  p=p->next;
	  continue;
	}
      if(!strcmp(q->translate, prev_app))
	{
	  p=p->next;
	  continue;
	}

      tab[0] = g_strdup(q->translate);
      g_free(prev_app); prev_app = g_strdup(q->translate);

      tab[2] = g_strdup_printf("%s", ti_calc.byte2type(q->vartype));
      tab[3] = g_strdup_printf("%u", (int)(q->varsize));
      child_node=gtk_ctree_insert_node(GTK_CTREE (ctree_wnd), parent_node,
				       NULL, tab, 5, 
				       pixmap1, mask1, pixmap2, mask2, 
				       FALSE, TRUE);
      switch(q->varattr)
	{
	case VARATTR_LOCK:
	  gtk_ctree_node_set_pixmap(GTK_CTREE (ctree_wnd), 
				    child_node, 1, pixmap4, mask4);
	  break;
	case VARATTR_ARCH:
	  gtk_ctree_node_set_pixmap(GTK_CTREE (ctree_wnd), 
				    child_node, 1, pixmap5, mask5);
	  break;
	}
      gtk_ctree_node_set_row_data (GTK_CTREE(ctree_wnd), 
				   child_node, (gpointer)q);
      gtk_ctree_node_set_cell_style(GTK_CTREE(ctree_wnd), 
				    child_node, 0, style);
      
      p = p->next;
      for(i=0; i<4; i++) g_free(tab[i]);
    }
  
  gdk_pixmap_unref(pixmap1);
  gdk_pixmap_unref(pixmap2);
  gdk_pixmap_unref(pixmap3);
  gdk_pixmap_unref(pixmap4);
  gdk_pixmap_unref(pixmap5);

  gtk_clist_thaw(GTK_CLIST (ctree_wnd));
}


/* Refresh the selection of the ctree window */
void ctree_selection_refresh(void)
{
  GList *p;
  gint row;
  GList *s1, *s2;
  
  s1 = g_list_copy(ctree_win.selection);
  s2 = g_list_copy(ctree_win.selection2);
  /*
  DISPLAY("ctree_selection_refresh\n");
  for(i=0; i<g_list_length(s1); i++)
    {
      p = g_list_nth(ctree_win.selection, i);
      DISPLAY("varname=%s\n", ((VariableInfo *)(p->data))->varname);
      DISPLAY("%p %p %p\n", p->prev, p->data, p->next);
    }
  */
  if(ctree_wnd == NULL)  return;
  gtk_clist_unselect_all(GTK_CLIST(ctree_wnd));
  ctree_selection_destroy();

  // Variables
  p = s1;
  while(p != NULL)
    {
      row=gtk_clist_find_row_from_data(GTK_CLIST (ctree_wnd), p->data);
      
      if(row == -1)
	{
	  fprintf(stderr, "Context debugging:\n");
          fprintf(stderr, "Filename: %s\n", ((struct file_info *)(p->data))->filename);
	  fprintf(stderr, "Selection error: please report this bug.\n");
	}
      gtk_clist_select_row(GTK_CLIST (ctree_wnd), row, 1);
      
      p = g_list_next(p);
    }

  // Applications
  p = s2;
  while(p != NULL)
    {
      row=gtk_clist_find_row_from_data(GTK_CLIST (ctree_wnd), p->data);
      if(row == -1)
	{
	  fprintf(stderr, "Context debugging:\n");
          fprintf(stderr, "Filename: %s\n", ((struct file_info *)(p->data))->filename);
	  fprintf(stderr, "Selection error: please report this bug.\n");
	}
      gtk_clist_select_row(GTK_CLIST (ctree_wnd), row, 1);
      
      p = g_list_next(p);
    }

  return;
}


