/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This piece of code is used to modify the /etc/X11/fs/config file and
  to restart the X Font Server.
  I did not found a program or a command for adding a font the system
  and update consequently the xfs config file. Then, I decided to write
  a such program.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#define XFS_CFG_PATH        "/usr/X11R6/lib/X11/fs"
#define XFS_CFG_PATH_REDHAT "/etc/X11/fs/"
#define XFS_CFG_PATH_DEBIAN "/etc/X11/xfs/"

#define XFS_CFG_FILE        "config"
#define XFS_CFG             XFS_CFG_PATH        XFS_CFG_FILE
#define XFS_CFG_REDHAT      XFS_CFG_PATH_REDHAT XFS_CFG_FILE
#define XFS_CFG_DEBIAN      XFS_CFG_PATH_DEBIAN XFS_CFG_FILE

#define MAXCHARS     256

int main(int argc, char **argv, char **arge)
{
  FILE *in;
  FILE *out;
  int c;
  char buffer[256];
  FILE *p;
  pid_t pid;
  char *s;
  char filename[256];
  char tmp_filename[256];
  char old_filename[256];
  
  /* At first, determine the right file at the right place  */
  strcpy(filename, XFS_CFG);
  if( access(filename, F_OK) != 0)
    {
      strcpy(filename, XFS_CFG_REDHAT);
      if( access(filename, F_OK) != 0 )
	{
	  strcpy(filename, XFS_CFG_DEBIAN);
	  if( access(filename, F_OK) != 0 )
	    {
	      fprintf(stderr, "Unable to find the xfs config file.\n");
	      fprintf(stderr, "Program aborted.\n");
	      exit(-1);
	    }
	}
    }
  fprintf(stdout, "-> xfs config file: <%s>\n", filename);
  //exit(0);

  fprintf(stdout, "-> Checking if the file has been already modified... ");
  in = fopen(filename, "rt");
  if(in == NULL)
    {
      fprintf(stderr, "Unable to open this file: %s\n", filename);
      exit(-1);
    }
  
  /* Modify the file */
  while(!feof(in))
    {
      fgets(buffer, 256, in);
      if(strstr(buffer, "ticalcs") != NULL)
	{
	  fprintf(stdout, "Yes !\n");
	  fprintf(stdout, "No modifications made.\n");
	  fprintf(stdout, "Exiting.\n");

	  fclose(in);
	  exit(0);
	}
    }
  fprintf(stdout, "No.\n");
  fprintf(stdout, "-> Then, modifying the file... ");
  
  rewind(in);
  
  strcpy(buffer, filename);
  strcat(buffer, ".tmp");

  out = fopen(buffer, "wt");
  if(out == NULL)
    {
      fprintf(stderr, "Unable to open this file: %s\n", buffer);
      exit(-1);
    }

  while(!feof(in))
    {
      fgets(buffer, 256, in);
      if(feof(in)) break;
      fputs(buffer, out);
      buffer[strlen(buffer)] = '\0';
      //fprintf(stdout, "<%s>\n", buffer);
      // search the catalogue entry
      if(strstr(buffer, "catalogue") != NULL)
        {
	  // search the last line of the catalogue entry
	  for(;;)
	    {
	      fgets(buffer, 256, in);	
	      //fprintf(stdout, "<%s>\n", buffer);
	     
	      if(buffer[strlen(buffer) - 2] == ',')
		{
		  // not the last line
		  fputs(buffer, out);
                  continue;
		}
	      else
		{
		  // this is the last line
		  buffer[strlen(buffer) - 1] = '\0';
		  strcat(buffer, ",\n");
		  fputs(buffer, out);
		  
		  // add our entry
		  fprintf(out, "\t/usr/X11R6/lib/X11/fonts/ticalcs\n");
		  break;
		}
	    }	  
        }
    }  
  fprintf(stdout, "Done.\n");
  fclose(in);
  fclose(out);

  fprintf(stdout, "-> Backup the file... ");
  strcpy(tmp_filename, filename);
  strcat(tmp_filename, ".tmp");
  strcpy(old_filename, filename);
  strcat(old_filename, ".old");

  rename(filename, old_filename);
  rename(tmp_filename, filename);
  fprintf(stdout, "Done.\n");
  fprintf(stdout, "Your previous XFS config file has been saved into 'config.old'.\n");

  fprintf(stdout, "-> Now, force the server to re-read its configuration file...\n");
  p = popen("pstree -p", "r");
  if(p == NULL)
    {
      fprintf(stdout, "Unable to get the XFS pid.\n");
      fprintf(stdout, "You will have to do it yourself.\n");
      exit(-1);
    }

  while(!feof(p))
    {
      fgets(buffer, 256, p);
      if(strstr(buffer, "xfs") != NULL)
	{
	  //fprintf(stdout, "<%s>\n", buffer);
	  s = strstr(buffer, "(");
	  s++;
	  sscanf(s, "%i", &pid);
	  //fprintf(stdout, "pid: %i\n", pid);

	  break;
	}
    }
  pclose(p);

  fprintf(stdout, "Sending signal SIGUSR1 to X Font Server, pid=%i.\n", pid);
  if(kill(pid, SIGUSR1) == -1)
    {
      fprintf(stderr, "Unable to send signal.\n");
      fprintf(stderr, "Try do it yourself.\n");
      exit(-1);
    }
  fprintf(stdout, "Done.\n");

  return 0;
}
