#include <stdio.h>
#include <jvmti.h>
#include <tijmp.h>
#include <tijmp_TIJMPController.h>

static JNINativeMethod registry[6] = {
    {"runGC", "()V", (void*)&TIJMPController_runGC},
    {"walkHeap", "()V", (void*)&TIJMPController_walkHeap},
    {"showInstances", "(Ljava/lang/Class;)V", 
     (void*)&TIJMPController_showInstances},
    {"showOwners", "(Ljava/lang/Class;)V", 
     (void*)&TIJMPController_showOwners},
    {"childObjectsSummary", "(Ljava/lang/Object;)V", 
     (void*)&TIJMPController_childObjectsSummary},
    {"getObjectsForTags", "([J)[Ljava/lang/Object;", 
     (void*)&TIJMPController_getObjectsForTags}
};

void JNICALL VMInit (jvmtiEnv *jvmti, JNIEnv* jni_env, jthread thread) {
    jmethodID m_init;
    jclass cls;
    jint rc;
    
    tijmp_vm_inited ();
    cls = (*jni_env)->FindClass (jni_env, "tijmp/TIJMPController");
    if (!cls) {
	fprintf (stdout, "Failed to find java classes, will not run\n");
	return;
    } 

    /* register native methods */
    rc = (*jni_env)->RegisterNatives (jni_env, cls, registry, 6);
    if (rc != 0) {
	fprintf (stdout, 
		 "Failed to register native methos, will probably crash: %d\n",
		 rc);
    }

    fprintf (stdout, "Trying to call java gui init()\n");
    
    /* Init java gui */
    m_init = (*jni_env)->GetStaticMethodID (jni_env, cls, "init", "()V");
    (*jni_env)->CallStaticVoidMethod (jni_env, cls, m_init);
}
