package tijmp.actions;

import java.awt.event.ActionEvent;
import tijmp.filter.AndFilter;
import tijmp.filter.ExactFilter;
import tijmp.filter.Filter;
import tijmp.filter.NotFilter;
import tijmp.ui.FilterConfig;
import tijmp.ui.Translator;

/** A class that filters out one specific class.
 */
public class FilterOutClass extends FilterAction {
    private Class<?> clz;
    public FilterOutClass (FilterConfig fc, Class<?> clz) {
	super ("Filter out " + Translator.translate (clz, null), fc);
	this.clz = clz;
    }
    
    public void actionPerformed (ActionEvent e) {
	FilterConfig fc = getFilterConfig ();
	Filter f = fc.getFilter ();
	ExactFilter rf = new ExactFilter (clz);
	NotFilter nf = new NotFilter (rf);
	AndFilter af = new AndFilter (f, nf);
	fc.setFilter (af);
    }
}
