; Extrernal functions of the kernel (Mainly Exported functions)

; The calc go idle.
; In:
;	SR = 
; Destroy:
;	d0-d2/a0-a1
kernel::idle:	
	trap	#12				; Go to Supervisor mode to get SR
	move.w	d0,d2				; Get old SR and save it
	move.w	SR,d0				; For calculus
	andi.w	#$0700,d0			; Get Interrupt Mask
	lsr.w	#8,d0				; Get int 
	ifnd	PEDROM_92P			; Can be call from Flash
		move.b	IntMaskTab(Pc,d0.w),$600005	; Stop procs until an int is trigered
	endif
	ifd	PEDROM_92P
		move.b	IntMaskTab(Pc,d0.w),d0	; We are in the Flash Rom
		jsr	IdleRam			; Must be done in RAM (Since we stop FlashRom too !)
	endif
	move.w	d2,SR				; Reset SR to its initial value.
	rts

IntMaskTab	dc.b	%11111,%11110,%11100,%11000,%10000,%00000,%00000,%00000

; Execute an ASM file.
; In:
;	d0.w = Handle of the file.
; Destroy:
;	d0-d2/a0-a1
kernel::exec:
	movem.l	d3-d7/a2-a6,-(a7)
	move.w	d0,-(a7)
	beq	\end
	ROM_THROW	HLock		; Deref & lock files (Even if the file is archived, it works !)

	moveq	#0,d3
	move.w	(a0),d3			; Read file size

	ifnd	PEDROM_PPG
		cmpi.b	#$F3,1(a0,d3.l)	; is it an ASM ?
		bne.s	\Fail		; no -> bye !
	endif
	ifd	PEDROM_PPG
		cmpi.b	#$F3,1(a0,d3.l)	; is it an ASM ?
		beq.s	\Asm		; Yes, run it
		cmpi.b	#$F8,1(a0,d3.l)	; Is it an OTH ?
		bne	\Fail		; No -> Bye ! 
		cmpi.b	#'p',-3(a0,d3.l)
		bne	\Fail
		cmpi.b	#'p',-2(a0,d3.l)
		bne	\Fail
		cmpi.b	#'g',-1(a0,d3.l)
		bne.s	\Fail			; it is a PPG, start it
			move.w	(a7),d4		; Org Handle
			bsr	ExtractPPG	; Extract the PPG
			move.w	d0,(a7)		; Save Handle
			beq.s	\Fail		; Success ?
			bsr	HLock
			ifnd	TI89TI
			adda.l	#$40000,a0	; PPG are launched from Ghost Space
			endc
			bra.s	\notarchived
	endif
\Asm:	clr.w	(a7)		; Clear Copy Handle

	; Check if it is a Pack-Archive
	lea	4(a0),a5
	cmp.l	#'68cA',(a5)
	beq	k_ExeArchive_entry	; It is the same pushed handles but we have to pop the pushed handle.
	
	; Check if it is archived
	move.l	a0,a3
	cmp.l	#$200000,a3
	blt.s	\notarchived
		; Unarchive the prog
		addq.l	#3,d3		; Add size of 'size' and 'type' to the handle size (FIXME: Sure ?)
		move.l	d3,-(a7)
		ROM_THROW	HeapAlloc
		addq.l	#4,a7

    		move.w	d0,(a7)		; Pushes the handle of the temp block for future use
		beq.s	\Fail
		ROM_THROW	HLock	; Deref & locks file

		move.l a0,a1		; a1 : destination
		subq.w #1,d3
\cpy			move.b	(a3)+,(a1)+    ; copy to RAM
			dbf	d3,\cpy
\notarchived
	HW2TSR_PATCH a0,d0

	; Patch it with Tios Relocation
	moveq	#0,d1
	move.w	(a0)+,d1		; Read size
	move.l	a0,a5
	pea	-1(a0,d1.l)
	pea	(a5)
	ROM_THROW	EX_patch
	addq.l	#8,a7
	
	; Call the program
	jsr	(a5)
	nop				; In case it is
	nop				; a nostub program
	nop				; which returns a value
	
	move.l	d0,d4
	tst.w	(a7)		; Get the saved handle
	beq.s	\end
		ROM_THROW	HeapFree
\end	addq.w	#2,a7
	move.l	d4,d0
	movem.l	(a7)+,d3-d7/a2-a6 
	rts
\Fail	moveq	#-128,d4
	bra.s	\end
	
;	HANDLE:d0 kernel::Ptr2Hd(void *a0)
kernel::Ptr2Hd:	;(In: a0 Out: d0)
	movem.l	d1-d3/a1-a3,-(a7)
	move.l	a0,d3
	; Get the address between 0 and 256 Kb if it was in RAM
	lea	$200000,a3		; Limit between FlashRom & Ram
	cmp.l	a3,d3
	bhi.s	\FlashRomAddr
		andi.l	#$0003FFFF,d3	; Avoid Ghost Space
\FlashRomAddr:	
	; Get Heap Ptr
	move.l	RAM_TABLE+$11*4(Pc),a1
	move.l	(a1),a1
	addq.l	#4,a1			; Skip the first entry.
	; Start scanning
	move.w	#MAX_HANDLES-2,d2	; Well, we assume there are 2000 entries even if it could be wrong.
	moveq	#1,d0			; Handle = 1
\loop		move.l	(a1)+,a2	; Read address of handle
		move.l	a2,d1		; NULL ? so skip this 
		beq.s	\next
		cmp.l	a2,d3
		blt.s	\next		; Is Hd->addr > a0 ?
		ifnd	PEDROM		; Get Size of Handle for AMS if it is in RAM
			moveq	#0,d1
			move.w	-(a2),d1	
			add.w	d1,d1
			cmp.l	a3,a2		; Is it an archived file ?
			blt.s	\RamFile
				move.w	2(a2),d1
				addq.l	#4,d1	; d1 = Size of the Handle if it is archived
		endif
		ifd	PEDROM		; Get Size of Handle for Pedrom if it is in RAM
			move.l	-6(a2),d1
			subq.l	#6,d1
			cmp.l	a3,a2		; Is it an archived file ?
			blt.s	\RamFile
				moveq	#0,d1
				move.w	(a2),d1
				addq.l	#2,d1	; d1 = Size of the Handle if it is archived
		endif
\RamFile	add.l	d1,a2		; a2 -> End of file
		cmp.l	a2,d3		; If Hd->addr + Hd->size < a0 ?
		blt.s	\end
\next		addq.w	#1,d0		; Next Handle
		dbf	d2,\loop
		clr.w	d0
\end:	movem.l	(a7)+,d1-d3/a1-a3
	rts

; SYM_ENTRY:a0 kernel::Hd2Sym(HANDLE d0)
kernel::Hd2Sym:
	movem.l	d0-d3/a1-a2,-(a7)
	move.w	d0,d3
	; Go throught the VAT, searching the Handle
	move.w	#2,-(a7)
	clr.l	-(a7)
	ROM_THROW SymFindFirst
	addq.l	#6,a7
\loop		cmp.w	SYM_ENTRY.hVal(a0),d3
		beq.s	\sym_found
		ROM_THROW SymFindNext
		move.l	a0,d0
		bne.s	\loop
	suba.l	a0,a0			; Can not find the handle in the VAT.
\sym_found
	movem.l	(a7)+,d0-d3/a1-a2
	rts
	
;	LIB_DESCRIPTOR:a0 kernel::LibsBegin(char name[] a0, VERSION d1.b)
kernel::LibsBegin:
	movem.l	d0-d7/a1-a6,-(a7)
	move.b	d1,d0				; Library version in d0 :( (Bad specs)
	bsr	find_lib			; Find the library in the VAT : unarchive / uncompress / check version.
	move.l	a0,d0				; Success ?
	beq.s	\end				; No, exit
		move.l	a0,a5			; Reloc the library
		bsr	kernel::relocation
		tst.w	d0
		beq.s	\end
			suba.l	a0,a0		; Error (We don't have to free the lib copy since reloc calls unreloc, which frees the temp copies).
\end	movem.l	(a7)+,d0-d7/a1-a6
	rts
	
;	kernel::LibsEnd(LIB_DESCRIPTOR a0)
kernel::LibsEnd:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	a0,a5
	bsr	kernel::unrelocation			; Unrelocs and frees copies.
	movem.l	(a7)+,d0-d7/a0-a6
	rts

;	kernel::LibsCall(LIBS Descriptor, WORD function, ...)
kernel::LibsCall:
	movem.l	a0-a1/d0-d1,-(a7)	; Push a1 even if we don't destroy it, so that we can write something instead (Avoid subq.l #4,a7)
	move.l	20(a7),a0		; Lib Descriptor
	move.w	24(a7),d0		; Function
	bsr.s	kernel::LibsPtr
	move.l	a0,16(a7)		; Check is success and save it.
	movem.l	(a7)+,a0/d0-d1		; Restore registers
	bne.s	\Jump			; Flags are unaffected
		addq.l	#4,a7		; Error Pop the return address
\Jump	rts
	
;	kernel::LibsPtr(LIBS Descriptor a0, WORD function d0)
kernel::LibsPtr:
	move.l	d1,-(a7)
	
	; Check Signature
	move.l	KHEADER_signa(a0),d1	; Signature : 68kP, 68kL or 68kA
	lsr.l	#8,d1		; Get '68k?'
	cmp.l	#'68k',d1	; Check ?
	bne.s	\error

	move.l	a0,d1
	adda.w	KHEADER_expOff(a0),a0	; Export table
	cmp.w	(a0)+,d0		; Out of range ?
	bge.s	\error
	
	ext.l	d0		; Extension but d0.b only => d0.l = d0.w
	add.w	d0,d0
	move.w	0(a0,d0.w),d0	; Get offset
	add.l	d1,d0		; Org + Offset = address
	move.l	d0,a0		; In a0
	
\end	move.l	(a7)+,d1
	rts
\error	suba.l	a0,a0
	bra.s	\end


;	kernel::LibsExec(char name[], WORD function, BYTE version, ...)
kernel::LibsExec:
	movem.l	d0-d7/a0-a6,-(a7)			; 
	bsr	kernel_install_int
	moveq	#0,d7					; Set Error
	pea	(12).w					; Create a list (Next, RealReturnAddr, LibPtr)
	ROM_THROW HeapAllocPtr				; Alloc Node
	move.l	a0,(a7)					; Ok ?
	beq.s	\AllocError
	move.l	a0,a3					; Ptr to node
	move.l	(LibsExecList-FirstRun)(a6),(a3)+	; Save Next 
	move.l	(4*16)(a7),(a3)+			; Save Real Return Address
	move.l	a3,(LibsExecList-FirstRun)(a6)		; Update list
	move.l	(4*17)(a7),a0				; Library name
	move.b	(4*18+2)(a7),d0				; Minimum Library version
	bsr	find_lib				; Find the library
	move.l	a0,(a3)					; Save the lib & Check for success
	beq.s	\FreeNode
	move.l	a0,a5					; Relocation of the library.
	bsr	kernel::relocation			; If it failed the library is free !
	tst.w	d0					; Kernel::relocation may destroy all registers if an error occured !
	bne.s	\FreeNode
	move.l	a5,a0
	move.w	(4*18)(a7),d0				; Function #
	bsr.s	kernel::LibsPtr				; Get the ptr to the required func
	move.l	a0,d0
	beq.s	\UnrelocLib
	move.l	a0,(4*17)(a7)				; New return address
	lea	\next(pc),a0
	move.l	a0,(4*18)(a7)				; After it return here
	addq.l	#4,a7					; Pop Stack Frame
	movem.l	(a7)+,d0-d7/a0-a6
	addq.l	#4,a7					; Pop First Return Address
	rts						; Jump to the function and return \next
\next	subq.l	#8,a7					; Fix stack ptr.
	movem.l	d0-d7/a0-a7,-(a7)			; Pop a7 to increase Stack Frame
	bsr	kernel_install_int			; Get a6 
	subq.l	#4,a7					; Create Stack Frame
\UnrelocLib:
	move.l	(LibsExecList-FirstRun)(a6),a3
	move.l	(a3),a5					; Read Lib Ptr
	bsr	kernel::unrelocation			; Unreloc & delete. It sets d7 to 1 too !
\FreeNode:
	move.l	(LibsExecList-FirstRun)(a6),a3		; Kernel::relocation may destroy all registers if an error occured ! (execpt a6 & a5)
	move.l	-(a3),(4*16)(a7)			; Set Return Address
	move.l	-(a3),(LibsExecList-FirstRun)(a6)	; Set new next
	move.l	a3,(a7)
	ROM_THROW HeapFreePtr				; Free Node
\AllocError
	addq.l	#4,a7					; Fix stack
	move.l	d7,(4*16)(a7)				; Set error
\end:	movem.l	(a7)+,d0-d7/a0-a6
	rts

;	kernel::HdKeep(HANDLE d0)
kernel::HdKeep:
	ifnd	PEDROM			; Pedrom doesn't erase any handle, execpt if the user asks for it.
	movem.l	a0/d0-d1,-(a7)
HdTable		move.w	#0,a0		; Read save table
	moveq	#7,d1
	eor.w	d1,d0			; 
	and.w	d0,d1			; -> Bit = (7 - 7 & Hd)
	lsr.w	#3,d0			; -> Offset
	bclr.b	d1,0(a0,d0.w)		; Clear it.
	movem.l	(a7)+,a0/d0-d1
	endif
	rts
	
; It executes a Pack-Archive.
; Kernel Functions $50.l
ExeArchive
	move.l	(a7)+,a0		; Load program address
	movem.l	d3-d7/a2-a6,-(a7)
	; Is packArchive ?
	move.l	a0,a5
	cmp.l	#'68cA',(a5)
	bne	k_exeA_return
	; If sym.twin ?
	;	MakeHSym(Ptr2Hd(SYM), SYM);
	;	HSYMtoName(HSYM, buffer); // Standard C string ! 18 bytes
	;	SymDelTwin(SYM)
	;	SymFindPtr(buffer, 0);
	bsr	kernel::Ptr2Hd		; Get Handle of the prgram
	bsr	kernel_install_int	; Destroy a6/a0		; Restore line1111 and a6
	bsr	kernel::Hd2Sym		; Get SYM of the program.
	move.l	a0,d0			; Sym not found ?
	beq.s	k_ExeArchive_no_twin
	move.l	a0,a3
	btst.b	#2,SYM_ENTRY.flags(a3)	; Twin flag ?
	beq.s	k_ExeArchive_no_twin	; No Twin Flag set.
		move.w	SYM_ENTRY.hVal+SYM_ENTRY.sizeof(a3),-(a7) ; twin symbol is always the next symbol !
		ROM_THROW HeapDeref	; Push Handle and Deref it (It is archived so it is locked!)
		lea	4(a0),a5	; New program ref
		pea	(4).w		; New size of the old SYM_ENTRY.
		move.w	SYM_ENTRY.hVal(a3),-(a7)
		ROM_THROW HeapUnlock	; Unlock handle
		ROM_THROW HeapRealloc	; Handle wont change and we can not get an error.
		ROM_THROW HeapDeref
		move.l	#2*65536+$F8,(a0)	; New file (Void file)
		addq.l	#6,a7		; Fix stack
k_ExeArchive_entry:
		addq.l	#2,a7		; Cf the call in kernel::exec
k_ExeArchive_no_twin:
	; Extract it and run it
	moveq	#0,d0		; File 0 of archive
	bsr.s	kernel::ExtractFromPack
	move.w	d0,-(a7)
	beq.s	\error
		; To do: add it in the UsedLibraries table! (Idem in kernel::exec?)
		bsr	kernel::exec	; Exec the file (for tios reloc & lockage)
		ROM_THROW HeapFree	; Free the handle
\error:		addq.w	#2,a7
k_exeA_return:
	movem.l	(a7)+,d3-d7/a2-a6
	rts			; Go Back  (175*2 = 350 octets)


; In:
;	a5 -> KArchive
;	d0 = Number of file
; Out:
;	d0.w = handle
kernel::ExtractFromPack:
	; Find the address of compressed data
	clr.w	d1
	lea	14(a5),a5	; Get ptr to data (Skip ASM header)
	move.b	(a5)+,d1	; Read Number of file
	lea	(17-15)(a5),a0
\package	tst.b	(a0)+
		bne.s	\package
		dbf	d1,\package
	; Package is at the next EVEN address
	move.l	a0,d1
	andi.w	#1,d1
	adda.w	d1,a0

;	Call function x of lib 'bidulelib' with z version (kernel::LibsExec).
;		In:	d0 = Number of file
;			a0 -> Package
;		Out:	Handle = d0 or H_NULL
	move.b	(a5)+,-(a7)	; Push Version
	move.b	(a5)+,d1	; d1.w = 0 or 1
	move.w	d1,-(a7)	; Push Function
	pea	(a5)		; Lib Name
	bsr	kernel::LibsExec
	tst.l	(a7)		; Test error
	addq.l	#8,a7		; Does not affect the Z flag
	bne.s	\return
		clr.w	d0	; An Error occured
\return	rts


; Find a compressed file in one Pack Archive
; In:
;	a2 -> File Name
;	d0.w = Pack Archive Handle
; Out:
;	d0 = Handle
kernel::ExtractFileFromPack:
	movem.l	d3-d4/a3-a5,-(a7)
	move.l	a7,a4				; Save the stack Ptr
	clr.w	-(a7)				; Stop
	move.w	d0,-(a7)			; Push Handle
	bra.s	ExtractFileFromPack

; Find a compressed file throught all the Pack Archives
; In:
;	a2 -> File Name
; Out:
;	d0 = Handle
kernel::ExtractFile:
	movem.l	d3-d4/a3-a5,-(a7)
	move.l	a7,a4				; Save the stack Ptr
	; Search packages
	; Go throught packages...
	move.w	#2,-(a7)
	clr.l	-(a7)
	ROM_THROW SymFindFirst
\loop		move.w	SYM_ENTRY.hVal(a0),-(a7)
		beq.s	\popit
			ROM_THROW HeapDeref
			cmp.l	#'68cA',2+2(a0)
			beq.s	\GoodKArch
\popit		addq.l	#2,a7
\GoodKArch	ROM_THROW SymFindNext
		move.l	a0,d0
		bne.s	\loop

ExtractFileFromPack:
\loop2	move.w	(a7),d0
	beq.s	\done
		ROM_THROW HLock
		lea	2+2(a0),a5
		; Find file in the package ?
		moveq	#-1,d3		; File index (-1: first file is the compressed library to used !)
		clr.w	d4
		move.b	14(a5),d4	; Read Number of file
		lea	(17)(a5),a3	; First Filename
\cmp_loop
			cmpi.b	#'!',(a3)	; Check Static Archive
			bne.s	\CmpFile
				addq.l	#3,a3	; Skip '!' + Offset
\CmpFile		pea	(a3)			
			pea	(a2)
			ROM_THROW SymCmp
			addq.l	#8,a7
			tst.w	d0
			beq.s	\found_name
\next				tst.b	(a3)+	; Next name
				bne.s	\next
			addq.w	#1,d3		; Index++
			dbf	d4,\cmp_loop	; Next File
		bra.s	\no_archive
\found_name	move.w	d3,d0		
		blt.s	\next		; If -1, it was the compressed library : skip it and go throught the next files
		cmpi.b	#'!',-3(a3)	; Check Static Archive
		beq.s	\StaticUncompress
		bsr	kernel::ExtractFromPack
		tst.w	d0
		bne.s	\done
\no_archive:	ROM_THROW HeapUnlock	; Not found, Unlock the archive
		addq.l	#2,a7		; And skip it
		bra.s	\loop2
\StaticUncompress
; If the KArch is in RAM, some problem may appear with HeapFree (It seems that HeapFree of an handle which ptr to the archive zone does nohing more than clear the handle ref)
; Update: I have checked carrefully the execution of HeapFree : it sets the Block pointed by the Handle to a Free Block (it doesn't do anything if ptr is in archive), then it merges all the free blocks.
		cmp.l	#$200000,a3	; So we won't accept any RAM Static Pack Archive
		bls.s	\next
		ROM_THROW HeapGetHandle	; Get a free handle
		moveq	#0,d1
		move.b	-(a3),d1	; High Part (The offset is in Big Endian)
		lsl.w	#8,d1
		or.b	-(a3),d1	; Low Part
		add.l	a5,d1		; Ptr to file
		move.w	d0,d2
		lsl.w	#2,d2
		move.l	RAM_TABLE+$11*4(Pc),a0
		move.l	(a0),a0
		move.l	d1,0(a0,d2.w)	; Save the Handle Ref
\done	move.l	a4,a7			; Restore the stack Ptr
	movem.l	(a7)+,d3-d4/a3-a5
	rts			; 60 bytes

	