/*
 * message.c - Ticker.app message module
 *
 * Copyright (c) 1999 Jiro Sekiba<jir@sekiba.com>
 * Copyright (c) 2001 Seiichi SATO <ssato@sh.rim.or.jp>
 *
 * licensed under the GPL.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#if defined(HAVE_STRING_H)
#include <string.h>
#elif defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#include <unistd.h>

#include "mem.h"

#define MAX_MESSAGE 50
#define DEFAULT_MSG "Ticker.app"

/* private variables */
static char *msgs[MAX_MESSAGE];
static int msg_num = 0;
static int msg_index = -1;

static void load_file(const char *filename, int use_tail)
{
    FILE *fp;
    char tmp[BUFSIZ];
    int len, i = -1;

    if (filename) {
	fp = fopen(filename, "r");
	if (fp == NULL) {
	    perror(filename);
	    msg_num = 0;
	} else {
	    while (fgets(tmp, BUFSIZ, fp)) {
		if (!use_tail) {
		    i++;
		    len = strlen(tmp);
		    if (tmp[len - 1] == '\n')
			tmp[len - 1] = '\0';
		    msgs[i] = malloc_wrap((size_t) ((len) * sizeof(char)));
		    strncpy(msgs[i], tmp, len);
		    if (i >= MAX_MESSAGE - 1)
			break;
		}
	    }

	    if (use_tail) {
		len = strlen(tmp);
		if (tmp[len - 1] == '\n')
		    tmp[len - 1] = '\0';
		msgs[0] = malloc_wrap((size_t) ((len) * sizeof(char)));
		strncpy(msgs[0], tmp, len);
		msg_num = 1;
	    } else {
		msg_num = i + 1;
	    }

	    fclose(fp);
	}
    }

    if (msg_num == 0) {
	msgs[0] = malloc_wrap((strlen(DEFAULT_MSG) + strlen(" version ") +
			       strlen(VERSION) + 1) * sizeof(char));
	sprintf(msgs[0], "%s version %s", DEFAULT_MSG, VERSION);
	msg_num = 1;
    }

}


void Msg_init(const char *filename, int use_tail)
{
    load_file(filename, use_tail);
}

void Msg_reload(const char *filename, int use_tail)
{
    int i;

    if (msg_num > 0) {
	for (i = 0; i < msg_num; i++)
	    free(msgs[i]);
    }

    load_file(filename, use_tail);
}

char *Get_message(void)
{
    msg_index++;
    if (msg_index >= msg_num)
	msg_index = 0;
    return msgs[msg_index];
}
