#include <gtk/gtk.h>
#include <gst/gst.h>

static GtkWidget *preview; /* NULL */

static gchar *opt_device; /* NULL */
static gint   opt_title;  /* 0 */

int
main (int argc, char **argv)
{
  static const GOptionEntry test_goptions[] = {
    {"device", '\0', 0, G_OPTION_ARG_STRING, &opt_device,
        "DVD device to use (default: /dev/dvd)", NULL},
    {"title", '\0', 0, G_OPTION_ARG_INT, &opt_title,
        "which title to preview (default: 1)", NULL},
    {NULL, '\0', 0, 0, NULL, NULL, NULL}
  };
  GOptionContext *ctx;
  GError *err = NULL;

  gtk_init (&argc, &argv);

  /* command line option parsing */
  ctx = g_option_context_new ("");
  g_option_context_add_group (ctx, gst_init_get_option_group ());
  g_option_context_add_main_entries (ctx, test_goptions, NULL);

  if (!g_option_context_parse (ctx, &argc, &argv, &err)) {
    g_error ("Error parsing command line options: %s", err->message);
    g_error_free (err);
    return -1;
  }

  g_print ("Device: %s\n", opt_device);

  gst_init (&argc, &argv);

  if (!opt_device)
    opt_device = g_strdup ("/dev/dvd");

  if (opt_title <= 0)
    opt_title = 1;

  preview = th_title_preview_new (opt_device, "Title XYZ", opt_title, &err);

  if (preview == NULL) {
    g_error ("Failed to create preview window!");
  }

  gtk_widget_show (preview);

  /* hackety-hack (kids: don't do this at home) */
  g_signal_connect (preview, "delete-event", G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect (preview, "destroy", G_CALLBACK (gtk_main_quit), NULL);

  g_print ("Running Gtk+ main loop .. \n");
  gtk_main ();

  g_print ("Done\n");

  return 0;
}
