
/*********************************************************************
 *                
 * Filename:      thinkpad.h
 * Description:   header file for the thinkpad module
 * Author:        Thomas Hood <jdthood@mail.com>
 * Created:       19 July 1999 
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 1999 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#if !defined(__THINKPAD_H__)
#define __THINKPAD_H__

#include "smapi.h"
#include "superio.h"
#include "rtcmosram.h"

/****** defines ******/

/*** ioctl commands ***/
#define MAGIC_THINKPAD_IOCTL  ('(')
#define IOCTL_THINKPAD_GETVER   _IOR (MAGIC_THINKPAD_IOCTL,0x1,thinkpad_ioparm_t)
#define IOCTL_THINKPAD_ENABLE   _IOWR(MAGIC_THINKPAD_IOCTL,0x2,thinkpad_ioparm_t)
#define IOCTL_THINKPAD_DISABLE  _IOWR(MAGIC_THINKPAD_IOCTL,0x3,thinkpad_ioparm_t)
#define IOCTL_SMAPI_REQUEST     _IOWR(MAGIC_THINKPAD_IOCTL,0x10,smapi_ioparm_t)
#define IOCTL_SUPERIO_REQUEST   _IOWR(MAGIC_THINKPAD_IOCTL,0x11,superio_ioparm_t)
#define IOCTL_RTCMOSRAM_REQUEST _IOWR(MAGIC_THINKPAD_IOCTL,0x12,rtcmosram_ioparm_t)

/****** typedefs ******/

/*** thinkpad module input/output parameters ***/
typedef union _thinkpad_ioparm {
	char szVersion[ LEN_VERSION_MAX+1 ];
	char szName[ LEN_NAME_MAX+1 ];
} thinkpad_ioparm_t;



#endif
