
/*********************************************************************
 *                
 * Filename:      rtcmosram.h
 * Description:   header file for the rtcmosram module
 * Author:        Thomas Hood <jdthood@mail.com>
 * Created:       24 July 1999 
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 1999 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#if !defined(__RTCMOSRAM_H__)
#define __RTCMOSRAM_H__

/****** defines ******/

#define RTCMOSRAM_FUNC_GETDATA             (0)
#define RTCMOSRAM_FUNC_DAYLIGHTSAVINGTIME_ABLIFY   (1)
#define RTCMOSRAM_FUNC_DAYLIGHTSAVINGTIME_GET      (2)

/****** typedefs ******/

typedef struct _rtcmosram_data_t {
	byte bSeconds;           /* 0x00 */
	byte bSecondAlarm;       /* 0x01 */
	byte bMinutes;           /* 0x02 */
	byte bMinuteAlarm;       /* 0x03 */
	byte bHours;             /* 0x04 */
	byte bHourAlarm;         /* 0x05 */
	byte bDayOfWeek;         /* 0x06 */
	byte bDateOfMonth;       /* 0x07 */
	byte bMonth;             /* 0x08 */
	byte bYear;              /* 0x09 */
	byte bStatusA;           /* 0x0A */
	byte bStatusB;           /* 0x0B */
	byte bStatusC;           /* 0x0C */
	byte bStatusD;           /* 0x0D */
	byte bStatusDiag;        /* 0x0E */
	byte bStatusShutdown;    /* 0x0F */
	byte bDisketteDriveType; /* 0x10 */
	byte bHardDiskDrive23Type;/* 0x11 */
	byte bHardDiskDrive01Type;/* 0x12 */
	byte bReserved13;        /* 0x13 */
	byte bEquipment;         /* 0x14 */
	byte bSizeBaseMemLow;    /* 0x15 */ /* Note that there is a word boundary */
	byte bSizeBaseMemHigh;   /* 0x16 */ /* between the two halves of this ! */
	byte bSizeExpMemLow;     /* 0x17 */ /* Note that there is a word boundary */
	byte bSizeExpMemHigh;    /* 0x18 */ /* between the two halves of this ! */
	byte bReserved19;        /* 0x19 */
	byte bReserved1A;        /* 0x1A */
	byte bHardDiskDrive2Type;/* 0x1B */
	byte bHardDiskDrive3Type;/* 0x1C */
	byte bReserved1D;        /* 0x1D */
	byte bReserved1E;        /* 0x1E */
	byte bReserved1F;        /* 0x1F */
	byte bReserved20;        /* 0x20 */
		/* On the ThinkPad 600 21U, the low two bits of bReserved20
		 * record the internal pointing device setup:
		 * 0:enable 1:disable 2:autodisable */
	byte bReserved21;        /* 0x21 */
	byte bReserved22;        /* 0x22 */
	byte bReserved23;        /* 0x23 */
	byte bReserved24;        /* 0x24 */
	byte bReserved25;        /* 0x25 */
	byte bReserved26;        /* 0x26 */
	byte bReserved27;        /* 0x27 */
	byte bReserved28;        /* 0x28 */
	byte bReserved29;        /* 0x29 */
	byte bReserved2A;        /* 0x2A */
	byte bReserved2B;        /* 0x2B */
	byte bReserved2C;        /* 0x2C */
	byte bReserved2D;        /* 0x2D */
	byte bConfigChecksumHigh;/* 0x2E */
	byte bConfigChecksumLow; /* 0x2F */
	word wSizeUsableMem;     /* 0x30,0x31 */
	bcd8_t bcd8DateCentury;  /* 0x32 */
	byte bReserved33;        /* 0x33 */
	byte bReserved34;        /* 0x34 */
	byte bReserved35;        /* 0x35 */
	byte bReserved36;        /* 0x36 */
	byte bReserved37;        /* 0x37 */
	byte bReserved38;        /* 0x38 */
	byte bReserved39;        /* 0x39 */
	byte bReserved3A;        /* 0x3A */
	byte bReserved3B;        /* 0x3B */
	byte bReserved3C;        /* 0x3C */
	byte bReserved3D;        /* 0x3D */
	byte bReserved3E;        /* 0x3E */
	byte bReserved3F;        /* 0x3F */
	byte bReserved40;        /* 0x40 */
	byte bReserved41;        /* 0x41 */
	byte bReserved42;        /* 0x42 */
	byte bReserved43;        /* 0x43 */
	byte bReserved44;        /* 0x44 */
	byte bReserved45;        /* 0x45 */
	byte bReserved46;        /* 0x46 */
	byte bReserved47;        /* 0x47 */
	byte bReserved48;        /* 0x48 */
	byte bReserved49;        /* 0x49 */
	byte bReserved4A;        /* 0x4A */
	byte bReserved4B;        /* 0x4B */
	byte bReserved4C;        /* 0x4C */
	byte bReserved4D;        /* 0x4D */
	byte bReserved4E;        /* 0x4E */
	byte bReserved4F;        /* 0x4F */
	byte bReserved50;        /* 0x50 */
	byte bReserved51;        /* 0x51 */
	byte bReserved52;        /* 0x52 */
	byte bReserved53;        /* 0x53 */
	byte bReserved54;        /* 0x54 */
	byte bReserved55;        /* 0x55 */
	byte bReserved56;        /* 0x56 */
	byte bReserved57;        /* 0x57 */
	byte bReserved58;        /* 0x58 */
	byte bReserved59;        /* 0x59 */
	byte bReserved5A;        /* 0x5A */
	byte bReserved5B;        /* 0x5B */
	byte bReserved5C;        /* 0x5C */
	byte bReserved5D;        /* 0x5D */
	byte bReserved5E;        /* 0x5E */
	byte bReserved5F;        /* 0x5F */
	byte bReserved60;        /* 0x60 */
	byte bReserved61;        /* 0x61 */
	byte bReserved62;        /* 0x62 */
	byte bReserved63;        /* 0x63 */
	byte bReserved64;        /* 0x64 */
	byte bReserved65;        /* 0x65 */
	byte bReserved66;        /* 0x66 */
	byte bReserved67;        /* 0x67 */
	byte bReserved68;        /* 0x68 */
	byte bReserved69;        /* 0x69 */
	byte bReserved6A;        /* 0x6A */
	byte bReserved6B;        /* 0x6B */
	byte bReserved6C;        /* 0x6C */
	byte bReserved6D;        /* 0x6D */
	byte bReserved6E;        /* 0x6E */
	byte bReserved6F;        /* 0x6F */
	byte bReserved70;        /* 0x70 */
	byte bReserved71;        /* 0x71 */
	byte bReserved72;        /* 0x72 */
	byte bReserved73;        /* 0x73 */
	byte bReserved74;        /* 0x74 */
	byte bReserved75;        /* 0x75 */
	byte bReserved76;        /* 0x76 */
	byte bReserved77;        /* 0x77 */
	byte bReserved78;        /* 0x78 */
	byte bReserved79;        /* 0x79 */
	byte bReserved7A;        /* 0x7A */
	byte bReserved7B;        /* 0x7B */
	byte bReserved7C;        /* 0x7C */
	byte bReserved7D;        /* 0x7D */
	byte bReserved7E;        /* 0x7E */
	byte bReserved7F;        /* 0x7F */
} rtcmosram_data_t  __attribute__ (( packed ));

typedef struct _rtcmosram_inparm_t {
	word wFunc;
	word wParm0;
	dword dwParm1;
} rtcmosram_inparm_t;

typedef struct _rtcmosram_outparm_t {
	word wRtn;
	word wParm0;
	dword dwParm1;
} rtcmosram_outparm_t;

typedef union _rtcmosram_ioparm_t {
	rtcmosram_inparm_t in;
	rtcmosram_outparm_t out;
	rtcmosram_data_t data;
} rtcmosram_ioparm_t;

/****** declarations ******/

int rtcmosram_do(
	unsigned long ulongIoctlArg,
	flag_t fCallerHasWritePerm
);

#endif
