#ifndef RMCAST_H
#define RMCAST_H

/***************************************************************************
                             rmcast.h
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "rminternals.h" 


#define RM_USE_CURRENT_CONFIG      -1

#define PIPE                    1 /* this option cannot figure in the config. file  */
#define TCP_IP                  2 /* this option cannot be modified by the user */
#define TCP_PORT                3 /* this option cannot be modified by the user */
#define SHUT_DOWN_ROUTINE       4 /* this option cannot figure in the config. file  */
#define CUR_STATE_SERVER_IS_UP  5 /* this option cannot be modified by the user */
#define DEST_IP                 6
#define DEST_PORT               7
#define TTL                     8
#define MICROSLEEP              9
#define AVG_DELAY               10 /* still not used */
#define VERSION                 11 /* still not used */
#define TRANSMISSION_MODE       12
#define LOG_FILE                13
#define NEW_USER_SUPPORT        14
#define STATISTICS              15 /* still not used */
#define REFRESH_TIMER           16
#define LOSS_PROB               17


struct tagCurState 
{
    int size;
    char *data;
    
};

typedef struct tagCurState CurState;



void RM_readConfigFile(char *filename);
void RM_initialize(void);
int  RM_getCurState(char *group1, int port1, CurState *c);
int  RM_joinGroup (char *group, int port);
int  RM_leaveGroup(int  sock,   char *group);
void RM_terminate (void);
int  RM_sendto    (int socket, char *buffer, int buffsize);
int  RM_recv      (int socket, char *buffer, int buffsize);



CurState RM_getCurStatus (int socket);
int      RM_SendCurStatus(int connfd, char *buff, int buffsize);

void     RM_getOption(int opt, void *return_value);
void     RM_setOption    (int opt,    void *optvalue);


void RMDEBUG_setpidip(int pid, char *ip);
void RMDEBUG_setsn(int sn);



#endif
