
/******************************************************************************
* MODULE     : rel_hashmap.gen.h
* DESCRIPTION: see rel_hashmap.gen.cc
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>
#include <list.gen.h>
#include <hashmap.gen.h>

#module rel_hashmap (T,U)
#import hashmap (T,U)
#import list(hashmap<T,U>)
#import tree

class rel_hashmap_rep<T,U>;

class rel_hashmap<T,U> {
#import concrete_null (rel_hashmap<T,U>, rel_hashmap_rep<T,U>)
  inline rel_hashmap<T,U> (U init);
  inline rel_hashmap<T,U> (hashmap<T,U> item);
  inline rel_hashmap<T,U> (hashmap<T,U> item, rel_hashmap<T,U> next);
  U  operator [] (T x);
  U& operator () (T x);
};

class rel_hashmap_rep<T,U>: concrete_struct {
public:
  hashmap<T,U>     item;
  rel_hashmap<T,U> next;

  inline rel_hashmap_rep<T,U> (hashmap<T,U> item2, rel_hashmap<T,U> next2):
    item(item2), next(next2) {}
  bool contains (T x);
  void extend ();
  void shorten ();
  void merge ();
  void find_changes (hashmap<T,U>& CH);
  void find_differences (hashmap<T,U>& CH);
  void change (hashmap<T,U> CH);

  friend class rel_hashmap<T,U>;
};

#import code_concrete_null (rel_hashmap<T,U>, rel_hashmap_rep<T,U>)
inline rel_hashmap<T,U>::rel_hashmap<T,U> (U init):
  rep (new rel_hashmap_rep<T,U> (hashmap<T,U> (init), rel_hashmap<T,U> ())) {}
inline rel_hashmap<T,U>::rel_hashmap<T,U> (hashmap<T,U> item):
  rep (new rel_hashmap_rep<T,U> (item, rel_hashmap<T,U> ())) {}
inline rel_hashmap<T,U>::rel_hashmap<T,U>
  (hashmap<T,U> item, rel_hashmap<T,U> next):
    rep (new rel_hashmap_rep<T,U> (item, next)) {}

ostream& operator << (ostream& out, rel_hashmap<T,U> H);

#endmodule // code_rel_hashmap (T,U)
