
/******************************************************************************
* MODULE     : hashset.gen.h
* DESCRIPTION: hashsets with reference counting
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <list.gen.h>
#include <tree.gen.h>

#module hashset (T)
#import basic
#import list (T)
#import tree

class hashset_rep<T>: concrete_struct {
  int size;    // size of hashset (nr of entries)
  int n;       // nr of keys (a power of two)
  int max;     // mean number of entries per key
  list<T>* a;  // the array of entries

public:
  inline hashset_rep<T> ():
    size(0), n(1), max(1), a (new list<T>[1]) {}
  inline hashset_rep<T>(int n2, int max2=1):
    size(0), n(n2), max(max2), a (new list<T>[n]) {}
  inline ~hashset_rep<T> () { delete[] a; }

  bool contains (T x);
  void resize (int n);
  void insert (T x);
  void remove (T x);

  friend class hashset<T>;
  friend inline int N (hashset<T> h);
  friend ostream& operator << (ostream& out, hashset<T> h);
  friend bool operator <= (hashset<T> h1, hashset<T> h2);
  friend class hashset_iterator_rep<T>;
};

class hashset<T> {
#import concrete (hashset<T>, hashset_rep<T>)
  inline hashset<T> (int n=1, int max=1):
    rep (new hashset_rep<T>(n, max)) {}
  operator tree ();
};
#import code_concrete (hashset<T>, hashset_rep<T>)

extern inline int N (hashset<T> h) { return h->size; }
bool operator == (hashset<T> h1, hashset<T> h2);
bool operator <= (hashset<T> h1, hashset<T> h2);
bool operator <  (hashset<T> h1, hashset<T> h2);

#ifndef STANDARD_HASHES
#define STANDARD_HASHES
inline int hash (int i) { return i; }
inline int hash (pointer ptr) { return (int) ptr; }
#endif

#endmodule // hashset (T)
