
/******************************************************************************
* MODULE     : gg_system.cc
* DESCRIPTION: system dependent code
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#ifndef _GG_SYSTEM
#define _GG_SYSTEM
#include "gg_string.h"

string make_env_variables   ();
string make_object          (string in, string out, string options);
string make_static_library  (string in, string out, string opts, string libp);
string make_dynamic_library (string in, string out, string opts, string libp);
string make_static_binary   (string in, string out, string opts, string libp);
string make_dynamic_binary  (string in, string out, string opts, string libp);

bool   test_os (string s);
bool   option_contains (string s, string what);
string special_object_option (string s);
string special_library_option (string s);
string special_binary_option (string s);

#endif // _GG_SYSTEM
