
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : symbol-menu.scm
;; DESCRIPTION : for choosing TeXmacs symbols graphically from menu
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (insert-object t)
  (insert-tree (object->tree t)))

;;
;; Large delimiters
;;

(define left-delimiter-menu
  '((symbol "<left-(-2>" (left "(") "E-E-(")
    (symbol "<left-)-2>" (left ")") "E-E-l )")
    (symbol "<left-[-2>" (left "[") "E-E-[")
    (symbol "<left-]-2>" (left "]") "E-E-l ]")
    (symbol "<left-{-2>" (left "{") "E-E-{")
    (symbol "<left-}-2>" (left "}") "E-E-l }")
    (symbol "<left-langle-2>" (left "langle") "E-E-<")
    (symbol "<left-rangle-2>" (left "rangle") "E-E-l >")
    (symbol "<left-lfloor-2>" (left "lfloor"))
    (symbol "<left-rfloor-2>" (left "rfloor"))
    (symbol "<left-lceil-2>" (left "lceil"))
    (symbol "<left-rceil-2>" (left "rceil"))
    (symbol "<left-llbracket-2>" (left "llbracket"))
    (symbol "<left-rrbracket-2>" (left "rrbracket"))
    (symbol "<left-|-4>" (left "|") "E-E-l |")
    (symbol "<left-||-4>" (left "||"))
    (symbol "<left-/-2>" (left "/") "E-E-l /")
    (symbol "<left-\\-2>" (left "\\") "E-E-l b")
    (symbol "<left-.-2>" (left ".") "E-E-l .")))

(define middle-delimiter-menu
  '((symbol "<mid-(-2>" (mid "(") "E-E-m (")
    (symbol "<mid-)-2>" (mid ")") "E-E-m )")
    (symbol "<mid-[-2>" (mid "[") "E-E-m [")
    (symbol "<mid-]-2>" (mid "]") "E-E-m ]")
    (symbol "<mid-{-2>" (mid "{") "E-E-m {")
    (symbol "<mid-}-2>" (mid "}") "E-E-m }")
    (symbol "<mid-langle-2>" (mid "langle") "E-E-m <")
    (symbol "<mid-rangle-2>" (mid "rangle") "E-E-m >")
    (symbol "<mid-lfloor-2>" (mid "lfloor"))
    (symbol "<mid-rfloor-2>" (mid "rfloor"))
    (symbol "<mid-lceil-2>" (mid "lceil"))
    (symbol "<mid-rceil-2>" (mid "rceil"))
    (symbol "<mid-llbracket-2>" (mid "llbracket"))
    (symbol "<mid-rrbracket-2>" (mid "rrbracket"))
    (symbol "<mid-|-4>" (mid "|") "E-E-|")
    (symbol "<mid-||-4>" (mid "||"))
    (symbol "<mid-/-2>" (mid "/") "E-E-/")
    (symbol "<mid-\\-2>" (mid "\\") "E-E-b")))

(define right-delimiter-menu
  '((symbol "<right-(-2>" (right "(") "E-E-r (")
    (symbol "<right-)-2>" (right ")") "E-E-)")
    (symbol "<right-[-2>" (right "[") "E-E-r [")
    (symbol "<right-]-2>" (right "]") "E-E-]")
    (symbol "<right-{-2>" (right "{") "E-E-r {")
    (symbol "<right-}-2>" (right "}") "E-E-}")
    (symbol "<right-langle-2>" (right "langle") "E-E-r <")
    (symbol "<right-rangle-2>" (right "rangle") "E-E->")
    (symbol "<right-lfloor-2>" (right "lfloor"))
    (symbol "<right-rfloor-2>" (right "rfloor"))
    (symbol "<right-lceil-2>" (right "lceil"))
    (symbol "<right-rceil-2>" (right "rceil"))
    (symbol "<right-llbracket-2>" (right "llbracket"))
    (symbol "<right-rrbracket-2>" (right "rrbracket"))
    (symbol "<right-|-4>" (right "|") "E-E-r |")
    (symbol "<right-||-4>" (right "||"))
    (symbol "<right-/-2>" (right "/") "E-E-r /")
    (symbol "<right-\\-2>" (right "\\") "E-E-r b")
    (symbol "<right-.-2>" (right ".") "E-E-r .")))

;;
;; Big operators
;;

(define big-operator-menu
  '((symbol "<big-sum-2>" (big "sum") "E-E-S")
    (symbol "<big-prod-2>" (big "prod") "E-E-P")
    (symbol "<big-int-2>" (big "int") "E-E-I")
    (symbol "<big-oint-2>" (big "oint") "E-E-O")
    (symbol "<big-amalg-2>" (big "amalg") "E-E-A")
    (symbol "<big-cap-2>" (big "cap") "E-E-N")
    (symbol "<big-cup-2>" (big "cup") "E-E-U")
    (symbol "<big-wedge-2>" (big "wedge") "E-E-W")
    (symbol "<big-vee-2>" (big "vee") "E-E-V")
    (symbol "<big-odot-2>" (big "odot") "E-E-@ .")
    (symbol "<big-oplus-2>" (big "oplus") "E-E-@ +")
    (symbol "<big-otimes-2>" (big "otimes") "E-E-@ x")
    (symbol "<big-sqcap-2>" (big "sqcap"))
    (symbol "<big-sqcup-2>" (big "sqcup"))
    (symbol "<big-curlywedge-2>" (big "curlywedge"))
    (symbol "<big-curlyvee-2>" (big "curlyvee"))
    (symbol "<big-triangleup-2>" (big "triangleup"))
    (symbol "<big-triangledown-2>" (big "triangledown"))
    (symbol "<big-box-2>" (big "box"))
    (symbol "<big-pluscup-2>" (big "pluscup"))
    (symbol "<big-parallel-2>" (big "parallel"))
    (symbol "<big-interleave-2>" (big "interleave"))
    (symbol "<big-.-2>" (big ".") "E-E-.")))

;;
;; Binary operations
;;

(define binary-operation-menu
  '((symbol "<oplus>" "@ +")
    (symbol "<ominus>" "@ -")
    (symbol "<otimes>" "@ x")
    (symbol "<oslash>" "@ / *")
    (symbol "<odot>" "@ .")
    (symbol "<varocircle>" "@ @ *")
    (symbol "<circledast>")
    (symbol "<obar>" "@ |")
    (symbol "<boxplus>" "@ * +")
    (symbol "<boxminus>" "@ * -")
    (symbol "<boxtimes>" "@ * x")
    (symbol "<boxslash>" "@ * /")
    (symbol "<boxdot>" "@ * .")
    (symbol "<boxbox>" "@ * @ *")
    (symbol "<boxast>")
    (symbol "<boxbar>" "@ * |")

    (symbol "<pm>" "+ -")
    (symbol "<mp>" "- +")
    (symbol "<times>" "* * *")
    (symbol "<div>")
    (symbol "<ast>" "* *")
    (symbol "<star>")
    (symbol "<circ>" "@")
    (symbol "<bullet>" "@ * *")
    (symbol "<cdot>" "* * * *")
    (symbol "<cap>" "E-E-n")
    (symbol "<cup>" "E-E-u")
    (symbol "<uplus>")
    (symbol "<sqcap>" "E-E-n *")
    (symbol "<sqcup>" "E-E-u *")
    (symbol "<vee>" "E-E-v")
    (symbol "<wedge>" "E-E-w")))

;;
;; Binary relations
;;

(define binary-relation-menu-1
  '((symbol "<sim>" "~")
    (symbol "<simeq>" "~ -")
    (symbol "<approx>" "~ ~")
    (symbol "<cong>" "~ =")
    (symbol "<asymp>" "= *")
    (symbol "<equiv>" "= * *")
    (symbol "<asympasymp>" "= * * *")
    (symbol "<simsim>" "= * * * *")
    (symbol "<bumpeq>")
    (symbol "<Bumpeq>")
    (symbol "<circeq>" "@ =")
    (symbol "<backsim>")
    (symbol "<backsimeq>")
    (symbol "<eqcirc>" "= @")
    (symbol "<thicksim>")
    (symbol "<thickapprox>")
    (symbol "<approxeq>" "~ ~ -")
    (symbol "<triangleq>")
    (symbol "<neq>" "= /")
    (symbol "<nin>")
    (symbol "<perp>")
    (symbol "<smile>")
    (symbol "<frown>")
    (symbol "<propto>")))

(define binary-relation-menu-2
  '((symbol "<less>" "<")
    (symbol "<leqslant>" "< =")
    (symbol "<leq>" "< = *")
    (symbol "<leqq>" "< = * *")
    (symbol "<ll>" "< <")
    (symbol "<lleq>" "< < =")
    (symbol "<lll>" "< < <")
    (symbol "<llleq>" "< < < =")
    (symbol "<gtr>" ">")
    (symbol "<geqslant>" "> =")
    (symbol "<geq>" "> = *")
    (symbol "<geqq>" "> = * *")
    (symbol "<gg>" "> >")
    (symbol "<ggeq>" "> > =")
    (symbol "<ggg>" "> > >")
    (symbol "<gggeq>" "> > > =")

    (symbol "<prec>" "< *")
    (symbol "<preccurlyeq>" "< * =")
    (symbol "<preceq>" "< * = *")
    (symbol "<precsim>" "< * ~")
    (symbol "<precprec>" "< < *")
    (symbol "<precpreceq>" "< < * =")
    (symbol "<precprecprec>" "< < < *")
    (symbol "<precprecpreceq>" "< < < * =")
    (symbol "<succ>" "> *")
    (symbol "<succcurlyeq>" "> * =")
    (symbol "<succeq>" "> * = *")
    (symbol "<succsim>" "> * ~")
    (symbol "<succsucc>" "> > *")
    (symbol "<succsucceq>" "> > * =")
    (symbol "<succsuccsucc>" "> > > *")
    (symbol "<succsuccsucceq>" "> > > * =")

    (symbol "<subset>" "< * *")
    (symbol "<subseteq>" "< * * =")
    (symbol "<subseteqq>" "< * * = *")
    (symbol "<sqsubset>" "< * * * *")
    (symbol "<sqsubseteq>" "< * * * * =")
    (symbol "<Subset>")
    (symbol "<subsetplus>" "< * * +")
    (symbol "<in>" "< * * *")
    (symbol "<supset>" "> * *")
    (symbol "<supseteq>" "> * * =")
    (symbol "<supseteqq>" "> * * = *")
    (symbol "<sqsupset>" "> * * * *")
    (symbol "<sqsupseteq>" "> * * * * =")
    (symbol "<Supset>")
    (symbol "<supsetplus>" "> * * +")
    (symbol "<ni>" "> * * *")

    (symbol "<vartriangleleft>" "< |")
    (symbol "<trianglelefteqslant>" "< | =")
    (symbol "<trianglelefteq>" "< | = *")
    (symbol "<blacktriangleleft>" "< | *")
    (symbol "<lesssim>" "< ~")
    (symbol "<lessapprox>" "< ~ ~")
    (symbol "<precsim>" "< * ~")
    (symbol "<precapprox>" "< * ~ ~")
    (symbol "<vartriangleright>" "| >")
    (symbol "<trianglerighteqslant>" "| > =")
    (symbol "<trianglerighteq>" "| > = *")
    (symbol "<blacktriangleright>" "| > *")
    (symbol "<gtrsim>" "> ~")
    (symbol "<gtrapprox>" "> ~ ~")
    (symbol "<succsim>" "> * ~")
    (symbol "<succapprox>" "> * ~ ~")))

;;
;; Arrows
;;

(define horizontal-arrow-menu
  '((symbol "<leftarrow>" "< -")
    (symbol "<Leftarrow>" "< = * * *")
    (symbol "<leftharpoonup>")
    (symbol "<leftharpoondown>")
    (symbol "<leftleftarrows>" "< - < -")
    (symbol "<leftarrowtail>" "< - <")
    (symbol "<hookleftarrow>")
    (symbol "<looparrowleft>")
    (symbol "<twoheadleftarrow>" "< < -")

    (symbol "<rightarrow>" "- >")
    (symbol "<Rightarrow>" "= >")
    (symbol "<rightharpoonup>")
    (symbol "<rightharpoondown>")
    (symbol "<rightrightarrows>" "- > - >")
    (symbol "<rightarrowtail>" "> - >")
    (symbol "<hookrightarrow>")
    (symbol "<looparrowright>")
    (symbol "<twoheadrightarrow>" "- > >")

    (symbol "<leftrightarrow>" "< - >")
    (symbol "<Leftrightarrow>" "< = >")
    (symbol "<leftrightharpoons>" "< - - > * *")
    (symbol "<rightleftharpoons>" "- > < - *")
    (symbol "<leftrightarrows>" "< - - > *")
    (symbol "<rightleftarrows>" "- > < -")
    (symbol "<mapsto>" "| - >")
    (symbol "<rightsquigarrow>" "~ >")
    (symbol "<leftrightsquigarrow>" "< ~ >")))

(define vertical-arrow-menu
  '((symbol "<uparrow>")
    (symbol "<Uparrow>")
    (symbol "<upuparrows>")
    (symbol "<upharpoonleft>")
    (symbol "<upharpoonright>")
    (symbol "<nwarrow>")
    (symbol "<nearrow>")
    (symbol "<updownarrow>")

    (symbol "<downarrow>")
    (symbol "<Downarrow>")
    (symbol "<downdownarrows>")
    (symbol "<downharpoonleft>")
    (symbol "<downharpoonright>")
    (symbol "<swarrow>")
    (symbol "<searrow>")
    (symbol "<Updownarrow>")))

(define long-arrow-menu
  '((symbol "<longleftarrow>" "< - -")
    (symbol "<longrightarrow>" "- - >")
    (symbol "<longleftrightarrow>" "< - - >")
    (symbol "<Longleftarrow>" "< = =")
    (symbol "<Longrightarrow>" "= = >")
    (symbol "<Longleftrightarrow>" "< = = >")
    (symbol "<longhookleftarrow>")
    (symbol "<longhookrightarrow>")
    (symbol "<longmapsto>" "| - - >")))

;;
;; Negations
;;

(define negation-menu
  '((symbol "<lneq>" "< = * / *")
    (symbol "<lneqq>" "< = * * / *")
    (symbol "<lvertneqq>" "< = * * / * *")
    (symbol "<lnsim>" "< ~ / *")
    (symbol "<lnapprox>" "< ~ ~ / *")
    (symbol "<precneqq>" "< * = * / *")
    (symbol "<gneq>" "> = * / *")
    (symbol "<gneqq>" "> = * * / *")
    (symbol "<gvertneqq>" "> = * * / * *")
    (symbol "<gnsim>" "> ~ / *")
    (symbol "<gnapprox>" "> ~ ~ / *")
    (symbol "<succneqq>" "> * = * / *")

    (symbol "<precnsim>" "< * ~ / *")
    (symbol "<precnapprox>" "< * ~ ~ / *")
    (symbol "<subsetneq>" "< * * = / *")
    (symbol "<subsetneqq>" "< * * = * / *")
    (symbol "<varsubsetneq>" "< * * = / * *")
    (symbol "<varsubsetneqq>" "< * * = * / * *")
    (symbol "<succnsim>" "> * ~ / *")
    (symbol "<succnapprox>" "> * ~ ~ / *")
    (symbol "<supsetneq>" "> * * = / *")
    (symbol "<supsetneqq>" "> * * = * / *")
    (symbol "<varsupsetneq>" "> * * = / * *")
    (symbol "<varsupsetneqq>" "> * * = * / * *")))

;;
;; Greek characters
;;

(define lower-greek-menu
  '((symbol "<alpha>" "A-a")
    (symbol "<beta>" "A-b")
    (symbol "<gamma>" "A-g")
    (symbol "<delta>" "A-d")
    (symbol "<epsilon>" "A-e *")
    (symbol "<varepsilon>" "A-e")
    (symbol "<zeta>" "A-z")
    (symbol "<eta>" "A-h")
    (symbol "<theta>" "A-q")
    (symbol "<vartheta>" "A-q *")
    (symbol "<iota>" "A-i")
    (symbol "<kappa>" "A-k")
    (symbol "<lambda>" "A-l")
    (symbol "<mu>" "A-m")
    (symbol "<nu>" "A-n")
    (symbol "<xi>" "A-x")
    (symbol "<omicron>" "A-o")
    (symbol "<pi>" "A-p")
    (symbol "<varpi>" "A-p *")
    (symbol "<rho>" "A-r")
    (symbol "<varrho>" "A-r *")
    (symbol "<sigma>" "A-s")
    (symbol "<varsigma>" "A-s *")
    (symbol "<tau>" "A-t")
    (symbol "<upsilon>" "A-u")
    (symbol "<phi>" "A-f *")
    (symbol "<varphi>" "A-f")
    (symbol "<chi>" "A-c")
    (symbol "<psi>" "A-y")
    (symbol "<omega>" "A-w")))

(define upper-greek-menu
  '((symbol "<Gamma>" "A-G")
    (symbol "<Delta>" "A-D")
    (symbol "<Theta>" "A-Q")
    (symbol "<Lambda>" "A-L")
    (symbol "<Xi>" "A-X")
    (symbol "<Pi>" "A-P")
    (symbol "<Sigma>" "A-S")
    (symbol "<Upsilon>" "A-U")
    (symbol "<Phi>" "A-F")
    (symbol "<Psi>" "A-Y")
    (symbol "<Omega>" "A-W")))

;;
;; Miscellaneous symbols
;;

(define miscellaneous-symbol-menu
  '((symbol "<aleph>")
    (symbol "<beth>")
    (symbol "<gimel>")
    (symbol "<daleth>")
    (symbol "<imath>")
    (symbol "<jmath>")
    (symbol "<ell>")
    (symbol "<wp>" "E-E-p")
    (symbol "<Re>")
    (symbol "<Im>")
    (symbol "<Mho>")
    (symbol "<emptyset>")
    (symbol "<varnothing>")
    (symbol "<nabla>")
    (symbol "<top>")
    (symbol "<bot>")
    (symbol "<vdash>" "| -")
    (symbol "<Vdash>" "| | -")
    (symbol "<Vvdash>" "| | | -")
    (symbol "<vDash>" "| =")
    (symbol "<dashv>" "- |")
    (symbol "<angle>")
    (symbol "<forall>")
    (symbol "<exists>")
    (symbol "<neg>")
    (symbol "<flat>")
    (symbol "<natural>")
    (symbol "<sharp>")
    (symbol "<backslash>")
    (symbol "<partial>")
    (symbol "<infty>" "@ @")
    (symbol "<box>")
    (symbol "<diamond>")
    (symbol "<triangle>")
    (symbol "<clubsuit>")
    (symbol "<diamondsuit>")
    (symbol "<heartsuit>")
    (symbol "<spadesuit>")
    (symbol "<sun>")
    (symbol "<leftmoon>")
    (symbol "<rightmoon>")
    (symbol "<earth>")
    (symbol "<male>")
    (symbol "<female>")
    (symbol "<maltese>")
    (symbol "<kreuz>")
    (symbol "<recorder>")
    (symbol "<phone>")
    (symbol "<checked>")
    (symbol "<pointer>")
    (symbol "<bell>")
    (symbol "<eighthnote>")
    (symbol "<quarternote>")
    (symbol "<halfnote>")
    (symbol "<fullnote>")
    (symbol "<twonotes>")))

(define dots-menu
  '((symbol "<ldots>" ". .")
    (symbol "<cdots>" ". . *")
    (symbol "<hdots>" ". . * *")
    (symbol "<vdots>" ". . * * *")
    (symbol "<ddots>" ". . * * * *")
    (symbol "<udots>" ". . * * * * *")))
