
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : giac.scm
;; DESCRIPTION : Special support for giac
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (giac-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(giac-input-var-row (cdr r)))))

(define (giac-input-row r)
  (display "[")
  (cas-input (car r))
  (giac-input-var-row (cdr r))
  (display "]"))

(define (giac-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(giac-input-row (car t))
	(giac-input-var-rows (cdr t)))))

(define (giac-input-rows t)
  (display "matrix([")
  (giac-input-row (car t))
  (giac-input-var-rows (cdr t))
  (display "])"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "giac" "giac --texmacs")
(connection-format "giac" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("giac" (make-session "giac" "default")))))
(define (in-giac?) (equal? (get-env "prog language") "giac"))

(set! cas-input-current-cas "giac")
(cas-input-set! 'rows giac-input-rows)
(display "")
