% last change   : 23-Okt-04 21:02:25
% status        : 0.75 beta
% created       : 2001/06/28 17:49:53
%
% subject       : german phd thesis law
%
% to do         : very much ... :-)
%
% don't blame me for this piece of code ...
%
%  Axel Sodtalbers (juramisc@sodtalbers.de)


\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jurabook}[2004/10/24 V0.75 (beta) juridical books (AS)]

% for a change history cf. 
% doc/jmgerdoc.tex (\subsubsection{Versionsgeschichte})


%========================================
%               
% Required packages
%
%========================================

\RequirePackage{jurabase}% calc, ifthen, xspace
\RequirePackage{remreset}
\RequirePackage{fancyhdr}
% fancyhdr muss aktuell (>V.2) sein, da es aber keine Versionsinformation
% besitzt, versuchen wir es so:
\@ifundefined{fancyhead}%
  {\ClassError{jurabook}%
     {You are using an outdated version of fancyhdr!\MessageBreak
      jurabook needs fancyhdr version 2 or higher.}%
     {Get fanyhdr's current version from CTAN.}%
  }%   
  {\relax}


%========================================
%               
% Klassen-Optionen 
%
%========================================

\iffalse

  indexpagenumbers
  ==================
  Sollen Seitenzahlen in den Index aufgenommen werden (statt der Randnummern)? 
  -> default: false

\fi

\newif\if@indexpagenumbers 
\@indexpagenumbersfalse
\DeclareOption{indexpagenumbers}{\@indexpagenumberstrue}

  
\iffalse 

 norunners
 ===============
 Sollen KEINE Randnummern ausgegeben werden?
 -> default: false
 
 (wenn gewaehlt, wird auch indexpagenumbers auf true geschaltet)

\fi

\newif\if@dorunners
\@dorunnerstrue
\DeclareOption{norunners}{%
  \@dorunnersfalse%
  \@indexpagenumberstrue}


\iffalse
 
 rnrefbold
 =========
 Sollen in Verweisen mit \mnref{Marke} die Randnummern fett ausgegeben werden? 
 -> default: false
 
 Hinweis: Die Randnummern im Text selbst werden _stets_ fett ausgegeben!

\fi

\newif\if@rnrefbold% rn = runners
\@rnrefboldfalse
\DeclareOption{rnrefbold}{\@rnrefboldtrue}

  
\iffalse

  rnintoc  (rn in toc)
  =======

  Sollen auch die Randnummern in das Inhaltsverzeichnis
  mit aufgenommen werden? (funktioniert noch nicht!)

\fi

\iffalse

  oldfootnotes
  ===============
  Altes Fussnotenlayout? 
  -> default: false
  
  Wenn *nicht* angegeben:
  __________________________
  999 Hier Fussnotentext ...
      Zweite Zeile ...
\fi

\newif\if@oldfootnotes
\@oldfootnotesfalse
\DeclareOption{oldfootnotes}{\@oldfootnotestrue}

\iffalse

  fncontinued
  ===============
  Fussnoten werden auch nach chapter weitergezaehlt 
  -> default: false
  
\fi


\newif\if@fncontinued
\@fncontinuedfalse
\DeclareOption{fncontinued}{\@fncontinuedtrue}


\iffalse

  suppresswebdates
  ================
  Ausgabe des Abrufdatums in citeweb-Befehlen unterdruecken?
  -> default: false

\fi

\newif\if@suppresswebdates
\@suppresswebdatesfalse
\DeclareOption{suppresswebdates}{\@suppresswebdatestrue}

\iffalse

  longfnrule
  ==========
  Lange Linie ueber den Fussnoten? 
  -> default: false

  Hinweis: wie in den neuen Buechern von C.H. Beck.
\fi

\newif\if@longfnrule
\@longfnrulefalse
\DeclareOption{longfnrule}{\@longfnruletrue}


\iffalse

  classiclayout
  =============
  Eher konservativeres / klassisches Layout? 
  -> default: false

\fi

\newif\if@classiclayout
\@classiclayoutfalse
\DeclareOption{classiclayout}{\@classiclayouttrue}


\iffalse

  centeredlayout
  ==================
  Sollen die 'parts' im Inhaltsverzeichnis zentriert werden?
  -> default: false

\fi
  
\newif\if@centeredlayout
\@centeredlayoutfalse
\DeclareOption{centeredlayout}{\@centeredlayouttrue}


\iffalse

  compact
  =======
  Keine eigenen Seiten fuer parts?
  -> default: false

\fi


\newif\if@compactlayout
\@compactlayoutfalse
\DeclareOption{compact}{%
  \@compactlayouttrue%
  \if@centeredlayout%
  \else%
    \ClassWarningNoLine{jurabook}%
      {If you're using the 'compact' option,\MessageBreak%
       it is maybe a good idea to use\MessageBreak%
       the 'centeredlayout' option, too ..}%
  \fi%
}


\iffalse

  decisionhints
  =============
  
  Sollen die Anmerkungen zu den Entscheidungen in der 
  Entscheidungsliste nicht mit ausgegeben werden? 
  -> default: false (= Anmerkungen werden NICHT ausgegeben)

\fi

\newif\if@decisionhints 
\@decisionhintsfalse
\DeclareOption{decisionhints}{\@decisionhintstrue}


\iffalse

  overviewwithsec
  ===============
  Sollen auch die 'sections' in den Ueberblick ('\overview') genommen werden?
  -> default: false

\fi
  
\newif\if@secinovw
\@secinovwfalse
\DeclareOption{overviewwithsec}{\@secinovwtrue}


\iffalse

  chapterprefix
  ===============
  Erst 'Kapitel', dann die Kapitelummer?
  (ergibt: 'Kapitel 1')
  
  -> default: true

\fi
  
\newif\if@chapterprefix
\@chapterprefixtrue
\DeclareOption{chapterprefix}{\@chapterprefixtrue\@chaptersuffixfalse}

\iffalse

  chaptersuffix
  ===============
  Erst Kapitelnummer, dann 'Kapitel'?
  (ergibt: '1. Kapitel')
  
  -> default: false

\fi
  
\newif\if@chaptersuffix
\@chaptersuffixfalse
\DeclareOption{chaptersuffix}{\@chaptersuffixtrue\@chapterprefixfalse}


\iffalse

  fixtocindent
  ===============
  sections werden um eine fixe Breite (defaulttocindent, 1.5em)
  eingerueckt.
  
  -> default: false

\fi
  
\newif\if@fixtocindent
\@fixtocindentfalse
\DeclareOption{fixtocindent}{\@fixtocindenttrue}


\iffalse

  printmaketime
  =============
  Soll das Erstellungsdatum ('\today') in den Fusszeilen ausgegeben werden?
  -> default: false
\fi


\newif\if@printmaketime
\@printmaketimefalse
\DeclareOption{maketime}{\@printmaketimetrue}


\iffalse

  officialtitle
  =============
  "Offizielle" Titelei gem. Promotionsordnung?
  -> default: false
  
  Gekoppelt an 'goettingen'-Option:
  
  goettingen
  ==========
  Offizieller Titel nach der Goettinger Promotionsordnung
  -> default: false
\fi

\newif\if@officialtitle
\@officialtitlefalse
\newif\if@goettingen
\@goettingenfalse

\DeclareOption{officialtitle}{%
  \@officialtitletrue%
  \@goettingentrue}


\DeclareOption{goettingen}{%
  \@officialtitletrue%
  \@goettingentrue}


\iffalse

  bonn
  ==========
  Offizieller Titel nach der Bonner Promotionsordnung
  -> default: false
\fi

\newif\if@bonn
\@bonnfalse

\DeclareOption{bonn}{%
  \@officialtitletrue%
  \@goettingenfalse
  \@bonntrue}


\iffalse

  all other options will be passed to LaTeX-book class ...
  
  (Begleiter 489)
\fi

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}   
\ProcessOptions\relax


\iffalse
  Output of all options (for debugging purposes)
\fi

\newcommand{\@jb@oo@screenandlog}[1]{%
  \wlog{#1}\typeout{#1}%
}
\newcommand{\@jb@oo@document}[1]{#1\newline}

\newcommand{\@jb@checkopt}[1]{
  \def\@@jb@check{#1}
  \csname if@\@@jb@check\endcsname
    \@jb@oo{\@@jb@check :\space on}
  \else
    \@jb@oo{\@@jb@check :\space off}
  \fi    
}

\iffalse
  \dumpoptions[out]
               #1
  #1-> '0' Output in logfile only (default)
  #1-> '1' Output on screen only 
  #1-> '2' Output in logfile and on screen 
  #1-> '3' Output in document
  
\fi

\newcommand{\dumpoptions}[1][0]{%
  \let\@jb@oo\wlog
  \ifthenelse{#1 = 1}{\let\@jb@oo\typeout}{\relax}%
  \ifthenelse{#1 = 2}{\let\@jb@oo\@jb@oo@screenandlog}{\relax}%
  \ifthenelse{#1 = 3}{\let\@jb@oo\@jb@oo@document}{\relax}%
  \@jb@checkopt{indexpagenumbers}
  \if@dorunners \@jb@oo{norunners: off}\else\@jb@oo{norunners: on}\fi
  \@jb@checkopt{rnrefbold}
  \@jb@checkopt{oldfootnotes}
  \@jb@checkopt{fncontinued}
  \@jb@checkopt{longfnrule}
  \@jb@checkopt{classiclayout}
  \@jb@checkopt{centeredlayout}
  \if@compactlayout \@jb@oo{compact: off}\else\@jb@oo{compact: on}\fi
  \@jb@checkopt{decisionhints}  
  \if@secinovw \@jb@oo{overviewwithsec: off}\else\@jb@oo{overviewwithsec: on}\fi
  \@jb@checkopt{chapterprefix}  
  \@jb@checkopt{chaptersuffix}  
  \@jb@checkopt{fixtocindent}  
  \if@printmaketime \@jb@oo{maketime: off}\else\@jb@oo{maketime: on}\fi
  \@jb@checkopt{officialtitle}  
  \@jb@checkopt{goettingen}  
  \@jb@checkopt{bonn}
}

%========================================
%               
% Weitere Vorbereitungen ...
%
%========================================

% loading jurabook's basis
\LoadClass{book}

\if@fncontinued%
  \@removefromreset{footnote}{chapter}%
\fi

% pdf support
\newif\ifjubopdftex
\jubopdftexfalse

% somewhat complicate construction, but:
% no if ... constructions allowd inside IfFileExists

\newif\if@ifpdfloaded
\@ifpdfloadedfalse

\IfFileExists{ifpdf.sty}%
  {\usepackage{ifpdf}%
   \@ifpdfloadedtrue}%
  {\relax}

\if@ifpdfloaded
  \ifpdf\jubopdftextrue\else\jubopdftexfalse\fi
\else
  \ClassWarningNoLine{jurabook}%
    {Cannot load 'ifpdf.sty' - please get this\MessageBreak
     package from CTAN. Now I'll use a poor man's\MessageBreak
     solution to detect pdf usage ..}%
  \@ifundefined{pdfoutput}%
    {\jubopdftexfalse}% 
    {\jubopdftextrue}% we're using pdfLaTeX
\fi


% this will be set in FinalJuboSettings
\newif\if@jurabibloaded
\@jurabibloadedfalse
\newif\if@hyperrefloaded
\@hyperrefloadedfalse

% Folgender Trick notwendig, sonst bleiben Kopfzeilen kuerzer bei Verwendung
% von a4wide.sty o. ae. Geruempel

\AtBeginDocument{\FinalJuboSettings}

\newcommand{\FinalJuboSettings}{%
  \@ifpackageloaded{babel}%
    {\iflanguage{german}%
      {\addto\captionsgerman{\renewcommand{\partname}{Teil:}}
       \selectlanguage{german}%
      }%
      {\iflanguage{ngerman}%
        {\addto\captionsngerman{\renewcommand{\partname}{Teil:}}
         \selectlanguage{ngerman}%
        }%
        {\ClassWarningNoLine{jurabook}%
          {This class is designed for german documents only,\MessageBreak
           so please select 'german' or 'ngerman' language option}%
        }%
      }%     
    }%
    {% jurabook gibt zwar eine Meldung aus, macht dann aber ungeruehrt weiter ...
     \@ifpackageloaded{german}%
       {\relax}%
       {\@ifpackageloaded{ngerman}%
         {\relax}%
         {\ClassWarningNoLine{jurabook}%
            {This class is designed for german documents only,\MessageBreak
             so please use 'german', 'ngerman' or 'babel' package}%
         }%
       }%  
     \renewcommand{\partname}{Teil:}%
    }% 
  \setchaptername{\textsection}%
  \SetJuboPagestyle%
  \if@longfnrule%   Paketoption 'longfnrule' = TRUE? 
    \renewcommand{\footnoterule}{%
      \kern-3\p@%
      \hrule\@width\columnwidth%
      \kern2.6\p@}%
  \fi%
  \@ifpackageloaded{jurabib}{\@jurabibloadedtrue}{\@jurabibloadedfalse}%
  \@ifpackageloaded{hyperref}{\@hyperrefloadedtrue}{\@hyperrefloadedfalse}%
  \@ifundefined{url}%
    {\ClassWarningNoLine{jurabook}%
       {You should either load the 'jurabib' package\MessageBreak
        or the 'url' package. Now, I will use a faked and\MessageBreak
        improper version of the \string\url\space command}%
       \providecommand{\url}[1]{{\ttfamily ##1}}%
       \providecommand{\urldef}[2]{\@gobble{##1}\@gobble{##2}}% huh?
    }%
    {\relax}%
  \renewcommand{\@pnumwidth}{2em}% statt 1.55
  \renewcommand{\@tocrmarg}{4em}%  statt 2.55
  \setlength{\proofmodetextwidth}{.77\textwidth}%
  \setlength{\proofmodeleftmargin}{\z@}%
}


% einige Reportausgaben:
\AtEndDocument{%
  \wlog{^^J^^J-------------------^^Jjurabook Info:}
  \wlog{\therealchapters\space Kapitel (chapters), \thetotalsections\space Abschnitte (sections).}
  \wlog{\therunner\space Randnummern.}
  \wlog{\thetotalfootnotes\space Fussnoten.}
  \wlog{\thetotaldcs\space Entscheidungen (\thetotaldecisions\space beruecksichtigt, \thetotalnotyets\space nicht beruecksichtigt).}%
  \wlog{\thetotalwebcites\space WWW-Zitierungen innerhalb des Textes.}
  \if@dorunners
    \wlog{Randnummern sind eingeschaltet.}
  \else
    \wlog{Randnummern sind ausgeschaltet!!}
  \fi
  \if@indexpagenumbers
    \wlog{In den Index wurden Seitenzahlen geschrieben.}
  \else
    \wlog{In den Index wurden Randnummern geschrieben.}
  \fi%
  \if@compactlayout
    \wlog{Kompaktes Layout gewaehlt.}
  \fi
  \if@centeredlayout
    \wlog{Zentriertes Layout gewaehlt.}
  \fi  
  \wlog{^^J}%
}

%================================================================================
%               
% Hier beginnen die eigentlichen Befehle 
%
%================================================================================


%============================================
%  Support Macros
%============================================

% used by commands with two optional arguments
\newcommand{\@@firstopt}{}


% style commands
%
% every style command has the following format:
%  \jb @ element @ style 
%
% Example: \jb@title@style

\newcommand*{\jb@officialtitle@style}{\large}

\if@classiclayout
  \newcommand*{\jb@title@style}{\LARGE}
  \newcommand*{\jb@subtitle@style}{\large}
  \newcommand*{\jb@author@style}{\large}
  \newcommand*{\jb@titledate@style}{\large}
\else
  \newcommand*{\jb@title@style}{\Huge\bfseries}
  \newcommand*{\jb@subtitle@style}{\Large}
  \newcommand*{\jb@author@style}{\Large}
  \newcommand*{\jb@titledate@style}{\large}
\fi
\newcommand*{\jb@publishinfo@style}{\Large}
\newcommand*{\jb@thanks@style}{\normalsize}

\newcommand*{\jb@maketime@style}{\small\itshape}


% #1: element
% #2: style

\newcommand{\setjbookstyle}[2]{%
  \@ifundefined{jb@#1@style}%
    {\ClassWarningNoLine{jurabook}%
     {You try to set the element '#1'\MessageBreak
      using the \protect\setjbookstyle\space command,\MessageBreak
      but jurabook does not know this element}}%
    {\expandafter\def\csname jb@#1@style\endcsname{#2}}%
}


%============================================
%               
%  Titelei
%
%============================================


\iffalse
  
  \subtitle{untertitel}
            #1
            
  Ein subtitle ist optional, deswegen wird hier nicht
  der code aus latex.tex uebernommen (dieser fuehrt
  zu einer Fehlermeldung, wenn zB \@title unbesetzt ist).

  \publishinfo{verlag}
             #1
            
  Fuer Verlag o.ae., wird ganz unten auf die Titelseite gesetzt.
              
\fi


\def\subtitle#1{\gdef\@subtitle{#1}}
\def\@subtitle{}
\def\publishinfo#1{\gdef\@publishinfo{#1}}
\def\@publishinfo{}
\def\birthplace#1{\gdef\@birthplace{#1}}
\def\@birthplace{}
\def\publishplace#1{\gdef\@publishplace{#1}}
\def\@publishplace{G\"ottingen}
\def\publishyear#1{\gdef\@publishyear{#1}}
\def\@publishyear{\the\year}

\newcommand*{\firstexaminername}{Berichterstatter:}
\newcommand*{\secondexaminername}{Mitberichterstatter:}
\def\firstexaminer#1{\gdef\@firstexaminer{#1}}
\def\@firstexaminer{}
\def\secondexaminer#1{\gdef\@secondexaminer{#1}}
\def\@secondexaminer{}
\def\examdate#1{\gdef\@examdate{#1}}
\def\@examdate{\today}

\if@titlepage%
  \if@officialtitle%
    \if@goettingen
     \wlog{hi}
      \ClassInfo{jurabook}{Setting up the official titlepage (goettingen)\@gobble}
      \renewcommand{\maketitle}{%
        \begin{titlepage}
          \begin{center}
            \jb@officialtitle@style%
            \@title \par%
            \ifx\@subtitle\@empty% 
            \else
              \vskip 4ex\par
              \@subtitle\par%
            \fi
            \vskip 8ex\par%
            Dissertation\bigskip
          
            zur Erlangung des Doktorgrades\par
            des Juristischen Fachbereichs\par
            (Juristische Fakult\"at)\par
            der Georg-August-Universit\"at zu G\"ottingen\par%
            \vskip 2ex
          
            vorgelegt\par
            von\par%
            \vskip 4ex
            \@author\par%
            \vskip 2ex
            aus \@birthplace\par
            \vskip 4ex
            \@publishplace\space\@publishyear
          \end{center}
          \newpage
          \thispagestyle{empty}
          \begin{tabular}[2]{ll}
          \firstexaminername & \@firstexaminer\\
          \secondexaminername & \@secondexaminer\\
          Tag der m\"undlichen Pr\"ufung: & \@examdate\\\
          \end{tabular}
        \end{titlepage}%
        \@emptytitles%
        }
    \else
      \if@bonn % for testing purposes
        \ClassInfo{jurabook}{Setting up the official titlepage (bonn)\@gobble}
      \else
%        hier kommen vielleicht einmal andere Unis hinein ...
      \fi
    \fi%
  \else%
    \renewcommand{\maketitle}{%
      \begin{titlepage}%
        \let\footnotesize\small
        \let\footnoterule\relax
        \let \footnote \thanks
        \null\vfil%
        %\vskip 60\p@
        \begin{center}%
        \if@classiclayout% original definition: 
          {\jb@title@style\@title\par}%
          \ifx\@subtitle\@empty% \ifthenelse funzt hier nicht wg. moegl. '\\'
          \else%
            {\jb@subtitle@style\vskip 4ex\@subtitle\par}%
          \fi%
          {\jb@author@style
           \vskip 8ex von\par
           \vskip 1ex%
           \lineskip .75em%
           \begin{tabular}[t]{c}%
             \@author
           \end{tabular}\par%
           \vskip 1.5em}%
          {\jb@titledate@style\@date\par}%
        \else % slightly modernized:
          {\jb@title@style\vskip 2ex \@title\par}%
          \ifx\@subtitle\@empty% \ifthenelse funzt hier nicht wg. moegl. '\\'
          \else
            {\jb@subtitle@style\vskip 4ex\@subtitle \par}%
          \fi%
          {\jb@author@style\vskip 8ex von\par
           \vskip 1ex%
           \lineskip .75em%
           \begin{tabular}[t]{c}%
             \@author
           \end{tabular}\par%
           \vskip 1.5em}
          {\jb@titledate@style\@date\par}%     
        \fi%
        \end{center}\par  
        {\jb@thanks@style\@thanks\par}
        \ifx\@publishinfo\@empty%
          {\vfil\null}%
        \else% 
          {\vfill\hfil\jb@publishinfo@style\@publishinfo\hfil}%
        \fi%
      \end{titlepage}%
    \@emptytitles%
    }%
  \fi  
\else % Option 'notitlepage' gesetzt - nicht mit jurabook!
  \ClassError{jurabook}%
    {jurabook does not support the 'notitlepage' option.}%
    {Remove 'notitlepage' option or use the original book class.}%
\fi

\newcommand{\@emptytitles}{%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \global\let\@subtitle\@empty
  \global\let\@publishinfo\@empty  
  \global\let\@birthplace\@empty
  \global\let\@publishplace\@empty
  \global\let\@publishyear\@empty
  \global\let\@firstexaminer\@empty
  \global\let\@secondexaminer\@empty
  \global\let\@examdate\@empty
  \global\let\subtitle\relax
  \global\let\publishinfo\relax  
  \global\let\birthplace\relax
  \global\let\publishplace\relax
  \global\let\publishyear\relax
  \global\let\firstexaminer\relax
  \global\let\secondexaminer\relax  
  \global\let\examdate\relax%
}
  

%============================================
%               
%  Seitenlayout
%
%============================================


%========================================
% Umschalten auf 1 1/2 Zeilenabstand
%========================================

\iffalse
 vgl. Begleiter 90, 52
 
 linespread statt baselinestretch?
\fi

\providecommand{\onehalfspacing}{% 
  \normalsize
  \ifthenelse{\@ptsize = 0}% 10pt
    {\renewcommand{\baselinestretch}{1.25}}%
    {}
  \ifthenelse{\@ptsize = 1}% 11pt
    {\renewcommand{\baselinestretch}{1.21}}%
    {}
  \ifthenelse{\@ptsize = 2}% 12pt
    {\renewcommand{\baselinestretch}{1.24}}%
    {}
  \normalsize  
}

\providecommand{\onespacing}{% den Spass wieder zurueck auf einzeilig
  \renewcommand{\baselinestretch}{\@ne}%
  \normalsize}


%========================================
% Fussnoten
%========================================

\newcounter{totalfootnotes}\setcounter{totalfootnotes}{\z@}

\newlength{\fnlabelwidth}
\if@fncontinued
  \settowidth{\fnlabelwidth}{\footnotesize 9999}%
\else%
  \settowidth{\fnlabelwidth}{\footnotesize 999}%
\fi   

\if@oldfootnotes% Paketoption 'oldfootnotes' = TRUE?
% hier das 'altmodische' Layout
% identisch mit LaTeX-Vorgabe, aber einzeilig
  \renewcommand{\@makefntext}[1]{%
    \stepcounter{totalfootnotes}%
    \renewcommand{\baselinestretch}{\@ne}% (nur) dieses hinzugefuegt fuer einzeilige Ausgabe
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1%
    }
\else%
  \newlength{\fnmarksep} % Platz zwischen Fussnote und Fussnotentext
  \setlength{\fnmarksep}{3pt}%
  \renewcommand{\@makefntext}[1]{%
    \stepcounter{totalfootnotes}%
    \renewcommand{\baselinestretch}{\@ne}%
    \setlength{\parindent}{\z@}%
    \begin{list}{}{%
      \setlength{\labelwidth}{\fnlabelwidth}%
      \setlength{\leftmargin}{\labelwidth}%
      \addtolength{\leftmargin}{\fnmarksep}%
      \setlength{\labelsep}{\leftmargin}%
      \addtolength{\labelsep}{-\labelwidth}%
      \setlength{\itemsep}{\z@}%
      \setlength{\itemindent}{\z@}%
      \setlength{\parsep}{\z@}%
      \setlength{\topsep}{\z@}%
      \setlength{\partopsep}{\z@}%
      \footnotesize}%
      \item[\@makefnmark\hfill]#1%
    \end{list}%
    }
\fi

\let\fussnote=\footnote % for historic reasons! :-)


%============================================
%               
%  Kopf- und Fusszeilen / Kolummentitel
%
%============================================

\iffalse
  mit fancyhdr-Paket
  
 (Begleiter 96f., Loesung S. 99 Abb 4.6
 

 twoside
 =======
  
 | gerade Seiten (even)            | ungerade Seiten (odd)            |
 |                                 |                                  |
 | Seite       x chapter          |           II. section      Seite |
 ----------------------------------------------------------------------
 |                                 |                                  |
 
 
 oneside (maybe pdf disk versions)
 =======

 |                                 | 
 |                                 | 
 |             x chapter          | 
 -----------------------------------
 |                                 |  
 |                                 |
 -----------------------------------
 |                                 |
 |             Seite               |


 
 (P): \pagestyle{fancyplain} setzt jedes mal die Kolumnentitel neu
 \renewcommand innerhalb eines \newcommand klappt nicht,
 deshalb Rueckgriff auf ##1 !

\fi

\newcommand*{\maketimename}{Stand:}

\newcommand*{\@maketime}{\today}
\newcommand{\setmaketime}[1]{%
  \renewcommand{\@maketime}{#1}%
}


% adopted to fancyhdr v2.0
\newcommand{\SetJuboPagestyle}{%
  \pagestyle{fancy}%
  \if@classiclayout
    \fancyhead{}
    \if@printmaketime
      \fancyhead[LE,RO]{\jb@maketime@style\maketimename\space\@maketime}
    \fi
    \fancyfoot{}
    \fancyfoot[LE,RO]{\thepage}
    \renewcommand{\headrulewidth}{0pt}%
  \else% Standard:
    \def\chaptermark##1{\markboth {\jubo@chaptercomplete\quad ##1}{}}%
    \def\sectionmark##1{\markright {\thesection\space ##1}}%
    \fancyhead{}
    \if@twoside
      \fancyhead[LE,RO]{\thepage}
      \fancyhead[CE]{\leftmark}
      \fancyhead[CO]{\rightmark}
      \fancyfoot{}
      \if@printmaketime
        \fancyfoot[LE,RO]{\jb@maketime@style\maketimename\space\@maketime}
      \fi
%     \headrulewidth (Strich in der Kopfzeile) bleibt auf default wert 0.4pt
    \else
      \chead{\leftmark}
      \cfoot{\thepage}
      \if@printmaketime
        \rfoot{\jb@maketime@style\maketimename\space\@maketime}
      \fi
    \fi
  \fi%
}

\iffalse
 Vergroessern der Kopfhoehe, um Fehlermeldungen von 'fanychdr' zu vermeiden
 (vgl.  fanychdr.dvi, p. 12)
 bei 10pt ist das nicht notwendig
\fi

\ifthenelse{\@ptsize = 1}%            11pt? (gilt fuer ec-Schrift)
  {\addtolength{\headheight}{1.6\p@}}% otherwise 'Overfull \vbox (1.59999pt too high) ...'
  {}
\ifthenelse{\@ptsize = 2}%            12pt?
  {\addtolength{\headheight}{2.5\p@}}% otherwise 'Overfull \vbox (2.49998pt too high) ...'
  {}


\iffalse
  Folgender Trick ist unmittelbar geklaut aus:
  Kloeckl, 3.4.3, S. 116 ff.
  fancyhdr.pdf, chapter 14
  
  Bewirkt, dass leere Seiten nach \chapter
  keine Kolumnentitel enthalten.
  
  Wird implizit von \chapter aufgerufen.
\fi


\renewcommand{\cleardoublepage}{%
  \clearpage%
  \if@twoside%
    \ifodd\c@page%
    \else%
      \thispagestyle{empty}%
      \mbox{}\newpage%
      \if@twocolumn\mbox{}\newpage\fi % really necessary?!
    \fi%
  \fi%
}



%========================================
% Randnummern (= runners)
%========================================

% (siehe auch Begleiter 74)

% Randnummernzaehler:
\newcounter{runner}
\renewcommand{\therunner}{\arabic{runner}}

% Zaehler fuer nachtraeglich eingefuegte Rn.
\newcounter{extrarunner}[runner]
\renewcommand{\theextrarunner}{\therunner\alph{extrarunner}}

% Wird beim Referenzieren benoetigt:
\newcommand*{\rnname}{Rn.}
\newcommand*{\jubopagename}{S.} 

% Platz fuer Randnummer:
\newlength{\oddmarginspace}
\setlength{\oddmarginspace}{1em}
\addtolength{\oddmarginspace}{-\marginparsep}


\iffalse Randnnummer setzen

  \rn[marke]{Erstes} Wort, denn hier faengt der Absatz an
      #1     #2
  
  #1: Marke (optional, default: keine Marke)
  #2: Das Wort, mit dem der Absatz eingeleitet wird.

\fi

\newcommand*{\rn}[2][]{%
  \if@dorunners%
    \stepcounter{runner}%
    #2\marginpar%
      [\hfill{{\bfseries\therunner}}\quad\quad]%   % Stimmt zwar, aber warum?!
      {\quad {\bfseries\therunner}}%
%   hiermit wird entsprechender Eintrag in die toc gesetzt:
    \protected@edef\@currentlabel{\therunner}%
  \fi% dieses Kommentarzeichen MUSS hier hin, sonst gibt es unerwuenschte Leerzeichen!
  \ifthenelse{\equal{#1}{\@empty}}%
    {}% nix
    %else
    {\label{#1}}%
}    


\iffalse nachtraeglich Randnummer einfuegen (fuer 2. Auflage, sonst sinnlos)

  \extrarn[marke]{Erstes} Wort, denn hier faengt der Absatz an
           #1     #2

  #1: Marke (optional, default: keine Marke)
  #2: Das Wort, mit dem der Absatz eingeleitet wird.
  
  Der stepcounter-Befehl muss auch hier am Anfang erscheinen,
  Weil sonst es nicht auf 'a' gesetzt wird (0<>a).
  
  UNGETESTET!
\fi

\newcommand*{\extrarn}[2][]{%
  \stepcounter{extrarunner}#2\marginpar%
  [\hfill{\textbf{\theextrarunner}}\quad\quad]%   % Stimmt zwar, aber warum?!
  {\quad \textbf{\theextrarunner}}%
% hiermit entsprechender Eintrag in toc:
  \protected@edef\@currentlabel{\therunner\theextrarunner}
  \ifthenelse{\equal{#1}{\@empty}}%
    {}% nix!
  %else
    {\label{#1}}%
  }
  

\iffalse Randnummer referenzieren

  \mnref{marke}
         #1

  #1: Bezeichnung der Marke, auf die verwiesen wird
  
  \mnreff setzt autom. ein 'f.' dahinter,
  \mnrefff ein 'ff.'
\fi

\newcommand{\rnref}[1]{%
  \if@dorunners%
    \if@rnrefbold% Paketoption 'rnefbold' = TRUE? 
      {\bfseries \rnname~\ref{#1}}%
    \else%
      \rnname~\ref{#1}%
    \fi
  \else
    \jubopagename~\ref{#1}%  
  \fi%
  }
  
\newcommand{\rnreff}[1]{%
  \rnref{#1}~f.}

\newcommand{\rnrefff}[1]{%
  \rnref{#1}~ff.}

\newcommand*{\dnrefname}{unten}
\newcommand*{\uprefname}{oben}

\newcommand*{\autornref}[1]{%
}    
   
%========================================
%               
% Bucheinteilungen (Matters)
%
%========================================

% Am Buchanfang wird immer mit grossen Roemischen Zahlen paginiert:

\renewcommand{\frontmatter}{%
  \cleardoublepage%
  \@mainmatterfalse%
  \pagenumbering{Roman}%
}

% main matter faengt nicht wieder bei 1 an.???

\renewcommand{\mainmatter}{%
  \@ifstar{\jb@mainmatters}{\jb@mainmatter}
}
  
\newcommand{\jb@mainmatter}{%
  \cleardoublepage%
  \@mainmattertrue%
  \setcounter{page}{\@ne}%
  \pagenumbering{arabic}%
}


\newif\if@jubo@proofmode
\@jubo@proofmodefalse
\newlength{\proofmodetextwidth}
\newlength{\proofmodeleftmargin}

\newlength{\jb@textwidth}
\newlength{\jb@columnwidth}
\newlength{\jb@hsize}
\newlength{\jb@linewidth}
\newlength{\jb@headwidth}
\newlength{\jb@evensidemargin}
\newlength{\jb@oddsidemargin}

\newcommand{\jb@mainmatters}{%
  \jb@mainmatter%
  \ClassWarningNoLine{jurabook}%
     {\protect\mainmatter* command is switching to proof mode,\MessageBreak
      text will by typeset in a rather small column.\MessageBreak
      (textwidth=\the\proofmodetextwidth)\MessageBreak
      From now on, EVERYTHING can happen ..}%
  \if@twoside
    \ClassWarningNoLine{jurabook}%
     {When using \protect\mainmatter*, please\MessageBreak
      use the 'oneside' option also}%
  \fi    
  \@jubo@proofmodetrue%   
  % don't try this at home ... =:O
  \setlength{\jb@textwidth}{\textwidth}%
  \setlength{\jb@columnwidth}{\columnwidth}%
  \setlength{\jb@hsize}{\hsize}%
  \setlength{\jb@linewidth}{\textwidth}%
  \setlength{\jb@headwidth}{\headwidth}%
  \setlength{\jb@evensidemargin}{\evensidemargin}%
  \setlength{\jb@oddsidemargin}{\oddsidemargin}%
  \setlength{\textwidth}{\proofmodetextwidth}%
  \setlength{\columnwidth}{\textwidth}%
  \setlength{\hsize}{\textwidth}%
  \setlength{\linewidth}{\textwidth}% 
  \setlength{\headwidth}{\textwidth}%
  \setlength{\evensidemargin}{\proofmodeleftmargin}%
  \setlength{\oddsidemargin}{\proofmodeleftmargin}%
}

\renewcommand{\backmatter}{%
  \if@jubo@proofmode%
    \ClassWarningNoLine{jurabook}%
      {Leaving proof mode, switching back to\MessageBreak
       normal textwidth}%
    \setlength{\textwidth}{\jb@textwidth}%
    \setlength{\columnwidth}{\jb@columnwidth}%
    \setlength{\hsize}{\jb@hsize}%
    \setlength{\linewidth}{\jb@linewidth}% 
    \setlength{\headwidth}{\jb@headwidth}%
    \setlength{\evensidemargin}{\jb@evensidemargin}%
    \setlength{\oddsidemargin}{\jb@oddsidemargin}%
  \fi%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmatterfalse%
  \@jubo@proofmodefalse%
}


%==============================================
%               
% Inhaltsverzeichnis und (optionale) Uebersicht
%
%==============================================

\iffalse
  alles wie im original book.cls, 
  aber ohne die \MakeUppercase Befehle
\fi

\renewcommand{\tableofcontents}{%
  \if@twocolumn
    \@restonecoltrue\onecolumn
  \else
    \@restonecolfalse
  \fi
  \@chapter@withoutnumber@notoc{\contentsname}%
  \@starttoc{toc}%
  \if@restonecol\twocolumn\fi%
}


%====================================================
% Ausgabe der Inhaltsuebersicht 
%====================================================

\iffalse
 Grds.: werden hier nur die Chapter aufgelistet
 Ausn.: 'overviewwithsec'-Option gesetzt, dann
        auch Sections.

 (zur Loesung Begleiter 37 ff.)
\fi

\newcommand{\overviewname}{Inhalts\"ubersicht}
\newcommand{\overview}{% geklaut aus book.cls, ohne \makeuppercase
  \if@twocolumn
    \@restonecoltrue\onecolumn
  \else
    \@restonecolfalse
  \fi%
  \@chapter@withoutnumber@notoc{\overviewname}%
  \@starttoc{ovw}%
  \if@restonecol\twocolumn\fi%
}


%========================================
%               
% Parts and Chapters 
%
%========================================


% putting linefeeds into headings
\newcommand{\hnewline}{\relax}
\newcommand{\@@part@hnewline}{\par}
\if@centeredlayout
  \newcommand{\@@chapter@hnewline}{\par}
\else
  \newcommand{\@@chapter@hnewline}{\newline}
\fi


\iffalse
 copied from book.tex and modified:
 
 \part{Einfuehrung} -> 'Erster Teil: Einfuehrung'
 
\fi

%========================================
% Parts
%========================================

\renewcommand{\thepart}{%
  \ifcase\value{part} 
  \or Erster%
  \or Zweiter%
  \or Dritter%
  \or Vierter%
  \or F\"unfter%
  \or Sechster%
  \or Siebter%
  \or Achter%
  \or Neunter%
  \or Zehnter%
  \or Elfter%
  \or Zw\"olfter%
  \else%
    \ClassError{jurabook}%
      {Too many parts.}%
      {Contact juramisc@sodtalbers.de!}
  \fi%
}


% soll chapter-Befehl einen Seitenwechsel ausloesen?
% abhaengig von Option 'compact': 
%   wenn 'compact'=TRUE, 
%     dann nach part nicht auf eigene Seite

\newif\if@chapterclearpage 
\@chapterclearpagetrue


%  \part[intext]{text}
%        #1      #2
%
%  'text' (#2) is put into the toc in any case
%  pagestyle is 'empty' (not 'plain', as in book.cls)    

\renewcommand{\part}{%
  \if@openright\cleardoublepage\else\clearpage\fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi%
  \if@compactlayout%
    \@chapterclearpagefalse%
  \else%
    \@chapterclearpagetrue%
    \null\vfil%
  \fi% 
  \secdef\@part\@spart%
}
  

% opt         #1: title in text, possibly incl. \hnewline = \par
%             #2: title

\renewcommand{\@part}[2][]{%
  \ifnum \c@secnumdepth >-2\relax
    \refstepcounter{part}%
    \if@centeredlayout%
      \addtocontents{toc}{\protect\@partlinecenter{\thepart\space\partname}{#2}}%
      \addtocontents{ovw}{\protect\@partlinecenter{\thepart\space\partname}{#2}}%
    \else%
      \addcontentsline{toc}{part}{\thepart\space\partname\space #2}%
      \addcontentsline{ovw}{part}{\thepart\space\partname\space #2}%
    \fi%
  \else%
     \addcontentsline{toc}{part}{#2}%
     \addcontentsline{ovw}{part}{#2}%
  \fi%
  \markboth{}{}%
  \begingroup%
    \centering%
    \interlinepenalty \@M%
    \normalfont%
    \ifnum \c@secnumdepth >-2\relax
      \huge\bfseries \thepart~\partname\ 
      \par
      \vskip 20\p@
    \fi
    \Huge\bfseries%
    \ifthenelse{\equal{#1}{\@empty}}%
      {#2\par}%
      {\let\hnewline\@@part@hnewline%
       #1\par}%
  \endgroup
  \@endpart%
}

\renewcommand{\@endpart}{%
  \if@compactlayout%
    \vskip \baselineskip%
  \else%
    \vfil\vfil% one more vfil than in original book.cls
    \newpage%
    \if@twoside%
      \null%
      \thispagestyle{empty}%
      \newpage%
    \fi%
  \fi%
  \if@tempswa%
    \twocolumn%
  \fi%
}


%========================================
% Grundlegende Einstellungen fuer
% chapter, sections, subsections ...
%========================================

\newlength{\chapternumwidth}
\newlength{\sectionnumwidth}
\newlength{\subsectionnumwidth}
\newlength{\subsubsectionnumwidth}
\newlength{\subthreesectionnumwidth}
\newlength{\subfoursectionnumwidth}
\newlength{\subfivesectionnumwidth}
\newlength{\subsixsectionnumwidth}


\newlength{\sectiontocindent}
\newlength{\subsectiontocindent}
\newlength{\subsubsectiontocindent}
\newlength{\subthreesectiontocindent}
\newlength{\subfoursectiontocindent}
\newlength{\subfivesectiontocindent}
\newlength{\subsixsectiontocindent}

\newlength{\defaulttocindent}
\setlength{\defaulttocindent}{1.5em}


% Folgendes wird auf jeden Fall in 
% FinalJuboSettings / AtBeginDocument aufgerufen:

\newcommand{\jubo@settocindents}{%
  \if@chapterprefix%
    \settowidth{\chapternumwidth}{\chaptername~999\space}% warum drei x 9? zweimal ist zu knapp
  \else% chaptersuffix:
    \settowidth{\chapternumwidth}{999.~\chaptername\space}%
  \fi%
  \settowidth{\sectionnumwidth}{VIII.\ }%
  \settowidth{\subsectionnumwidth}{88.\ }%
  \settowidth{\subsubsectionnumwidth}{b).\ }%
  \settowidth{\subthreesectionnumwidth}{bb)\ }%
  \settowidth{\subfoursectionnumwidth}{bbb)\ }%
  \settowidth{\subfivesectionnumwidth}{(88)\ }%
  \settowidth{\subsixsectionnumwidth}{(b)\ }%
  \if@chapterprefix%
    \setlength{\sectiontocindent}{\chapternumwidth}%
  \else%
    \settowidth{\@tempdima}{99.\space}%
    \setlength{\sectiontocindent}{\@tempdima}%  
  \fi  
  \if@fixtocindent%
    \setlength{\sectiontocindent}{\defaulttocindent}% = 1.5em per default
  \fi%  
  \setlength{\subsectiontocindent}{\sectiontocindent}%
  \addtolength{\subsectiontocindent}{\sectionnumwidth}%
  \setlength{\subsubsectiontocindent}{\subsectiontocindent}%
  \addtolength{\subsubsectiontocindent}{\subsectionnumwidth}%
  \setlength{\subthreesectiontocindent}{\subsubsectiontocindent}%
  \addtolength{\subthreesectiontocindent}{\subsubsectionnumwidth}%
  \setlength{\subfoursectiontocindent}{\subthreesectiontocindent}%
  \addtolength{\subfoursectiontocindent}{\subthreesectionnumwidth}%
  \setlength{\subfivesectiontocindent}{\subfoursectiontocindent}%
  \addtolength{\subfivesectiontocindent}{\subfoursectionnumwidth}%
  \setlength{\subsixsectiontocindent}{\subfivesectiontocindent}%
  \addtolength{\subsixsectiontocindent}{\subfivesectionnumwidth}%
}  


%========================================               
% Chapters 
%========================================

\iffalse
  Neudefinition der Kapitelueberschriften (aus 'book.cls'):
  - kein einzelnes "Kapitel X" mehr
  - stattdessen:  2 (...) (default)
  - bringt *stets* die lange Kapitel-Ueberschrift ins Inhaltsverzeichnis
  - pagestyle ist empty (nicht: plain)
  
  \renewcommand*{\chaptername}{\textsection} -> oben in AtBeginDocument
  
  Siehe auch oben die Neudefinition von \cleardoublepage{}

  Kloeckl S. 90: Format der Ueberschriften und der Nummern  
 
  \@makechapterhead{text}
                    #1

  \@chapapp   -> \chaptername -> '\textsection' -> ''
  \thechapter =  Kapitelnummer.
  #1          =  Ueberschrift
 
\fi

\newcommand{\chapterextra}{}

% \setchaptername[#1]{#2}
% #1 -> prefix
% #2 -> chaptername (default: \textsection)

\newcommand{\setchaptername}[2][]{%
  \@ifpackageloaded{babel}%
    {\iflanguage{german}%
      {\addto\captionsgerman{\renewcommand{\chaptername}{#2}}%
       \selectlanguage{german}%
      }%
      {\iflanguage{ngerman}%
        {\addto\captionsngerman{\renewcommand{\chaptername}{#2}}%
         \selectlanguage{ngerman}%
        }%
        {\ClassWarningNoLine{jurabook}%
          {This class is designed for german documents only,\MessageBreak
           so please select german or ngerman language option.}}%
      }%           
    }%
    {% jurabook gibt zwar eine Meldung aus, macht dann aber ungeruehrt weiter ...
     \@ifpackageloaded{german}%
       {\relax}%
       {\@ifpackageloaded{ngerman}%
         {\relax}%
         {\ClassWarningNoLine{jurabook}%
            {This class is designed for german documents only,\MessageBreak
             so please use 'german', 'ngerman' or 'babel' package}%
         }%
       }%
     \renewcommand{\chaptername}{#2}%
    }% 
  \renewcommand{\chapterextra}{#1}%
  \jubo@settocindents%
} 

\renewcommand{\thechapter}{\arabic{chapter}}

\newcounter{realchapters}
\setcounter{realchapters}{\z@}

\newcommand{\jubo@chaptercomplete}{}
\newcommand{\make@jubo@chaptercomplete}{%
  \if@chapterprefix%
    \renewcommand{\jubo@chaptercomplete}{\@chapapp~\thechapter\chapterextra}
  \else%
    \renewcommand{\jubo@chaptercomplete}{\thechapter.~\@chapapp\chapterextra}
  \fi%
  }
\newlength{\@chaptercompletelength}


\renewcommand{\chapter}{%
  \if@chapterclearpage%
    \if@openright\cleardoublepage\else\clearpage\fi%
  \else%
    \@chapterclearpagetrue%
  \fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \global\@topnum\z@%
  \@afterindentfalse
  \secdef\@chapter\@schapter%
}


\renewcommand{\@chapter}[1][]{%
  \renewcommand{\@@firstopt}{#1}%
  \@@chapter%
}


% opt @@firstopt: shorttitle
% opt         #1: title in text, possibly incl. \hnewline = \par
%             #2: title

\newcommand{\@@chapter}[2][]{%
  \stepcounter{realchapters}%
  \ifnum \c@secnumdepth >\m@ne
    \if@mainmatter
      \make@jubo@chaptercomplete%
      \refstepcounter{chapter}%
      \if@chapterprefix%
        \typeout{^^JChapter\space\thechapter\chapterextra^^J------------}%
      \else
        \typeout{^^J\thechapter.\space Chapter\chapterextra^^J------------}%
      \fi  
      \addcontentsline{toc}{chapter}{%
         \protect\numberline{\jubo@chaptercomplete}#2}%
      \addcontentsline{ovw}{ovwchapter}{% Overview
         \protect\numberline{\jubo@chaptercomplete}#2}%
    \else%
      \addcontentsline{toc}{chapter}{#2}%
      \addcontentsline{ovw}{ovwchapter}{#2}% 
    \fi%
  \else%
    \addcontentsline{toc}{chapter}{#2}%
    \addcontentsline{ovw}{chapter}{#2}%
  \fi
  \ifthenelse{\equal{\@@firstopt}{\@empty}}%
    {\chaptermark{#2}}% else
    {\chaptermark{\@@firstopt}}%
  \addtocontents{lof}{\protect\addvspace{10\p@}}%
  \addtocontents{lot}{\protect\addvspace{10\p@}}%
  \if@twocolumn%
    \ifthenelse{\equal{#1}{\@empty}}%
      {\@topnewpage[\@makechapterhead{#2}]}%
      {\let\hnewline\@@chapter@hnewline%
       \@topnewpage[\@makechapterhead{#1}]}  
  \else%
    \ifthenelse{\equal{#1}{\@empty}}%
      {\@makechapterhead{#2}}%
      {\let\hnewline\@@chapter@hnewline%
       \@makechapterhead{#1}}%
    \@afterheading%
  \fi%
}


\renewcommand{\@makechapterhead}[1]{%
  \make@jubo@chaptercomplete%
  \vspace*{50\p@}%
  \if@centeredlayout%
    {\centering \normalfont%
     \ifnum \c@secnumdepth >\m@ne
       \if@mainmatter
         \begingroup
           \huge\bfseries\jubo@chaptercomplete\quad 
           #1\par
         \endgroup%
       \fi%
     \else%    
       \huge\bfseries #1%
     \fi%  
    }%
  \else%
    \settowidth{\@chaptercompletelength}{\huge\bfseries \jubo@chaptercomplete\quad}%
    {\parindent \z@ \raggedright \normalfont%
      \ifnum \c@secnumdepth >\m@ne% 
        \if@mainmatter%
          \begingroup%
            \hangindent=\@chaptercompletelength%
            \huge\bfseries\jubo@chaptercomplete\quad%
            {\raggedright #1\par}%
          \endgroup%
        \fi%
      \else%
        \huge\bfseries #1%
      \fi%
    }%
  \fi%
  \vskip 40\p@%  
}  


%=====================================
%               
% \@chapter@withoutnumber{heading}
%                         #1
%
% put #1 ...
%   ... as chapter heading
%   ... in the headline
%   ... into toc / ovw
%=====================================


\newcommand{\@chapter@withoutnumber}[1]{%
  \typeout{^^J#1^^J------------}%
  \if@openright\cleardoublepage\else\clearpage\fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \global\@topnum\z@%
  \@afterindentfalse%
  \addcontentsline{toc}{extrajubostuff}{\protect\numberline{}#1}%
  \addcontentsline{ovw}{extrajubostuff}{\protect\numberline{}#1}%
  \addtocontents{lof}{\protect\addvspace{10\p@}}%
  \addtocontents{lot}{\protect\addvspace{10\p@}}%
  \markboth{#1}{#1}%
  \if@twocolumn
    \@topnewpage[\@makechapterhead@withoutnumber{#1}]%
  \else
    \@makechapterhead@withoutnumber{#1}%
    \@afterheading%
  \fi%
}


%=====================================
%               
% \@chapter@withoutnumber@notoc{heading}
%           #1
%
% put #1 ...
%   ... as chapter heading
%   ... in the headline
%=====================================

\newcommand{\@chapter@withoutnumber@notoc}[1]{%
  \typeout{^^J#1^^J------------}%
  \if@openright\cleardoublepage\else\clearpage\fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \global\@topnum\z@%
  \@afterindentfalse%
  \markboth{#1}{#1}%
  \if@twocolumn
    \@topnewpage[\@makechapterhead@withoutnumber{#1}]%
  \else
    \@makechapterhead@withoutnumber{#1}%
    \@afterheading%
  \fi%
}  
\let\@schapter\@chapter@withoutnumber@notoc%


\newcommand{\@makechapterhead@withoutnumber}[1]{%
  \vspace*{50\p@}%
  \if@centeredlayout%
    {\centering\normalfont\huge\bfseries #1\par}%
  \else%
    {\normalfont\huge\bfseries\noindent #1\par}%
  \fi%
  \vskip 40\p@%
}


\newcommand{\changestarchapters}{%
  \let\@schapter\@chapter@withoutnumber
}

\newcommand{\resetstarchapters}{%
  \let\@schapter\@chapter@withoutnumber@notoc%
}


%=====================================
%               
% Appendix / Anhang
%
%=====================================   

\iffalse

  Hier befinden sich die Makros fuer chapter im Anhang. 
  Auf diese Definitionen wird umgeschaltet durch den
  \appendix Befehl.

  (sind zum grossen Teil identisch mit obigen Makros,
  liess sich jedoch nicht ohne Chaos abkuerzen ...)
    
\fi


\renewcommand{\appendix}{%
  \par
  \setcounter{chapter}{\z@}%
  \setcounter{section}{\z@}%
  \renewcommand{\thechapter}{\Alph{chapter}}%
  \renewcommand{\chaptermark}[1]{%
    \markboth{\appendixname\space\thechapter\space ##1}{\appendixname\space\thechapter\space ##1}%
  }%
  \let\chapter\appendixchapter%
}


% lonelyappendix = appendix without a counter ('Appendix' instead of 'Appendix A')
\newif\if@lonely@appchap
\@lonely@appchapfalse

\newcommand{\appendixchapter}{%
  \if@openright\cleardoublepage\else\clearpage\fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \global\@topnum\z@%
  \@afterindentfalse
  \secdef\@appendixchapter\@schapter%
}


\newcommand{\lonelyappendixchapter}{%
  \if@lonely@appchap%
    \ClassWarning{jurabook}%
      {You are using \protect\lonelyappendixchapter, but the\MessageBreak%
       appendix contains more than one chapter. Better\MessageBreak%
       use a simple \protect\chapter\space command}%
  \else%
  \fi%
  \@lonely@appchaptrue%
  \renewcommand{\chaptermark}[1]{%
    \markboth{\appendixname\space ##1}{\appendixname\space ##1}%
  }%
  \if@openright\cleardoublepage\else\clearpage\fi%
  \chapterlevel%
  \thispagestyle{empty}%
  \global\@topnum\z@%
  \@afterindentfalse
  \secdef\@appendixchapter\@schapter%
}


\newcommand{\@appendixchapter}[1][]{%
  \renewcommand{\@@firstopt}{#1}%
  \@@appendixchapter%
}

% opt @@firstopt: shorttitle
% opt         #1: title in text, possibly incl. \hnewline = \par
%             #2: title

\newcommand{\@@appendixchapter}[2][]{%
  \if@lonely@appchap%
    \typeout{^^JLonely Appendix^^J------------}%
    \addcontentsline{toc}{extrajubostuff}{%
      \protect\numberline{}\appendixname\space #2}%
    \addcontentsline{ovw}{extrajubostuff}{% Overview
      \protect\numberline{}\appendixname\space #2}%
  \else%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{chapter}%
      \typeout{^^JAppendix\space\thechapter^^J------------}%
      \addcontentsline{toc}{appendixchapter}{%
        \protect\numberline{\appendixname\space\thechapter}#2}%
      \addcontentsline{ovw}{ovwappendixchapter}{% Overview
        \protect\numberline{\appendixname\space\thechapter}#2}%
    \else%
      \addcontentsline{toc}{appendixchapter}{#2}%
      \addcontentsline{ovw}{ovwappendixchapter}{#2}%
    \fi%
  \fi
  \ifthenelse{\equal{\@@firstopt}{\@empty}}%
    {\chaptermark{#2}}%
    {\chaptermark{\@@firstopt}}
  \addtocontents{lof}{\protect\addvspace{10\p@}}%
  \addtocontents{lot}{\protect\addvspace{10\p@}}%
  \if@twocolumn
    \ifthenelse{\equal{#1}{\@empty}}%
      {\@topnewpage[\@makeappendixchapterhead{#2}]}%
      {\let\hnewline\@@chapter@hnewline%
       \@topnewpage[\@makeappendixchapterhead{#1}]}%
  \else
    \ifthenelse{\equal{#1}{\@empty}}%
      {\@makeappendixchapterhead{#2}}%
      {\let\hnewline\@@chapter@hnewline%
       \@makeappendixchapterhead{#1}}%
    \@afterheading%
  \fi%
}


\newcommand{\@makeappendixchapterhead}[1]{%
  \vspace*{50\p@}%
  \if@centeredlayout%
    {\centering \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \if@mainmatter
         \begingroup
         \huge\bfseries
           \if@lonely@appchap%
             \appendixname\quad%
           \else%
             \appendixname~\thechapter\quad%
           \fi%  
         #1\par
         \endgroup
       \fi
     \else    
       \huge\bfseries #1
     \fi%  
    }%
  \else%
    {\if@lonely@appchap%
       \settowidth{\@chaptercompletelength}{\huge\bfseries\appendixname\quad}%
     \else%
       \settowidth{\@chaptercompletelength}{\huge\bfseries\appendixname~\thechapter\quad}%
     \fi%
     \begingroup%
       \parindent \z@ \raggedright \normalfont%
       \ifnum \c@secnumdepth >\m@ne
         \if@mainmatter
           \begingroup%
             \hangindent=\@chaptercompletelength%
             \if@lonely@appchap
               \huge\bfseries\appendixname\quad%
             \else%
               \huge\bfseries\appendixname~\thechapter\quad%
             \fi%
             {\raggedright #1\par}%
           \endgroup  
         \fi
       \else
         \huge\bfseries #1  
       \fi%
     \endgroup%
     \vskip 40\p@%
    }%
  \fi%
}

  
%========================================
%               
% Sections 
%
%========================================

\iffalse

 sections werden mit roemischen Ziffern gezaehlt:
  I. Einleitung
 II. Grundlagen der Produzentenhaftung

 Falls overviewwithsec als Paket-Option mit angegeben wurde,
 wird der \section Eintrag (und nur der) in die ovw. Datei 
 geschrieben. 
\fi


\newcounter{totalsections}%
\setcounter{totalsections}{\z@}

\renewcommand*{\thesection}{\Roman{section}.}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \stepcounter{totalsections}%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M \raggedright #8\@@par}% linksbuendig!!!! NEU
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi%
      \ifx #8\@empty% Achtes Argument leer? 
        #7%           dann das siebente (= das laengere)
      \else%
        #8%           sonst ist hier das laengere gespeichert
      \fi}%
    \ifnum #2=1% section?
      \if@secinovw% Option overviewwithsections = TRUE?
        \addcontentsline{ovw}{#1}{% Overview-Datei
          \ifnum #2>\c@secnumdepth \else
            \protect\numberline{\csname the#1\endcsname}%
          \fi%
          \ifx #8\@empty% achtes Argument leer?
            #7% dann das siebente (= das laengere)
          \else
            #8% sonst ist hier das laengere gespeichert
          \fi}%  
      \fi%
    \fi%    
  \else%
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi%
        \ifx #8\@empty% achtes Argument leer?
          #7% dann das siebente (= das laengere)
        \else%
          #8% sonst ist hier das laengere gespeichert
        \fi}%    
      \ifnum #2=1 % section?
        \if@secinovw % Option overviewwithsections = TRUE?
          \addcontentsline{ovw}{#1}{% 
            \ifnum #2>\c@secnumdepth \else
              \protect\numberline{\csname the#1\endcsname}%
            \fi%
            \ifx #8\@empty% 
              #7% dann das siebente (= das laengere)
            \else%
              #8% sonst ist hier das laengere gespeichert
            \fi}%
        \fi%
      \fi}%
  \fi%
  \@xsect{#5}%
}

\setcounter{secnumdepth}{7}
\setcounter{tocdepth}{7}


%========================================
% subsection ("1. Blabla")
%========================================

\renewcommand{\thesubsection}{\arabic{subsection}.}


%========================================
% subsubsection ("a. Blubb")
%========================================

\renewcommand{\thesubsubsection}{\alph{subsubsection})}


%==================================================
% subsubsubsection = subthreesection ("aa. lalala")
%==================================================

\newcounter{subthreesection}[subsubsection]
\renewcommand{\thesubthreesection}{\alph{subthreesection}\alph{subthreesection})}
\let\subthreesectionmark\@gobble

\newcommand{\subthreesection}{\@startsection%
  {subthreesection}%
  {4}%
  {\z@}%
  {-3.25ex\@plus -1ex \@minus -.2ex}%
  {1.5ex \@plus .2ex}%
  {\normalfont\normalsize\bfseries}}
\let\subsubsubsection\subthreesection


%======================================================
% subsubsubsubsection = subfoursection ("aaa. blubber")
%======================================================

\newcounter{subfoursection}[subthreesection]
\renewcommand{\thesubfoursection}%
  {\alph{subfoursection}\alph{subfoursection}\alph{subfoursection})}
\let\subfoursectionmark\@gobble

\newcommand*{\subfoursection}{\@startsection%
  {subfoursection}%
  {5}%
  {\z@}%
  {-3.25ex\@plus -1ex \@minus -.2ex}%
  {1.5ex \@plus .2ex}%
  {\normalfont\normalsize\bfseries}}
\let\subsubsubsubsection\subfoursection


%======================================================
% subfivesection ("(1) blubber")
%======================================================

\newcounter{subfivesection}[subfoursection]
\renewcommand{\thesubfivesection}%
  {(\arabic{subfivesection})}
\let\subfivesectionmark\@gobble

\newcommand*{\subfivesection}{\@startsection%
  {subfivesection}%
  {6}%
  {\z@}%
  {-3.25ex\@plus -1ex \@minus -.2ex}%
  {1.5ex \@plus .2ex}%
  {\normalfont\normalsize\bfseries}}
\let\subsubsubsubsubsection\subfivesection


%======================================================
% subsixsection ("(a) blubber")
%======================================================

\newcounter{subsixsection}[subfivesection]
\renewcommand{\thesubsixsection}%
  {(\alph{subfivesection})}
\let\subsixsectionmark\@gobble

\newcommand*{\subsixsection}{\@startsection%
  {subsixsection}%
  {7}%
  {\z@}%
  {-3.25ex\@plus -1ex \@minus -.2ex}%
  {1.5ex \@plus .2ex}%
  {\normalfont\normalsize\bfseries}}
\let\subsubsubsubsubsubsection\subsixsection


%=======================================================
% paragraph 
%
% Setzt neue Gliedererungsstufe 6 
% kommt nicht ins toc, tocdepth=5
%=======================================================

\@removefromreset{paragraph}{subsubsection}%
\let\paragraphmark\@gobble
\renewcommand{\theparagraph}%
  {\@arabic\c@paragraph}

\renewcommand{\paragraph}{\@startsection%
  {paragraph}% #1
  {8}% #2
  {\z@}% #3
  {3.25ex \@plus1ex \@minus.2ex}% #4
  {-1em}% #5
  {\normalfont\normalsize\bfseries}}% #6
% #7: [arg]
% #8: {partitlearg}
                               

%=======================================================
% subparagraph 
%
% Setzt neue Gliedererungsstufe 7 (kommt nicht ins toc)
%=======================================================

\renewcommand{\subparagraph}{\@startsection%
  {subparagraph}%
  {9}%
  {\parindent}%
  {3.25ex \@plus1ex \@minus .2ex}%
  {-1em}%
  {\normalfont\normalsize\bfseries}}
                                      

%=====================================
%               
% toc/sub/levelup  
%
%=====================================

\newcounter{max@level}\setcounter{max@level}{5}

\newcounter{current@level}
% 0 = chapter
% 1 = section
% 2 = subsection
% 3 = subsubsection
% 4 = subthreesection
% 5 = subfoursection
% 6 = subfivesection
% 7 = subsixsection

\newcommand{\toc}[2][]{%
  \ifcase \value{current@level}%
    \chapter[#1]{#2}%
  \or \section[#1]{#2}%
  \or \subsection[#1]{#2}%
  \or \subsubsection[#1]{#2}%
  \or \subthreesection[#1]{#2}%
  \or \subfoursection[#1]{#2}%
  \or \subfivesection[#1]{#2}%
  \or \subsixsection[#1]{#2}%
  \else%
    \ClassError{jurabook}%
      {Too many \protect\sub\space commands\MessageBreak
       (you are already on subsixsection level)}%
      {Use \protect\levelup\space or contact juramisc@sodtalbers.de.}%   
  \fi%
}  
  
\newcommand{\levelup}{%
  \addtocounter{current@level}{\m@ne}%
   \ifthenelse{\value{current@level}<\z@}%
    {\ClassError{jurabook}%
      {You are on chapter level, you cannot use \protect\levelup.}%
      {Use \protect\part\space or check your sectioning.}%
    }%  
    {\relax}%
}

\newcommand{\sub}[2][]{%
  \stepcounter{current@level}%
  \toc[#1]{#2}%  
}  

\newcommand{\chapterlevel}{%
  \setcounter{current@level}{\z@}%
}  
   

%======================================
%               
% \l@... Makros fuer Inhaltsverzeichnis
%
%======================================

\renewcommand*{\l@part}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \parindent \z@ \rightskip \@tocrmarg % statt: \@pnumwidth
      \parfillskip -\@tocrmarg
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@tocrmarg{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup%
  \fi% 
}


\iffalse
  
  Zentrierte Ausgabe der parts im Inhaltsverzeichnis / Uebersicht
  
  \@partlinecenter{welcherteil}{text}
                   #1           #2

  welcherteil = 'Erster Teil:' (usw)

  vgl. Kloeckl 166; Begleiter 34
\fi

\newcommand{\@partlinecenter}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{6ex}%
    \begingroup
      \centering \normalfont 
      {\Large\bfseries #1\par}
      \addvspace{2ex}
      {\Large\bfseries #2\par}
      \addvspace{2ex}
    \endgroup
    \nopagebreak
  \fi  
}

\renewcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength{\@tempdima}{\chapternumwidth}% statt 1.5em (Rest identisch)
    \begingroup
      \parindent \z@%
      \rightskip \@tocrmarg % statt \@pnumwidth
      \parfillskip -\@tocrmarg
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@tocrmarg{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}
        

\iffalse
 Fuer den Ueberblick (overview): 
 
 alles wie \l@chapter, aber: 
 
 Im Inhaltsueberblick Kapitelueberschriften nur dann 
 fett ausgeben, wenn auch sections ausgegeben werden.
\fi

\newcommand*\l@ovwchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{\chapternumwidth}% statt 1.5em (s.o.)
    \begingroup
      \parindent \z@ \rightskip \@tocrmarg % statt \@pnumwidth
      \parfillskip -\@tocrmarg
      \if@secinovw
        \leavevmode \bfseries
      \fi  
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@tocrmarg{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}


% appendix chapter
\newcommand{\l@appendixchapter}[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \settowidth{\@tempdima}{\bfseries\appendixname~XX\space}%
    \begingroup
      \parindent \z@ \rightskip \@tocrmarg % statt \@pnumwidth
      \parfillskip -\@tocrmarg
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@tocrmarg{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\newcommand{\l@ovwappendixchapter}[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \if@secinovw%
      \settowidth\@tempdima{\bfseries\appendixname~XX\space}%
    \else%
      \settowidth\@tempdima{\appendixname~XX\space}%
    \fi%
    \begingroup
      \parindent \z@ \rightskip \@tocrmarg % statt \@pnumwidth
      \parfillskip -\@tocrmarg
      \if@secinovw
        \leavevmode \bfseries
      \fi  
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@tocrmarg{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\renewcommand*{\l@section}{\@dottedtocline{1}{\sectiontocindent}{\sectionnumwidth}}
\renewcommand*{\l@subsection}{\@dottedtocline{2}{\subsectiontocindent}{\subsectionnumwidth}}
\renewcommand*{\l@subsubsection}{\@dottedtocline{3}{\subsubsectiontocindent}{\subsubsectionnumwidth}}
\newcommand*{\l@subthreesection}{\@dottedtocline{4}{\subthreesectiontocindent}{\subthreesectionnumwidth}}
\newcommand*{\l@subfoursection}{\@dottedtocline{5}{\subfoursectiontocindent}{\subfoursectionnumwidth}}
\newcommand*{\l@subfivesection}{\@dottedtocline{6}{\subfivesectiontocindent}{\subfivesectionnumwidth}}
\newcommand*{\l@subsixsection}{\@dottedtocline{7}{\subsixsectiontocindent}{\subsixsectionnumwidth}}


\iffalse

  Mit '\l@extrajubostuff' werden
  Literatur-, Entscheidungs-, Website- und Stichwortverzeichnis
  in das Inhaltsverzeichnis gebracht. 
  
\fi

\newcommand*{\l@extrajubostuff}[2]{%
  \addpenalty{-\@highpenalty}%
  \vskip 1.0em \@plus\p@%
  \setlength{\@tempdima}{\z@}% ??? okay?
  \begingroup
     \parindent \z@%
     \rightskip \@tocrmarg % not: \@pnumwidth
     \parfillskip -\@tocrmarg
     \leavevmode \mdseries % not: bfseries
     \advance\leftskip\@tempdima
     \hskip -\leftskip
     #1\nobreak\hfil \nobreak\hb@xt@\@tocrmarg{\hss #2}\par
     \penalty\@highpenalty
   \endgroup%
}
    
            
%=====================================
%               
% Verschiedenes  
%
%=====================================

\iffalse

  \TODO{Hinweis}
        #1

  Eine Markierung fuer Anmerkungen im Text fuer Sachen, die noch bearbeitet 
  werden muessen. Wird umrahmt im Rand ausgedruckt.      
\fi

\newcommand{\TODO}[1]{%
  \marginpar{\framebox{\parbox{\marginparwidth}{\bfseries #1}}}%
  \ClassWarning{jurabook}%
    {There is still something to do}% 'on input line no ...'
}  


\newcommand{\xref}[1]{% vereinfacht Zitierungen
  \ref{#1} auf S.~\pageref{#1}}


% cf. the example in begleiter, p. 61
\newcommand{\openquote}{\glqq}
\newcommand{\closequote}{\grqq}

\renewenvironment{quote}
  {\vspace{2ex plus 3.0pt minus 5.0pt}
   \begin{small}
   \begingroup\leftskip=\parindent\rightskip=\parindent\noindent\llap{\openquote}\ignorespaces%
  }%
  {\unskip\closequote\par\endgroup
   \end{small}
   \vspace{2ex plus 3.0pt minus 5.0pt}%
  }
  

%========================================
%               
% Index 
%
%========================================

% TLC 11.1.7 (p. 653); Begleiter 361 f.

\newcommand{\Index}[1]{#1\index{#1}}
\newcommand{\MIndex}[1]{#1\index{#1|textbf}}
\newcommand{\seealso}[2]{\emph{\alsoname} #1}


% The following code is taken from:
% index.sty 2004/01/20 v4.2beta Improved index support (dmj)
% by David M. Jones,
% MIT Laboratory for Computer Science, Cambridge, MA 02139, USA
%
% and 
% 
% manmac.tex (cf. TeXBook p. 423)

\def\special@jb@hat{\ifmmode\def\next{^}\else\let\next=\index\fi\next}
\def\special@jb@underscore{\ifmmode\def\next{_}\else\let\next=\Index\fi\next}

\newif\if@shortindexing

\begingroup
  \catcode`\^\active
  \catcode`\_\active

  \gdef\shortindexingon{%
     \@shortindexingtrue
     \chardef\old@jb@hatcode\catcode`\^\relax
     \chardef\old@jb@underscorecode\catcode`\_\relax
     \catcode`\^\active
     \catcode`\_\active
     \let\old@jb@hat ^%
     \let\old@jb@underscore _%
     \let^\special@jb@hat
     \let_\special@jb@underscore}

  \gdef\shortindexingoff{%
     \if@shortindexing
       \@shortindexingfalse
       \let^\old@jb@hat
       \let_\old@jb@underscore
       \catcode`\^\old@jb@hatcode
       \catcode`\_\old@jb@underscorecode
     \fi}
\endgroup


\if@indexpagenumbers%
% leave everything as it is ...  
\else
% The following code puts the numbers of the runners into the index
  \renewcommand{\@wrindex}[1]{%
     \protected@write\@indexfile{}%
        {\string\indexentry{#1}{\therunner}}% instead of \thepage
   \endgroup
   \@esphack}%
\fi


% Setting the index prologue

\if@indexpagenumbers%
  \newcommand*{\indexprologue}{Die Zahlen beziehen sich auf die jeweiligen Seiten.}
\else  
  \newcommand*{\indexprologue}{Die Zahlen verweisen auf die Randnummern.}
\fi  

\newcommand{\@indexprologue}{%
   \begingroup
     \normalsize\itshape%
     \indexprologue%
     \vspace{\bigskipamount}\vspace{\bigskipamount}\par
   \endgroup%
}

\iffalse
  Hier die entsprechende Umdefinierung 
  der 'index'-Umgebung, so dass der
  IndexHint integriert wird.
  
  vgl. a. Begleiter 378
\fi

\renewenvironment{theindex}{%
  \if@twocolumn
    \@restonecolfalse
  \else
    \@restonecoltrue
  \fi
  \columnseprule \z@
  \columnsep 35\p@
  \twocolumn[\@makeschapterhead{\indexname}%
             \addcontentsline{toc}{extrajubostuff}{\numberline{}\indexname}%
             \@indexprologue]%
  \@mkboth{\indexname}% \MakeUppercase rausgenommen
          {\indexname}%
  \thispagestyle{empty}%
  \parindent\z@
  \parskip\z@ \@plus .3\p@\relax
  \let\item\@idxitem%
  }%
  {\if@restonecol\onecolumn\else\clearpage\fi%
}


\iffalse

 Folgendes Kommando bringt Eintrag fuer Literaturverzeichnis 
 in das Inhaltsverzeichnis.
 
 Kommt auch (bzw gerade) mit jurabib zurecht.
 
 Zu Risiken und Nebenwirkungen ...
   
\fi

\newcommand{\bibtotoc}{%
  \if@jurabibloaded%
    \@ifundefined{bib@heading}%
      {\ClassError{jurabook}%
        {You are using an outdated version of the package 'jurabib'.}%
        {Get the latest version (>=0.6) of 'jurabib' from www.jurabib.org}%
      }%
      {\ClassInfo{jurabook}{Changing jurabib's \protect\bib@heading\space command}%
       \let\oldbib@heading\bib@heading%
       \renewcommand{\bib@heading}{%
         \@chapter@withoutnumber{\bibname}%
        }%
      }%
  \else%    
    \ClassInfo{jurabook}{Changing LaTeX's `thebibliography' environment}%
    \renewenvironment{thebibliography}[1]% stolen from book.cls
      {\@chapter@withoutnumber{\bibname}%
       \list{\@biblabel{\@arabic\c@enumiv}}%
            {\settowidth\labelwidth{\@biblabel{##1}}%
             \leftmargin\labelwidth
             \advance\leftmargin\labelsep
             \@openbib@code
             \usecounter{enumiv}%
             \let\p@enumiv\@empty
             \renewcommand\theenumiv{\@arabic\c@enumiv}}%
       \sloppy
       \clubpenalty4000
       \@clubpenalty \clubpenalty
       \widowpenalty4000%
       \sfcode`\.\@m%
      }%
      {\def\@noitemerr
        {\@latex@warning{Empty `thebibliography' environment}}%
       \endlist%
      }%
  \fi% 
}%

\iffalse
  this put a nomenclature list
  created with nomencl.sty into the toc / ovw
  
  tested with '2000/12/03 v3.1a Nomenclature package (BS)'
\fi

\newcommand{\nomencltotoc}{%
  \@ifundefined{@nomenclature}%
    {\ClassError{jurabook}%
       {\protect\nomencltotoc\space without 'nomencl' package}%
       {Use 'nomencl' package or don't use \protect\nomencltotoc}%
    }%
    {\ClassInfo{jurabook}{Changing nomencl's \protect\theglossary\space command}%
     \renewcommand{\theglossary}{%
       \@chapter@withoutnumber{\nomname}%
       \nompreamble
       \list{}{%
         \labelwidth\nom@tempdim
         \leftmargin\labelwidth
         \advance\leftmargin\labelsep
         \itemsep\nomitemsep
         \let\makelabel\nomlabel}%
      }%
    }%
}

    
%=====================================================
%               
% Zitieren von Websites / Verzeichnis der Webadressen 
%
%===================================================== 

\iffalse
 Naehere Informationen: Begleiter 37 ff.
\fi

\newcounter{totalwebcites}

\newcommand*{\cwrevisionopen}{(}%        oeffnendes Zeichen fuer den Stand
\newcommand*{\cwrevisionname}{Stand:}
\newcommand*{\cwrevisionclose}{)}%       schliessendes Zeichen fuer den Stand

\iffalse

  \citeweb[abrufdatum]{url}{beschreibung}
           #1          #2   #3

  * =  kein Eintrag in low
\fi

\newcommand{\citeweb}{%
    \@ifstar{\@@cws}{\@@cw}%
}

\newcommand{\@@cw}[3][]{%  
  \@citeweb[#1]{#2}%
  \if@dorunners%
    \addtocontents{low}{\protect\lowcontentsline{#2}{#3}{\therunner}}%
  \else%
    \addtocontents{low}{\protect\lowcontentsline{#2}{#3}{\thepage}}%
  \fi%
}

\newcommand{\@@cws}[3][]{%
  \@gobble{#3}% Beschreibung wird hier nicht benoetigt 
  \@citeweb[#1]{#2}%
}

\newcommand{\@citeweb}[2][]{%
  \stepcounter{totalwebcites}%
  \url{#2}\space%
  \if@suppresswebdates%
    \@gobble{#1}%
  \else%
    \cwrevisionopen\cwrevisionname\space
    \ifthenelse{\equal{#1}{\@empty}}% 
      {\ClassWarning{jurabook}{No date in web citation -- replaced by current date}%
       \number\day.~\number\month. \number\year\cwrevisionclose%
      }% don't delete this percent character!
    % else    
      {#1\cwrevisionclose}%
    % fi
  \fi%      
}


\iffalse

  \addextrawebcite{url}
                   #1

  fuegt einen extra Eintrag in die Liste:
\fi

\newcommand{\addextrawebcite}[1]{%
  \addtocontents{low}{\protect\lowcontentsline{#1}}%
}

\newcommand{\lowcontentsline}[3]{%
  \begingroup%
    \interlinepenalty\@M
    \noindent \url{#1}\space\dotfill~#3\newline%
    \noindent #2\par\smallskip%
  \endgroup% 
}

\if@indexpagenumbers%
  \newcommand*{\lowprologue}{Die Zahlen beziehen sich auf die jeweiligen Seiten.}
\else  
  \newcommand*{\lowprologue}{Die Zahlen verweisen auf die Randnummern.}
\fi

\newcommand{\@lowprologue}{%
   \begingroup
     \normalsize\itshape%
     \lowprologue%
     \vspace{\bigskipamount}\vspace{\bigskipamount}\par
   \endgroup%
}


\newcommand*{\weblistname}{Quellen im World Wide Web}
\newcommand{\tableofwebcites}{% geklaut aus book.cls, ohne \makeuppercase
   \if@twocolumn
     \@restonecoltrue\onecolumn
   \else
     \@restonecolfalse
   \fi
   \@chapter@withoutnumber{\weblistname}%
   \@lowprologue%
   \@starttoc{low}%
   \if@restonecol\twocolumn\fi%
}


%========================================
%               
% Liste der Entscheidungen 
%
%========================================

\newif\if@indecisionlist    % sind wir innerhalb der Entsch-Liste?
\@indecisionlistfalse
\newif\if@notfinalsw        % Entsch nicht rechtskaeftig?
\@notfinalswfalse

\newcommand*{\dcssep}{--}
\newcommand*{\decisionlistname}{Zitierte Entscheidungen}
\newcommand*{\notfinalname}{(nicht rechtskr.)}

\newcounter{totaldcs}
\newcounter{totaldecisions}
\newcounter{totalnotyets}

\newcommand{\decisionentry}[2]{}    % wird von \@starttoc benoetigt
\@starttoc{dcs}                     % oeffnet \jobname.dcs

% \if@indexpagenumbers%
%  \newcommand*{\decisionhint}
%    {Die Zahlen in den eckigen Klammern beziehen sich auf die jeweiligen Seiten.}
% else  
%   \newcommand*{\decisionhint}
%    {Die Zahlen in den eckigen Klammern verweisen auf die Randnummern.}
% \fi  

% \newcommand{\@Decisionhint}{%
%    {\normalsize\itshape
%    \decisionhint%
%    \bigskip\space\bigskip%
%    }}

\newcommand{\@Decisionhint}{\relax}


\iffalse Befehl fuer Zitat innerhalb des Textes:

  \@dcs[nrkr]{gericht}{fundstelle}{stichwort}
       #1    #2       #3          #4

  #1: nicht rechtskraeftig  (Optional)
  ----------------
  #2: Gericht
  #3: Fundstelle
  #4: Stichwort
  
  Prozentzeichen nicht vergessen!
\fi

\newcommand{\@dcs}[4][]{%
  {\itshape #2}\space #3%
  \ifthenelse{\equal{#4}{\@empty}}%
    {\ClassInfo{jurabook}{No keyword in \protect\dcs}}%
    {\space\dcssep\space #4}%
  \ifthenelse{\equal{#1}{\@empty}}%
    {\relax}%
    {\space\notfinalname}%
  \if@dorunners%
    \addtocontents{dcs}{\protect\decisionentry{#4}{\therunner}}%
  \else
    \addtocontents{dcs}{\protect\decisionentry{#4}{\thepage}}%
  \fi%  
}

\newcommand{\dcs}{\@ifstar{\@@dcss}{\@@dcs}}

\newcommand{\@@dcs}[3]{%
  \@dcs{#1}{#2}{#3}{}%
}  

\newcommand{\@@dcss}[3]{%
  \@dcs[nrkr]{#1}{#2}{#3}%
}

\newcommand{\dcshighlightfont}{\bfseries} % Hervorheben von Gericht und Fundstelle

\newenvironment{decisionlist}
  {\@indecisionlisttrue%
   \@chapter@withoutnumber{\decisionlistname}%
   \@Decisionhint%
   \raggedright
   \begin{small}
   \begin{list}%
     {}%
     {\setlength{\leftmargin}{\z@}
      \setlength{\rightmargin}{\z@}
      \setlength{\itemsep}{1ex}}
  }
  {\end{list}
   \end{small}
   \@indecisionlistfalse
  }
  

\iffalse fuegt eine Entscheidung in die EntscheidungsLISTE ein:

 \@decision{gericht}{fundstelle}{stichwort}{datum}{az}{anmerkung}{nichtrechtskraeftig)

 #1: Gericht
 #2: Fundstelle
 #3: Stichwort
 #4: Datum der Entscheidung
 #5: Aktenzeichen
 #6: Anmerkungen (werden nur dann NICHT ausgegeben, wenn Option 'decisionsfinal' eingeschaltet)
 #7: Urteil oder Beschluss (vom ...)
 #8: Entscheidung rechtskraeftig? (ja, wenn arg leer, sonst \notfinalname)
  
\fi

\newcommand*{\decisionname}{Urt.}
\newcommand*{\decreename}{Beschl.}
\newcommand*{\decisionfromname}{v.}

\newcommand{\@decision}[8]{%
  \if@indecisionlist%
    \stepcounter{totaldcs}%
    \stepcounter{totaldecisions}%
    \ifthenelse{\equal{#8}{\@empty}}{\@notfinalswfalse}{\@notfinalswtrue}
    \item {\dcshighlightfont #1}, #7\space\decisionfromname\space #4~\dcssep~#5\if@notfinalsw{\space\notfinalname ,}\else{,}\fi\space{\dcshighlightfont #2}%
    \ifthenelse{\equal{#3}{\@empty}}%
      {\ClassInfo{jurabook}{No keyword in \protect\dcs}}%
      {\space\mbox{\dcssep\space #3.}}%
    \if@decisionhints%
      \ifthenelse{\equal{#6}{\@empty}}%
        {\relax}%
        {\footnote{#6}}%
    \fi%
    \par%
    \if@notfinalsw
      \ifthenelse{\equal{#1}{BGH}}%
        {\ClassWarning{jurabook}{Eine nicht rechtskraeftige Entscheidung des BGH??!}}{}
    \fi  
  \else
    \ClassError{jurabook}%
      {\protect\decision\space or \protect\decree\space used in text (instead of \protect\dcs)}%
      {Use the \protect\dcs\space command!}%
  \fi%
}


\iffalse
   \decision[Versaumnisurt.]{BGH}{NJW 2001, 964}{Kindertee IV}{12.12.2000}{VI ZR 345/99}{
             #1              #2   #3             #4            #5          #6
    Kv.
    Verjaehrung, gilt fuer jedes Organ der Gesellschaft separat.
    = ZIP 2001, 379??? mit Anm. Brueggemeier (Kv).}
    #7
\fi

\newcommand{\decision}{\@ifstar{\@@decs}{\@@dec}}  

\newcommand{\@@dec}[7][\decisionname]{%
  \@decision{#2}{#3}{#4}{#5}{#6}{#7}{#1}{}%
}

\newcommand{\@@decs}[7][\decisionname]{%
  \@decision{#2}{#3}{#4}{#5}{#6}{#7}{#1}{nrkr}%
}

\newcommand{\decree}{\@ifstar{\@@dcrs}{\@@dcr}}

\newcommand{\@@dcr}[6]{%
  \@decision{#1}{#2}{#3}{#4}{#5}{#6}{\decreename}{}%
}

\newcommand{\@@dcrs}[6]{%
  \@decision{#1}{#2}{#3}{#4}{#5}{#6}{\decreename}{nrkr}%
}  

\newcommand{\@@notyet}[7][marillion]{%
  \ClassInfo{jurabook}{decision in list but not cited in text}% 'on inpute line xx'
  \stepcounter{totaldcs}%
  \stepcounter{totalnotyets}%
}  

% this seems to be ridiculous ...
\newcommand{\notyet}{\@ifstar{\@@notyet}{\@@notyet}}
  
% Separierung verschiedener Gerichte  
\newcommand{\newcourt}{%
  \space\bigskip%
}

\endinput
% end of jurabook.cls
