<?xml version='1.0'?>
<!--####################################################################
 |  $Id: db2latex-mw-table.xsl 120 2004-03-26 20:19:43Z mw $
 |  $Author: mw $
 + ################################################################# -->


<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
    exclude-result-prefixes="doc" version='1.0'>

  <xsl:template name="table.format.tabularx">
    <xsl:param name="cols" select="1"/>
    <xsl:param name="i" select="1"/>
    <xsl:param name="colsep" select="1"/>
  <!-- sum of numeric portions in 1*-like colwidths -->
  <xsl:param name="starfactor" select="0"/>
  <xsl:choose>
  <!-- Out of the recursive iteration -->
  <xsl:when test="$i > $cols"></xsl:when>
  <!-- There are still columns to count -->
  <xsl:otherwise>
    <xsl:variable name="userwidth">
      <xsl:choose>
        <xsl:when test="./colspec[@colnum=$i]">
          <xsl:value-of select="./colspec[@colnum=$i]/@colwidth"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="./colspec[position()=$i]/@colwidth"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="useralign">
      <xsl:choose>
        <xsl:when test="./colspec[@colnum=$i]">
          <xsl:value-of select="./colspec[@colnum=$i]/@align"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="./colspec[position()=$i]/@align"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="width">
      <xsl:variable name="cells" select="thead/row/entry[$i]|tbody/row/entry[$i]"/>
      <xsl:choose>
        <xsl:when test="string-length($userwidth)=0 and count($cells//itemizedlist|$cells//orderedlist|$cells//variablelist)&gt;0">
        <!-- In these specific circumstances, we MUST use a line-wrapped column
             and yet the user hasn't specified one. -->
        <xsl:value-of select="'1*'"/>
      </xsl:when>
      <xsl:otherwise>
      <!-- In the general case, we just do what the user wants (may even
           have no pre-specified width). -->
      <xsl:value-of select="$userwidth"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<!-- Try to take heed of colspecs -->
<xsl:choose>
  <xsl:when test="$width!=''">
    <xsl:text>&gt;{</xsl:text>
    <xsl:if test="contains($width,'*')">
    <!-- see tabularx documentation -->
    <xsl:text>\hsize=</xsl:text>
    <xsl:value-of select="substring-before($width,'*') * $starfactor" />
      <xsl:text>\hsize</xsl:text>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$useralign='left'"><xsl:text>\RaggedRight</xsl:text></xsl:when>
      <xsl:when test="$useralign='right'"><xsl:text>\RaggedLeft</xsl:text></xsl:when>
      <xsl:when test="$useralign='center'"><xsl:text>\Centering</xsl:text></xsl:when>
      <xsl:when test="$useralign='char' and $latex.use.dcolumn='1'">
        <xsl:variable name="char" select="(./colspec[@colnum=$i]/@char|./colspec[position()=$i]/@char)[1]"/>
        <xsl:choose>
          <xsl:when test="$char=''"><xsl:text>d</xsl:text></xsl:when>
          <xsl:otherwise>D{<xsl:value-of select="$char"/>}{<xsl:value-of select="$char"/>}{-1}</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$useralign!=''"><xsl:message>Table column '<xsl:value-of select="$useralign"/>' alignment is not supported.</xsl:message></xsl:when>
    </xsl:choose>
    <xsl:text>}</xsl:text>
    <xsl:choose>
      <xsl:when test="contains($width,'*')">
        <xsl:text>X</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>p{</xsl:text><xsl:value-of select="$width" /><xsl:text>}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$i&lt;$cols and $colsep='1'">
      <xsl:text>|</xsl:text>
    </xsl:if>
  </xsl:when>
  <xsl:otherwise>
    <xsl:choose>
      <xsl:when test="$useralign='left'"><xsl:text>l</xsl:text></xsl:when>
      <xsl:when test="$useralign='right'"><xsl:text>r</xsl:text></xsl:when>
      <xsl:when test="$useralign='center'"><xsl:text>c</xsl:text></xsl:when>
      <xsl:when test="$useralign='justify'"><xsl:text>X</xsl:text></xsl:when>
      <xsl:when test="$useralign='char' and $latex.use.dcolumn='1'">
        <xsl:variable name="char" select="(./colspec[@colnum=$i]/@char|./colspec[position()=$i]/@char)[1]"/>
        <xsl:choose>
          <xsl:when test="$char=''"><xsl:text>d</xsl:text></xsl:when>
          <xsl:otherwise>D{<xsl:value-of select="$char"/>}{<xsl:value-of select="$char"/>}{-1}</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>c</xsl:text>
        <xsl:if test="$useralign!=''">
          <xsl:message>Table column '<xsl:value-of select="$useralign"/>' alignment is not supported.</xsl:message>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$i&lt;$cols and $colsep='1'">
      <xsl:text>|</xsl:text>
    </xsl:if>
  </xsl:otherwise>
</xsl:choose>
<!-- Recursive for next column -->
<xsl:call-template name="table.format.tabularx">
  <xsl:with-param name="i" select="$i+1"/>
  <!-- Added by MW, 2003-10-19 -->
  <xsl:with-param name="colsep" select="$colsep"/>
  <xsl:with-param name="cols" select="$cols"/>
  <xsl:with-param name="starfactor" select="$starfactor"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>



<xsl:template match="tgroup">
  <xsl:variable name="align" select="@align"/>

<!-- Changed by MW, 2003-10-19 -->
<xsl:variable name="colsep">
  <xsl:choose>
    <xsl:when test="string-length(@colsep)&lt;1">0</xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="@colsep"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable>

<xsl:variable name="frame">
  <xsl:choose>
    <xsl:when test="string-length(../@frame)&lt;1">all</xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="../@frame"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:variable name="colspecs" select="./colspec"/>
<xsl:variable name="usex">
  <xsl:choose>
    <xsl:when test="$latex.use.ltxtable='1'">
      <xsl:text>0</xsl:text>
    </xsl:when>
  <!-- if there are lists within cells, we need tabularx -->
  <xsl:when test="$latex.use.tabularx=1 and (descendant::itemizedlist|descendant::orderedlist|descendant::variablelist)">
    <xsl:text>1</xsl:text>
  </xsl:when>
<!-- if there are instances of 1*-style colwidths, we need tabularx -->
<xsl:when test="$latex.use.tabularx=1 and contains(colspec/@colwidth,'*')">
  <xsl:text>1</xsl:text>
</xsl:when>
<!-- if there are colspecs with 'justify' alignment and no explicit width, we need tabularx -->
<xsl:when test="$latex.use.tabularx=1 and count(colspec[@align='justify'])&gt;0">
  <xsl:text>1</xsl:text>
</xsl:when>
<xsl:otherwise>
  <xsl:text>0</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="useminipage">
<!-- Hack to get around LaTeX issue with tabular (not necessary with tabularx).
     This is NOT a good solution, and has problems of its own, but at least the footnotes
     do not actually disappear (which is what would otherwise happen). -->
<xsl:if test="count(.//footnote)!=0">1</xsl:if>
</xsl:variable>
<xsl:choose>
  <xsl:when test="$usex='1'">
    <xsl:text>\begin{tabularx}{\linewidth}{</xsl:text>
  </xsl:when>
  <xsl:when test="$latex.use.ltxtable='1'">
    <xsl:text>\begin{longtable}{</xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:if test="$useminipage='1'"><xsl:text>\begin{minipage}{\linewidth}&#10;</xsl:text></xsl:if>
    <xsl:text>\begin{tabular}{</xsl:text>
  </xsl:otherwise>
</xsl:choose>
<xsl:if test="$frame='all' or $frame='sides'">
  <xsl:text>|</xsl:text>
</xsl:if>
<xsl:variable name="cols">
  <xsl:choose>
    <xsl:when test="@cols">
      <xsl:value-of select="@cols"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="count(tbody/row[1]/entry)"/>
      <xsl:message>Warning: table lacks cols attribute. Assuming <xsl:value-of select="count(tbody/row[1]/entry)"/>.</xsl:message>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:choose>
  <xsl:when test="$usex=1">
    <xsl:call-template name="table.format.tabularx">
      <xsl:with-param name="cols" select="$cols"/>
    <!-- Changed by MW, 2003-10-19 -->
    <xsl:with-param name="colsep" select="$colsep"/>
    <xsl:with-param name="starfactor">
      <xsl:call-template name="generate.starfactor">
        <xsl:with-param name="cols" select="$cols"/>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:when>
<xsl:otherwise>
  <xsl:call-template name="table.format.tabular">
    <xsl:with-param name="cols" select="$cols"/>
  </xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:if test="$frame='all' or $frame='sides'">
  <xsl:text>|</xsl:text>
</xsl:if>
<xsl:text>}&#10;</xsl:text>
<xsl:if test="$frame!='sides' and $frame!='none' and $frame!='bottom'">
  <xsl:text>\hline &#10;</xsl:text>
</xsl:if>
<!-- APPLY TEMPLATES -->
<xsl:choose>
  <xsl:when test="$latex.use.ltxtable='1'">
    <xsl:apply-templates select="thead"/>
    <xsl:apply-templates select="tfoot"/>
    <xsl:apply-templates select="tbody"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:apply-templates select="thead"/>
    <xsl:apply-templates select="tbody"/>
    <xsl:apply-templates select="tfoot"/>
  </xsl:otherwise>
</xsl:choose>
<!--                 -->
<xsl:if test="$frame!='sides' and $frame!='none' and $frame!='top'">
  <xsl:text>\hline &#10;</xsl:text>
</xsl:if>
<xsl:choose>
  <xsl:when test="$usex=1">
    <xsl:text>\end{tabularx}&#10;</xsl:text>
  </xsl:when>
  <xsl:when test="$latex.use.ltxtable='1'">
    <xsl:text>\end{longtable}&#10;</xsl:text>
  <!-- catcode touchup ARGH -->
  <xsl:call-template name="generate.latex.cell.separator">
    <xsl:with-param name="which" select="'post'"/>
  </xsl:call-template>
</xsl:when>
<xsl:otherwise>
  <xsl:text>\end{tabular}&#10;</xsl:text>
  <xsl:if test="$useminipage='1'"><xsl:text>\end{minipage}&#10;</xsl:text></xsl:if>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- this lets us specify vertical space between rows -->
<xsl:template match="tbody/row">
  <xsl:apply-templates/>
  <xsl:text> \tabularnewline</xsl:text>
  <xsl:if test="contains(@role,'db2latex:rowvspace')">
    <!-- FIXME: let user specify amount of vert. spcace -->
    <xsl:text>[1ex]</xsl:text>
  </xsl:if>
  <xsl:text>&#10;</xsl:text>
  <xsl:call-template name="generate.table.row.separator"/>
</xsl:template>

<xsl:template name="table.row.separator">
  <xsl:text>&#10;</xsl:text>
</xsl:template>


</xsl:stylesheet>
