// Copyright (c) 1999, 2000 David A. Bartold
// Copyright (c) 2002 Raymond Ostertag
// 2002 fev 13 Add parameters for water
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
/////// Start of User Definable Parameters and Their Defaults /////////////////
///////////////////////////////////////////////////////////////////////////////
// The Parameters used in the POV code are described here. Feel free to modify
// them manually if they are not implemented in the dialog boxes. If they are
// implemented your change will have no effect.
// The structure of this document follow what you can see in the SCENE OPTIONS
// dialog

/////// Global ////////////////////////////////////////////////////////////////

// TF_FILE and TF_HEIGHT_FIELD
// in the dialog box : never
// type : TGA graphic file
// file to render as Height-field

#ifndef (TF_HEIGHT_FIELD)
#declare TF_HEIGHT_FIELD = height_field { tga "TF_FILE" smooth }
#end

/////// Camera tab ////////////////////////////////////////////////////////////

// TF_CAMERA_LOCATION
// in the dialog box : POSITION
// type : vector
// Set the camera's location.

#ifndef (TF_CAMERA_LOCATION)
#declare TF_CAMERA_LOCATION = <0,  (TF_X_SCALE+TF_Z_SCALE)/2*1.5, -1.4*TF_Z_SCALE>;
#end

// TF_CAMERA_LOOK_AT
// in the dialog box : LOOK AT
// type : vector
// Set the location to which the camera points.

#ifndef (TF_CAMERA_LOOK_AT)
#declare TF_CAMERA_LOOK_AT = <0, 0, 0>;
#end

// in the dialog box : OBSERVE SEALEVEL
// type : boolean
// No effect.

// in the dialog box : ELEVATION OFFSET
// type : numeric [0-1]
// No effect.

/////// Scaling ///////////////////////////////////////////////////////////////

// TF_[XZ]_SCALE
// in the dialog box : SIZE X - SIZE Z
// type : slide [500-25000]
// Scales along the X and Z axis
#ifndef (TF_X_SCALE)
#declare TF_X_SCALE = 1000;
#end
#ifndef (TF_Z_SCALE)
#declare TF_Z_SCALE = 1000;
#end

// TF_Y_SCALE_FACTOR and TF_Y_SCALE
// in the dialog box : SIZE Y
// type : slide [0-1]
// Basically, it sets the height of the rendered terrain

#ifndef (TF_Y_SCALE_FACTOR)
#declare TF_Y_SCALE_FACTOR = 0.33;
#end

#ifndef (TF_Y_SCALE)
#declare TF_Y_SCALE = (TF_X_SCALE+TF_Z_SCALE)/2*TF_Y_SCALE_FACTOR;
#end

// TF_SCALE
// in the dialog box : never
// type : vector
// Not a parameter, it's useful to have this vector for the POV code.

#ifndef (TF_SCALE)
#declare TF_SCALE = <TF_X_SCALE, TF_Y_SCALE, TF_Z_SCALE>;
#end

/////// Atmosphere ////////////////////////////////////////////////////////////

// in the dialog box : ATMOSPHERE TYPE
// type : include file
// Not a parameter, you choose here wich file is used for the atmosphere theme
// earth_fog : standard POV fogs
// earth_haze : some kind of haze effect with scattering and POV ground fog

// TF_HAVE_FOG
// in the dialog box : FOG
// type : boolean
// Turn on/off for a atmospheric fog.

#ifndef (TF_HAVE_FOG)
#declare TF_HAVE_FOG = false;
#end

// TF_HAVE_GROUND_FOG
// in the dialog box : GROUND FOG
// type : boolean
// Turn on/off for a ground-level fog.

#ifndef (TF_HAVE_GROUND_FOG)
#declare TF_HAVE_GROUND_FOG = false;
#end

// TF_HAVE_RAINBOW
// in the dialog box : RAINBOW
// type : boolean
// Turn on/off for a rainbow.

#ifndef (TF_HAVE_RAINBOW)
#declare TF_HAVE_RAINBOW = false;
#end

// TF_FOG_TURBULENCE
// in the dialog box : FOG TURBULENCE
// type : slide[0-1]
// Control of the density turbulence for all types of fog

#ifndef (TF_FOG_TURBULENCE)
#declare TF_FOG_TURBULENCE = 0;
#end

// TF_FOG_DENSITY
// in the dialog box : FOG DENSITY
// type : slide[0-1]
// Control of the density for all types of fog

#ifndef (TF_FOG_DENSITY)
#declare TF_FOG_DENSITY = 0.25;
#end

// TF_GROUND_FOG_DENSITY
// in the dialog box : no
// type : slide[0-1]
// Control of the density only for ground fog

#ifndef (TF_GROUND_FOG_DENSITY)
#declare TF_GROUND_FOG_DENSITY = TF_FOG_DENSITY;
#end

// TF_FOG_OFFSET
// in the dialog box : FOG OFFSET
// type : slide[0..1]
// the value 0 means that the fog is as the same level as the water
// the value 1 means that the fog is as the same level of the camera
// or, if the camera is upper that 1.0 (the summit of the land),
// the fog cover only the whole land

#ifndef (TF_FOG_OFFSET)
#declare TF_FOG_OFFSET = 0.40;
#end

// TF_FOG_ALT
// in the dialog box : FOG ALT
// type : slide[]0..1]
// control how the fog disappear in the atmosphere,
// with the value 0 there is no fading

#ifndef (TF_FOG_ALT)
#declare TF_FOG_ALT = 0.40;
#end

/////// Sky ///////////////////////////////////////////////////////////////////

// in the dialog box : SKY TYPE
// type : include file
// Not a parameter, you choose here wich file is used for the sky theme
// earth_regular : complet sky with celest objects
// earth_static : simple model , it's always noon, without celest objects
// mapped_sky : simple model, a graphic file is projected as background

// TF_SKY_COLORDESCRIPTION
// in the dialog box : no
// type : include file
// this file contain the nine colours used to set the colour of the background sky
// used in regular and static models

#ifndef (TF_SKY_COLORDESCRIPTION)
#declare TF_SKY_COLORDESCRIPTION = "skycolor_earth.inc"
#end

// TF_SKY_COLORATION
// in the dialog box : no
// type : color vector
// Permanent additionnal coloration for the background sky
// used in regular and static models

#ifndef (TF_SKY_COLORATION)
#declare TF_SKY_COLORATION =  <1.0, 1.0, 1.0>; // no coloration
#end

// TF_STARS_TEXTURE
// in the dialog box : no
// type : include file
// Selection of a file for the stars texture, you can choose between 6 files
// used in regular model only

#ifndef (TF_STARS_TEXTURE)
#declare TF_STARS_TEXTURE =  "stars_01.inc"
#end

// TF_STARS_BRIGHTNESS
// in the dialog box : no
// type : slide[0, 1]
// Brightness of the stars
// used in regular model only

#ifndef (TF_STARS_BRIGHTNESS)
#declare TF_STARS_BRIGHTNESS =  0.5;
#end

// TF_LIGHTS_DESCRIPTION
// in the dialog box : no
// type : include file
// Selection of file for the description of the valid lights (ambient, camera_light)
// used in regular and static models

#ifndef (TF_LIGHTS_DESCRIPTION)
#declare TF_LIGHTS_DESCRIPTION =  "lights_standard.inc"
#end

// TF_HAVE_AMBIENT_LIGHT
// in the dialog box : no
// type : boolean
// Add an ambient area light over the height-field
// used in regular model only

#ifndef (TF_HAVE_AMBIENT_LIGHT)
#declare  TF_HAVE_AMBIENT_LIGHT = true;
#end

// TF_AMBIENT_LIGHT_LUMINOSITY
// in the dialog box : no
// type : slide[0, 1]
// Luminosity for the lights
// used in every models

#ifndef (TF_AMBIENT_LIGHT_LUMINOSITY)
#declare  TF_AMBIENT_LIGHT_LUMINOSITY= 0.3;
#end

// TF_HAVE_CAMERA_LIGHT
// in the dialog box : no
// type : boolean
// Add a light over the camera
// used in regular model only

#ifndef (TF_HAVE_CAMERA_LIGHT)
#declare  TF_HAVE_CAMERA_LIGHT = false;
#end

// TF_CAMERA_LIGHT_LUMINOSITY
// in the dialog box : no
// type : slide[0, 1]
// Luminosity for the camera light
// used in regular model only

#ifndef (TF_CAMERA_LIGHT_LUMINOSITY)
#declare  TF_CAMERA_LIGHT_LUMINOSITY= 0.5;
#end

// TF_HAVE_CLOUDS
// in the dialog box : CLOUDS
// type : boolean
// Create background clouds (texture on a sphere)
// used in regular and static models

#ifndef (TF_HAVE_CLOUDS)
#declare TF_HAVE_CLOUDS = false;
#end

// TF_CLOUDS_TEXTURE
// in the dialog box : CLOUD TYPE
// type : include file
// Selection of a texture for background clouds
// used in regular and static models

#ifndef (TF_CLOUDS_TEXTURE)
#declare TF_CLOUDS_TEXTURE = "clouds_01.inc"
#end

// TF_HAVE_CLOUDS_ROOF
// in the dialog box : no
// type : boolean
// Create a roof of clouds (texture on a plane)(experimental)
// used in regular model only

#ifndef (TF_HAVE_CLOUDS_ROOF)
#declare TF_HAVE_CLOUDS_ROOF = false;
#end

// TF_CLOUDS_ROOF_DENSITY
// in the dialog box : no
// type slide[1, 50]
// Number of iterations for clouds creation,
// It's experimental, seems that there is only two results [1-4], [5-50]
// used in regular model only

#ifndef (TF_CLOUDS_ROOF_DENSITY)
#declare TF_CLOUDS_ROOF_DENSITY = 5;
#end

// TF_CLOUDS_ROOF_HEIGHT
// in the dialog box : no
// type slide[1, 5]
// Heigth of the plane (roof) - 1 means at the summit of the heigth-field
// used in regular model only

#ifndef (TF_CLOUDS_ROOF_HEIGHT)
#declare TF_CLOUDS_ROOF_HEIGHT = 2.0;
#end

// TF_SUN_APPARENT_SIZE
// in the dialog box : no
// slide :[0.5 , 2.0]
// apparent size of the sun from earth, don't increase this too much
// used in regular model only

#ifndef (TF_SUN_APPARENT_SIZE)
#declare TF_SUN_APPARENT_SIZE  = 1.0;
#end

// TF_SUN_LIGHT_COLOR
// in the dialog box : no
// type : color vector
// color and brightness of the light that simulate the sun lightning
// used in regular model only

#ifndef (TF_SUN_LIGHT_COLOR)
#declare TF_SUN_LIGHT_COLOR  = <0.8, 0.8, 0.8>;
#end

// TF_MOON_IMAGE
// in the dialog box : no
// type : PNG graphic file (becareful, PNG not always work)
// Selection of the image mapped to the moon
// You can download nice free maps here, you need to convert them in PNG.
// http://www.evildrganymede.demon.co.uk/render/render_f.htm
// http://maps.jpl.nasa.gov/
// http://www.radcyberzine.com/xglobe/ (earth maps))
// used in regular model only

#ifndef (TF_MOON_IMAGE)
#declare TF_MOON_IMAGE = "moon_moon.png"
#end

// TF_MOON_TIME_OFFSET
// in the dialog box : no
// type : slide[0, 24]
// (in hours) offset between moon and sun
// 0 or 24 they are at the same location, 12 at the opposite
// used in regular model only

#ifndef (TF_MOON_TIME_OFFSET)
#declare TF_MOON_TIME_OFFSET = 12;
#end

// TF_MOON_LIGHT_COLOR
// in the dialog box : no
// type : color vector
// color and brightness of the light that simulate the moon lightning
// used in regular model only

#ifndef (TF_MOON_LIGHT_COLOR)
#declare TF_MOON_LIGHT_COLOR  = <0.3, 0.3, 0.3>;
#end

// TF_MOON_APPARENT_SIZE
// in the dialog box : no
// type : slide[0.5 , 2.0]
// apparent size of the moon from earth, don't increase this too much
// used in regular model only

#ifndef (TF_MOON_APPARENT_SIZE)
#declare TF_MOON_APPARENT_SIZE = 1.0;
#end

// TF_MOON_[YZ]_ROT
// in the dialog box : no
// type : slide[-180 , 180]
// Y (in degrees) rotate the moon along is natural axis (longitude)
// Z (in degrees) rotate the moon if you want see poles (latitude)
// See also earth_regular_sky.inc at moon section for useful hints
// used in regular model only

#ifndef (TF_MOON_Y_ROT)
#declare TF_MOON_Y_ROT = 0;
#end
#ifndef (TF_MOON_Z_ROT)
#declare TF_MOON_Z_ROT = 0;
#end

// TF_SKY_IMAGE
// in the dialog box : no
// type : TGA graphic file
// Selection of the image mapped as background
// Default format is 16/9. See mapped_sky.inc to change this.
// used in mapped_sky model only

#ifndef (TF_SKY_IMAGE)
#declare TF_SKY_IMAGE = "sky_test_320x180.tga"
#end

// TF_SKY_IMAGE_SCALE
// in the dialog box : no
// type : slide[0.1 , 10.0]
// Scale of image mapped to the sky, use this if the image don't really fill the background
// used in mapped_sky model only

#ifndef (TF_SKY_IMAGE_SCALE)
#declare TF_SKY_IMAGE_SCALE = 1.0;
#end

// TF_SKY_IMAGE_ELEVATION_OFFSET
// in the dialog box : no
// type : slide[-0.5, 0.0]
// Adjustment of the elevation offset of the image mapped to the sky
// used in mapped_sky model only

#ifndef (TF_SKY_IMAGE_ELEVATION_OFFSET)
#declare TF_SKY_IMAGE_ELEVATION_OFFSET = -0.2;
#end

/////// Water /////////////////////////////////////////////////////////////////

// in the dialog box : SKY TYPE
// type : include file
// Not a parameter, you choose here wich file is used for the water theme
// Only one available now

// TF_HAVE_WATER
// in the dialog box : FILLED SEA
// type : boolean
// Self explanatory.

#ifndef (TF_HAVE_WATER)
#declare TF_HAVE_WATER = true;
#end

// TF_WATER_LEVEL
// in the dialog box : SEA LEVEL
// type : slide[0, 1]
// The smaller the number, the more land that is above water.

#ifndef (TF_WATER_LEVEL)
#declare TF_WATER_LEVEL = 0.33;
#end

// TF_WATER_CLARITY
// in the dialog box : WATER CLARITY
// type : slide[0, 1]
// It has no effect if water is disabled. O: it's opaque

#ifndef (TF_WATER_CLARITY)
#declare TF_WATER_CLARITY = 0.95;
#end

// TF_WATER_COLOR
// in the dialog box : no
// type : color vector
// Control the colour of the water

#ifndef (TF_WATER_COLOR)
#declare TF_WATER_COLOR = <0.61, 0.73, 0.80>;
#end

// TF_WATER_BOTTOMCOLOR
// in the dialog box : no
// type : color vector
// Not a parameter, you should use this at level 0 in the declaration of the
// final texture_map of TF_LANDSCAPE_TEXTURE

#ifndef (TF_WATER_BOTTOMCOLOR)
#declare TF_WATER_BOTTOMCOLOR = <0, 0, 0>;
#end

// TF_WATER_REFLECTION
// in the dialog box : no
// type : slide[0 , 1]
// Control the reflection of the water. 1 : like a mirror

#ifndef (TF_WATER_REFLECTION)
#declare TF_WATER_REFLECTION = 0.50;
#end

// TF_WATER_FREQUENCY
// in the dialog box : no
// type : slide[0 , 5000]
// Control the frequency of the waves

#ifndef (TF_WATER_FREQUENCY)
#declare TF_WATER_FREQUENCY = 1300;
#end

// TF_WATER_HEIGT
// in the dialog box : no
// type : slide[0, 10]
// Control height of the waves. 0 : flat like ice

#ifndef (TF_WATER_HEIGT)
#declare TF_WATER_HEIGHT = 1;
#end

// TF_WATER_SMOOTHWAVE
// in the dialog box : no
// type : boolean
// Add an additionnal smooth wave

#ifndef (TF_WATER_SMOOTHWAVE)
#declare TF_WATER_SMOOTHWAVE = false;
#end

/////// Pov-Ray /////////////////////////////////////////////////////////////////

// in the dialog box : TERRAIN THEME
// type : include file
// Not a parameter, you choose here wich file is used for the terrain theme
// desert, mountain, green,...

// in the dialog box : RAINBOW
// obsolete

// TF_TIME_OF_DAY
// in the dialog box : TIME OF DAY
// type : slide[0, 24]
// Time of day is expressed as the number of hours, the moon location depend on
// TF_MOON_TIME_OFFSET parameter
// e.x.  0.0  = (12:00am) Midnight
//       6.25 = ( 6:15am) Around sunrise
//      12.0  = (12:00pm) Noon
// used in regular sky model only

#ifndef (TF_TIME_OF_DAY)
#declare TF_TIME_OF_DAY = 12.0;
#end

// TF_NORTH_DIR
// in the dialog box : NORTH DIRECTION
// type : slide[0, 360]
// Set the direction for North.
// Moon and Sun goes from east to west as in the real world, so it's important
// to know were the North is.
// North = 0 or 180 , look along the X axis to see celest objects
// North = 90 or 270, look along the Z axis to see celest objects

#ifndef (TF_NORTH_DIR)
#declare TF_NORTH_DIR = 0.0;
#end

/////////////////////////////////////////////////////////////////////////////
/////// End of User Definable Parameters ////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

// Well not really the end, you can find many other local parameters in the POV
// files...