// POV file adapted from topo example by Russell Towle
// adapted from gforge for Terraform by Robert Gasch
//


#include "defaults.inc"
 

/////// End of User Definable Parameters ////////////////////////////////////

// Include files
#include "colors.inc"
#include "textures.inc"


camera
{
	location 	TF_CAMERA_LOCATION
	look_at		TF_CAMERA_LOOK_AT
}



light_source { <-3*(TF_X_SCALE/2), TF_Y_SCALE*10, -0.1*(TF_Z_SCALE/2)> 
			   color red 0.75 green 0.5 blue 0.3 }
light_source { <-3*(TF_X_SCALE/2), TF_Y_SCALE*5, 0.5*(TF_Z_SCALE/2)>   
			   color red 0.25 green 0.1 blue 0.0 }


// The heightfield object is in the X-Z plane, centered on the origin, 
// and extends +/- 0.5 units in the X and Z directions

// Tiling has been diasabled as it causes a bunch of headaches ...
//#if (TF_TILE_TERRAIN = false)

  object
  {
    TF_HEIGHT_FIELD
    scale <TF_X_SCALE, TF_Y_SCALE, TF_Z_SCALE>  // reduce height
    //translate <-.5*TF_X_SCALE, 0, -.5*TF_Z_SCALE>

    texture 
      { 
      pigment { color White } 
      finish { phong 0.1 ambient 0.2 } 
      }
  }

/*
#else

  #declare zoff = 0;
  #declare zlim = 2;

  #while (zoff  < zlim)

    #declare xoff = 0;
    #declare xlim = 2;

    #while (xoff  < xlim)

      object
      {
        TF_HEIGHT_FIELD

        texture 
        { 
          pigment { color White } 
          finish { phong 0.1 ambient 0.2 } 
        }

        scale <TF_X_SCALE, TF_Y_SCALE, TF_Z_SCALE>
        translate <TF_X_SCALE*(-1+xoff ), 0, TF_Z_SCALE*(-0.5+zoff)>
      }

      #declare xoff  = xoff  + 1;
    #end

    #declare zoff  = zoff  + 1;
  #end

#end
*/


