########################################################################
#
#   Given a directory with TryeType fonts, generate a directory 
#   called 'derived ' with material to support the files from GhostScript. 
#
#   This is an example that is part of the Ted word processor installation.
#   Do not run this script before you know exactly what it does.
#   In particular, realise that it destroys any directory or file 
#   called 'derived' in the current directory.
#   Refer to http://www.nllgg.nl/Ted/index.html for the 'Ted' documentation.
#
########################################################################

rm -rf derived
mkdir derived
rm -rf derived
mkdir derived

for ttf in *.ttf
do
    afm=`basename $ttf .ttf`.afm

    Ted --TtfToAfm $ttf derived/$afm

    grep '^Comment fonts.dir' derived/$afm | \
		sed -e 's/^Comment fonts.dir *//' >> derived/fonts.dir.extra

    grep '^Comment Fontmap' derived/$afm | \
		sed -e 's/^Comment Fontmap *//' >> derived/Fontmap.extra
done

echo '###########' Generated files:
du -a derived
