#   include	"bitmapConfig.h"

#   include	"bmintern.h"
#   include	<string.h>
#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Color administration.						*/
/*									*/
/************************************************************************/

void bmSetCalculatedShifts(	ColorAllocator *	ca,
				unsigned long		redMask,
				unsigned long		greenMask,
				unsigned long		blueMask )
    {
    ca->caRedPixelShift= 0;
    while( ! ( redMask & 0x1 ) )
	{ ca->caRedPixelShift++; redMask= redMask >> 1;	}
    ca->caRedMask= redMask;
    ca->caRedApproxShift= 8;
    while( redMask & 0x1 )
	{ ca->caRedApproxShift--; redMask= redMask >> 1;	}

    ca->caGreenPixelShift= 0;
    while( ! ( greenMask & 0x1 ) )
	{ ca->caGreenPixelShift++; greenMask= greenMask >> 1;	}
    ca->caGreenMask= greenMask;
    ca->caGreenApproxShift= 8;
    while( greenMask & 0x1 )
	{ ca->caGreenApproxShift--; greenMask= greenMask >> 1;	}

    ca->caBluePixelShift= 0;
    while( ! ( blueMask & 0x1 ) )
	{ ca->caBluePixelShift++; blueMask= blueMask >> 1;	}
    ca->caBlueMask= blueMask;
    ca->caBlueApproxShift= 8;
    while( blueMask & 0x1 )
	{ ca->caBlueApproxShift--; blueMask= blueMask >> 1;	}

    return;
    }

void bmCleanColorAllocator(	ColorAllocator *	ca )
    {
    if  ( ca->caColors )
	{ free( ca->caColors ); ca->caColors= (AllocatorColor *)0;	}

    ca->caColorCount= 0;

    return;
    }

void bmInitColorAllocator(	ColorAllocator *	ca )
    {
    int		i;

    ca->caColorCount= 0;
    ca->caColors= (AllocatorColor *)0;

    for ( i= 0; i < 64; i++ )
	{ ca->ca222Colors[i].acAllocated= AC_CALCULATED;	}

    ca->caAllocationType= AC_UNALOCATED;
    ca->caSystemPrivate= (void *)0;
    ca->caSystemAllocator= (SystemAllocator)0;

    return;
    }
