/************************************************************************/
/*									*/
/*  Attributes of text.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_FONT_H
#   define	DOC_FONT_H

#   include	<utilPropMask.h>
#   include	<utilTextAttribute.h>

/************************************************************************/
/*									*/
/*  Font Administration in terms of 'Document Fonts'			*/
/*									*/
/*  1)  A document font is characterized by an item in the font list	*/
/*	in an offce document. The main key is the name of the font.	*/
/*	It is possible that two fonts with the same name exist. In that	*/
/*	case, the character set helps to distinguish between them.	*/
/*									*/
/************************************************************************/

#   define FONTpitchDEFAULT		0
#   define FONTpitchFIXED		1
#   define FONTpitchVARIABLE		2

#   define FONTlenPANOSE		20

typedef struct DocumentFontInstance
    {
    TextAttribute	dfiAttribute;
    int			dfiPhysicalFont;
    int			dfiPsFaceNumber;
    } DocumentFontInstance;

typedef struct DocumentFont
    {
    char *			dfFamilyStyle;	/*  fnil, fswiss ..	*/
    char *			dfName;		/*  Helvetica,		*/
						/*  Helvetica Narrow.	*/
    int				dfDocFamilyNumber;/*  f0, f1 ...	*/

    int				dfPsFamilyNumber;

    int				dfInstanceCount;
    DocumentFontInstance *	dfInstances;

    int				dfCharset;	/*  fcharsetN		*/
    int				dfEncodingUsed;

    int				dfPitch;	/*  fprqN		*/
    char			dfPanose[FONTlenPANOSE+1];
    } DocumentFont;

typedef struct DocumentFontList
    {
    int			dflCount;
    DocumentFont *	dflFonts;
    } DocumentFontList;

/************************************************************************/
/*									*/
/*  Default attributes.							*/
/*									*/
/************************************************************************/

extern TextAttribute   DocDefaultAttributes;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitFont(	DocumentFont *	df );

extern void docCleanFont(	DocumentFont *	df );

extern int docCopyFont(	DocumentFont *		to,
			const DocumentFont *	from );

extern void docInitFontList(	DocumentFontList *	dfl );

extern void docCleanFontList(	DocumentFontList *	dfl );

extern int docCopyFontList(	DocumentFontList *		to,
				const DocumentFontList *	from );

extern const char *	utilFontFamilyStyle( const char * fontFamilyName );

extern DocumentFont *	docInsertFont(	DocumentFontList *	dfl,
					int			n,
					const char *		familyStyle,
					const char *		fontName );

extern int utilFontCompareFaces(	const void *	veft1,
					const void *	veft2 );

extern int docGetFontByName(	DocumentFontList *	dfl,
				const char *		fontFamilyName,
				int			encoding,
				int			encodingIsDefault );

#   endif	/*  DOC_FONT_H	*/
