/************************************************************************/
/*									*/
/*  Format changes to the document/selection.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docLayout.h"
#   include	"tedEdit.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Change the attributes of the selection.				*/
/*									*/
/*  1)  Adjust the start line for recalculating the layout of the first	*/
/*	paragraph in the selection.					*/
/*  2)  If necessary, split the first particule to change the text	*/
/*	attributes of the second half.					*/
/*  3)  For all paragraphs in the selection upto the last one..		*/
/*  4)  Change the text attributes.					*/
/*									*/
/************************************************************************/

static int tedChangeParaProperties( PropertyMask *		pPpChgMask,
				    PropertyMask *		pTaChgMask,
				    BufferItem *		paraBi,
				    int				partFrom,
				    int				partUpto,
				    AppDrawingData *		add,
				    BufferDocument *		bd,
				    DocumentFontList *		dfl,
				    const PropertyMask *	taUpdMask,
				    TextAttribute		taNew,
				    const PropertyMask *	ppUpdMask,
				    const ParagraphProperties *	ppNew )
    {
    PropertyMask	ppChgMask;
    PropertyMask	taChgMask;

    PROPmaskCLEAR( &ppChgMask );
    PROPmaskCLEAR( &taChgMask );

    if  ( ! PROPmaskISEMPTY( taUpdMask ) )
	{
	TextParticule *		tp= paraBi->biParaParticules+ partFrom;
	int			part;

	tp= paraBi->biParaParticules+ partFrom;
	for ( part= partFrom; part < partUpto; tp++, part++ )
	    {
	    PropertyMask	pm;

	    PROPmaskCLEAR( &pm );

	    docAttributeDifference( &pm,
				    tp->tpTextAttribute, taNew, taUpdMask );

	    utilPropMaskOr( &taChgMask, &taChgMask, &pm );

	    if  ( tedChangeParticuleAttribute( add, tp, dfl,
						    taUpdMask, taNew ) )
		{ LDEB(part); return -1;	}
	    }
	}

    if  ( ! PROPmaskISEMPTY( ppUpdMask ) )
	{
	if  ( docUpdParaProperties( &ppChgMask,
			    &(paraBi->biParaProperties), ppUpdMask, ppNew ) )
	    { XDEB(ppUpdMask); return -1;	}
	}

    *pTaChgMask= taChgMask;
    *pPpChgMask= ppChgMask;
    return 0;
    }

static int tedChangeSectionProperties(	PropertyMask *		pSpChgMask,
					BufferItem *		sectBi,
					const PropertyMask *	spUpdMask,
					const SectionProperties * spNew,
					DocumentRectangle *	drChanged,
					const DocumentRectangle * drBack )
    {
    PropertyMask	spChgMask;

    PROPmaskCLEAR( &spChgMask );

    if  ( docUpdSectProperties( &spChgMask,
			    &(sectBi->biSectProperties), spUpdMask, spNew ) )
	{ XDEB(spUpdMask); return -1;	}

    if  ( PROPmaskISSET( &spChgMask, SPpropTITLEPG )		||
	  PROPmaskISSET( &spChgMask, SPpropNUMBER_STYLE )	||
	  PROPmaskISSET( &spChgMask, SPpropPAGE_RESTART )	||
	  PROPmaskISSET( &spChgMask, SPpropSTART_PAGE )		)
	{ docUnionRectangle( drChanged, drChanged, drBack );	}

    if  ( PROPmaskISSET( &spChgMask, SPpropNUMBER_STYLE )	||
	  PROPmaskISSET( &spChgMask, SPpropPAGE_RESTART )	||
	  PROPmaskISSET( &spChgMask, SPpropSTART_PAGE )		)
	{
	sectBi->biSectHeader.eiPageFormattedFor= -1;
	sectBi->biSectFirstPageHeader.eiPageFormattedFor= -1;
	sectBi->biSectLeftPageHeader.eiPageFormattedFor= -1;
	sectBi->biSectRightPageHeader.eiPageFormattedFor= -1;

	sectBi->biSectFooter.eiPageFormattedFor= -1;
	sectBi->biSectFirstPageFooter.eiPageFormattedFor= -1;
	sectBi->biSectLeftPageFooter.eiPageFormattedFor= -1;
	sectBi->biSectRightPageFooter.eiPageFormattedFor= -1;
	}

    utilPropMaskOr( pSpChgMask, pSpChgMask, &spChgMask );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Use the new ruler settings, or other geometry properties of a	*/
/*  BufferItem.								*/
/*									*/
/************************************************************************/

static void tedApplyItemFormat(	EditOperation *			eo,
				BufferItem *			bi,
				const AppDrawingData *		add )
    {
    DocumentRectangle * drChanged= &(eo->eoChangedRectangle);
    DocumentRectangle	drLocal;

    drLocal.drX0= add->addBackRect.drX0;
    drLocal.drX1= add->addBackRect.drX1;
    drLocal.drY0= BI_TOP_PIXELS( add, bi );
    drLocal.drY1= BI_BELOW_PIXELS( add, bi );

    docUnionRectangle( drChanged, drChanged, &drLocal );

    docEditIncludeItemInReformatRange( eo, bi );

    return;
    }

/************************************************************************/
/*									*/
/*  Change properties of the current selection.				*/
/*									*/
/************************************************************************/

int tedChangeSelectionProperties( EditDocument *		ed,
				const PropertyMask *		taUpdMaskCall,
				TextAttribute			taNew,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	spNew )
    {
    AppDrawingData *		add= &(ed->edDrawingData);

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);
    DocumentFontList *		dfl= &(dp->dpFontList);

    int				part;

    TextParticule *		tp;

    BufferItem *		paraBi;
    BufferItem *		sectBi= (BufferItem *)0;

    int				firstParticuleSplit= 0;

    PropertyMask		taUpdMask;

    PropertyMask		selTaChgMask;
    PropertyMask		selPpChgMask;
    PropertyMask		selSpChgMask;

    PropertyMask		paraTaChgMask;
    PropertyMask		paraPpChgMask;
    PropertyMask		sectSpChgMask;

    PropertyMask		pm;

    DocumentSelection		ds;
    SelectionGeometry		sg;

    EditOperation		eo;

    tedStartEditOperation( &eo, &ds, &sg, ed, 1 );

    taUpdMask= *taUpdMaskCall;

    PROPmaskCLEAR( &selTaChgMask );
    PROPmaskCLEAR( &selPpChgMask );
    PROPmaskCLEAR( &selSpChgMask );

    if  ( docIsIBarSelection( &ds ) )
	{ PROPmaskCLEAR( &taUpdMask );	}

    paraBi= ds.dsBegin.dpBi;
    part= ds.dsBegin.dpParticule;

    if  ( ! paraBi )
	{ XDEB(paraBi); return -1; }

    /*  1  */
    tp= paraBi->biParaParticules+ part;

    /*  2  */
    PROPmaskCLEAR( &pm );
    if  ( (unsigned)ds.dsBegin.dpStroff > tp->tpStroff )
	{
	docAttributeDifference( &pm, tp->tpTextAttribute, taNew, &taUpdMask );
	}

    if  ( ! PROPmaskISEMPTY( &pm ) )
	{
	int		stroff= ds.dsBegin.dpStroff;

	if  ( (unsigned)stroff < tp->tpStroff+ tp->tpStrlen )
	    {
	    TextParticule *	newTp;

	    newTp= docCopyParticule( paraBi, part+ 1, stroff,
			tp->tpStroff+ tp->tpStrlen- stroff, DOCkindTEXT, tp );
	    if  ( ! newTp )
		{ XDEB(newTp); return -1;	}

	    tp= paraBi->biParaParticules+ part;
	    tp->tpStrlen= stroff- tp->tpStroff;
	    tp= newTp; part++;

	    if  ( ds.dsEnd.dpBi == paraBi )
		{ firstParticuleSplit= 1;	}
	    }
	else{ tp++; part++; }
	}

    PROPmaskCLEAR( &sectSpChgMask );

    sectBi= paraBi->biParent->biParent->biParent;
    if  ( ! PROPmaskISEMPTY( spUpdMask ) )
	{
	if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
						    spUpdMask, spNew,
						    &(eo.eoChangedRectangle),
						    &(add->addBackRect) ) )
	    { XDEB(spUpdMask); return -1;	}

	utilPropMaskOr( &selSpChgMask, &selSpChgMask, &sectSpChgMask );
	}

    /*  3  */
    while( paraBi != ds.dsEnd.dpBi )
	{
	int	col;
	int	partUpto= paraBi->biParaParticuleCount;

	col= paraBi->biParent->biNumberInParent;

	if  ( ds.dsCol0 < 0					||
	      ds.dsCol1 < 0					||
	      ( col >= ds.dsCol0 && col <= ds.dsCol1 )	)
	    {
	    /*  4  */
	    if  ( tedChangeParaProperties( &paraPpChgMask, &paraTaChgMask,
				    paraBi, part, partUpto, add, bd, dfl,
				    &taUpdMask, taNew, ppUpdMask, ppNew ) )
		{ LDEB(1);	}

	    if  ( sectBi != paraBi->biParent->biParent->biParent )
		{
		if  ( ! PROPmaskISEMPTY( &sectSpChgMask ) )
		    { tedApplyItemFormat( &eo, sectBi, add );	}

		sectBi= paraBi->biParent->biParent->biParent;
		if  ( ! PROPmaskISEMPTY( spUpdMask ) )
		    {
		    if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
						    spUpdMask, spNew,
						    &(eo.eoChangedRectangle),
						    &(add->addBackRect) ) )
			{ XDEB(spUpdMask); return -1;	}

		    utilPropMaskOr( &selSpChgMask,
					    &selSpChgMask, &sectSpChgMask );
		    }
		}

	    if  ( ! PROPmaskISEMPTY( &paraPpChgMask )	||
		  ! PROPmaskISEMPTY( &paraTaChgMask )	)
		{
		tedApplyItemFormat( &eo, paraBi, add );

		if  ( ! PROPmaskISEMPTY( &paraPpChgMask )	&&
		      paraBi == ds.dsBegin.dpBi		)
		    { tedDocAdaptHorizontalRuler( ed, paraBi );	}

		utilPropMaskOr( &selTaChgMask, &selTaChgMask, &paraTaChgMask );
		utilPropMaskOr( &selPpChgMask, &selPpChgMask, &paraPpChgMask );
		}
	    }

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { XDEB(paraBi); return -1;	}

	part= 0; firstParticuleSplit= 0;
	}

    /*  4  */
    if  ( tedChangeParaProperties( &paraPpChgMask, &paraTaChgMask, paraBi,
		    part,
		    ds.dsEnd.dpParticule+ firstParticuleSplit, add, bd, dfl,
		    &taUpdMask, taNew, ppUpdMask, ppNew ) )
	{ LDEB(1);	}

    part= ds.dsEnd.dpParticule+ firstParticuleSplit;
    tp= paraBi->biParaParticules+ part;

    if  ( sectBi != paraBi->biParent->biParent->biParent )
	{
	if  ( ! PROPmaskISEMPTY( &sectSpChgMask ) )
	    { tedApplyItemFormat( &eo, sectBi, add ); }

	sectBi= paraBi->biParent->biParent->biParent;
	if  ( ! PROPmaskISEMPTY( spUpdMask ) )
	    {
	    if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
						    spUpdMask, spNew,
						    &(eo.eoChangedRectangle),
						    &(add->addBackRect) ) )
		{ XDEB(spUpdMask); return -1;	}

	    utilPropMaskOr( &selSpChgMask, &selSpChgMask, &sectSpChgMask );
	    }
	}

    if  ( ! PROPmaskISEMPTY( &sectSpChgMask ) )
	{ tedApplyItemFormat( &eo, sectBi, add ); }

    PROPmaskCLEAR( &pm );
    if  ( part < paraBi->biParaParticuleCount )
	{
	docAttributeDifference( &pm, tp->tpTextAttribute, taNew, &taUpdMask );
	}

    if  ( ! PROPmaskISEMPTY( &pm ) )
	{
	int	strend= tp->tpStroff+ tp->tpStrlen;

	if  ( ds.dsEnd.dpStroff < strend )
	    {
	    TextParticule *	newTp;

	    newTp= docCopyParticule( paraBi, part+ 1, ds.dsEnd.dpStroff,
		    strend- ds.dsEnd.dpStroff,
		    DOCkindTEXT, tp );

	    if  ( ! newTp )
		{ XDEB(newTp); return -1;	}

	    tp= paraBi->biParaParticules+ part;
	    tp->tpStrlen= ds.dsEnd.dpStroff- tp->tpStroff;
	    }

	PROPmaskCLEAR( &pm );
	docAttributeDifference( &pm, tp->tpTextAttribute, taNew, &taUpdMask );
	utilPropMaskOr( &paraTaChgMask, &paraTaChgMask, &pm );

	/*  2  */
	if  ( tedChangeParticuleAttribute( add, tp, dfl, &taUpdMask, taNew ) )
	    { LDEB(1);	}
	}

    if  ( ! PROPmaskISEMPTY( &paraPpChgMask )	||
	  ! PROPmaskISEMPTY( &paraTaChgMask )	)
	{
	tedApplyItemFormat( &eo, paraBi, add );

	if  ( ! PROPmaskISEMPTY( &paraPpChgMask )	&&
	      paraBi == ds.dsBegin.dpBi		)
	    { tedDocAdaptHorizontalRuler( ed, paraBi );	}

	utilPropMaskOr( &selPpChgMask, &selPpChgMask, &paraPpChgMask );
	utilPropMaskOr( &selTaChgMask, &selTaChgMask, &paraTaChgMask );
	}

    if  ( ! PROPmaskISEMPTY( &selPpChgMask )	||
	  ! PROPmaskISEMPTY( &selTaChgMask )	||
	  ! PROPmaskISEMPTY( &selSpChgMask )	)
	{
	if  ( tedEditFinishRangeSelection( ed, &eo, &ds ) )
	    { LDEB(1);	}

	tedAdaptToolsToSelection( ed );

	appDocumentChanged( ed, 1 );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Utility routines around tedChangeSelectionProperties():		*/
/*									*/
/************************************************************************/

int tedAppChangeSectionProperties( EditApplication *		ea,
				const PropertyMask *		spUpdMask,
				const SectionProperties *	spNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TextAttribute		taNew;

    PropertyMask		taUpdMask;
    PropertyMask		ppUpdMask;

    PROPmaskCLEAR( &taUpdMask );
    PROPmaskCLEAR( &ppUpdMask );

    docInitTextAttribute ( &taNew );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    if  ( tedChangeSelectionProperties( ed,
				    &taUpdMask, taNew,
				    &ppUpdMask, (ParagraphProperties *)0,
				    spUpdMask, spNew ) )
	{ XDEB(spUpdMask); return -1;	}

    return 0;
    }

int tedAppChangeParagraphProperties( EditApplication *		ea,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TextAttribute		taNew;

    PropertyMask		taUpdMask;
    PropertyMask		spUpdMask;

    PROPmaskCLEAR( &taUpdMask );
    PROPmaskCLEAR( &spUpdMask );

    docInitTextAttribute ( &taNew );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    if  ( tedChangeSelectionProperties( ed,
				    &taUpdMask, taNew,
				    ppUpdMask, ppNew,
				    &spUpdMask, (SectionProperties *)0 ) )
	{ XDEB(ppUpdMask); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Adapt format tool to the circumstances.				*/
/*									*/
/************************************************************************/

void tedAdaptFormatToolToDocument(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentSelection		ds;
    SelectionGeometry		sg;

    if  ( ! tar->tarInspector )
	{ return;	}

    if  ( tedGetSelection( &ds, &sg, td ) )
	{ LDEB(1); return;	}

    tedFormatToolAdaptToSelection( tar->tarInspector, bd,
					    &ds, &sg, ed->edFileReadOnly );

    return;
    }

/************************************************************************/
/*									*/
/*  Get a suggestion about the line height: Used for the initial value	*/
/*  for space before/after in the format tool.				*/
/*									*/
/************************************************************************/

int tedGetParaLineHeight(	int *			pLineHeight,
				EditDocument *		ed )
    {
    TedDocument *		td;
    AppDrawingData *		add;

    BufferItem *		bi;

    DocumentSelection		ds;
    SelectionGeometry		sg;

    add= &(ed->edDrawingData);
    td= (TedDocument *)ed->edPrivateData;

    if  ( tedGetSelection( &ds, &sg, td ) )
	{ LDEB(1); return -1;	}

    bi= ds.dsBegin.dpBi;

    if  ( docPsParagraphLineExtents( &(add->addPhysicalFontList), bi ) )
	{ LDEB(1); return -1;	}

    *pLineHeight= bi->biParaAscentTwips- bi->biParaDescentTwips; return 0;
    }

