/************************************************************************/
/*									*/
/*  Read an RTF text file into a BufferDocument				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<bitmap.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"


static int docRtfResultPictWord(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc	)
    {
    switch( rcw->rcwId )
	{
	case RTFidWMETAFILE:
	    rrc->rrcInsertedObject->ioResultKind= DOCokPICTWMETAFILE;
	    rrc->rrcInsertedObject->ioResultMapMode= arg;
	    break;

	case RTFidPICWGOAL:
	    if  ( rrc->rrcInsertedObject->ioTwipsWide == 0 )
		{ rrc->rrcInsertedObject->ioTwipsWide= arg; }
	    else{
		if  ( rrc->rrcInsertedObject->ioTwipsWide- arg >  1	||
		      rrc->rrcInsertedObject->ioTwipsWide- arg < -1	)
		    { LLDEB(rrc->rrcInsertedObject->ioTwipsWide,arg);	}
		}
	    break;

	case RTFidPICHGOAL:
	    if  ( rrc->rrcInsertedObject->ioTwipsHigh == 0 )
		{ rrc->rrcInsertedObject->ioTwipsHigh= arg; }
	    else{
		if  ( rrc->rrcInsertedObject->ioTwipsHigh- arg >  1	||
		      rrc->rrcInsertedObject->ioTwipsHigh- arg < -1	)
		    { LLDEB(rrc->rrcInsertedObject->ioTwipsHigh,arg);	}
		}
	    break;

	case RTFidPICSCALEX:
	    if  ( rrc->rrcInsertedObject->ioScaleX == 100 )
		{ rrc->rrcInsertedObject->ioScaleX= arg; }
	    else{
		if  ( rrc->rrcInsertedObject->ioScaleX != arg )
		    { LLDEB(rrc->rrcInsertedObject->ioScaleX,arg);	}
		}
	    break;

	case RTFidPICSCALEY:
	    if  ( rrc->rrcInsertedObject->ioScaleY == 100 )
		{ rrc->rrcInsertedObject->ioScaleY= arg; }
	    else{
		if  ( rrc->rrcInsertedObject->ioScaleY != arg )
		    { LLDEB(rrc->rrcInsertedObject->ioScaleY,arg);	}
		}
	    break;

	case RTFidPICW:
	    rrc->rrcInsertedObject->io_xWinExt= arg;
	    break;

	case RTFidPICH:
	    rrc->rrcInsertedObject->io_yWinExt= arg;
	    break;

	case RTFidPICCROPT:
	    rrc->rrcInsertedObject->ioTopCropTwips= arg;
	    break;

	case RTFidPICCROPB:
	    rrc->rrcInsertedObject->ioBottomCropTwips= arg;
	    break;

	case RTFidPICCROPL:
	    rrc->rrcInsertedObject->ioLeftCropTwips= arg;
	    break;

	case RTFidPICCROPR:
	    rrc->rrcInsertedObject->ioRightCropTwips= arg;
	    break;

	default:
	    SLDEB(rcw->rcwWord,rcw->rcwId); break;
	}

    return 0;
    }

static int docRtfPictWord(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    switch( rcw->rcwId )
	{
	case RTFidMACPICT:
	    rrc->rrcInsertedObject->ioKind= DOCokMACPICT;
	    break;
	case RTFidWMETAFILE:
	    rrc->rrcInsertedObject->ioKind= DOCokPICTWMETAFILE;
	    rrc->rrcInsertedObject->ioMapMode= arg;
	    break;
	case RTFidPNGBLIP:
	    rrc->rrcInsertedObject->ioKind= DOCokPICTPNGBLIP;
	    break;
	case RTFidJPEGBLIP:
	    rrc->rrcInsertedObject->ioKind= DOCokPICTJPEGBLIP;
	    break;
	case RTFidEMFBLIP:
	    rrc->rrcInsertedObject->ioKind= DOCokPICTEMFBLIP;
	    break;
	case RTFidPICWGOAL:
	    rrc->rrcInsertedObject->ioTwipsWide= arg;
	    break;
	case RTFidPICHGOAL:
	    rrc->rrcInsertedObject->ioTwipsHigh= arg;
	    break;
	case RTFidPICSCALEX:
	    rrc->rrcInsertedObject->ioScaleX= arg;
	    break;
	case RTFidPICSCALEY:
	    rrc->rrcInsertedObject->ioScaleY= arg;
	    break;
	case RTFidBLIPTAG:
	    rrc->rrcInsertedObject->ioBliptag= arg;
	    break;
	case RTFidPICW:
	    rrc->rrcInsertedObject->io_xWinExt= arg;
	    break;
	case RTFidPICH:
	    rrc->rrcInsertedObject->io_yWinExt= arg;
	    break;
	case RTFidPICCROPT:
	    rrc->rrcInsertedObject->ioTopCropTwips= arg;
	    break;
	case RTFidPICCROPB:
	    rrc->rrcInsertedObject->ioBottomCropTwips= arg;
	    break;
	case RTFidPICCROPL:
	    rrc->rrcInsertedObject->ioLeftCropTwips= arg;
	    break;
	case RTFidPICCROPR:
	    rrc->rrcInsertedObject->ioRightCropTwips= arg;
	    break;

	default:
	    /* SLDEB(rcw->rcwWord,rcw->rcwId); */
	    break;
	}

    return 0;
    }

static RtfControlWord	docRtfPictWords[]=
    {
	{ "bin",	RTFidBIN,	DOClevPARA, docRtfPictWord, },
	{ "dibitmap",	RTFidDIBITMAP,	DOClevPARA, docRtfPictWord, },
	{ "macpict",	RTFidMACPICT,	DOClevPARA, docRtfPictWord, },
	{ "picbmp",	RTFidPICBMP,	DOClevPARA, docRtfPictWord, },
	{ "picbpp",	RTFidPICBPP,	DOClevPARA, docRtfPictWord, },
	{ "piccropb",	RTFidPICCROPB,	DOClevPARA, docRtfPictWord, },
	{ "piccropl",	RTFidPICCROPL,	DOClevPARA, docRtfPictWord, },
	{ "piccropr",	RTFidPICCROPR,	DOClevPARA, docRtfPictWord, },
	{ "piccropt",	RTFidPICCROPT,	DOClevPARA, docRtfPictWord, },
	{ "pich",	RTFidPICH,	DOClevPARA, docRtfPictWord, },
	{ "pichgoal",	RTFidPICHGOAL,	DOClevPARA, docRtfPictWord, },
	{ "picscaled",	RTFidPICSCALED,	DOClevPARA, docRtfPictWord, },
	{ "picscalex",	RTFidPICSCALEX,	DOClevPARA, docRtfPictWord, },
	{ "picscaley",	RTFidPICSCALEY,	DOClevPARA, docRtfPictWord, },
	{ "picw",	RTFidPICW,	DOClevPARA, docRtfPictWord, },
	{ "picwgoal",	RTFidPICWGOAL,	DOClevPARA, docRtfPictWord, },
	{ "pmmetafile",	RTFidPMMETAFILE, DOClevPARA, docRtfPictWord, },
	{ "wbitmap",	RTFidWBITMAP,	DOClevPARA, docRtfPictWord, },
	{ "wbmbitspixel", RTFidWBMBITSPIXEL, DOClevPARA, docRtfPictWord, },
	{ "wbmplanes",	RTFidWBMPLANES,	DOClevPARA, docRtfPictWord, },
	{ "wbmwidthbytes", RTFidWBMWIDTHBYTES,DOClevPARA, docRtfPictWord, },
	{ "wmetafile",	RTFidWMETAFILE,	DOClevPARA, docRtfPictWord, },
	{ "pngblip",	RTFidPNGBLIP,	DOClevPARA, docRtfPictWord, },
	{ "jpegblip",	RTFidJPEGBLIP,	DOClevPARA, docRtfPictWord, },
	{ "emfblip",	RTFidEMFBLIP,	DOClevPARA, docRtfPictWord, },

	{ "bliptag",	RTFidBLIPTAG,	DOClevPARA, docRtfPictWord, },
	{ "blipupi",	RTFidBLIPUPI,	DOClevPARA, docRtfPictWord, },

					/********************************/
					/*  Bug in textbridge...	*/
					/********************************/
	{ "picwGoal",	RTFidPICWGOAL,	DOClevPARA, docRtfPictWord, },
	{ "pichGoal",	RTFidPICHGOAL,	DOClevPARA, docRtfPictWord, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfResultPictWords[]=
    {
	{ "bin",	RTFidBIN,	DOClevPARA, docRtfResultPictWord, },
	{ "dibitmap",	RTFidDIBITMAP,	DOClevPARA, docRtfResultPictWord, },
	{ "macpict",	RTFidMACPICT,	DOClevPARA, docRtfResultPictWord, },
	{ "picbmp",	RTFidPICBMP,	DOClevPARA, docRtfResultPictWord, },
	{ "picbpp",	RTFidPICBPP,	DOClevPARA, docRtfResultPictWord, },
	{ "piccropb",	RTFidPICCROPB,	DOClevPARA, docRtfResultPictWord, },
	{ "piccropl",	RTFidPICCROPL,	DOClevPARA, docRtfResultPictWord, },
	{ "piccropr",	RTFidPICCROPR,	DOClevPARA, docRtfResultPictWord, },
	{ "piccropt",	RTFidPICCROPT,	DOClevPARA, docRtfResultPictWord, },
	{ "pich",	RTFidPICH,	DOClevPARA, docRtfResultPictWord, },
	{ "pichgoal",	RTFidPICHGOAL,	DOClevPARA, docRtfResultPictWord, },
	{ "picscaled",	RTFidPICSCALED,	DOClevPARA, docRtfResultPictWord, },
	{ "picscalex",	RTFidPICSCALEX,	DOClevPARA, docRtfResultPictWord, },
	{ "picscaley",	RTFidPICSCALEY,	DOClevPARA, docRtfResultPictWord, },
	{ "picw",	RTFidPICW,	DOClevPARA, docRtfResultPictWord, },
	{ "picwgoal",	RTFidPICWGOAL,	DOClevPARA, docRtfResultPictWord, },
	{ "pmmetafile",	RTFidPMMETAFILE,DOClevPARA, docRtfResultPictWord, },
	{ "wbitmap",	RTFidWBITMAP,	DOClevPARA, docRtfResultPictWord, },
	{ "wbmbitspixel",
			RTFidWBMBITSPIXEL, DOClevPARA, docRtfResultPictWord, },
	{ "wbmplanes",	RTFidWBMPLANES,	DOClevPARA, docRtfResultPictWord, },
	{ "wbmwidthbytes",
			RTFidWBMWIDTHBYTES,DOClevPARA, docRtfResultPictWord, },
	{ "wmetafile",	RTFidWMETAFILE,	DOClevPARA, docRtfResultPictWord, },

	{ "bliptag",	RTFidBLIPTAG,	DOClevPARA, docRtfPictWord, },
	{ "blipupi",	RTFidBLIPUPI,	DOClevPARA, docRtfPictWord, },

					/********************************/
					/*  Bug in textbridge...	*/
					/********************************/
	{ "picwGoal",	RTFidPICWGOAL,	DOClevPARA, docRtfResultPictWord, },
	{ "pichGoal",	RTFidPICHGOAL,	DOClevPARA, docRtfResultPictWord, },

	{ 0, 0, 0 }
    };

static int docRtfSaveObjectData(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len )
    {
    if  ( docObjectSetData( rrc->rrcInsertedObject, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfSaveResultData(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len	)
    {
    if  ( docSetResultData( rrc->rrcInsertedObject, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

int docRtfReadPict(	SimpleInputStream *	sis,
			const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	externRrc )
    {
    RtfReadingContext		internRrc;
    int				rval;
    TextParticule *		tp;

    BufferItem *		bi= externRrc->rrcBi;
    int				off= bi->biParaStrlen;

    if  ( docInflateTextString( bi, 1 ) )
	{ LLDEB(bi->biParaStrlen,1); return -1; }

    bi->biParaString[off]= ' ';
    bi->biParaStrlen++;
    bi->biParaString[bi->biParaStrlen]= '\0';

    tp= docInsertObject( bi, &externRrc->rrcInsertedObject,
			    -1, off, externRrc->rrcCurrentTextAttribute );
    if  ( ! tp )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    docRtfInitReadingContext( &internRrc );
    docRtfCopyReadingContext( &internRrc, externRrc );

    rval= docRtfConsumeGroup( sis, DOClevPARA, &internRrc,
				docRtfPictWords, docRtfEmptyTable,
				docRtfSaveObjectData );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    docRtfCopyReadingContextBack( externRrc, &internRrc  );
    docRtfCleanReadingContext( &internRrc );

    return rval;
    }


#   if 0
static RtfControlWord	docRtfNonshppictGroups[]=
    {
	{ "pict",	RTFidPICT,	DOClevPARA, docRtfReadPict, },
    };
#   endif

int docRtfReadNonshppict(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

#   if 0
    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfNonshppictGroups,
				docRtfIgnoreParticule );
#   else
    rval= docRtfSkipGroup( sis, rcw, arg, rrc );
#   endif

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static RtfControlWord	docRtfShppictGroups[]=
    {
	{ "pict",	RTFidPICT,	DOClevPARA, docRtfReadPict, },
    };

int docRtfReadShppict(		SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfShppictGroups,
				docRtfIgnoreParticule );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfReadResultPict(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfResultPictWords, docRtfEmptyTable,
				docRtfSaveResultData );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static RtfControlWord	docRtfNonshpResultpictGroups[]=
    {
	{ "pict",	RTFidPICT,	DOClevPARA, docRtfReadResultPict, },
    };

static int docRtfReadNonshResultpict(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfNonshpResultpictGroups,
				docRtfIgnoreParticule );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfObjectWord(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    switch( rcw->rcwId )
	{
	case RTFidOBJEMB:
	    rrc->rrcInsertedObject->ioKind= DOCokOLEOBJECT;
	    break;
	case RTFidOBJW:
	    rrc->rrcInsertedObject->ioTwipsWide= arg;
	    break;
	case RTFidOBJH:
	    rrc->rrcInsertedObject->ioTwipsHigh= arg;
	    break;
	case RTFidOBJSCALEX:
	    rrc->rrcInsertedObject->ioScaleX= arg;
	    break;
	case RTFidOBJSCALEY:
	    rrc->rrcInsertedObject->ioScaleY= arg;
	    break;
	default:
	    /* SLDEB(rcw->rcwWord,rcw->rcwId); */ break;
	}

    return 0;
    }

static int docRtfSaveObjectClass(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len	)
    {
    if  ( docSetObjectClass( rrc->rrcInsertedObject, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfSaveObjectName(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len	)
    {
    if  ( docSetObjectName( rrc->rrcInsertedObject, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfObjectClass(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfEmptyTable,
				docRtfSaveObjectClass );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfObjectName(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfEmptyTable,
				docRtfSaveObjectName );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfObjectData(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfEmptyTable, docRtfEmptyTable,
				docRtfSaveObjectData );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfResultWord(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    switch( rcw->rcwId )
	{
	case RTFidCGRID:
	    break;
	default:
	    SLDEB(rcw->rcwWord,rcw->rcwId); break;
	    break;
	}

    return 0;
    }

static RtfControlWord	docRtfResultWords[]=
    {
	{ "cgrid",	RTFidCGRID,	DOClevANY, docRtfResultWord, },
	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfResultGroups[]=
    {
	{ "pict",	RTFidPICT,	DOClevPARA, docRtfReadResultPict, },
	{ "nonshppict",	RTFidNONSHPPICT,DOClevPARA, docRtfReadNonshResultpict, },
	{ 0, 0, 0 }
    };

static int docRtfObjectResult(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int				rval;

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfResultWords, docRtfResultGroups,
				docRtfIgnoreParticule );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static RtfControlWord	docRtfObjectWords[]=
    {
	{ "objemb",	RTFidOBJEMB,	DOClevPARA, docRtfObjectWord, },
	{ "objw",	RTFidOBJW,	DOClevPARA, docRtfObjectWord, },
	{ "objh",	RTFidOBJH,	DOClevPARA, docRtfObjectWord, },
	{ "objscalex",	RTFidOBJSCALEX,	DOClevPARA, docRtfObjectWord, },
	{ "objscaley",	RTFidOBJSCALEY,	DOClevPARA, docRtfObjectWord, },
	{ "objsetsize",	RTFidOBJSETSIZE,DOClevPARA, docRtfObjectWord, },
	{ "rsltmerge",	RTFidRSLTMERGE, DOClevPARA, docRtfObjectWord, },
	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfObjectGroups[]=
    {
	{ "objname",	RTFidOBJNAME,	DOClevPARA, docRtfObjectName, },
	{ "objclass",	RTFidOBJCLASS,	DOClevPARA, docRtfObjectClass, },
	{ "objdata",	RTFidOBJDATA,	DOClevPARA, docRtfObjectData, },
	{ "result",	RTFidOBJDATA,	DOClevPARA, docRtfObjectResult, },
	{ 0, 0, 0 }
    };

int docRtfReadObject(	SimpleInputStream *	sis,
			const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc )
    {
    int				rval;

    BufferItem *		bi= rrc->rrcBi;
    int				off= bi->biParaStrlen;

    if  ( docInflateTextString( bi, 1 ) )
	{ LLDEB(bi->biParaStrlen,1); return -1; }

    bi->biParaString[off]= ' ';
    bi->biParaStrlen++;
    bi->biParaString[bi->biParaStrlen]= '\0';

    if  ( ! docInsertObject( bi, &rrc->rrcInsertedObject, -1,
					off, rrc->rrcCurrentTextAttribute ) )
	{ LDEB(bi->biParaParticuleCount); return -1;	}

    rval= docRtfConsumeGroup( sis, DOClevPARA, rrc,
				docRtfObjectWords, docRtfObjectGroups,
				docRtfSaveObjectData );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }
