/************************************************************************/
/*									*/
/*  Read/Write paragraph properties to/from RTF.			*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save Paragraph Properties.						*/
/*									*/
/************************************************************************/

void docRtfSaveParagraphProperties( SimpleOutputStream *	sos,
				int *				pCol,
				const PropertyMask *		updMask,
				const ParagraphProperties *	pp )
    {
    if  ( PROPmaskISSET( updMask, PPpropSTYLE ) )
	{ docRtfWriteArgTag( "\\s", pCol, pp->ppStyle, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropHYPHPAR ) )
	{
	if  ( pp->ppHyphenateParagraph )
	    { docRtfWriteTag( "\\hyphpar", pCol, sos );		 }
	else{
	    docRtfWriteArgTag( "\\hyphpar", pCol,
					pp->ppHyphenateParagraph, sos );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropNEWPAGE ) )
	{
	if  ( pp->ppStartsOnNewPage )
	    { docRtfWriteTag( "\\pagebb", pCol, sos );			 }
	else{
	    docRtfWriteArgTag( "\\pagebb", pCol,
					    pp->ppStartsOnNewPage, sos );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp->ppWidowControl )
	    { docRtfWriteTag( "\\widctlpar", pCol, sos );	}
	else{ docRtfWriteTag( "\\nowidctlpar", pCol, sos );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEP ) )
	{
	if  ( pp->ppKeepOnPage )
	    { docRtfWriteTag( "\\keep", pCol, sos );		 }
	else{
	    docRtfWriteArgTag( "\\keep", pCol,
					pp->ppKeepOnPage, sos );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEPN ) )
	{
	if  ( pp->ppKeepWithNext )
	    { docRtfWriteTag( "\\keepn", pCol, sos );		 }
	else{
	    docRtfWriteArgTag( "\\keepn", pCol,
					pp->ppKeepWithNext, sos );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropOUTLINELEVEL ) )
	{
	docRtfWriteArgTag( "\\outlinelevel", pCol, pp->ppOutlineLevel, sos );
	}

    if  ( PROPmaskISSET( updMask, PPpropFIRST_INDENT ) )
	{ docRtfWriteArgTag( "\\fi", pCol, pp->ppFirstIndentTwips, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropLEFT_INDENT ) )
	{ docRtfWriteArgTag( "\\li", pCol, pp->ppLeftIndentTwips, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropRIGHT_INDENT ) )
	{ docRtfWriteArgTag( "\\ri", pCol, pp->ppRightIndentTwips, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropSPACE_BEFORE ) )
	{ docRtfWriteArgTag( "\\sb", pCol, pp->ppSpaceBeforeTwips, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropSPACE_AFTER ) )
	{ docRtfWriteArgTag( "\\sa", pCol, pp->ppSpaceAfterTwips, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_DIST ) ||
	  PROPmaskISSET( updMask, PPpropLINE_SPACING_MULT ) )
	{
	docRtfWriteArgTag( "\\sl",
				pCol, pp->ppLineSpacingTwips, sos );
	docRtfWriteArgTag( "\\slmult",
				pCol, pp->ppLineSpacingIsMultiple, sos );
	}

    if  ( PROPmaskISSET( updMask, PPpropALIGNMENT ) )
	{
	switch( pp->ppAlignment )
	    {
	    case DOCiaLEFT:	docRtfWriteTag( "\\ql", pCol, sos ); break;
	    case DOCiaRIGHT:	docRtfWriteTag( "\\qr", pCol, sos ); break;
	    case DOCiaCENTERED:	docRtfWriteTag( "\\qc", pCol, sos ); break;
	    case DOCiaJUSTIFIED:docRtfWriteTag( "\\qj", pCol, sos ); break;
	    default:
		LDEB(pp->ppAlignment); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropTAB_STOPS ) )
	{
	TabStop *	ts= pp->ppTabStops;
	int		i;

	for ( i= 0; i < pp->ppTabCount; ts++, i++ )
	    {
	    if  ( *pCol >= 65 )
		{ docRtfWriteNextLine( pCol, sos );	}

	    switch( ts->tsAlignment )
		{
		case DOCtaLEFT:
		    break;
		case DOCtaRIGHT:
		    docRtfWriteTag( "\\tqr", pCol, sos );
		    break;
		case DOCtaCENTRE:
		    docRtfWriteTag( "\\tqc", pCol, sos );
		    break;
		case DOCtaDECIMAL:
		    docRtfWriteTag( "\\tqdec", pCol, sos );
		    break;
		default:
		    LDEB(ts->tsAlignment); break;
		}

	    switch( ts->tsLeader )
		{
		case DOCtlNONE:
		    break;
		case DOCtlDOTS:
		    docRtfWriteTag( "\\tldot", pCol, sos );
		    break;
		case DOCtlUNDERLINE:
		    docRtfWriteTag( "\\tlul", pCol, sos );
		    break;
		case DOCtlHYPH:
		    docRtfWriteTag( "\\tlhyph", pCol, sos );
		    break;
		case DOCtlTHICK:
		    docRtfWriteTag( "\\tlth", pCol, sos );
		    break;
		case DOCtlEQUAL:
		    docRtfWriteTag( "\\tleq", pCol, sos );
		    break;
		default:
		    LDEB(ts->tsLeader); break;
		}

	    docRtfWriteArgTag( "\\tx", pCol, ts->tsTwips, sos );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropTOP_BORDER ) )
	{ docRtfSaveBorder( "\\brdrt", pCol, &(pp->ppTopBorder), sos ); }

    if  ( PROPmaskISSET( updMask, PPpropBOTTOM_BORDER ) )
	{ docRtfSaveBorder( "\\brdrb", pCol, &(pp->ppBottomBorder), sos ); }

    if  ( PROPmaskISSET( updMask, PPpropSHADING_LEVEL ) )
	{ docRtfWriteArgTag( "\\shading", pCol, pp->ppShadingLevel, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropSHADING_PATTERN ) )
	{
	switch( pp->ppShadingPattern )
	    {
	    case DOCspBGBDIAG:
		docRtfWriteTag( "\\bgbdiag", pCol, sos );
		break;
	    case DOCspBGCROSS:
		docRtfWriteTag( "\\bgcross", pCol, sos );
		break;
	    case DOCspBGDCROSS:
		docRtfWriteTag( "\\bgdcross", pCol, sos );
		break;
	    case DOCspBGDKBDIAG:
		docRtfWriteTag( "\\bgdkbdiag", pCol, sos );
		break;
	    case DOCspBGDKCROSS:
		docRtfWriteTag( "\\bgdkcross", pCol, sos );
		break;
	    case DOCspBGDKDCROSS:
		docRtfWriteTag( "\\bgdkdcross", pCol, sos );
		break;
	    case DOCspBGDKFDIAG:
		docRtfWriteTag( "\\bgdkfdiag", pCol, sos );
		break;
	    case DOCspBGDKHORIZ:
		docRtfWriteTag( "\\bgdkhoriz", pCol, sos );
		break;
	    case DOCspBGDKVERT:
		docRtfWriteTag( "\\bgdkvert", pCol, sos );
		break;
	    case DOCspBGFDIAG:
		docRtfWriteTag( "\\bgfdiag", pCol, sos );
		break;
	    case DOCspBGHORIZ:
		docRtfWriteTag( "\\bghoriz", pCol, sos );
		break;
	    case DOCspBGVERT:
		docRtfWriteTag( "\\bgvert", pCol, sos );
		break;

	    default:
		LDEB(pp->ppShadingPattern); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_FOREGROUND ) )
	{ docRtfWriteArgTag( "\\cfpat", pCol, pp->ppShadingForeground, sos ); }

    if  ( PROPmaskISSET( updMask, PPpropSHADING_BACKGROUND ) )
	{ docRtfWriteArgTag( "\\cbpat", pCol, pp->ppShadingBackground, sos ); }

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a paragraph property when reading RTF.			*/
/*									*/
/************************************************************************/

int docRtfRememberParagraphProperty(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    switch( rcw->rcwId )
	{
	case PPprop_NONE:
	    docCleanParagraphProperties( &(rrc->rrcParagraphProperties) );
	    docInitParagraphProperties(  &(rrc->rrcParagraphProperties) );
	    return 0;

	case PPpropSTYLE:
	    rrc->rrcStyle.dsLevel= DOClevPARA;
	    rrc->rrcParagraphProperties.ppStyle= arg;
	    break;

	case PPpropLEFT_INDENT:
	    rrc->rrcParagraphProperties.ppLeftIndentTwips= arg;
	    break;

	case PPpropFIRST_INDENT:
	    rrc->rrcParagraphProperties.ppFirstIndentTwips= arg;
	    break;

	case PPpropRIGHT_INDENT:
	    rrc->rrcParagraphProperties.ppRightIndentTwips= arg;
	    break;

	case PPpropALIGNMENT:
	    rrc->rrcParagraphProperties.ppAlignment= rcw->rcwEnumValue;
	    break;

	case PPpropTAB_STOPS:
	    SDEB(rcw->rcwWord);
	    return 0;

	case PPpropNEWPAGE:
	    rrc->rrcParagraphProperties.ppStartsOnNewPage= arg != 0;
	    break;

	case PPpropWIDCTLPAR:
	    rrc->rrcParagraphProperties.ppWidowControl= rcw->rcwEnumValue;
	    break;

	case PPpropKEEP:
	    rrc->rrcParagraphProperties.ppKeepOnPage= arg != 0;
	    break;

	case PPpropKEEPN:
	    rrc->rrcParagraphProperties.ppKeepWithNext= arg != 0;
	    break;

	case PPpropSPACE_BEFORE:
	    rrc->rrcParagraphProperties.ppSpaceBeforeTwips= arg;
	    break;

	case PPpropSPACE_AFTER:
	    rrc->rrcParagraphProperties.ppSpaceAfterTwips= arg;
	    break;

	case PPpropLINE_SPACING_DIST:
	    rrc->rrcParagraphProperties.ppLineSpacingTwips= arg;
	    break;

	case PPpropLINE_SPACING_MULT:
	    rrc->rrcParagraphProperties.ppLineSpacingIsMultiple= ( arg != 0 );
	    break;

	case PPpropTOP_BORDER:
	    rrc->rrcParagraphProperties.ppTopBorder=
						    rrc->rrcBorderProperties;
	    break;

	case PPpropBOTTOM_BORDER:
	    rrc->rrcParagraphProperties.ppBottomBorder=
						    rrc->rrcBorderProperties;
	    break;

	case PPpropOUTLINELEVEL:
	    if  ( arg >= 0 && arg < 10 )
		{ rrc->rrcParagraphProperties.ppOutlineLevel= arg;	}
	    else{ rrc->rrcParagraphProperties.ppOutlineLevel= 9;	}
	    break;

	case PPpropHYPHPAR:
	    rrc->rrcParagraphProperties.ppHyphenateParagraph= arg != 0;
	    break;

	case PPpropSHADING_LEVEL:
	    rrc->rrcParagraphProperties.ppShadingLevel= arg;
	    break;

	case PPpropSHADING_PATTERN:
	    rrc->rrcParagraphProperties.ppShadingPattern= rcw->rcwEnumValue;
	    break;

	case PPpropSHADING_FOREGROUND:
	    rrc->rrcParagraphProperties.ppShadingForeground= arg;
	    break;

	case PPpropSHADING_BACKGROUND:
	    rrc->rrcParagraphProperties.ppShadingBackground= arg;
	    break;

	default:
	    SDEB(rcw->rcwWord);
	    return 0;
	}

    PROPmaskADD( &(rrc->rrcStyle.dsParaMask), rcw->rcwId );

    return 0;
    }
