#ifndef __DEFINES_H__
#define __DEFINES_H__

#include "config.h"
#include "tcpr.h"

/* should packet counters be 32 or 64 bit? --enable-64bit */
#ifdef ENABLE_64BITS
#define COUNTER unsigned long long
#define COUNTER_SPEC "%llu"
#else
#define COUNTER unsigned long
#define COUNTER_SPEC "%lu"
#endif


#ifdef HAVE_BPF
#include <net/bpf.h>
#define PCAP_DONT_INCLUDE_PCAP_BPF_H 1
#endif

#if defined INCLUDE_PCAP_BPF_H_FILE && !defined PCAP_DONT_INCLUDE_PCAP_BPF_H
#include "/usr/include/pcap-bpf.h"
#define PCAP_DONT_INCLUDE_PCAP_BPF_H 1 /* don't re-include it in pcap.h */
#endif

#include "/usr/include/pcap.h"

#include "lib/strlcpy.h"
#include "common/list.h"
#include "common/cidr.h"

/* 
 * net/bpf.h doesn't include DLT types, but pcap-bpf.h does.  
 * Unfortunately, pcap-bpf.h also includes things in net/bpf.h
 * while also missing some key things (wow, that sucks)
 * The result is that I stole the DLT types from pcap-bpf.h and 
 * put them in here.
 */
#include "common/dlt_names.h"


#ifdef HAVE_LIBNET
#include "/usr/local/include/libnet.h"
#endif

typedef struct tcpr_ipv4_hdr ipv4_hdr_t;
typedef struct tcpr_ipv6_hdr ipv6_hdr_t;
typedef struct tcpr_tcp_hdr tcp_hdr_t;
typedef struct tcpr_udp_hdr udp_hdr_t;
typedef struct tcpr_icmpv4_hdr icmpv4_hdr_t;
typedef struct tcpr_icmpv6_hdr icmpv6_hdr_t;
typedef struct tcpr_ethernet_hdr eth_hdr_t;
typedef struct tcpr_802_1q_hdr vlan_hdr_t;
typedef struct sll_header sll_hdr_t;
typedef struct tcpr_arp_hdr arp_hdr_t;
typedef struct tcpr_dnsv4_hdr dnsv4_hdr_t;

/* our custom typdefs/structs */
typedef u_char tcpr_macaddr_t[TCPR_ETH_H];

struct tcpr_bpf_s {
    char *filter;
    int optimize;
    struct bpf_program program;
};
typedef struct tcpr_bpf_s tcpr_bpf_t;

struct tcpr_xX_s {
#define xX_MODE_INCLUDE 'x'
#define xX_MODE_EXCLUDE 'X'
    int mode;
    tcpr_list_t *list;
    tcpr_cidr_t *cidr;
#define xX_TYPE_LIST 1
#define xX_TYPE_CIDR 2
    int type;
};
typedef struct tcpr_xX_s tcpr_xX_t;

/* number of ports 0-65535 */
#define NUM_PORTS 65536
struct tcpr_services_s {
    char tcp[NUM_PORTS];    
    char udp[NUM_PORTS];
};
typedef struct tcpr_services_s tcpr_services_t;

struct tcpr_speed_s {
    /* speed modifiers */
    int mode;
#define SPEED_MULTIPLIER 1
#define SPEED_MBPSRATE   2
#define SPEED_PACKETRATE 3
#define SPEED_TOPSPEED   4
#define SPEED_ONEATATIME 5
    float speed;
};
typedef struct tcpr_speed_s tcpr_speed_t;

#define MAX_FILES   1024        /* Max number of files we can pass to tcpreplay */

#define DEFAULT_MTU 1500        /* Max Transmission Unit of standard ethernet
                                 * don't forget *frames* are MTU + L2 header! */

#define MAXPACKET 65535         /* was 16436 linux loopback, but maybe something is bigger then 
                                   linux loopback */

#define MAX_SNAPLEN 65535       /* tell libpcap to capture the entire packet */

#define DNS_RESOLVE 1
#define DNS_DONT_RESOLVE 0

#define RESOLVE 0               /* disable dns lookups */
#define BPF_OPTIMIZE 1          /* default is to optimize bpf program */
#define PCAP_TIMEOUT 100        /* 100ms pcap_open_live timeout */

enum bool_t {
	FALSE = 0,
	TRUE
};

#define EBUF_SIZE 1024           /* size of our error buffers */
#define MAC_SIZE  7             /* size of the mac[] buffer */

enum pad_t {
	PAD_PACKET,
	TRUNC_PACKET
};

#define DNS_QUERY_FLAG 0x8000

enum direction_t {
	UNKNOWN = -1,
	CLIENT = 0,
	SERVER = 1,
	ANY = 2
};

enum tcpprep_mode {
	ERROR_MODE,     /* Some kind of error has occurred */
	CIDR_MODE,     	/* single pass, CIDR netblock */
	REGEX_MODE,		/* single pass, regex */
	PORT_MODE,		/* single pass, use src/dst ports to split */
	MAC_MODE,		/* single pass, use src mac to split */
	AUTO_MODE,		/* first pass through in auto mode */
	ROUTER_MODE,	/* second pass through in router mode */
	BRIDGE_MODE,	/* second pass through in bridge mode */
	SERVER_MODE,	/* second pass through in server (router) mode */
	CLIENT_MODE		/* second pass through in client (router) mode */
};

#define BROADCAST_MAC "\FF\FF\FF\FF\FF\FF"

/* MAC macros for printf */
#define MAC_FORMAT "%02X:%02X:%02X:%02X:%02X:%02X"
#define MAC_STR(x) x[0], x[1], x[2], x[3], x[4], x[5]

/* struct timeval print structs */
#define TIMEVAL_FORMAT "%lu.%08lu"

/* force a word or half-word swap on both Big and Little endian systems */
#ifndef SWAPLONG
#define SWAPLONG(y) \
((((y)&0xff)<<24) | (((y)&0xff00)<<8) | (((y)&0xff0000)>>8) | (((y)>>24)&0xff))
#endif

#ifndef SWAPSHORT
#define SWAPSHORT(y) \
( (((y)&0xff)<<8) | ((u_short)((y)&0xff00)>>8) )
#endif

/* converts a 64bit int to network byte order */
#ifndef HAVE_NTOHLL
#ifdef WORDS_BIGENDIAN
#define ntohll(x) (x)
#define htonll(x) (x)
#else
/* stolen from http://www.codeproject.com/cpp/endianness.asp */
#define ntohll(x) (((u_int64_t)(ntohl((int)((x << 32) >> 32))) << 32) | \
                     (unsigned int)ntohl(((int)(x >> 32))))
#define htonll(x) ntohll(x)
#endif /* WORDS_BIGENDIAN */
#endif

#define DEBUG_INFO   1          /* informational only, lessthan 1 line per packet */
#define DEBUG_BASIC  2          /* limited debugging, one line per packet */
#define DEBUG_DETAIL 3          /* more detailed, a few lines per packet */
#define DEBUG_MORE   4          /* even more detail */
#define DEBUG_CODE   5          /* examines code & values, many lines per packet */



#endif /* DEFINES */
