/*
 * basiclog.h - basic DataLog classes
 * $Id: basiclog.h,v 1.8 2003/01/26 09:09:07 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_BASICLOG_H

# define __TCPREEN_BASICLOG_H
# include "log.h"

/*
 * Base class for all basic log formats
 */
class BasicDataLog : public DataLog
{
	private:
		int (*logwrite) (const void *, int, FILE *);
		long incount, outcount;
	
	public:
		BasicDataLog (int (*logfunc) (const void *, int, FILE *)) :
			DataLog (), logwrite (logfunc),
			incount (0), outcount (0)
		{
		}
		virtual ~BasicDataLog (void);

		void Connect (const char *server, const char *client);
		int WriteServerData (const void *data, int length, int oob);
		int WriteClientData (const void *data, int length, int oob);
		void ShutdownServer (void);
		void ShutdownClient (void);
};

template <int (*fwrite_func) (const void *, int, FILE *)>
class TemplateBasicDataLog : public BasicDataLog
{
	public:
		TemplateBasicDataLog <fwrite_func> (void) :
			BasicDataLog (fwrite_func)
		{
		}
};
		

# include "output.h"

typedef TemplateBasicDataLog<fwrite_count> CountDataLog;
typedef TemplateBasicDataLog<fwrite_C> CDataLog;
typedef TemplateBasicDataLog<fwrite_hex> HexDataLog;
typedef TemplateBasicDataLog<fwrite_raw> RawDataLog;
typedef TemplateBasicDataLog<fwrite_strip> StrippedDataLog;

/*
 * Makers for the above classes
 */
extern DataLog *CountDataLogMaker (void);
extern DataLog *CDataLogMaker (void);
extern DataLog *HexDataLogMaker (void);
extern DataLog *RawDataLogMaker (void);
extern DataLog *StrippedDataLogMaker (void);

#endif /* ifndef __TCPREEN_BASICLOG_H */

