[manpage_begin uevent::onidle n 0.1]
[copyright {2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {User events}]
[titledesc {Request merging and deferal to idle time}]
[require Tcl 8.4]
[require uevent::onidle [opt 0.1]]
[require logger]
[keywords event idle deferal merge on-idle callback]
[description]

This package provides objects which can merge multiple requestes for
an action and execute the action the moment the system (event loop)
becomes idle. The action to be run is configured during object
construction.

[section API]

The package exports a class, [class uevent::onidle], as specified
below.

[list_begin definitions]

[call [cmd ::uevent::onidle] [arg objectName] [arg commandprefix]]

The command creates a new [term onidle] object with an associated
global Tcl command whose name is [arg objectName].  This command may
be used to invoke various operations on the object.

[para]

The [arg commandprefix] is the action to perform when the event loop
is idle and the user asked for it using the method [method request]
(See below).

[list_end]

The object commands created by the class commands above have
the form:

[list_begin definitions]

[call [arg objectName] [method request]]

This method requests the execution of the command prefix specified
during the construction of [arg objectName] the next time the event
loop is idle. Multiple requests are merged and cause only one
execution of the command prefix.

[list_end]

[section Examples]

Examples of this type of deferal are buried in the (C-level)
implementations all the Tk widgets, defering geometry calculations and
window redraw activity in this manner.


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph uevent] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
