
#include "sql-mysql.h"
const int maxConns = 10;

class Manager_sql {
 private:
	Sql_interface *conns[maxConns];
	int nConnections;

	// Find the next unused connection slot (the next available slot
	// in 'conns' array).
	int findFreeConn();

  	// The last error message
	char *errmsg;

 public:
	Manager_sql();

	int connect(int argc, char **argv);
	int disconnect(int c);

	int inUse(int i) { if (conns[i]) return 1; else return 0; }

	Sql_interface *connection(int n) { if (n >= maxConns) return NULL; return conns[n]; }

	// Get the error message, if there was one, for the last message
	char *getErrorMsg();

};
