// ---------------------------------------------------------
//
// Author: Tony Darugar, tdarugar@binevolve.com
// 
// $Id: sql-manager.cc,v 1.5 1999/06/10 02:50:11 tdarugar Exp $
//
// ---------------------------------------------------------

#include <stdio.h>
#include "sql-manager.h"

// ---------------------------------------------------------
Manager_sql::Manager_sql() {
	nConnections=0;
	for (int i=0; i < maxConns; i++) {
		conns[i] = NULL;
	}
}

// ---------------------------------------------------------
int 
Manager_sql::findFreeConn() {
	for (int i=0; i < maxConns; i++) {
		if (conns[i] == NULL) return i;
	}
	return -1;
}

// ---------------------------------------------------------
char *
Manager_sql::getErrorMsg() {
	return errmsg;
}

// ---------------------------------------------------------
int 
Manager_sql::connect(int argc, char **argv) {

	if (nConnections >= maxConns) return -1;

	Sql_mysql *newconn = new Sql_mysql(argc, argv);
	if (!newconn->isConnected()) {
		errmsg = newconn->getErrorMsg();
		delete newconn;
		return -1;
	}

	int connNum = findFreeConn();
	conns[connNum] = newconn;
	nConnections++;
	return (connNum);
}



// ---------------------------------------------------------
int 
Manager_sql::disconnect(int c) {
	if (!conns[c]) return 0;

	delete conns[c];
	conns[c] = NULL;
	nConnections--;
	return 1;
}
