#ifndef TCD_CD_UTILS_H
#define TCD_CD_UTILS_H

#include <SDL/SDL.h>

/**
 * Calculates the length of a CD in frames.
 * Preconditions:
 * - the expression CD_INDRIVE(cdrom->status) shall be true.
 */
extern int cd_length(const SDL_CD *cdrom);

/**
 * Calculates the CDDB disc ID of a CD.
 * Preconditions:
 * - the expression CD_INDRIVE(cdrom->status) shall be true.
 */
extern unsigned long cddb_discid(const SDL_CD *cdrom);

#endif
