/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common.tar;

import edu.uoregon.tau.common.tar.InvalidHeaderException;
import edu.uoregon.tau.common.tar.TarEntry;
import edu.uoregon.tau.common.tar.TarInputStream;
import edu.uoregon.tau.common.tar.TarOutputStream;
import edu.uoregon.tau.common.tar.TarProgressDisplay;
import edu.uoregon.tau.common.tar.TarTransFileTyper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TarArchive {
    protected boolean verbose;
    protected boolean debug;
    protected boolean keepOldFiles;
    protected int userId;
    protected String userName;
    protected int groupId;
    protected String groupName;
    protected String rootPath;
    protected String tempPath;
    protected String pathPrefix;
    protected int recordSize;
    protected byte[] recordBuf;
    protected TarInputStream tarIn;
    protected TarOutputStream tarOut;
    protected TarTransFileTyper transTyper;
    protected TarProgressDisplay progressDisplay;

    public TarArchive(InputStream inputStream) {
        this(inputStream, 10240);
    }

    public TarArchive(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarArchive(InputStream inputStream, int n, int n2) {
        this.tarIn = new TarInputStream(inputStream, n, n2);
        this.initialize(n2);
    }

    public TarArchive(OutputStream outputStream) {
        this(outputStream, 10240);
    }

    public TarArchive(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public TarArchive(OutputStream outputStream, int n, int n2) {
        this.tarOut = new TarOutputStream(outputStream, n, n2);
        this.initialize(n2);
    }

    private void initialize(int n) {
        this.rootPath = null;
        this.pathPrefix = null;
        this.tempPath = System.getProperty("user.dir");
        this.userId = 0;
        this.userName = "";
        this.groupId = 0;
        this.groupName = "";
        this.debug = false;
        this.verbose = false;
        this.keepOldFiles = false;
        this.progressDisplay = null;
        this.recordBuf = new byte[this.getRecordSize()];
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.tarIn != null) {
            this.tarIn.setDebug(bl);
        } else if (this.tarOut != null) {
            this.tarOut.setDebug(bl);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setTarProgressDisplay(TarProgressDisplay tarProgressDisplay) {
        this.progressDisplay = tarProgressDisplay;
    }

    public void setKeepOldFiles(boolean bl) {
        this.keepOldFiles = bl;
    }

    public void setAsciiTranslation(boolean bl) {
    }

    public void setTransFileTyper(TarTransFileTyper tarTransFileTyper) {
        this.transTyper = tarTransFileTyper;
    }

    public void setUserInfo(int n, String string, int n2, String string2) {
        this.userId = n;
        this.userName = string;
        this.groupId = n2;
        this.groupName = string2;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getTempDirectory() {
        return this.tempPath;
    }

    public void setTempDirectory(String string) {
        this.tempPath = string;
    }

    public int getRecordSize() {
        if (this.tarIn != null) {
            return this.tarIn.getRecordSize();
        }
        if (this.tarOut != null) {
            return this.tarOut.getRecordSize();
        }
        return 512;
    }

    private String getTempFilePath(File file) {
        File file2;
        String string = this.tempPath + File.separator + file.getName() + ".tmp";
        for (int i = 1; i < 5 && (file2 = new File(string)).exists(); ++i) {
            string = this.tempPath + File.separator + file.getName() + "-" + i + ".tmp";
        }
        return string;
    }

    public void closeArchive() throws IOException {
        if (this.tarIn != null) {
            this.tarIn.close();
        } else if (this.tarOut != null) {
            this.tarOut.close();
        }
    }

    public void listContents() throws IOException, InvalidHeaderException {
        while (true) {
            TarEntry tarEntry;
            if ((tarEntry = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            if (this.progressDisplay == null) continue;
            this.progressDisplay.showTarProgressMessage(tarEntry.getName());
        }
    }

    public void extractContents(File file) throws IOException, InvalidHeaderException {
        while (true) {
            TarEntry tarEntry;
            if ((tarEntry = this.tarIn.getNextEntry()) == null) {
                if (!this.debug) break;
                System.err.println("READ EOF RECORD");
                break;
            }
            this.extractEntry(file, tarEntry);
        }
    }

    private void extractEntry(File file, TarEntry tarEntry) throws IOException {
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(tarEntry.getName());
        }
        String string = tarEntry.getName();
        string = string.replace('/', File.separatorChar);
        File file2 = new File(file, string);
        if (tarEntry.isDirectory()) {
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("error making directory path '" + file2.getPath() + "'");
            }
        } else {
            File file3 = new File(file2.getParent());
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("error making directory path '" + file3.getPath() + "'");
            }
            if (this.keepOldFiles && file2.exists()) {
                if (this.verbose && this.progressDisplay != null) {
                    this.progressDisplay.showTarProgressMessage("not overwriting " + tarEntry.getName());
                }
            } else {
                int n;
                boolean bl = false;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = null;
                if (bl) {
                    printWriter = new PrintWriter(fileOutputStream);
                }
                byte[] byArray = new byte[32768];
                while ((n = this.tarIn.read(byArray)) != -1) {
                    if (bl) {
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            if (byArray[i] != 10) continue;
                            String string2 = new String(byArray, n2, i - n2);
                            printWriter.println(string2);
                            n2 = i + 1;
                        }
                        continue;
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
                if (bl) {
                    printWriter.close();
                } else {
                    fileOutputStream.close();
                }
            }
        }
    }

    public void writeEntry(TarEntry tarEntry, boolean bl) throws IOException {
        boolean bl2 = tarEntry.isUnixTarFormat();
        File file = null;
        File file2 = tarEntry.getFile();
        TarEntry tarEntry2 = (TarEntry)tarEntry.clone();
        if (this.verbose && this.progressDisplay != null) {
            this.progressDisplay.showTarProgressMessage(tarEntry2.getName());
        }
        String string = null;
        if (this.rootPath != null && tarEntry2.getName().startsWith(this.rootPath)) {
            string = tarEntry2.getName().substring(this.rootPath.length() + 1);
        }
        if (this.pathPrefix != null) {
            String string2 = string = string == null ? this.pathPrefix + "/" + tarEntry2.getName() : this.pathPrefix + "/" + string;
        }
        if (string != null) {
            tarEntry2.setName(string);
        }
        this.tarOut.putNextEntry(tarEntry2);
        if (tarEntry2.isDirectory()) {
            if (bl) {
                TarEntry[] tarEntryArray = tarEntry2.getDirectoryEntries();
                for (int i = 0; i < tarEntryArray.length; ++i) {
                    TarEntry tarEntry3 = tarEntryArray[i];
                    if (bl2) {
                        tarEntry3.setUnixTarFormat();
                    }
                    this.writeEntry(tarEntry3, bl);
                }
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[32768];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1) {
                this.tarOut.write(byArray, 0, n);
            }
            fileInputStream.close();
            if (file != null) {
                file.delete();
            }
            this.tarOut.closeEntry();
        }
    }
}

