/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.interfaces.Searchable;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SearchPanel
extends JPanel {
    private Searchable searchable;
    private JTextField searchField;

    public SearchPanel(final SearchableOwner searchableOwner, final Searchable searchable) {
        this.searchable = searchable;
        searchable.setSearchHighlight(false);
        searchable.setSearchMatchCase(false);
        this.searchField = new JTextField();
        this.searchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    searchable.searchNext();
                } else if (searchable.setSearchString(SearchPanel.this.searchField.getText())) {
                    SearchPanel.this.searchField.setBackground(Color.white);
                    SearchPanel.this.searchField.setForeground(Color.black);
                } else {
                    SearchPanel.this.searchField.setBackground(new Color(255, 102, 102));
                    SearchPanel.this.searchField.setForeground(Color.white);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchable.setSearchString("");
                searchableOwner.showSearchPanel(false);
            }
        });
        JButton jButton2 = new JButton("Next");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchable.searchNext();
            }
        });
        JButton jButton3 = new JButton("Previous");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchable.searchPrevious();
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("Highlight");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchable.setSearchHighlight(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Match Case");
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                searchable.setSearchMatchCase(jCheckBox2.isSelected());
                if (searchable.setSearchString(SearchPanel.this.searchField.getText())) {
                    SearchPanel.this.searchField.setBackground(Color.white);
                    SearchPanel.this.searchField.setForeground(Color.black);
                } else {
                    SearchPanel.this.searchField.setBackground(new Color(255, 102, 102));
                    SearchPanel.this.searchField.setForeground(Color.white);
                }
            }
        });
        ParaProfUtils.addCompItem(this, (Component)jButton, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)new JLabel("Find:"), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ParaProfUtils.addCompItem(this, (Component)this.searchField, gridBagConstraints, 2, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(this, (Component)jButton2, gridBagConstraints, 3, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)jButton3, gridBagConstraints, 4, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)jCheckBox, gridBagConstraints, 5, 0, 1, 1);
        ParaProfUtils.addCompItem(this, (Component)jCheckBox2, gridBagConstraints, 6, 0, 1, 1);
        this.searchField.requestFocus();
    }

    public void setFocus() {
        this.searchField.requestFocus();
    }
}

