/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;

public class PPUserEventProfile
implements Comparable {
    private UserEventProfile userEventProfile;
    private DataSorter dataSorter;
    private UserEvent userEvent;
    private boolean highlighted = false;
    private Thread thread;

    public PPUserEventProfile(DataSorter dataSorter, Thread thread, UserEventProfile userEventProfile) {
        this.thread = thread;
        this.dataSorter = dataSorter;
        this.userEventProfile = userEventProfile;
        this.userEvent = userEventProfile.getUserEvent();
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public String getUserEventName() {
        return this.userEvent.getName();
    }

    public Color getColor() {
        return this.userEvent.getColor();
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public double getNumSamples() {
        return this.userEventProfile.getNumSamples();
    }

    public double getMinValue() {
        return this.userEventProfile.getMinValue();
    }

    public double getMaxValue() {
        return this.userEventProfile.getMaxValue();
    }

    public double getMeanValue() {
        return this.userEventProfile.getMeanValue();
    }

    public double getStdDev() {
        return this.userEventProfile.getStdDev();
    }

    public String getUserEventStatString(int n) {
        int n2 = 90;
        int n3 = 0;
        char[] cArray = new char[n2];
        PPUserEventProfile.insertSpaces(cArray, 0, 90);
        String string = UtilFncs.getOutputString((int)0, (double)this.getNumSamples(), (int)n);
        char[] cArray2 = string.toCharArray();
        int n4 = 0;
        while (n4 < cArray2.length) {
            cArray[n3] = cArray2[n4];
            ++n3;
            ++n4;
        }
        n3 = 18;
        string = UtilFncs.getOutputString((int)0, (double)this.getMaxValue(), (int)n);
        cArray2 = string.toCharArray();
        int n5 = 0;
        while (n5 < cArray2.length) {
            cArray[n3] = cArray2[n5];
            ++n3;
            ++n5;
        }
        n3 = 36;
        string = UtilFncs.getOutputString((int)0, (double)this.getMinValue(), (int)n);
        cArray2 = string.toCharArray();
        int n6 = 0;
        while (n6 < cArray2.length) {
            cArray[n3] = cArray2[n6];
            ++n3;
            ++n6;
        }
        n3 = 54;
        string = UtilFncs.getOutputString((int)0, (double)this.getMeanValue(), (int)n);
        cArray2 = string.toCharArray();
        int n7 = 0;
        while (n7 < cArray2.length) {
            cArray[n3] = cArray2[n7];
            ++n3;
            ++n7;
        }
        n3 = 72;
        string = UtilFncs.getOutputString((int)0, (double)this.getStdDev(), (int)n);
        cArray2 = string.toCharArray();
        int n8 = 0;
        while (n8 < cArray2.length) {
            cArray[n3] = cArray2[n8];
            ++n3;
            ++n8;
        }
        return new String(cArray);
    }

    private static int insertSpaces(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n] = 32;
            ++n;
            ++n3;
        }
        return n;
    }

    private int checkDescending(int n) {
        if (this.dataSorter.getDescendingOrder()) {
            return -n;
        }
        return n;
    }

    public int compareTo(Object object) {
        UserEventValueType userEventValueType = this.dataSorter.getUserEventValueType();
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)object;
        if (this.dataSorter.getSortType() == SortType.NAME) {
            return this.checkDescending(pPUserEventProfile.getUserEventName().compareTo(this.getUserEventName()));
        }
        if (this.dataSorter.getSortType() == SortType.NCT) {
            if (pPUserEventProfile.getNodeID() != this.getNodeID()) {
                return this.checkDescending(this.getNodeID() - pPUserEventProfile.getNodeID());
            }
            if (pPUserEventProfile.getContextID() != this.getContextID()) {
                return this.checkDescending(this.getContextID() - pPUserEventProfile.getContextID());
            }
            return this.checkDescending(this.getThreadID() - pPUserEventProfile.getThreadID());
        }
        if (this.dataSorter.getSortType() == SortType.VALUE || this.dataSorter.getSortType() == SortType.MEAN_VALUE) {
            return this.checkDescending(this.compareToHelper(userEventValueType.getValue(this.getUserEventProfile()), userEventValueType.getValue(pPUserEventProfile.getUserEventProfile())));
        }
        throw new ParaProfException("Unexpected sort type: " + this.dataSorter.getSortType());
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public Thread getThread() {
        return this.thread;
    }
}

