/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class PPThread {
    private int miscXBeg;
    private int miscXEnd;
    private int miscYBeg;
    private int miscYEnd;
    private ParaProfTrial ppTrial;
    private Thread thread = null;
    private List functions = new ArrayList();
    private List userevents = new ArrayList();
    private int yDrawCoord = -1;
    private double maxExclusivePercent;

    public PPThread(Thread thread, ParaProfTrial paraProfTrial) {
        if (thread == null) {
            throw new ParaProfException("PPThread constructor called with null thread");
        }
        this.ppTrial = paraProfTrial;
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public String getName() {
        if (this.getNodeID() == -1) {
            return "mean";
        }
        if (this.getNodeID() == -2) {
            return "total";
        }
        if (this.getNodeID() == -3) {
            return "std. dev.";
        }
        return "n,c,t " + this.getNodeID() + "," + this.getContextID() + "," + this.getThreadID();
    }

    public void addFunction(PPFunctionProfile pPFunctionProfile) {
        this.functions.add(pPFunctionProfile);
    }

    public void addUserevent(PPFunctionProfile pPFunctionProfile) {
        this.userevents.add(pPFunctionProfile);
    }

    public List getFunctionList() {
        return this.functions;
    }

    public ListIterator getFunctionListIterator() {
        return this.functions.listIterator();
    }

    public List getUsereventList() {
        return this.userevents;
    }

    public ListIterator getUsereventListIterator() {
        return this.userevents.listIterator();
    }

    public double getMaxExclusivePercent() {
        return this.maxExclusivePercent;
    }

    public Vector getSortedFunctionProfiles(DataSorter dataSorter, boolean bl) {
        Vector<PPFunctionProfile> vector = null;
        List list = this.thread.getFunctionProfiles();
        vector = new Vector<PPFunctionProfile>();
        this.maxExclusivePercent = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null || !bl && (!this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(dataSorter.getPhase()))) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(dataSorter, this.thread, functionProfile);
            vector.addElement(pPFunctionProfile);
            this.maxExclusivePercent = Math.max(this.maxExclusivePercent, functionProfile.getExclusivePercent(this.ppTrial.getDefaultMetricID()));
        }
        Collections.sort(vector);
        return vector;
    }

    public void setYDrawCoord(int n) {
        n = this.yDrawCoord;
    }

    public int getYDrawCoord() {
        return this.yDrawCoord;
    }

    public void setMiscCoords(int n, int n2, int n3, int n4) {
        this.miscXBeg = n;
        this.miscXEnd = n2;
        this.miscYBeg = n3;
        this.miscYEnd = n4;
    }

    public int getMiscXBeg() {
        return this.miscXBeg;
    }

    public int getMiscXEnd() {
        return this.miscXEnd;
    }

    public int getMiscYBeg() {
        return this.miscYBeg;
    }

    public int getMiscYEnd() {
        return this.miscYEnd;
    }
}

