/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.LedgerDataElement;
import edu.uoregon.tau.paraprof.LedgerWindowPanel;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class LedgerWindow
extends JFrame
implements Observer,
ParaProfWindow {
    public static final int FUNCTION_LEDGER = 0;
    public static final int GROUP_LEDGER = 1;
    public static final int USEREVENT_LEDGER = 2;
    public static final int PHASE_LEDGER = 3;
    private int windowType = -1;
    private ParaProfTrial ppTrial = null;
    private JScrollPane sp = null;
    private LedgerWindowPanel panel = null;
    private Vector list = new Vector();

    public void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public LedgerWindow(ParaProfTrial paraProfTrial, int n, Component component) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.windowType = n;
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(350, 450)));
        ((Component)this).setLocation(WindowPlacer.getNewLedgerLocation(this, component));
        switch (n) {
            case 0: {
                this.setTitle("Function Ledger: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            case 1: {
                this.setTitle("Group Ledger: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            case 2: {
                this.setTitle("User Event Ledger: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            case 3: {
                this.setTitle("Phase Ledger: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            default: {
                throw new ParaProfException("Invalid Ledger Window Type: " + n);
            }
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LedgerWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new LedgerWindowPanel(paraProfTrial, this, n);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setupMenus();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        if (this.windowType == 0) {
            ParaProf.helpWindow.writeText("This is the function ledger window.\n");
            ParaProf.helpWindow.writeText("This window shows all the functions tracked in this profile.\n");
            ParaProf.helpWindow.writeText("To see more information about any of the functions shown here,");
            ParaProf.helpWindow.writeText("right click on that function, and select from the popup menu.\n");
            ParaProf.helpWindow.writeText("You can also left click any function to highlight it in the system.");
        } else if (this.windowType == 1) {
            ParaProf.helpWindow.writeText("This is the group ledger window.\n");
            ParaProf.helpWindow.writeText("This window shows all the groups tracked in this profile.\n");
            ParaProf.helpWindow.writeText("Left click any group to highlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any group, and select from the popup menu to display more options for masking or displaying functions in a particular group.");
        } else {
            ParaProf.helpWindow.writeText("This is the user event ledger window.\n");
            ParaProf.helpWindow.writeText("This window shows all the user events tracked in this profile.\n");
            ParaProf.helpWindow.writeText("Left click any user event to highlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any user event, and select from the popup menu.");
        }
    }

    private void sortLocalData() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        this.list = new Vector();
                        if (this.windowType != 0) break block4;
                        Iterator iterator = this.ppTrial.getDataSource().getFunctions();
                        while (iterator.hasNext()) {
                            this.list.addElement(new LedgerDataElement((Function)iterator.next()));
                        }
                        break block5;
                    }
                    if (this.windowType != 1) break block6;
                    Iterator iterator = this.ppTrial.getDataSource().getGroups();
                    while (iterator.hasNext()) {
                        this.list.addElement(new LedgerDataElement((Group)iterator.next()));
                    }
                    break block5;
                }
                if (this.windowType != 2) break block7;
                Iterator iterator = this.ppTrial.getDataSource().getUserEvents();
                while (iterator.hasNext()) {
                    this.list.addElement(new LedgerDataElement((UserEvent)iterator.next()));
                }
                break block5;
            }
            if (this.windowType != 3) break block5;
            Group group = this.ppTrial.getDataSource().getGroup("TAU_PHASE");
            Iterator iterator = this.ppTrial.getDataSource().getFunctions();
            while (iterator.hasNext()) {
                Function function = (Function)iterator.next();
                if (!function.isGroupMember(group)) continue;
                this.list.addElement(new LedgerDataElement(function));
            }
        }
    }

    public Vector getData() {
        return this.list;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public int getWindowType() {
        return this.windowType;
    }
}

