/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.ConnectionManager;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DatabaseException;
import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.IntervalEvent;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class DatabaseAPI {
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected Vector nodes = null;
    protected Vector contexts = null;
    protected Vector threads = null;
    protected Vector intervalEvents = null;
    protected Vector metrics = null;
    protected Vector intervalEventData = null;
    protected Vector atomicEvents = null;
    protected Vector atomicEventData = null;
    private DB db = null;
    private ConnectionManager connector;
    private Hashtable intervalEventHash = null;
    private Hashtable atomicEventHash = null;
    private String configFileName = null;
    private boolean cancelUpload = false;
    private int totalItems;
    private int itemsDone;

    public void cancelUpload() {
        this.cancelUpload = true;
    }

    public String getMetricName(int n) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.elementAt(n)).getName();
        }
        return null;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public DB db() {
        return this.db;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public void initialize(Object object, boolean bl) throws SQLException {
        this.configFileName = new String((String)object);
        this.connector = new ConnectionManager(this.configFileName, bl);
        this.connector.connect();
        this.db = this.connector.getDB();
    }

    public void initialize(Object object, String string) throws SQLException {
        String string2 = (String)object;
        this.connector = new ConnectionManager(string2, string);
        this.connector.connect();
        this.db = this.connector.getDB();
    }

    public void terminate() {
        this.connector.dbclose();
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public ListIterator getApplicationList() {
        String string = "";
        return new DssIterator(Application.getApplicationList(this.db, string));
    }

    public ListIterator getExperimentList() throws DatabaseException {
        String string = "";
        if (this.application != null) {
            string = "WHERE application = " + this.application.getID();
        }
        return new DssIterator(Experiment.getExperimentList(this.db, string));
    }

    public ListIterator getTrialList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.experiment != null) {
            stringBuffer.append("WHERE t.experiment = " + this.experiment.getID());
        } else if (this.application != null) {
            stringBuffer.append("WHERE e.application = " + this.application.getID());
        }
        return new DssIterator(Trial.getTrialList(this.db, stringBuffer.toString()));
    }

    public Application setApplication(int n) {
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector vector = Application.getApplicationList(this.db, string);
        if (vector.size() == 1) {
            this.application = (Application)vector.elementAt(0);
        }
        return this.application;
    }

    public Application setApplication(String string, String string2) {
        Vector vector;
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE name = '" + string + "'");
        if (string2 != null) {
            stringBuffer.append(" AND version = " + string2);
        }
        if ((vector = Application.getApplicationList(this.db, stringBuffer.toString())).size() == 1) {
            this.application = (Application)vector.elementAt(0);
            return this.application;
        }
        return null;
    }

    public Experiment setExperiment(int n) throws DatabaseException {
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector vector = Experiment.getExperimentList(this.db, string);
        if (vector.size() == 1) {
            this.experiment = (Experiment)vector.elementAt(0);
            return this.experiment;
        }
        return null;
    }

    public Trial setTrial(int n) {
        return this.setTrial(n, true);
    }

    private Trial setTrial(int n, boolean bl) {
        String string;
        Vector vector;
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if ((vector = Trial.getTrialList(this.db, string = " WHERE t.id = " + n)).size() == 1) {
            this.trial = (Trial)vector.elementAt(0);
        }
        return this.trial;
    }

    public ListIterator getIntervalEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE trial = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE application = " + this.application.getID();
        }
        this.intervalEvents = IntervalEvent.getIntervalEvents(this, this.db, string);
        if (this.intervalEventHash == null) {
            this.intervalEventHash = new Hashtable();
        }
        Enumeration enumeration = this.intervalEvents.elements();
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = (IntervalEvent)enumeration.nextElement();
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return new DssIterator(this.intervalEvents);
    }

    public void getIntervalEventDetail(IntervalEvent intervalEvent) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ms.interval_event = " + intervalEvent.getID());
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND ms.metric in (");
            Enumeration enumeration = this.metrics.elements();
            while (enumeration.hasMoreElements()) {
                Metric metric = (Metric)enumeration.nextElement();
                stringBuffer.append(metric.getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        IntervalLocationProfile.getIntervalEventDetail(this.db, intervalEvent, stringBuffer.toString());
    }

    public void getAtomicEventDetail(AtomicEvent atomicEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE e.id = " + atomicEvent.getID());
        AtomicLocationProfile.getAtomicEventDetail(this.db, atomicEvent, stringBuffer.toString());
    }

    public ListIterator getAtomicEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE t.id = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE t.experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE e.application = " + this.application.getID();
        }
        this.atomicEvents = AtomicEvent.getAtomicEvents(this, this.db, string);
        if (this.atomicEventHash == null) {
            this.atomicEventHash = new Hashtable();
        }
        Enumeration enumeration = this.atomicEvents.elements();
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = (AtomicEvent)enumeration.nextElement();
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return new DssIterator(this.atomicEvents);
    }

    public IntervalEvent setIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        this.intervalEvents = new Vector();
        intervalEvent = this.getIntervalEvent(n);
        if (intervalEvent != null) {
            this.intervalEvents.addElement(intervalEvent);
        }
        this.setTrial(intervalEvent.getTrialID(), false);
        return intervalEvent;
    }

    public AtomicEvent setAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        this.atomicEvents = new Vector();
        atomicEvent = this.getAtomicEvent(n);
        if (atomicEvent != null) {
            this.atomicEvents.addElement(atomicEvent);
        }
        return atomicEvent;
    }

    public ListIterator getIntervalEventData() throws SQLException {
        Object object;
        Enumeration enumeration;
        if (this.trial == null && this.intervalEvents == null) {
            System.out.println("Please select a trial or a set of intervalEvents before getting intervalEvent data.");
            return null;
        }
        if (this.intervalEvents == null) {
            this.getIntervalEvents();
        }
        int n = 0;
        n = this.metrics != null && this.metrics.size() > 0 ? this.metrics.size() : this.trial.getMetricCount();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND p.interval_event in (");
            } else {
                stringBuffer.append(" WHERE p.interval_event in (");
            }
            enumeration = this.intervalEvents.elements();
            while (enumeration.hasMoreElements()) {
                object = (IntervalEvent)enumeration.nextElement();
                stringBuffer.append(((IntervalEvent)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            enumeration = this.contexts.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND p.metric IN (");
            enumeration = this.metrics.elements();
            while (enumeration.hasMoreElements()) {
                object = (Metric)enumeration.nextElement();
                stringBuffer.append(((Metric)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.intervalEventData = IntervalLocationProfile.getIntervalEventData(this.db, n, stringBuffer.toString());
        return new DssIterator(this.intervalEventData);
    }

    public ListIterator getAtomicEventData() {
        Object object;
        Enumeration enumeration;
        if (this.trial == null && this.atomicEvents == null) {
            System.out.println("Please select a trial or a set of user events before getting user event data.");
            return null;
        }
        if (this.atomicEvents == null) {
            this.getAtomicEvents();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND e.id IN (");
            } else {
                stringBuffer.append(" WHERE e.id IN (");
            }
            enumeration = this.atomicEvents.elements();
            while (enumeration.hasMoreElements()) {
                object = (AtomicEvent)enumeration.nextElement();
                stringBuffer.append(((AtomicEvent)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            enumeration = this.contexts.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.atomicEventData = AtomicLocationProfile.getAtomicEventData(this.db, stringBuffer.toString());
        return new DssIterator(this.atomicEventData);
    }

    public IntervalEvent getIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        if (this.intervalEventHash != null) {
            intervalEvent = (IntervalEvent)this.intervalEventHash.get(new Integer(n));
        }
        if (intervalEvent == null) {
            String string = " WHERE id = " + n;
            Vector vector = IntervalEvent.getIntervalEvents(this, this.db, string);
            if (vector.size() == 1) {
                intervalEvent = (IntervalEvent)vector.elementAt(0);
            }
            if (this.intervalEventHash == null) {
                this.intervalEventHash = new Hashtable();
            }
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return intervalEvent;
    }

    public AtomicEvent getAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        if (this.atomicEventHash != null) {
            atomicEvent = (AtomicEvent)this.atomicEventHash.get(new Integer(n));
        }
        if (atomicEvent == null) {
            String string = " WHERE u.id = " + n;
            Vector vector = AtomicEvent.getAtomicEvents(this, this.db, string);
            if (vector.size() == 1) {
                atomicEvent = (AtomicEvent)vector.elementAt(0);
            }
            if (this.atomicEventHash == null) {
                this.atomicEventHash = new Hashtable();
            }
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return atomicEvent;
    }

    public int saveApplication(Application application) {
        return application.saveApplication(this.db);
    }

    public int saveExperiment(Experiment experiment) throws DatabaseException {
        try {
            return experiment.saveExperiment(this.db);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving experiment", sQLException);
        }
    }

    public int saveTrial() {
        int n = this.trial.saveTrial(this.db);
        return n;
    }

    private int saveMetric(int n, Metric metric) throws SQLException {
        int n2 = 0;
        PreparedStatement preparedStatement = null;
        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
        preparedStatement.setString(1, metric.getName());
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string = new String();
        string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');"));
        n2 = Integer.parseInt(this.db.getDataItem(string));
        return n2;
    }

    private Hashtable saveMetrics(int n, Trial trial, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Enumeration enumeration = trial.getDataSource().getMetrics().elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Metric metric = (Metric)enumeration.nextElement();
            int n4 = 0;
            if (n2 < 0 || n2 == n3) {
                n4 = this.saveMetric(n, metric);
            }
            hashtable.put(new Integer(n3), new Integer(n4));
            ++n3;
        }
        return hashtable;
    }

    private Hashtable saveIntervalEvents(int n, Hashtable hashtable, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Enumeration enumeration = this.intervalEvents.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = (IntervalEvent)enumeration.nextElement();
            int n3 = intervalEvent.saveIntervalEvent(this.db, n, hashtable, n2);
            hashtable2.put(new Integer(intervalEvent.getID()), new Integer(n3));
        }
        return hashtable2;
    }

    private Hashtable saveAtomicEvents(int n) {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Enumeration enumeration = this.atomicEvents.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = (AtomicEvent)enumeration.nextElement();
            int n2 = atomicEvent.saveAtomicEvent(this.db, n);
            hashtable.put(new Integer(atomicEvent.getID()), new Integer(n2));
        }
        return hashtable;
    }

    private void saveAtomicEventData(Hashtable hashtable) {
        Enumeration enumeration = this.atomicEventData.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            AtomicLocationProfile atomicLocationProfile = (AtomicLocationProfile)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(new Integer(atomicLocationProfile.getAtomicEventID()));
            atomicLocationProfile.saveAtomicEventData(this.db, n);
        }
    }

    public int saveTrial(Trial trial) {
        return trial.saveTrial(this.db);
    }

    public int saveIntervalEvent(IntervalEvent intervalEvent, int n, Hashtable hashtable) throws SQLException {
        return intervalEvent.saveIntervalEvent(this.db, n, hashtable, -1);
    }

    public int saveAtomicEvent(AtomicEvent atomicEvent, int n) {
        return atomicEvent.saveAtomicEvent(this.db, n);
    }

    public void saveAtomicEventData(AtomicLocationProfile atomicLocationProfile, int n) {
        atomicLocationProfile.saveAtomicEventData(this.db, n);
    }

    public int getProgress() {
        if (this.totalItems != 0) {
            return (int)((float)this.itemsDone / (float)this.totalItems * 100.0f);
        }
        return 0;
    }

    public synchronized int saveParaProfTrial(Trial trial, int n) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Serializable serializable;
        long l = System.currentTimeMillis();
        DataSource dataSource = trial.getDataSource();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            arrayList.add(group.getName());
        }
        this.metrics = trial.getDataSource().getMetrics();
        int n2 = this.metrics.size();
        this.intervalEvents = new Vector();
        this.intervalEventData = new Vector();
        this.atomicEvents = new Vector();
        this.atomicEventData = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator2 = dataSource.getFunctions();
        while (iterator2.hasNext()) {
            serializable = (Function)iterator2.next();
            if (serializable == null) continue;
            object5 = new IntervalEvent(this);
            ((IntervalEvent)object5).setName(((Function)serializable).getName());
            ((IntervalEvent)object5).setID(((Function)serializable).getID());
            object4 = ((Function)serializable).getGroups();
            object3 = new StringBuffer();
            if (object4 != null) {
                for (int i = 0; i < ((Vector)object4).size(); ++i) {
                    if (i > 0) {
                        ((StringBuffer)object3).append("|");
                    }
                    ((StringBuffer)object3).append(((Group)((Vector)object4).get(i)).getName());
                }
                if (((Vector)object4).size() > 0) {
                    ((IntervalEvent)object5).setGroup(((StringBuffer)object3).toString());
                }
            }
            this.intervalEvents.add(object5);
            object2 = new IntervalLocationProfile(n2);
            object = new IntervalLocationProfile(n2);
            for (int i = 0; i < n2; ++i) {
                ((IntervalLocationProfile)object2).setNumCalls(((Function)serializable).getTotalNumCalls());
                ((IntervalLocationProfile)object2).setNumSubroutines(((Function)serializable).getTotalNumSubr());
                ((IntervalLocationProfile)object2).setInclusivePercentage(i, ((Function)serializable).getTotalInclusivePercent(i));
                ((IntervalLocationProfile)object2).setInclusive(i, ((Function)serializable).getTotalInclusive(i));
                ((IntervalLocationProfile)object2).setExclusivePercentage(i, ((Function)serializable).getTotalExclusivePercent(i));
                ((IntervalLocationProfile)object2).setExclusive(i, ((Function)serializable).getTotalExclusive(i));
                ((IntervalLocationProfile)object2).setInclusivePerCall(i, ((Function)serializable).getTotalInclusivePerCall(i));
                ((IntervalLocationProfile)object).setNumCalls(((Function)serializable).getMeanNumCalls());
                ((IntervalLocationProfile)object).setNumSubroutines(((Function)serializable).getMeanNumSubr());
                ((IntervalLocationProfile)object).setInclusivePercentage(i, ((Function)serializable).getMeanInclusivePercent(i));
                ((IntervalLocationProfile)object).setInclusive(i, ((Function)serializable).getMeanInclusive(i));
                ((IntervalLocationProfile)object).setExclusivePercentage(i, ((Function)serializable).getMeanExclusivePercent(i));
                ((IntervalLocationProfile)object).setExclusive(i, ((Function)serializable).getMeanExclusive(i));
                ((IntervalLocationProfile)object).setInclusivePerCall(i, ((Function)serializable).getMeanInclusivePerCall(i));
            }
            ((IntervalEvent)object5).setTotalSummary((IntervalLocationProfile)object2);
            ((IntervalEvent)object5).setMeanSummary((IntervalLocationProfile)object);
        }
        iterator2 = dataSource.getUserEvents();
        while (iterator2.hasNext()) {
            serializable = (UserEvent)iterator2.next();
            if (serializable == null) continue;
            object5 = new AtomicEvent(this);
            ((AtomicEvent)object5).setName(((UserEvent)serializable).getName());
            ((AtomicEvent)object5).setID(((UserEvent)serializable).getID());
            this.atomicEvents.add(object5);
        }
        iterator2 = trial.getDataSource().getNodes();
        while (iterator2.hasNext()) {
            serializable = (Node)iterator2.next();
            object5 = ((Node)((Object)serializable)).getContexts();
            while (object5.hasNext()) {
                object4 = (Context)object5.next();
                object3 = ((Context)object4).getThreads();
                while (object3.hasNext()) {
                    Object object6;
                    Object object7;
                    object2 = (Thread)object3.next();
                    object = ((Thread)object2).getFunctionProfiles();
                    Vector vector = ((Thread)object2).getUserEventProfiles();
                    Enumeration enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        object7 = (FunctionProfile)enumeration.nextElement();
                        if (object7 == null) continue;
                        object6 = new IntervalLocationProfile(n2);
                        ((IntervalLocationProfile)object6).setNode(((Thread)object2).getNodeID());
                        ((IntervalLocationProfile)object6).setContext(((Thread)object2).getContextID());
                        ((IntervalLocationProfile)object6).setThread(((Thread)object2).getThreadID());
                        ((IntervalLocationProfile)object6).setIntervalEventID(((FunctionProfile)object7).getFunction().getID());
                        ((IntervalLocationProfile)object6).setNumCalls(((FunctionProfile)object7).getNumCalls());
                        ((IntervalLocationProfile)object6).setNumSubroutines(((FunctionProfile)object7).getNumSubr());
                        for (int i = 0; i < n2; ++i) {
                            ((IntervalLocationProfile)object6).setInclusive(i, ((FunctionProfile)object7).getInclusive(i));
                            ((IntervalLocationProfile)object6).setExclusive(i, ((FunctionProfile)object7).getExclusive(i));
                            ((IntervalLocationProfile)object6).setInclusivePercentage(i, ((FunctionProfile)object7).getInclusivePercent(i));
                            ((IntervalLocationProfile)object6).setExclusivePercentage(i, ((FunctionProfile)object7).getExclusivePercent(i));
                            ((IntervalLocationProfile)object6).setInclusivePerCall(i, ((FunctionProfile)object7).getInclusivePerCall(i));
                        }
                        this.intervalEventData.add(object6);
                    }
                    if (vector == null) continue;
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        object7 = (UserEventProfile)enumeration.nextElement();
                        if (object7 == null) continue;
                        object6 = new AtomicLocationProfile();
                        ((AtomicLocationProfile)object6).setAtomicEventID(((UserEventProfile)object7).getUserEvent().getID());
                        ((AtomicLocationProfile)object6).setNode(((Thread)object2).getNodeID());
                        ((AtomicLocationProfile)object6).setContext(((Thread)object2).getContextID());
                        ((AtomicLocationProfile)object6).setThread(((Thread)object2).getThreadID());
                        ((AtomicLocationProfile)object6).setSampleCount(((UserEventProfile)object7).getUserEventNumberValue());
                        ((AtomicLocationProfile)object6).setMaximumValue(((UserEventProfile)object7).getUserEventMaxValue());
                        ((AtomicLocationProfile)object6).setMinimumValue(((UserEventProfile)object7).getUserEventMinValue());
                        ((AtomicLocationProfile)object6).setMeanValue(((UserEventProfile)object7).getUserEventMeanValue());
                        ((AtomicLocationProfile)object6).setSumSquared(((UserEventProfile)object7).getUserEventSumSquared());
                        this.atomicEventData.add(object6);
                    }
                }
            }
        }
        this.totalItems = this.intervalEvents.size() + this.intervalEventData.size() + this.atomicEvents.size() + this.atomicEventData.size();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n3 = 0;
        try {
            if (n < 0) {
                n3 = trial.saveTrial(this.db);
                trial.setID(n3);
                serializable = this.saveMetrics(n3, trial, n);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    object5 = this.saveIntervalEvents(n3, (Hashtable)serializable, n);
                    this.saveIntervalLocationProfiles(this.db, (Hashtable)object5, this.intervalEventData.elements(), (Hashtable)serializable, n);
                }
                if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
                    object5 = this.saveAtomicEvents(n3);
                    if (this.atomicEventData != null && this.atomicEventData.size() > 0) {
                        this.saveAtomicEventData((Hashtable)object5);
                    }
                }
            } else {
                n3 = trial.getID();
                serializable = this.saveMetrics(n3, trial, n);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    object5 = this.saveIntervalEvents(n3, (Hashtable)serializable, n);
                    this.saveIntervalLocationProfiles(this.db, (Hashtable)object5, this.intervalEventData.elements(), (Hashtable)serializable, n);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                throw new DatabaseException("Saving Trial Failed, rollback successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollback failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)l3 / 1000.0;
        return n3;
    }

    private Map uploadMetrics(int n, DataSource dataSource) throws SQLException {
        HashMap<Metric, Integer> hashMap = new HashMap<Metric, Integer>();
        Iterator iterator = dataSource.getMetrics().iterator();
        while (iterator.hasNext()) {
            Metric metric = (Metric)iterator.next();
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
            preparedStatement.setString(1, metric.getName());
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');"));
            int n2 = Integer.parseInt(this.db.getDataItem(string));
            hashMap.put(metric, new Integer(n2));
        }
        return hashMap;
    }

    private Map uploadFunctions(int n, DataSource dataSource) throws SQLException {
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        Iterator iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            String string = null;
            Vector vector = function.getGroups();
            StringBuffer stringBuffer = new StringBuffer();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(((Group)vector.get(i)).getName());
                }
                if (vector.size() > 0) {
                    string = stringBuffer.toString();
                }
            }
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');"));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(function, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private Map uploadUserEvents(int n, DataSource dataSource) throws SQLException {
        HashMap<UserEvent, Integer> hashMap = new HashMap<UserEvent, Integer>();
        String string = null;
        Iterator iterator = dataSource.getUserEvents();
        while (iterator.hasNext()) {
            UserEvent userEvent = (UserEvent)iterator.next();
            PreparedStatement preparedStatement = null;
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');"));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(userEvent, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private void addBatchFunctionProfile(PreparedStatement preparedStatement, Thread thread, int n, int n2, FunctionProfile functionProfile, int n3) throws SQLException {
        preparedStatement.setInt(1, n3);
        preparedStatement.setInt(2, n2);
        preparedStatement.setDouble(3, functionProfile.getInclusivePercent(n));
        preparedStatement.setDouble(4, functionProfile.getInclusive(n));
        preparedStatement.setDouble(5, functionProfile.getExclusivePercent(n));
        preparedStatement.setDouble(6, functionProfile.getExclusive(n));
        preparedStatement.setDouble(7, functionProfile.getNumCalls());
        preparedStatement.setDouble(8, functionProfile.getNumSubr());
        preparedStatement.setDouble(9, functionProfile.getInclusivePerCall(n));
        if (thread.getNodeID() >= 0) {
            preparedStatement.setInt(10, thread.getNodeID());
            preparedStatement.setInt(11, thread.getContextID());
            preparedStatement.setInt(12, thread.getThreadID());
        }
        ++this.itemsDone;
        preparedStatement.executeUpdate();
    }

    private void uploadFunctionProfiles(int n, DataSource dataSource, Map map, Map map2) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        if (this.db.getDBType().compareTo("oracle") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        Iterator iterator = dataSource.getMetrics().iterator();
        while (iterator.hasNext()) {
            Metric metric = (Metric)iterator.next();
            Integer n2 = (Integer)map2.get(metric);
            Iterator iterator2 = dataSource.getFunctions();
            while (iterator2.hasNext()) {
                Function function = (Function)iterator2.next();
                Integer n3 = (Integer)map.get(function);
                Thread thread = dataSource.getTotalData();
                this.addBatchFunctionProfile(preparedStatement, thread, metric.getID(), n2, function.getTotalProfile(), n3);
                Thread thread2 = dataSource.getMeanData();
                this.addBatchFunctionProfile(preparedStatement2, thread2, metric.getID(), n2, function.getMeanProfile(), n3);
                Iterator iterator3 = dataSource.getNodes();
                while (iterator3.hasNext()) {
                    Node node = (Node)iterator3.next();
                    Iterator iterator4 = node.getContexts();
                    while (iterator4.hasNext()) {
                        Context context = (Context)iterator4.next();
                        Iterator iterator5 = context.getThreads();
                        while (iterator5.hasNext()) {
                            Thread thread3 = (Thread)iterator5.next();
                            FunctionProfile functionProfile = thread3.getFunctionProfile(function);
                            if (functionProfile == null) continue;
                            if (this.cancelUpload) {
                                return;
                            }
                            this.addBatchFunctionProfile(preparedStatement3, thread3, metric.getID(), n2, functionProfile, n3);
                        }
                    }
                }
            }
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    private void uploadUserEventProfiles(int n, DataSource dataSource, Map map) throws SQLException {
        Iterator iterator = dataSource.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    Iterator iterator4 = thread.getUserEventProfiles().iterator();
                    while (iterator4.hasNext()) {
                        UserEventProfile userEventProfile = (UserEventProfile)iterator4.next();
                        if (this.cancelUpload) {
                            return;
                        }
                        if (userEventProfile == null) continue;
                        int n2 = (Integer)map.get(userEventProfile.getUserEvent());
                        PreparedStatement preparedStatement = null;
                        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_location_profile (atomic_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        preparedStatement.setInt(1, n2);
                        preparedStatement.setInt(2, thread.getNodeID());
                        preparedStatement.setInt(3, thread.getContextID());
                        preparedStatement.setInt(4, thread.getThreadID());
                        preparedStatement.setInt(5, userEventProfile.getUserEventNumberValue());
                        preparedStatement.setDouble(6, userEventProfile.getUserEventMaxValue());
                        preparedStatement.setDouble(7, userEventProfile.getUserEventMinValue());
                        preparedStatement.setDouble(8, userEventProfile.getUserEventMeanValue());
                        preparedStatement.setDouble(9, userEventProfile.getUserEventSumSquared());
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                }
            }
        }
    }

    private void computeUploadSize(DataSource dataSource) {
        Object object;
        this.totalItems = 0;
        Iterator iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            ++this.totalItems;
        }
        int n = dataSource.getMetrics().size();
        object = dataSource.getFunctions();
        while (object.hasNext()) {
            Function function = (Function)object.next();
            this.totalItems += n;
            this.totalItems += n;
            Iterator iterator2 = dataSource.getNodes();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator2.next();
                Iterator iterator3 = node.getContexts();
                while (iterator3.hasNext()) {
                    Context context = (Context)iterator3.next();
                    Iterator iterator4 = context.getThreads();
                    while (iterator4.hasNext()) {
                        Thread thread = (Thread)iterator4.next();
                        FunctionProfile functionProfile = thread.getFunctionProfile(function);
                        if (functionProfile == null) continue;
                        this.totalItems += n;
                    }
                }
            }
        }
    }

    public synchronized int uploadTrial(Trial trial, int n) throws DatabaseException {
        long l = System.currentTimeMillis();
        DataSource dataSource = trial.getDataSource();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n2 = -1;
        try {
            if (n < 0) {
                n2 = trial.saveTrial(this.db);
                trial.setID(n2);
                this.computeUploadSize(dataSource);
                Map map = this.uploadMetrics(n2, dataSource);
                Map map2 = this.uploadFunctions(n2, dataSource);
                this.uploadFunctionProfiles(n2, dataSource, map2, map);
                Map map3 = this.uploadUserEvents(n2, dataSource);
                this.uploadUserEventProfiles(n2, dataSource, map3);
                if (this.cancelUpload) {
                    this.db.rollback();
                    this.deleteTrial(n2);
                    return -1;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                throw new DatabaseException("Saving Trial Failed, rollback successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollback failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)l3 / 1000.0;
        return n2;
    }

    public int saveApplication() {
        int n = 0;
        if (this.application != null) {
            n = this.application.saveApplication(this.db);
        }
        return n;
    }

    public int saveExperiment() throws SQLException {
        int n = 0;
        if (this.experiment != null) {
            n = this.experiment.saveExperiment(this.db);
        }
        return n;
    }

    public void deleteTrial(int n) throws SQLException {
        Trial.deleteTrial(this.db, n);
    }

    public void deleteExperiment(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setExperiment(n);
        ListIterator listIterator = databaseAPI.getTrialList();
        while (listIterator.hasNext()) {
            Trial trial = (Trial)listIterator.next();
            Trial.deleteTrial(this.db, trial.getID());
        }
        Experiment.deleteExperiment(this.db, n);
    }

    public void deleteApplication(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setApplication(n);
        ListIterator listIterator = databaseAPI.getExperimentList();
        while (listIterator.hasNext()) {
            Experiment experiment = (Experiment)listIterator.next();
            databaseAPI.setExperiment(experiment.getID());
            ListIterator listIterator2 = databaseAPI.getTrialList();
            while (listIterator2.hasNext()) {
                Trial trial = (Trial)listIterator2.next();
                Trial.deleteTrial(this.db, trial.getID());
            }
            Experiment.deleteExperiment(this.db, experiment.getID());
        }
        Application.deleteApplication(this.db, n);
    }

    public int getNumberOfMetrics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + this.db.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.trial.getID());
        stringBuffer.append(" ORDER BY id ");
        try {
            ResultSet resultSet = this.db.executeQuery(stringBuffer.toString());
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public void saveIntervalLocationProfiles(DB dB, Hashtable hashtable, Enumeration enumeration, Hashtable hashtable2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        int n2 = 0;
        Integer n3 = null;
        while (enumeration.hasMoreElements()) {
            IntervalLocationProfile intervalLocationProfile = (IntervalLocationProfile)enumeration.nextElement();
            Integer n4 = (Integer)hashtable.get(new Integer(intervalLocationProfile.getIntervalEventID()));
            n2 = 0;
            n3 = (Integer)hashtable2.get(new Integer(n2));
            while (n3 != null) {
                if (n < 0 || n2 == n) {
                    preparedStatement.setInt(1, n4);
                    preparedStatement.setInt(2, intervalLocationProfile.getNode());
                    preparedStatement.setInt(3, intervalLocationProfile.getContext());
                    preparedStatement.setInt(4, intervalLocationProfile.getThread());
                    preparedStatement.setInt(5, n3);
                    preparedStatement.setDouble(6, intervalLocationProfile.getInclusivePercentage(n2));
                    preparedStatement.setDouble(7, intervalLocationProfile.getInclusive(n2));
                    preparedStatement.setDouble(8, intervalLocationProfile.getExclusivePercentage(n2));
                    preparedStatement.setDouble(9, intervalLocationProfile.getExclusive(n2));
                    preparedStatement.setDouble(10, intervalLocationProfile.getNumCalls());
                    preparedStatement.setDouble(11, intervalLocationProfile.getNumSubroutines());
                    preparedStatement.setDouble(12, intervalLocationProfile.getInclusivePerCall(n2));
                    preparedStatement.executeUpdate();
                }
                n3 = (Integer)hashtable2.get(new Integer(++n2));
            }
        }
        preparedStatement.close();
    }
}

