/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.jatha.Jatha;
import org.jatha.dynatype.LispException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispSymbol;
import org.jatha.dynatype.LispUnboundVariableException;
import org.jatha.dynatype.LispUndefinedFunctionException;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAFunctionException;
import org.jatha.dynatype.LispValueNotAListException;
import org.jatha.dynatype.StandardLispAtom;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispString;
import org.jatha.read.LispParser;

public class StandardLispSymbol
extends StandardLispAtom
implements LispSymbol {
    protected LispValue function;
    protected LispString name;
    protected LispValue value;
    protected LispValue plist;
    protected LispPackage pack;
    protected boolean isExternalInPackage = false;
    protected boolean isSpecial = false;
    protected int specialCount = 0;
    protected boolean mixedCase;

    public StandardLispSymbol() {
    }

    public StandardLispSymbol(Jatha lisp, String symbolName) {
        this(lisp, new StandardLispString(lisp, symbolName));
    }

    public StandardLispSymbol(Jatha lisp, LispString symbolNameString) {
        super(lisp);
        this.name = symbolNameString;
        this.value = null;
        this.function = null;
        this.plist = lisp.NIL;
        this.pack = null;
        this.mixedCase = (long)LispParser.firstCharNotInSet(0, symbolNameString.getValue(), "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ:*/+-?!.%$<>=_") < ((LispInteger)symbolNameString.length()).getLongValue();
    }

    public boolean basic_symbolp() {
        return true;
    }

    public boolean equals(LispSymbol otherSymbol) {
        return this == otherSymbol;
    }

    public String internal_getName() {
        return this.name.getValue();
    }

    public void internal_prin1(PrintStream os) {
        os.print(this.toString());
    }

    public void internal_princ(PrintStream os) {
        os.print(this.name.getValue());
    }

    public void internal_print(PrintStream os) {
        os.print(this.toString());
    }

    public void apropos_print(PrintWriter out) {
        String printRep = this.toString();
        out.print(printRep);
        out.print(' ');
        for (int i = 0; i < Jatha.APROPOS_TAB - printRep.length() - 1; ++i) {
            out.print(' ');
        }
        if (this.function != null) {
            if (this.function.basic_macrop()) {
                out.print("[macro] ");
            } else {
                out.print("[function] ");
            }
        }
        if (this.value != null) {
            out.print("value: " + this.value);
        }
        out.println();
    }

    public Object toJava() {
        return this.toStringSimple();
    }

    public String toString() {
        String pkg = "";
        if (this.pack == null) {
            pkg = "#:";
        } else if (this.pack != this.f_lisp.PACKAGE) {
            pkg = this.isExternalInPackage ? this.pack.toString() + ":" : this.pack.toString() + "::";
        }
        return pkg + this.name.getValue();
    }

    public String toStringSimple() {
        if (this.pack == this.f_lisp.findPackage("KEYWORD")) {
            return ":" + this.name.getValue();
        }
        return this.name.getValue();
    }

    public void set_special(boolean value) {
        this.isSpecial = value;
    }

    public boolean specialP() {
        return this.isSpecial;
    }

    public void adjustSpecialCount(int amount) {
        this.specialCount += amount;
    }

    public int get_specialCount() {
        return this.specialCount;
    }

    public void setPackage(LispPackage newPackage) {
        if (this.pack == null) {
            this.pack = newPackage;
        }
    }

    public void setExternal(boolean value) {
        this.isExternalInPackage = value;
    }

    public boolean externalP() {
        return this.isExternalInPackage;
    }

    public LispValue apply(LispValue args) {
        if (this.function == null) {
            return super.apply(args);
        }
        System.err.println("\nSorry, APPLY is not yet implemented.");
        return this.f_lisp.NIL;
    }

    public LispValue boundp() {
        if (this.value == null) {
            return this.f_lisp.NIL;
        }
        return this.f_lisp.T;
    }

    public LispValue fboundp() {
        if (this.function == null) {
            return this.f_lisp.NIL;
        }
        return this.f_lisp.T;
    }

    public LispValue funcall(LispValue args) {
        if (this.function == null) {
            throw new LispValueNotAFunctionException("The first argument to FUNCALL");
        }
        for (LispValue v = args; v != this.f_lisp.NIL; v = v.cdr()) {
            this.f_lisp.MACHINE.S.push(v.car());
        }
        this.f_lisp.MACHINE.C.pop();
        this.f_lisp.MACHINE.C.push(this.function.second());
        return this.f_lisp.NIL;
    }

    public LispValue pop() {
        if (this.value.basic_listp()) {
            LispValue returnValue = this.value.car();
            this.setf_symbol_value(this.value.cdr());
            return returnValue;
        }
        throw new LispValueNotAListException("The value of " + this.name.toStringSimple());
    }

    public LispValue push(LispValue newValue) {
        if (this.value.basic_listp()) {
            this.setf_symbol_value(new StandardLispCons(this.f_lisp, newValue, this.value));
            return newValue;
        }
        throw new LispValueNotAListException("The value of " + this.name.toStringSimple());
    }

    public LispValue setf_symbol_function(LispValue newFunction) {
        this.function = newFunction;
        return this.function;
    }

    public LispValue setf_symbol_plist(LispValue newPlist) {
        this.plist = newPlist;
        return this.plist;
    }

    public LispValue setf_symbol_value(LispValue newValue) {
        this.value = newValue;
        return this.value;
    }

    public LispValue setq(LispValue newValue) {
        this.value = newValue;
        return this.value;
    }

    public LispValue string() {
        return new StandardLispString(this.f_lisp, this.toString());
    }

    public LispValue symbolp() {
        return this.f_lisp.T;
    }

    public LispValue symbol_function() throws LispException {
        if (this.function == null) {
            throw new LispUndefinedFunctionException(this.name.getValue());
        }
        return this.function;
    }

    public LispValue symbol_name() {
        return this.name;
    }

    public LispValue symbol_package() {
        if (this.pack == null) {
            return this.f_lisp.NIL;
        }
        return this.pack;
    }

    public LispValue symbol_plist() {
        return this.plist;
    }

    public LispValue symbol_value() throws LispException {
        if (this.value == null) {
            throw new LispUnboundVariableException(this.name.getValue());
        }
        return this.value;
    }

    public LispValue type_of() {
        return this.f_lisp.SYMBOL_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.SYMBOL_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

