/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCharacter;
import org.jatha.dynatype.LispIndexOutOfRangeException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotACharacterException;
import org.jatha.dynatype.LispValueNotAStringException;
import org.jatha.dynatype.LispValueNotAnIntegerException;
import org.jatha.dynatype.StandardLispAtom;
import org.jatha.dynatype.StandardLispCharacter;
import org.jatha.dynatype.StandardLispInteger;

public class StandardLispString
extends StandardLispAtom
implements LispString {
    private String str;

    public StandardLispString() {
    }

    public StandardLispString(Jatha lisp, String strName) {
        super(lisp);
        this.str = strName;
    }

    public String getValue() {
        return this.str;
    }

    public void internal_princ(PrintStream os) {
        os.print(this.str);
    }

    public void internal_prin1(PrintStream os) {
        os.print("\"" + this.str + "\"");
    }

    public void internal_print(PrintStream os) {
        os.print("\"" + this.str + "\"");
    }

    public Object toJava() {
        return this.str;
    }

    public String toString() {
        return "\"" + this.str + "\"";
    }

    public String toStringSimple() {
        return this.str;
    }

    public boolean basic_constantp() {
        return true;
    }

    public LispValue basic_elt(int n) {
        return this.elt(this.f_lisp.makeInteger(n));
    }

    public int basic_length() {
        return this.str.length();
    }

    public boolean basic_stringp() {
        return true;
    }

    public LispValue concatenate(LispValue value) {
        if (value instanceof LispString) {
            return new StandardLispString(this.f_lisp, this.str + value.toStringSimple());
        }
        return new StandardLispString(this.f_lisp, this.str + ((Object)value).toString());
    }

    public LispValue elt(int index) {
        return this.elt(new StandardLispInteger(this.f_lisp, index));
    }

    public LispValue elt(LispValue index) {
        if (!index.basic_integerp()) {
            throw new LispValueNotAnIntegerException("to ELT");
        }
        long indexValue = ((LispInteger)index).getLongValue();
        if (indexValue < 0L || indexValue >= (long)this.str.length()) {
            throw new LispIndexOutOfRangeException(String.valueOf(indexValue) + " to ELT");
        }
        return new StandardLispCharacter(this.f_lisp, this.str.charAt((int)indexValue));
    }

    public LispValue eql(LispValue other) {
        if (other instanceof LispString && this.str.equals(((LispString)other).getValue())) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue equal(LispValue other) {
        return this.eql(other);
    }

    public boolean equals(LispValue other) {
        return this.eql(other) == this.f_lisp.T;
    }

    public LispValue first() {
        return this.elt(0);
    }

    public LispValue second() {
        return this.elt(1);
    }

    public LispValue third() {
        return this.elt(2);
    }

    public LispValue fourth() {
        return this.elt(3);
    }

    public LispValue fifth() {
        return this.elt(4);
    }

    public LispValue sixth() {
        return this.elt(5);
    }

    public LispValue seventh() {
        return this.elt(6);
    }

    public LispValue eighth() {
        return this.elt(7);
    }

    public LispValue ninth() {
        return this.elt(8);
    }

    public LispValue tenth() {
        return this.elt(9);
    }

    public LispValue last() {
        return this.elt(this.basic_length() - 1);
    }

    public LispValue length() {
        return new StandardLispInteger(this.f_lisp, this.str.length());
    }

    public LispValue stringp() {
        return this.f_lisp.T;
    }

    public LispValue nstringUpcase() {
        return this.stringUpcase();
    }

    public LispValue nstringCapitalize() {
        return this.stringCapitalize();
    }

    public LispValue nstringDowncase() {
        return this.stringDowncase();
    }

    public LispValue position(LispValue element) {
        if (element instanceof LispCharacter) {
            char elt = ((LispCharacter)element).getCharacterValue();
            int index = this.str.indexOf(elt);
            if (index < 0) {
                return this.f_lisp.NIL;
            }
            return this.f_lisp.makeInteger(index);
        }
        throw new LispValueNotACharacterException("The argument to POSITION (" + element + ")");
    }

    public LispValue string() {
        return this;
    }

    public LispValue stringCapitalize() {
        if (this.str.length() > 0) {
            return new StandardLispString(this.f_lisp, this.str.substring(0, 1).toUpperCase() + this.str.substring(1).toLowerCase());
        }
        return new StandardLispString(this.f_lisp, this.str);
    }

    public LispValue stringDowncase() {
        return new StandardLispString(this.f_lisp, this.str.toLowerCase());
    }

    public LispValue stringEndsWith(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.endsWith(((LispString)arg).getValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringEndsWith (" + arg + ")");
    }

    public LispValue stringEq(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.equals(((LispString)arg).getValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringEq (" + arg + ")");
    }

    public LispValue stringEqual(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.equalsIgnoreCase(((LispString)arg).getValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringEqual (" + arg + ")");
    }

    public LispValue stringGreaterP(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareToIgnoreCase(((LispString)arg).getValue()) > 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringGreaterP (" + arg + ")");
    }

    public LispValue stringGreaterThan(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareTo(((LispString)arg).getValue()) > 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringGreaterThan (" + arg + ")");
    }

    public LispValue stringGreaterThanOrEqual(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareTo(((LispString)arg).getValue()) >= 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringGreaterThanOrEqual (" + arg + ")");
    }

    public LispValue stringLeftTrim() {
        int i;
        int maxLength = this.str.length();
        for (i = 0; i < maxLength && Character.isWhitespace(this.str.charAt(i)); ++i) {
        }
        return new StandardLispString(this.f_lisp, this.str.substring(i));
    }

    public LispValue stringLeftTrim(LispValue deleteBag) {
        int i;
        if (!(deleteBag instanceof LispString)) {
            throw new LispValueNotAStringException("The argument to stringLeftTrim (" + deleteBag + ")");
        }
        int maxLength = this.str.length();
        for (i = 0; i < maxLength && ((LispString)deleteBag).getValue().indexOf(this.str.charAt(i)) >= 0; ++i) {
        }
        return new StandardLispString(this.f_lisp, this.str.substring(i));
    }

    public LispValue stringLessP(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareToIgnoreCase(((LispString)arg).getValue()) < 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringLessP (" + arg + ")");
    }

    public LispValue stringLessThan(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareTo(((LispString)arg).getValue()) < 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringLessThan (" + arg + ")");
    }

    public LispValue stringLessThanOrEqual(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareTo(((LispString)arg).getValue()) <= 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringLessThanOrEqual (" + arg + ")");
    }

    public LispValue stringNeq(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.equals(((LispString)arg).getValue())) {
                return this.f_lisp.NIL;
            }
            return this.f_lisp.T;
        }
        throw new LispValueNotAStringException("The argument to stringNeq (" + arg + ")");
    }

    public LispValue stringNotGreaterP(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareToIgnoreCase(((LispString)arg).getValue()) <= 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringNotGreaterP (" + arg + ")");
    }

    public LispValue stringNotLessP(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.compareToIgnoreCase(((LispString)arg).getValue()) >= 0) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringNotLessP (" + arg + ")");
    }

    public LispValue stringRightTrim() {
        int i;
        for (i = this.str.length() - 1; i >= 0 && Character.isWhitespace(this.str.charAt(i)); --i) {
        }
        return new StandardLispString(this.f_lisp, this.str.substring(0, i + 1));
    }

    public LispValue stringRightTrim(LispValue deleteBag) {
        int i;
        if (!(deleteBag instanceof LispString)) {
            throw new LispValueNotAStringException("The argument to stringRightTrim (" + deleteBag + ")");
        }
        for (i = this.str.length() - 1; i >= 0 && ((LispString)deleteBag).getValue().indexOf(this.str.charAt(i)) >= 0; --i) {
        }
        return new StandardLispString(this.f_lisp, this.str.substring(0, i + 1));
    }

    public LispValue stringStartsWith(LispValue arg) {
        if (arg instanceof LispString) {
            if (this.str.startsWith(((LispString)arg).getValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        throw new LispValueNotAStringException("The argument to stringStartsWith (" + arg + ")");
    }

    public LispValue stringTrim() {
        return new StandardLispString(this.f_lisp, this.str.trim());
    }

    public LispValue stringTrim(LispValue deleteBag) {
        LispValue result = this.stringRightTrim(deleteBag);
        return result.stringLeftTrim(deleteBag);
    }

    public LispValue stringUpcase() {
        return new StandardLispString(this.f_lisp, this.str.toUpperCase());
    }

    public LispValue substring(LispValue start) {
        return this.substring(start, new StandardLispInteger(this.f_lisp, this.str.length()));
    }

    public LispValue substring(LispValue start, LispValue end) {
        if (start instanceof LispInteger) {
            if (end instanceof LispInteger) {
                long i_begin = ((LispInteger)start).getLongValue();
                long i_end = ((LispInteger)end).getLongValue();
                long length = this.str.length();
                if (i_begin < 0L) {
                    throw new LispIndexOutOfRangeException("The start index of substring (" + i_begin + ")");
                }
                if (i_end < 0L) {
                    throw new LispIndexOutOfRangeException("The end index of substring (" + i_end + ")");
                }
                if (i_begin >= length || i_begin >= i_end) {
                    return new StandardLispString(this.f_lisp, "");
                }
                return new StandardLispString(this.f_lisp, this.str.substring((int)i_begin, (int)i_end));
            }
            throw new LispValueNotAnIntegerException("The operand of substring (" + start + ")");
        }
        throw new LispValueNotAnIntegerException("The operand of substring (" + end + ")");
    }

    public LispValue type_of() {
        return this.f_lisp.STRING_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.STRING_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

