/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispHashTable;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispReal;
import org.jatha.dynatype.StandardLispValue;

public class StandardLispHashTable
extends StandardLispValue
implements LispHashTable {
    LispValue EQ = null;
    LispValue EQL = null;
    LispValue EQUAL = null;
    LispValue EQUALP = null;
    LispValue DEFAULT_TYPE = this.EQL;
    LispInteger DEFAULT_SIZE = new StandardLispInteger(this.f_lisp, 103L);
    LispReal DEFAULT_REHASH_SIZE = new StandardLispReal(this.f_lisp, 1.2);
    LispReal DEFAULT_REHASH_THRESHOLD = new StandardLispReal(this.f_lisp, 0.6407776407776408);
    protected LispValue type = this.DEFAULT_TYPE;
    protected LispValue size = this.DEFAULT_SIZE;
    protected LispValue rehashSize = this.DEFAULT_REHASH_SIZE;
    protected LispValue rehashThreshold = this.DEFAULT_REHASH_THRESHOLD;
    protected HashMap theHashTable;

    public void initializeConstants() {
        this.EQ = this.f_lisp.EVAL.intern("EQ-HASH-TABLE", (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        this.EQL = this.f_lisp.EVAL.intern("EQL-HASH-TABLE", (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        this.EQUAL = this.f_lisp.EVAL.intern("EQUAL-HASH-TABLE", (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        this.EQUALP = this.f_lisp.EVAL.intern("EQUALP-HASH-TABLE", (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        this.DEFAULT_TYPE = this.EQL;
    }

    public StandardLispHashTable() {
    }

    public StandardLispHashTable(Jatha lisp) {
        super(lisp);
        this.f_lisp = lisp;
    }

    public StandardLispHashTable(Jatha lisp, LispValue typeArg, LispValue sizeArg, LispValue rehashSizeArg, LispValue rehashThresholdArg) {
        super(lisp);
        this.f_lisp = lisp;
        this.initializeConstants();
        this.type = typeArg != this.f_lisp.NIL ? typeArg : this.DEFAULT_TYPE;
        this.size = sizeArg != this.f_lisp.NIL ? sizeArg : this.DEFAULT_SIZE;
        this.rehashSize = rehashSizeArg != this.f_lisp.NIL ? rehashSizeArg : this.DEFAULT_REHASH_SIZE;
        this.rehashThreshold = rehashThresholdArg != this.f_lisp.NIL ? rehashThresholdArg : this.DEFAULT_REHASH_THRESHOLD;
        if (!this.size.basic_integerp()) {
            this.size = this.DEFAULT_SIZE;
        }
        if (!this.rehashSize.basic_floatp()) {
            this.rehashSize = this.DEFAULT_REHASH_SIZE;
        }
        if (!this.rehashThreshold.basic_floatp()) {
            this.rehashThreshold = this.DEFAULT_REHASH_THRESHOLD;
        }
        if (this.type != this.EQ && this.type != this.EQL && this.type != this.EQUAL && this.type != this.EQUALP) {
            this.type = this.DEFAULT_TYPE;
        }
        this.theHashTable = new HashMap((int)((LispInteger)this.size).getLongValue(), (float)((LispReal)this.rehashSize).getDoubleValue());
    }

    public void internal_princ(PrintStream os) {
        os.print(this.toString());
    }

    public void internal_prin1(PrintStream os) {
        os.print(this.toString());
    }

    public void internal_print(PrintStream os) {
        os.print(this.toString());
    }

    public Object toJava() {
        return this.theHashTable.clone();
    }

    public Collection toCollection() {
        ArrayList<LispCons> result = new ArrayList<LispCons>(this.theHashTable.size());
        Iterator iterator = this.theHashTable.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object val = this.theHashTable.get(key);
            result.add(this.f_lisp.makeCons(this.f_lisp.toLisp(key), this.f_lisp.toLisp(val)));
        }
        return super.toCollection();
    }

    public LispValue clrhash() {
        this.theHashTable.clear();
        return this;
    }

    public LispValue gethash(LispValue key) {
        return this.gethash(key, this.f_lisp.NIL);
    }

    public LispValue gethash(LispValue key, LispValue defawlt) {
        LispValue result = (LispValue)this.theHashTable.get(key);
        if (result == null) {
            return defawlt;
        }
        return result;
    }

    public LispValue remhash(LispValue key) {
        LispValue result = (LispValue)this.theHashTable.remove(key);
        if (result == null) {
            return this.f_lisp.NIL;
        }
        return result;
    }

    public LispValue setf_gethash(LispValue key, LispValue value) {
        this.theHashTable.put(key, value);
        return value;
    }

    public LispValue hashtablep() {
        return this.f_lisp.T;
    }

    public LispValue hash_table_count() {
        return new StandardLispInteger(this.f_lisp, this.theHashTable.size());
    }

    public LispValue hash_table_size() {
        return new StandardLispInteger(this.f_lisp, this.theHashTable.size());
    }

    public LispValue hash_table_rehash_size() {
        return new StandardLispReal(this.f_lisp, 1.0);
    }

    public LispValue hash_table_rehash_threshold() {
        return new StandardLispReal(this.f_lisp, 1.0);
    }

    public LispValue hash_table_test() {
        return this.f_lisp.EVAL.intern("EQL");
    }

    public LispValue type_of() {
        return this.f_lisp.HASHTABLE_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.HASHTABLE_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

