/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002, 2003 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for tar/common/tar.c
 */

#ifndef COMMON_TAR_INPUT_TAR_H
#define COMMON_TAR_INPUT_TAR_H

#include <file/input.h>
#include <tar/input.h>

class tar_input_tar: public tar_input
{
public:
	/**
	  * The destructor.
	  */
	virtual ~tar_input_tar();

	/**
	  * The constructor.
	  */
	tar_input_tar(file_input *);

	// see base class for documentation
	virtual int read_data(void *, int);

	// see base class for documentation
	virtual void read_data_padding();

	// see base class for documentation
	virtual int read_header(tar_header &);

	// see base class for documentation
	virtual void read_header_padding();

	// see base class for documentation
	virtual const char *filename() const;

private:
	/**
	  * The read_data_strict method is used to read in data from the
	  * input file, insisting on exactly the right number of bytes.
	  * Short reads not acceptable.
	  */
	int read_data_strict(void *, int);

	/**
	  * The `fp' instance variable is used to remember where we are
	  * getting out input from.
	  */
	file_input *fp;

	/**
	  * The `pos' instance variable is used to remember out current
	  * position within the input.
	  */
	long pos;

	/**
	  * The `state' instance variable is used to remember
	  * where we are up to in processing a single file.
	  *	0 = haven't read a header yet
	  *	1 = have read the header (read header padding next)
	  *	2 = have read the header padding (read data next)
	  *	3 = have read some data
	  */
	int state;

	/**
	  * The check_state method is used to make sure we are in the
	  * correct state for the method being called.
	  */
	void check_state(int, int = -1);

	/**
	  * The read_header_longname method is used to read a long
	  * file name (out of file data) and then read the next header,
	  * replacing the file name with the one read.
	  */
	int read_header_longname(int, tar_header &);

	/**
	  * The read_header_longlink method is used to read a long
	  * link name (out of file data) and then read the next header,
	  * replacing the link name with the one read.
	  */
	int read_header_longlink(int, tar_header &);

	/**
	  * The read_header_gzipped method is used to read a gzip flag
	  * header.  The unzipped name in in the file data.  Then read
	  * the next header, replacing the file name with the one read,
	  * and set the gzipped flag.
	  */
	int read_header_gzipped(int, tar_header &);

	/**
	  * The default constructor.  Do not use.
	  */
	tar_input_tar();

	/**
	  * The copy constructor.  Do not use.
	  */
	tar_input_tar(const tar_input_tar &);

	/**
	  * The assignment operator.  Do not use.
	  */
	tar_input_tar &operator=(const tar_input_tar &);
};

#endif /* COMMON_TAR_INPUT_TAR_H */
