//
//	tardy - a tar post-processor
//	Copyright (C) 2002 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate filenamelists
//

#pragma implementation "tar_input_filenamelist"

#include <tar/input/filename.h>
#include <tar/input/filenamelist.h>


tar_input_filenamelist::~tar_input_filenamelist()
{
	delete source;
	delete singleton;
}


tar_input_filenamelist::tar_input_filenamelist(filenamelist *arg) :
	source(arg),
	singleton(0)
{
}


tar_input *
tar_input_filenamelist::get_singleton()
	const
{
	if (!singleton)
	{
		rcstring filename;
		if (!source->read_one_line(filename))
			return 0;
		singleton = new tar_input_filename(filename);
	}
	return singleton;
}


int
tar_input_filenamelist::read_header(tar_header &result)
{
	if (singleton)
	{
		delete singleton;
		singleton = 0;
	}
	tar_input *fp = get_singleton();
	return (fp ? fp->read_header(result) : 0);
}


int
tar_input_filenamelist::read_data(void *buffer, int buflen)
{
	tar_input *fp = get_singleton();
	if (!fp)
		return 0;
	return fp->read_data(buffer, buflen);
}


const char *
tar_input_filenamelist::filename()
	const
{
	return source->filename();
}
