#!/usr/bin/env tarantool
test = require("sqltester")
test:plan(1896)

--!./tcltestrunner.lua
-- 2008 December 11
--
-- The author disclaims copyright to this source code.  In place of
-- a legal notice, here is a blessing:
--
--    May you do good and not evil.
--    May you find forgiveness for yourself and forgive others.
--    May you share freely, never taking more than you give.
--
-------------------------------------------------------------------------
-- This file implements regression tests for sql library.
--
-- This file is automatically generated from a separate TCL script.
-- This file seeks to exercise integer boundary values.
--
-- $Id: boundary3.test,v 1.2 2009/01/02 15:45:48 shane Exp $
-- ["set","testdir",[["file","dirname",["argv0"]]]]
-- ["source",[["testdir"],"\/tester.tcl"]]
-- Many of the boundary tests depend on a working 64-bit implementation.
test:do_test(
    "boundary3-1.1",
    function()
        return test:execsql([[
            CREATE TABLE t1(rowid  INT primary key, a NUMBER ,x SCALAR);
            INSERT INTO t1(rowid,a,x) VALUES(-8388609,1,'ffffffffff7fffff');
            INSERT INTO t1(rowid,a,x) VALUES(-36028797018963969,2,'ff7fffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(9223372036854775806,3,'7fffffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(127,4,'000000000000007f');
            INSERT INTO t1(rowid,a,x) VALUES(3,5,'0000000000000003');
            INSERT INTO t1(rowid,a,x) VALUES(16777216,6,'0000000001000000');
            INSERT INTO t1(rowid,a,x) VALUES(4398046511103,7,'000003ffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(16383,8,'0000000000003fff');
            INSERT INTO t1(rowid,a,x) VALUES(16777215,9,'0000000000ffffff');
            INSERT INTO t1(rowid,a,x) VALUES(281474976710655,10,'0000ffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(-2147483648,11,'ffffffff80000000');
            INSERT INTO t1(rowid,a,x) VALUES(268435455,12,'000000000fffffff');
            INSERT INTO t1(rowid,a,x) VALUES(562949953421311,13,'0001ffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(4294967295,14,'00000000ffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(2097151,15,'00000000001fffff');
            INSERT INTO t1(rowid,a,x) VALUES(16384,16,'0000000000004000');
            INSERT INTO t1(rowid,a,x) VALUES(72057594037927935,17,'00ffffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(8388607,18,'00000000007fffff');
            INSERT INTO t1(rowid,a,x) VALUES(1099511627776,19,'0000010000000000');
            INSERT INTO t1(rowid,a,x) VALUES(2147483647,20,'000000007fffffff');
            INSERT INTO t1(rowid,a,x) VALUES(-140737488355329,21,'ffff7fffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(34359738368,22,'0000000800000000');
            INSERT INTO t1(rowid,a,x) VALUES(32767,23,'0000000000007fff');
            INSERT INTO t1(rowid,a,x) VALUES(8388608,24,'0000000000800000');
            INSERT INTO t1(rowid,a,x) VALUES(140737488355327,25,'00007fffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(281474976710656,26,'0001000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(36028797018963967,27,'007fffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(72057594037927936,28,'0100000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(-32769,29,'ffffffffffff7fff');
            INSERT INTO t1(rowid,a,x) VALUES(255,30,'00000000000000ff');
            INSERT INTO t1(rowid,a,x) VALUES(4,31,'0000000000000004');
            INSERT INTO t1(rowid,a,x) VALUES(-32768,32,'ffffffffffff8000');
            INSERT INTO t1(rowid,a,x) VALUES(-2,33,'fffffffffffffffe');
            INSERT INTO t1(rowid,a,x) VALUES(140737488355328,34,'0000800000000000');
            INSERT INTO t1(rowid,a,x) VALUES(549755813888,35,'0000008000000000');
            INSERT INTO t1(rowid,a,x) VALUES(4294967296,36,'0000000100000000');
            INSERT INTO t1(rowid,a,x) VALUES(-8388608,37,'ffffffffff800000');
            INSERT INTO t1(rowid,a,x) VALUES(-1,38,'ffffffffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(34359738367,39,'00000007ffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(268435456,40,'0000000010000000');
            INSERT INTO t1(rowid,a,x) VALUES(2,41,'0000000000000002');
            INSERT INTO t1(rowid,a,x) VALUES(2097152,42,'0000000000200000');
            INSERT INTO t1(rowid,a,x) VALUES(562949953421312,43,'0002000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(-140737488355328,44,'ffff800000000000');
            INSERT INTO t1(rowid,a,x) VALUES(36028797018963968,45,'0080000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(549755813887,46,'0000007fffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(-2147483649,47,'ffffffff7fffffff');
            INSERT INTO t1(rowid,a,x) VALUES(65535,48,'000000000000ffff');
            INSERT INTO t1(rowid,a,x) VALUES(128,49,'0000000000000080');
            INSERT INTO t1(rowid,a,x) VALUES(32768,50,'0000000000008000');
            INSERT INTO t1(rowid,a,x) VALUES(2147483648,51,'0000000080000000');
            INSERT INTO t1(rowid,a,x) VALUES(-3,52,'fffffffffffffffd');
            INSERT INTO t1(rowid,a,x) VALUES(-128,53,'ffffffffffffff80');
            INSERT INTO t1(rowid,a,x) VALUES(-129,54,'ffffffffffffff7f');
            INSERT INTO t1(rowid,a,x) VALUES(-9223372036854775807,55,'8000000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(4398046511104,56,'0000040000000000');
            INSERT INTO t1(rowid,a,x) VALUES(1099511627775,57,'000000ffffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(-549755813889,58,'ffffff7fffffffff');
            INSERT INTO t1(rowid,a,x) VALUES(0,59,'0000000000000000');
            INSERT INTO t1(rowid,a,x) VALUES(1,60,'0000000000000001');
            INSERT INTO t1(rowid,a,x) VALUES(256,61,'0000000000000100');
            INSERT INTO t1(rowid,a,x) VALUES(65536,62,'0000000000010000');
            INSERT INTO t1(rowid,a,x) VALUES(-549755813888,63,'ffffff8000000000');
            INSERT INTO t1(rowid,a,x) VALUES(-36028797018963968,64,'ff80000000000000');
            CREATE INDEX t1i1 ON t1(a);
            CREATE INDEX t1i2 ON t1(x);
        ]])
    end, {
        -- <boundary3-1.1>
        
        -- </boundary3-1.1>
    })

test:do_execsql_test(
    "boundary3-1.2",
    "SELECT count(*) FROM t1"
    ,{64})

test:do_test(
    "boundary3-1.3",
    function()
        return test:execsql([[
            CREATE TABLE t2(r INT primary key, a NUMBER);
            INSERT INTO t2 SELECT rowid, a FROM t1;
            CREATE INDEX t2i1 ON t2(r);
            CREATE INDEX t2i2 ON t2(a);
            ---INSERT INTO t2 VALUES(100000,9.22337303685477580800e+18,65);
            ---INSERT INTO t2 VALUES(100001,-9.22337303685477580800e+18,66);
            INSERT INTO t2 VALUES(9223372036854775807, 65);
            INSERT INTO t2 VALUES(-9223372036854775808, 66);
            SELECT count(*) FROM t2;
        ]])
    end, {
        -- <boundary3-1.3>
        66
        -- </boundary3-1.3>
    })

test:do_execsql_test(
    "boundary3-2.1.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=72057594037927935 AND t2.a=t1.a"
    ,{17, "00ffffffffffffff"})

test:do_execsql_test(
    "boundary3-2.1.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00ffffffffffffff'"
    ,{72057594037927935LL, 17})

test:do_execsql_test(
    "boundary3-2.1.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=17"
    ,{72057594037927935LL, "00ffffffffffffff"})

test:do_execsql_test(
    "boundary3-2.1.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 72057594037927935 ORDER BY t2.a"
    ,{3, 28})

test:do_execsql_test(
    "boundary3-2.1.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 72057594037927935 ORDER BY t1.a DESC"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.1.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=17 ORDER BY t1.rowid"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.1.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=17 ORDER BY t1.rowid DESC"
    ,{3, 28})

test:do_execsql_test(
    "boundary3-2.1.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=17 ORDER BY x"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.1.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 72057594037927935 ORDER BY t2.a"
    ,{3, 17, 28})

test:do_execsql_test(
    "boundary3-2.1.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 72057594037927935 ORDER BY t1.a DESC"
    ,{28, 17, 3})

test:do_execsql_test(
    "boundary3-2.1.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=17 ORDER BY t1.rowid"
    ,{17, 28, 3})

test:do_execsql_test(
    "boundary3-2.1.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=17 ORDER BY t1.rowid DESC"
    ,{3, 28, 17})

test:do_execsql_test(
    "boundary3-2.1.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=17 ORDER BY x"
    ,{17, 28, 3})

test:do_execsql_test(
    "boundary3-2.1.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 72057594037927935 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.1.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 72057594037927935 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.1.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=17 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45})

test:do_execsql_test(
    "boundary3-2.1.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=17 ORDER BY t1.rowid DESC"
    ,{45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.1.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=17 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.1.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 72057594037927935 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.1.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 72057594037927935 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.1.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=17 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17})

test:do_execsql_test(
    "boundary3-2.1.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=17 ORDER BY t1.rowid DESC"
    ,{17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.1.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=17 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.2.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=16384 AND t2.a=t1.a"
    ,{16, "0000000000004000"})

test:do_execsql_test(
    "boundary3-2.2.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000004000'"
    ,{16384, 16})

test:do_execsql_test(
    "boundary3-2.2.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=16"
    ,{16384, "0000000000004000"})

test:do_execsql_test(
    "boundary3-2.2.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 16384 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.2.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 16384 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.2.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=16 ORDER BY t1.rowid"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23})

test:do_execsql_test(
    "boundary3-2.2.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=16 ORDER BY x"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23})

test:do_execsql_test(
    "boundary3-2.2.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 16384 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.2.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 16384 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.2.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=16 ORDER BY t1.rowid"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16})

test:do_execsql_test(
    "boundary3-2.2.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=16 ORDER BY x"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.2.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16})

test:do_execsql_test(
    "boundary3-2.2.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 16384 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.2.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 16384 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.2.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=16 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8})

test:do_execsql_test(
    "boundary3-2.2.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.2.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=16 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.2.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8})

test:do_execsql_test(
    "boundary3-2.2.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.2.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 16384 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.2.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 16384 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.2.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=16 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16})

test:do_execsql_test(
    "boundary3-2.2.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.2.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=16 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.2.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16})

test:do_execsql_test(
    "boundary3-2.2.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=16 ORDER BY t1.rowid DESC"
    ,{16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.3.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=4294967296 AND t2.a=t1.a"
    ,{36, "0000000100000000"})

test:do_execsql_test(
    "boundary3-2.3.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000100000000'"
    ,{4294967296, 36})

test:do_execsql_test(
    "boundary3-2.3.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=36"
    ,{4294967296, "0000000100000000"})

test:do_execsql_test(
    "boundary3-2.3.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 4294967296 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.3.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 4294967296 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.3.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=36 ORDER BY t1.rowid"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39})

test:do_execsql_test(
    "boundary3-2.3.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=36 ORDER BY x"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39})

test:do_execsql_test(
    "boundary3-2.3.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 4294967296 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.3.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 4294967296 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.3.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=36 ORDER BY t1.rowid"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36})

test:do_execsql_test(
    "boundary3-2.3.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=36 ORDER BY x"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.3.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36})

test:do_execsql_test(
    "boundary3-2.3.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 4294967296 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.3.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 4294967296 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.3.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=36 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14})

test:do_execsql_test(
    "boundary3-2.3.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.3.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=36 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.3.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14})

test:do_execsql_test(
    "boundary3-2.3.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.3.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 4294967296 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.3.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 4294967296 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.3.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=36 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36})

test:do_execsql_test(
    "boundary3-2.3.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.3.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=36 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.3.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36})

test:do_execsql_test(
    "boundary3-2.3.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=36 ORDER BY t1.rowid DESC"
    ,{36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.4.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=16777216 AND t2.a=t1.a"
    ,{6, "0000000001000000"})

test:do_execsql_test(
    "boundary3-2.4.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000001000000'"
    ,{16777216, 6})

test:do_execsql_test(
    "boundary3-2.4.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=6"
    ,{16777216, "0000000001000000"})

test:do_execsql_test(
    "boundary3-2.4.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 16777216 ORDER BY t2.a"
    ,{3, 7, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.4.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 16777216 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.4.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=6 ORDER BY t1.rowid"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12})

test:do_execsql_test(
    "boundary3-2.4.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=6 ORDER BY x"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12})

test:do_execsql_test(
    "boundary3-2.4.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 16777216 ORDER BY t2.a"
    ,{3, 6, 7, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.4.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 16777216 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.4.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=6 ORDER BY t1.rowid"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6})

test:do_execsql_test(
    "boundary3-2.4.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=6 ORDER BY x"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.4.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6})

test:do_execsql_test(
    "boundary3-2.4.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 16777216 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 9, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.4.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 16777216 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 9, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.4.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=6 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9})

test:do_execsql_test(
    "boundary3-2.4.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.4.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=6 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.4.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9})

test:do_execsql_test(
    "boundary3-2.4.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.4.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 16777216 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.4.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 16777216 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.4.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=6 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6})

test:do_execsql_test(
    "boundary3-2.4.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.4.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=6 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.4.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6})

test:do_execsql_test(
    "boundary3-2.4.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=6 ORDER BY t1.rowid DESC"
    ,{6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.5.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-32769 AND t2.a=t1.a"
    ,{29, "ffffffffffff7fff"})

test:do_execsql_test(
    "boundary3-2.5.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffffff7fff'"
    ,{-32769, 29})

test:do_execsql_test(
    "boundary3-2.5.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=29"
    ,{-32769, "ffffffffffff7fff"})

test:do_execsql_test(
    "boundary3-2.5.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -32769 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.5.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -32769 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 32, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.5.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=29 ORDER BY t1.rowid"
    ,{32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.5.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32})

test:do_execsql_test(
    "boundary3-2.5.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=29 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.5.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid"
    ,{32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.5.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32})

test:do_execsql_test(
    "boundary3-2.5.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -32769 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.5.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -32769 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.5.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=29 ORDER BY t1.rowid"
    ,{29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.5.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29})

test:do_execsql_test(
    "boundary3-2.5.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=29 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.5.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid"
    ,{29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.5.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29})

test:do_execsql_test(
    "boundary3-2.5.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -32769 ORDER BY t2.a"
    ,{1, 2, 11, 21, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.5.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -32769 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.5.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=29 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.5.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.5.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=29 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.5.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.5.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.5.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -32769 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.5.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -32769 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.5.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=29 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.5.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.5.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=29 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.5.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.5.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=29 ORDER BY t1.rowid DESC"
    ,{29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.6.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-140737488355329 AND t2.a=t1.a"
    ,{21, "ffff7fffffffffff"})

test:do_execsql_test(
    "boundary3-2.6.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffff7fffffffffff'"
    ,{-140737488355329LL, 21})

test:do_execsql_test(
    "boundary3-2.6.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=21"
    ,{-140737488355329LL, "ffff7fffffffffff"})

test:do_execsql_test(
    "boundary3-2.6.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -140737488355329 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.6.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -140737488355329 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.6.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=21 ORDER BY t1.rowid"
    ,{44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.6.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=21 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44})

test:do_execsql_test(
    "boundary3-2.6.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=21 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.6.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -140737488355329 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.6.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -140737488355329 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.6.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=21 ORDER BY t1.rowid"
    ,{21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.6.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=21 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21})

test:do_execsql_test(
    "boundary3-2.6.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=21 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.6.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -140737488355329 ORDER BY t2.a"
    ,{2, 55, 64})

test:do_execsql_test(
    "boundary3-2.6.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -140737488355329 ORDER BY t1.a DESC"
    ,{64, 55, 2})

test:do_execsql_test(
    "boundary3-2.6.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=21 ORDER BY t1.rowid"
    ,{55, 2, 64})

test:do_execsql_test(
    "boundary3-2.6.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=21 ORDER BY t1.rowid DESC"
    ,{64, 2, 55})

test:do_execsql_test(
    "boundary3-2.6.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=21 ORDER BY x"
    ,{55, 2, 64})

test:do_execsql_test(
    "boundary3-2.6.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -140737488355329 ORDER BY t2.a"
    ,{2, 21, 55, 64})

test:do_execsql_test(
    "boundary3-2.6.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -140737488355329 ORDER BY t1.a DESC"
    ,{64, 55, 21, 2})

test:do_execsql_test(
    "boundary3-2.6.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=21 ORDER BY t1.rowid"
    ,{55, 2, 64, 21})

test:do_execsql_test(
    "boundary3-2.6.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=21 ORDER BY t1.rowid DESC"
    ,{21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.6.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=21 ORDER BY x"
    ,{55, 2, 64, 21})

test:do_execsql_test(
    "boundary3-2.7.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=2 AND t2.a=t1.a"
    ,{41, "0000000000000002"})

test:do_execsql_test(
    "boundary3-2.7.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000002'"
    ,{2, 41})

test:do_execsql_test(
    "boundary3-2.7.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=41"
    ,{2, "0000000000000002"})

test:do_execsql_test(
    "boundary3-2.7.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 2 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.7.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 2 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.7.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=41 ORDER BY t1.rowid"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5})

test:do_execsql_test(
    "boundary3-2.7.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=41 ORDER BY x"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5})

test:do_execsql_test(
    "boundary3-2.7.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 2 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.7.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 2 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.7.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=41 ORDER BY t1.rowid"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41})

test:do_execsql_test(
    "boundary3-2.7.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=41 ORDER BY x"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.7.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41})

test:do_execsql_test(
    "boundary3-2.7.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 2 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.7.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 2 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.7.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=41 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60})

test:do_execsql_test(
    "boundary3-2.7.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.7.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=41 ORDER BY x"
    ,{59, 60, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.7.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60})

test:do_execsql_test(
    "boundary3-2.7.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.7.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 2 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.7.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 2 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.7.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=41 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41})

test:do_execsql_test(
    "boundary3-2.7.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.7.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=41 ORDER BY x"
    ,{59, 60, 41, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.7.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41})

test:do_execsql_test(
    "boundary3-2.7.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=41 ORDER BY t1.rowid DESC"
    ,{41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.8.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=4 AND t2.a=t1.a"
    ,{31, "0000000000000004"})

test:do_execsql_test(
    "boundary3-2.8.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000004'"
    ,{4, 31})

test:do_execsql_test(
    "boundary3-2.8.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=31"
    ,{4, "0000000000000004"})

test:do_execsql_test(
    "boundary3-2.8.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 4 ORDER BY t2.a"
    ,{3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.8.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 4 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 4, 3})

test:do_execsql_test(
    "boundary3-2.8.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=31 ORDER BY t1.rowid"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4})

test:do_execsql_test(
    "boundary3-2.8.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=31 ORDER BY x"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4})

test:do_execsql_test(
    "boundary3-2.8.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 4 ORDER BY t2.a"
    ,{3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.8.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 4 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 4, 3})

test:do_execsql_test(
    "boundary3-2.8.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=31 ORDER BY t1.rowid"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31})

test:do_execsql_test(
    "boundary3-2.8.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=31 ORDER BY x"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.8.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31})

test:do_execsql_test(
    "boundary3-2.8.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 4 ORDER BY t2.a"
    ,{1, 2, 5, 11, 21, 29, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.8.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 4 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 29, 21, 11, 5, 2, 1})

test:do_execsql_test(
    "boundary3-2.8.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=31 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5})

test:do_execsql_test(
    "boundary3-2.8.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.8.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=31 ORDER BY x"
    ,{59, 60, 41, 5, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.8.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5})

test:do_execsql_test(
    "boundary3-2.8.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.8.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 4 ORDER BY t2.a"
    ,{1, 2, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.8.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 4 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 2, 1})

test:do_execsql_test(
    "boundary3-2.8.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=31 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31})

test:do_execsql_test(
    "boundary3-2.8.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.8.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=31 ORDER BY x"
    ,{59, 60, 41, 5, 31, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.8.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31})

test:do_execsql_test(
    "boundary3-2.8.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=31 ORDER BY t1.rowid DESC"
    ,{31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.9.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=562949953421311 AND t2.a=t1.a"
    ,{13, "0001ffffffffffff"})

test:do_execsql_test(
    "boundary3-2.9.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0001ffffffffffff'"
    ,{562949953421311LL, 13})

test:do_execsql_test(
    "boundary3-2.9.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=13"
    ,{562949953421311LL, "0001ffffffffffff"})

test:do_execsql_test(
    "boundary3-2.9.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 562949953421311 ORDER BY t2.a"
    ,{3, 17, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.9.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 562949953421311 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 17, 3})

test:do_execsql_test(
    "boundary3-2.9.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=13 ORDER BY t1.rowid"
    ,{43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.9.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=13 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43})

test:do_execsql_test(
    "boundary3-2.9.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=13 ORDER BY x"
    ,{43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.9.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 562949953421311 ORDER BY t2.a"
    ,{3, 13, 17, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.9.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 562949953421311 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 17, 13, 3})

test:do_execsql_test(
    "boundary3-2.9.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=13 ORDER BY t1.rowid"
    ,{13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.9.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=13 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13})

test:do_execsql_test(
    "boundary3-2.9.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=13 ORDER BY x"
    ,{13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.9.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 562949953421311 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.9.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 562949953421311 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.9.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=13 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26})

test:do_execsql_test(
    "boundary3-2.9.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=13 ORDER BY t1.rowid DESC"
    ,{26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.9.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=13 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.9.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 562949953421311 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.9.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 562949953421311 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.9.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=13 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13})

test:do_execsql_test(
    "boundary3-2.9.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=13 ORDER BY t1.rowid DESC"
    ,{13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.9.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=13 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.10.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=256 AND t2.a=t1.a"
    ,{61, "0000000000000100"})

test:do_execsql_test(
    "boundary3-2.10.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000100'"
    ,{256, 61})

test:do_execsql_test(
    "boundary3-2.10.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=61"
    ,{256, "0000000000000100"})

test:do_execsql_test(
    "boundary3-2.10.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 256 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.10.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 256 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.10.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=61 ORDER BY t1.rowid"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8})

test:do_execsql_test(
    "boundary3-2.10.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=61 ORDER BY x"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8})

test:do_execsql_test(
    "boundary3-2.10.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 256 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.10.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 256 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.10.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=61 ORDER BY t1.rowid"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61})

test:do_execsql_test(
    "boundary3-2.10.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=61 ORDER BY x"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.10.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61})

test:do_execsql_test(
    "boundary3-2.10.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 256 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.10.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 256 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.10.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=61 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30})

test:do_execsql_test(
    "boundary3-2.10.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.10.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=61 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.10.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30})

test:do_execsql_test(
    "boundary3-2.10.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.10.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 256 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.10.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 256 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.10.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=61 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61})

test:do_execsql_test(
    "boundary3-2.10.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.10.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=61 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.10.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61})

test:do_execsql_test(
    "boundary3-2.10.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=61 ORDER BY t1.rowid DESC"
    ,{61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.11.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=34359738368 AND t2.a=t1.a"
    ,{22, "0000000800000000"})

test:do_execsql_test(
    "boundary3-2.11.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000800000000'"
    ,{34359738368, 22})

test:do_execsql_test(
    "boundary3-2.11.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=22"
    ,{34359738368, "0000000800000000"})

test:do_execsql_test(
    "boundary3-2.11.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 34359738368 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 35, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.11.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 34359738368 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 35, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.11.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=22 ORDER BY t1.rowid"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46})

test:do_execsql_test(
    "boundary3-2.11.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=22 ORDER BY x"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46})

test:do_execsql_test(
    "boundary3-2.11.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 34359738368 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.11.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 34359738368 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.11.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=22 ORDER BY t1.rowid"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22})

test:do_execsql_test(
    "boundary3-2.11.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=22 ORDER BY x"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.11.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22})

test:do_execsql_test(
    "boundary3-2.11.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 34359738368 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.11.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 34359738368 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.11.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=22 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39})

test:do_execsql_test(
    "boundary3-2.11.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.11.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=22 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.11.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39})

test:do_execsql_test(
    "boundary3-2.11.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.11.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 34359738368 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.11.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 34359738368 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.11.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=22 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22})

test:do_execsql_test(
    "boundary3-2.11.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.11.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=22 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.11.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22})

test:do_execsql_test(
    "boundary3-2.11.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=22 ORDER BY t1.rowid DESC"
    ,{22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.12.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=65536 AND t2.a=t1.a"
    ,{62, "0000000000010000"})

test:do_execsql_test(
    "boundary3-2.12.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000010000'"
    ,{65536, 62})

test:do_execsql_test(
    "boundary3-2.12.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=62"
    ,{65536, "0000000000010000"})

test:do_execsql_test(
    "boundary3-2.12.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 65536 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.12.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 65536 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.12.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=62 ORDER BY t1.rowid"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15})

test:do_execsql_test(
    "boundary3-2.12.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=62 ORDER BY x"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15})

test:do_execsql_test(
    "boundary3-2.12.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 65536 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.12.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 65536 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.12.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=62 ORDER BY t1.rowid"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62})

test:do_execsql_test(
    "boundary3-2.12.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=62 ORDER BY x"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.12.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62})

test:do_execsql_test(
    "boundary3-2.12.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 65536 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.12.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 65536 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.12.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=62 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48})

test:do_execsql_test(
    "boundary3-2.12.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.12.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=62 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.12.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48})

test:do_execsql_test(
    "boundary3-2.12.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.12.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 65536 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.12.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 65536 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.12.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=62 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62})

test:do_execsql_test(
    "boundary3-2.12.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.12.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=62 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.12.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62})

test:do_execsql_test(
    "boundary3-2.12.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=62 ORDER BY t1.rowid DESC"
    ,{62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.13.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=268435456 AND t2.a=t1.a"
    ,{40, "0000000010000000"})

test:do_execsql_test(
    "boundary3-2.13.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000010000000'"
    ,{268435456, 40})

test:do_execsql_test(
    "boundary3-2.13.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=40"
    ,{268435456, "0000000010000000"})

test:do_execsql_test(
    "boundary3-2.13.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 268435456 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.13.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 268435456 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.13.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=40 ORDER BY t1.rowid"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20})

test:do_execsql_test(
    "boundary3-2.13.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=40 ORDER BY x"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20})

test:do_execsql_test(
    "boundary3-2.13.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 268435456 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.13.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 268435456 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.13.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=40 ORDER BY t1.rowid"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40})

test:do_execsql_test(
    "boundary3-2.13.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=40 ORDER BY x"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.13.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40})

test:do_execsql_test(
    "boundary3-2.13.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 268435456 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.13.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 268435456 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.13.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=40 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12})

test:do_execsql_test(
    "boundary3-2.13.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.13.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=40 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.13.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12})

test:do_execsql_test(
    "boundary3-2.13.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.13.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 268435456 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.13.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 268435456 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.13.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=40 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40})

test:do_execsql_test(
    "boundary3-2.13.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.13.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=40 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.13.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40})

test:do_execsql_test(
    "boundary3-2.13.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=40 ORDER BY t1.rowid DESC"
    ,{40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.14.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-140737488355328 AND t2.a=t1.a"
    ,{44, "ffff800000000000"})

test:do_execsql_test(
    "boundary3-2.14.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffff800000000000'"
    ,{-140737488355328LL, 44})

test:do_execsql_test(
    "boundary3-2.14.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=44"
    ,{-140737488355328LL, "ffff800000000000"})

test:do_execsql_test(
    "boundary3-2.14.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -140737488355328 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.14.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -140737488355328 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.14.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=44 ORDER BY t1.rowid"
    ,{58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.14.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=44 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58})

test:do_execsql_test(
    "boundary3-2.14.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=44 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.14.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -140737488355328 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.14.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -140737488355328 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.14.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=44 ORDER BY t1.rowid"
    ,{44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.14.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=44 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44})

test:do_execsql_test(
    "boundary3-2.14.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=44 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.14.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -140737488355328 ORDER BY t2.a"
    ,{2, 21, 55, 64})

test:do_execsql_test(
    "boundary3-2.14.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -140737488355328 ORDER BY t1.a DESC"
    ,{64, 55, 21, 2})

test:do_execsql_test(
    "boundary3-2.14.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=44 ORDER BY t1.rowid"
    ,{55, 2, 64, 21})

test:do_execsql_test(
    "boundary3-2.14.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=44 ORDER BY t1.rowid DESC"
    ,{21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.14.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=44 ORDER BY x"
    ,{55, 2, 64, 21})

test:do_execsql_test(
    "boundary3-2.14.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -140737488355328 ORDER BY t2.a"
    ,{2, 21, 44, 55, 64})

test:do_execsql_test(
    "boundary3-2.14.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -140737488355328 ORDER BY t1.a DESC"
    ,{64, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.14.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=44 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44})

test:do_execsql_test(
    "boundary3-2.14.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=44 ORDER BY t1.rowid DESC"
    ,{44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.14.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=44 ORDER BY x"
    ,{55, 2, 64, 21, 44})

test:do_execsql_test(
    "boundary3-2.15.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=1099511627776 AND t2.a=t1.a"
    ,{19, "0000010000000000"})

test:do_execsql_test(
    "boundary3-2.15.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000010000000000'"
    ,{1099511627776, 19})

test:do_execsql_test(
    "boundary3-2.15.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=19"
    ,{1099511627776, "0000010000000000"})

test:do_execsql_test(
    "boundary3-2.15.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 1099511627776 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.15.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 1099511627776 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.15.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=19 ORDER BY t1.rowid"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7})

test:do_execsql_test(
    "boundary3-2.15.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=19 ORDER BY x"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7})

test:do_execsql_test(
    "boundary3-2.15.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 1099511627776 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.15.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 1099511627776 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.15.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=19 ORDER BY t1.rowid"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19})

test:do_execsql_test(
    "boundary3-2.15.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=19 ORDER BY x"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.15.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19})

test:do_execsql_test(
    "boundary3-2.15.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 1099511627776 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.15.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 1099511627776 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.15.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=19 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57})

test:do_execsql_test(
    "boundary3-2.15.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.15.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=19 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.15.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57})

test:do_execsql_test(
    "boundary3-2.15.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.15.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 1099511627776 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.15.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 1099511627776 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.15.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=19 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19})

test:do_execsql_test(
    "boundary3-2.15.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.15.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=19 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.15.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19})

test:do_execsql_test(
    "boundary3-2.15.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=19 ORDER BY t1.rowid DESC"
    ,{19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.16.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 9223372036854775807 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 9223372036854775807 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=3 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=3 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=3 ORDER BY x"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 9223372036854775807 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 9223372036854775807 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.16.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=3 ORDER BY t1.rowid"
    ,{3})

test:do_execsql_test(
    "boundary3-2.16.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=3 ORDER BY t1.rowid DESC"
    ,{3})

test:do_execsql_test(
    "boundary3-2.16.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=3 ORDER BY x"
    ,{3})

test:do_execsql_test(
    "boundary3-2.16.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 9223372036854775807 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.16.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 9223372036854775807 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.16.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=3 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28})

test:do_execsql_test(
    "boundary3-2.16.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=3 ORDER BY t1.rowid DESC"
    ,{28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.16.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=3 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.16.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 9223372036854775807 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.16.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 9223372036854775807 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.16.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=3 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.16.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=3 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.16.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=3 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.17.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=32768 AND t2.a=t1.a"
    ,{50, "0000000000008000"})

test:do_execsql_test(
    "boundary3-2.17.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000008000'"
    ,{32768, 50})

test:do_execsql_test(
    "boundary3-2.17.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=50"
    ,{32768, "0000000000008000"})

test:do_execsql_test(
    "boundary3-2.17.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 32768 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.17.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 32768 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.17.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=50 ORDER BY t1.rowid"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48})

test:do_execsql_test(
    "boundary3-2.17.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=50 ORDER BY x"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48})

test:do_execsql_test(
    "boundary3-2.17.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 32768 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.17.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 32768 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.17.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=50 ORDER BY t1.rowid"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50})

test:do_execsql_test(
    "boundary3-2.17.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=50 ORDER BY x"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.17.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50})

test:do_execsql_test(
    "boundary3-2.17.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 32768 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.17.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 32768 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.17.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=50 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23})

test:do_execsql_test(
    "boundary3-2.17.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.17.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=50 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.17.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23})

test:do_execsql_test(
    "boundary3-2.17.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.17.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 32768 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.17.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 32768 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.17.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=50 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50})

test:do_execsql_test(
    "boundary3-2.17.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.17.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=50 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.17.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50})

test:do_execsql_test(
    "boundary3-2.17.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=50 ORDER BY t1.rowid DESC"
    ,{50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.18.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-36028797018963968 AND t2.a=t1.a"
    ,{64, "ff80000000000000"})

test:do_execsql_test(
    "boundary3-2.18.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ff80000000000000'"
    ,{-36028797018963968LL, 64})

test:do_execsql_test(
    "boundary3-2.18.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=64"
    ,{-36028797018963968LL, "ff80000000000000"})

test:do_execsql_test(
    "boundary3-2.18.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -36028797018963968 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.18.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -36028797018963968 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.18.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=64 ORDER BY t1.rowid"
    ,{21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.18.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=64 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21})

test:do_execsql_test(
    "boundary3-2.18.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=64 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.18.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -36028797018963968 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.18.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -36028797018963968 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.18.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=64 ORDER BY t1.rowid"
    ,{64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.18.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=64 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64})

test:do_execsql_test(
    "boundary3-2.18.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=64 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.18.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -36028797018963968 ORDER BY t2.a"
    ,{2, 55})

test:do_execsql_test(
    "boundary3-2.18.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -36028797018963968 ORDER BY t1.a DESC"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.18.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=64 ORDER BY t1.rowid"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.18.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=64 ORDER BY t1.rowid DESC"
    ,{2, 55})

test:do_execsql_test(
    "boundary3-2.18.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=64 ORDER BY x"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.18.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -36028797018963968 ORDER BY t2.a"
    ,{2, 55, 64})

test:do_execsql_test(
    "boundary3-2.18.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -36028797018963968 ORDER BY t1.a DESC"
    ,{64, 55, 2})

test:do_execsql_test(
    "boundary3-2.18.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=64 ORDER BY t1.rowid"
    ,{55, 2, 64})

test:do_execsql_test(
    "boundary3-2.18.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=64 ORDER BY t1.rowid DESC"
    ,{64, 2, 55})

test:do_execsql_test(
    "boundary3-2.18.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=64 ORDER BY x"
    ,{55, 2, 64})

test:do_execsql_test(
    "boundary3-2.19.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=65535 AND t2.a=t1.a"
    ,{48, "000000000000ffff"})

test:do_execsql_test(
    "boundary3-2.19.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000000000000ffff'"
    ,{65535, 48})

test:do_execsql_test(
    "boundary3-2.19.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=48"
    ,{65535, "000000000000ffff"})

test:do_execsql_test(
    "boundary3-2.19.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 65535 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.19.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 65535 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.19.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=48 ORDER BY t1.rowid"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62})

test:do_execsql_test(
    "boundary3-2.19.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=48 ORDER BY x"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid"
    ,{62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62})

test:do_execsql_test(
    "boundary3-2.19.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 65535 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.19.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 65535 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.19.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=48 ORDER BY t1.rowid"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48})

test:do_execsql_test(
    "boundary3-2.19.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=48 ORDER BY x"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid"
    ,{48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.19.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48})

test:do_execsql_test(
    "boundary3-2.19.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 65535 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.19.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 65535 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.19.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=48 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50})

test:do_execsql_test(
    "boundary3-2.19.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.19.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=48 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.19.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50})

test:do_execsql_test(
    "boundary3-2.19.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.19.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 65535 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.19.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 65535 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.19.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=48 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48})

test:do_execsql_test(
    "boundary3-2.19.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.19.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=48 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.19.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48})

test:do_execsql_test(
    "boundary3-2.19.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=48 ORDER BY t1.rowid DESC"
    ,{48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.20.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=4294967295 AND t2.a=t1.a"
    ,{14, "00000000ffffffff"})

test:do_execsql_test(
    "boundary3-2.20.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00000000ffffffff'"
    ,{4294967295, 14})

test:do_execsql_test(
    "boundary3-2.20.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=14"
    ,{4294967295, "00000000ffffffff"})

test:do_execsql_test(
    "boundary3-2.20.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 4294967295 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.20.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 4294967295 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.20.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=14 ORDER BY t1.rowid"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36})

test:do_execsql_test(
    "boundary3-2.20.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=14 ORDER BY x"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid"
    ,{36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36})

test:do_execsql_test(
    "boundary3-2.20.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 4294967295 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.20.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 4294967295 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.20.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=14 ORDER BY t1.rowid"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14})

test:do_execsql_test(
    "boundary3-2.20.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=14 ORDER BY x"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.20.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14})

test:do_execsql_test(
    "boundary3-2.20.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 4294967295 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.20.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 4294967295 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.20.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=14 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51})

test:do_execsql_test(
    "boundary3-2.20.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.20.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=14 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.20.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51})

test:do_execsql_test(
    "boundary3-2.20.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.20.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 4294967295 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.20.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 4294967295 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.20.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=14 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14})

test:do_execsql_test(
    "boundary3-2.20.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.20.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=14 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.20.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14})

test:do_execsql_test(
    "boundary3-2.20.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=14 ORDER BY t1.rowid DESC"
    ,{14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.21.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=1099511627775 AND t2.a=t1.a"
    ,{57, "000000ffffffffff"})

test:do_execsql_test(
    "boundary3-2.21.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000000ffffffffff'"
    ,{1099511627775, 57})

test:do_execsql_test(
    "boundary3-2.21.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=57"
    ,{1099511627775, "000000ffffffffff"})

test:do_execsql_test(
    "boundary3-2.21.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 1099511627775 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.21.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 1099511627775 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.21.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=57 ORDER BY t1.rowid"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19})

test:do_execsql_test(
    "boundary3-2.21.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=57 ORDER BY x"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid"
    ,{19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19})

test:do_execsql_test(
    "boundary3-2.21.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 1099511627775 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 43, 45, 56, 57})

test:do_execsql_test(
    "boundary3-2.21.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 1099511627775 ORDER BY t1.a DESC"
    ,{57, 56, 45, 43, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.21.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=57 ORDER BY t1.rowid"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57})

test:do_execsql_test(
    "boundary3-2.21.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=57 ORDER BY x"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.21.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57})

test:do_execsql_test(
    "boundary3-2.21.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 1099511627775 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.21.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 1099511627775 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.21.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=57 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35})

test:do_execsql_test(
    "boundary3-2.21.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.21.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=57 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.21.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35})

test:do_execsql_test(
    "boundary3-2.21.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.21.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 1099511627775 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.21.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 1099511627775 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.21.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=57 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57})

test:do_execsql_test(
    "boundary3-2.21.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.21.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=57 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.21.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57})

test:do_execsql_test(
    "boundary3-2.21.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=57 ORDER BY t1.rowid DESC"
    ,{57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.22.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-8388608 AND t2.a=t1.a"
    ,{37, "ffffffffff800000"})

test:do_execsql_test(
    "boundary3-2.22.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffff800000'"
    ,{-8388608, 37})

test:do_execsql_test(
    "boundary3-2.22.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=37"
    ,{-8388608, "ffffffffff800000"})

test:do_execsql_test(
    "boundary3-2.22.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -8388608 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.22.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -8388608 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.22.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=37 ORDER BY t1.rowid"
    ,{29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.22.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29})

test:do_execsql_test(
    "boundary3-2.22.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=37 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.22.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid"
    ,{29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.22.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29})

test:do_execsql_test(
    "boundary3-2.22.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -8388608 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.22.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -8388608 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.22.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=37 ORDER BY t1.rowid"
    ,{37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.22.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37})

test:do_execsql_test(
    "boundary3-2.22.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=37 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.22.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid"
    ,{37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.22.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37})

test:do_execsql_test(
    "boundary3-2.22.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -8388608 ORDER BY t2.a"
    ,{1, 2, 11, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.22.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -8388608 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.22.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=37 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.22.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.22.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=37 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.22.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.22.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.22.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -8388608 ORDER BY t2.a"
    ,{1, 2, 11, 21, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.22.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -8388608 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.22.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=37 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.22.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.22.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=37 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.22.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37})

test:do_execsql_test(
    "boundary3-2.22.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=37 ORDER BY t1.rowid DESC"
    ,{37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.23.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=549755813888 AND t2.a=t1.a"
    ,{35, "0000008000000000"})

test:do_execsql_test(
    "boundary3-2.23.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000008000000000'"
    ,{549755813888, 35})

test:do_execsql_test(
    "boundary3-2.23.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=35"
    ,{549755813888, "0000008000000000"})

test:do_execsql_test(
    "boundary3-2.23.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 549755813888 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 43, 45, 56, 57})

test:do_execsql_test(
    "boundary3-2.23.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 549755813888 ORDER BY t1.a DESC"
    ,{57, 56, 45, 43, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.23.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=35 ORDER BY t1.rowid"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57})

test:do_execsql_test(
    "boundary3-2.23.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=35 ORDER BY x"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid"
    ,{57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57})

test:do_execsql_test(
    "boundary3-2.23.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 549755813888 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 35, 43, 45, 56, 57})

test:do_execsql_test(
    "boundary3-2.23.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 549755813888 ORDER BY t1.a DESC"
    ,{57, 56, 45, 43, 35, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.23.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=35 ORDER BY t1.rowid"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35})

test:do_execsql_test(
    "boundary3-2.23.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=35 ORDER BY x"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.23.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35})

test:do_execsql_test(
    "boundary3-2.23.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 549755813888 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.23.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 549755813888 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.23.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=35 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46})

test:do_execsql_test(
    "boundary3-2.23.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.23.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=35 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.23.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46})

test:do_execsql_test(
    "boundary3-2.23.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.23.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 549755813888 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.23.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 549755813888 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.23.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=35 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35})

test:do_execsql_test(
    "boundary3-2.23.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.23.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=35 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.23.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35})

test:do_execsql_test(
    "boundary3-2.23.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=35 ORDER BY t1.rowid DESC"
    ,{35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.24.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=8388607 AND t2.a=t1.a"
    ,{18, "00000000007fffff"})

test:do_execsql_test(
    "boundary3-2.24.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00000000007fffff'"
    ,{8388607, 18})

test:do_execsql_test(
    "boundary3-2.24.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=18"
    ,{8388607, "00000000007fffff"})

test:do_execsql_test(
    "boundary3-2.24.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 8388607 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.24.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 8388607 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.24.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=18 ORDER BY t1.rowid"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24})

test:do_execsql_test(
    "boundary3-2.24.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=18 ORDER BY x"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24})

test:do_execsql_test(
    "boundary3-2.24.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 8388607 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.24.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 8388607 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.24.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=18 ORDER BY t1.rowid"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18})

test:do_execsql_test(
    "boundary3-2.24.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=18 ORDER BY x"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.24.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18})

test:do_execsql_test(
    "boundary3-2.24.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 8388607 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.24.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 8388607 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.24.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=18 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42})

test:do_execsql_test(
    "boundary3-2.24.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.24.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=18 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.24.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42})

test:do_execsql_test(
    "boundary3-2.24.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.24.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 8388607 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 18, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.24.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 8388607 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 18, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.24.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=18 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18})

test:do_execsql_test(
    "boundary3-2.24.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.24.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=18 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.24.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18})

test:do_execsql_test(
    "boundary3-2.24.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=18 ORDER BY t1.rowid DESC"
    ,{18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.25.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-3 AND t2.a=t1.a"
    ,{52, "fffffffffffffffd"})

test:do_execsql_test(
    "boundary3-2.25.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='fffffffffffffffd'"
    ,{-3, 52})

test:do_execsql_test(
    "boundary3-2.25.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=52"
    ,{-3, "fffffffffffffffd"})

test:do_execsql_test(
    "boundary3-2.25.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -3 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.25.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -3 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.25.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=52 ORDER BY t1.rowid"
    ,{33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.25.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33})

test:do_execsql_test(
    "boundary3-2.25.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=52 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 33, 38})

test:do_execsql_test(
    "boundary3-2.25.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid"
    ,{33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.25.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33})

test:do_execsql_test(
    "boundary3-2.25.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -3 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.25.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -3 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.25.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=52 ORDER BY t1.rowid"
    ,{52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.25.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52})

test:do_execsql_test(
    "boundary3-2.25.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=52 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.25.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid"
    ,{52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.25.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52})

test:do_execsql_test(
    "boundary3-2.25.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -3 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.25.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -3 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.25.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=52 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.25.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.25.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=52 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.25.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.25.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.25.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -3 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.25.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -3 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.25.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=52 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.25.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.25.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=52 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.25.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.25.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=52 ORDER BY t1.rowid DESC"
    ,{52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.26.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=0 AND t2.a=t1.a"
    ,{59, "0000000000000000"})

test:do_execsql_test(
    "boundary3-2.26.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000000'"
    ,{0, 59})

test:do_execsql_test(
    "boundary3-2.26.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=59"
    ,{0, "0000000000000000"})

test:do_execsql_test(
    "boundary3-2.26.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 0 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.26.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 0 ORDER BY t1.a DESC"
    ,{62, 61, 60, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.26.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=59 ORDER BY t1.rowid"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60})

test:do_execsql_test(
    "boundary3-2.26.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=59 ORDER BY x"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60})

test:do_execsql_test(
    "boundary3-2.26.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 0 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.26.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 0 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.26.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=59 ORDER BY t1.rowid"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59})

test:do_execsql_test(
    "boundary3-2.26.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=59 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.26.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59})

test:do_execsql_test(
    "boundary3-2.26.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 0 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.26.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 0 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.26.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=59 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.26.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.26.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=59 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.26.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.26.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.26.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 0 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 59, 63, 64})

test:do_execsql_test(
    "boundary3-2.26.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 0 ORDER BY t1.a DESC"
    ,{64, 63, 59, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.26.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=59 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59})

test:do_execsql_test(
    "boundary3-2.26.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.26.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=59 ORDER BY x"
    ,{59, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.26.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59})

test:do_execsql_test(
    "boundary3-2.26.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=59 ORDER BY t1.rowid DESC"
    ,{59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.27.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-1 AND t2.a=t1.a"
    ,{38, "ffffffffffffffff"})

test:do_execsql_test(
    "boundary3-2.27.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffffffffff'"
    ,{-1, 38})

test:do_execsql_test(
    "boundary3-2.27.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=38"
    ,{-1, "ffffffffffffffff"})

test:do_execsql_test(
    "boundary3-2.27.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -1 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.27.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -1 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.27.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=38 ORDER BY t1.rowid"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.27.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59})

test:do_execsql_test(
    "boundary3-2.27.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=38 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.27.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.27.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59})

test:do_execsql_test(
    "boundary3-2.27.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -1 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.27.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -1 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.27.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=38 ORDER BY t1.rowid"
    ,{38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.27.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38})

test:do_execsql_test(
    "boundary3-2.27.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=38 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 38})

test:do_execsql_test(
    "boundary3-2.27.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid"
    ,{38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.27.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38})

test:do_execsql_test(
    "boundary3-2.27.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -1 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.27.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -1 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.27.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=38 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.27.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.27.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=38 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.27.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.27.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.27.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -1 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.27.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -1 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.27.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=38 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.27.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.27.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=38 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.27.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.27.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=38 ORDER BY t1.rowid DESC"
    ,{38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.28.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-2 AND t2.a=t1.a"
    ,{33, "fffffffffffffffe"})

test:do_execsql_test(
    "boundary3-2.28.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='fffffffffffffffe'"
    ,{-2, 33})

test:do_execsql_test(
    "boundary3-2.28.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=33"
    ,{-2, "fffffffffffffffe"})

test:do_execsql_test(
    "boundary3-2.28.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -2 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.28.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -2 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.28.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=33 ORDER BY t1.rowid"
    ,{38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.28.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38})

test:do_execsql_test(
    "boundary3-2.28.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=33 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 38})

test:do_execsql_test(
    "boundary3-2.28.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid"
    ,{38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.28.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38})

test:do_execsql_test(
    "boundary3-2.28.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -2 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.28.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -2 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.28.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=33 ORDER BY t1.rowid"
    ,{33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.28.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33})

test:do_execsql_test(
    "boundary3-2.28.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=33 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 33, 38})

test:do_execsql_test(
    "boundary3-2.28.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid"
    ,{33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.28.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33})

test:do_execsql_test(
    "boundary3-2.28.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -2 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.28.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -2 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.28.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=33 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.28.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.28.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=33 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.28.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52})

test:do_execsql_test(
    "boundary3-2.28.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.28.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -2 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 44, 47, 52, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.28.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -2 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 52, 47, 44, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.28.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=33 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.28.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.28.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=33 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.28.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33})

test:do_execsql_test(
    "boundary3-2.28.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=33 ORDER BY t1.rowid DESC"
    ,{33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.29.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=2097152 AND t2.a=t1.a"
    ,{42, "0000000000200000"})

test:do_execsql_test(
    "boundary3-2.29.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000200000'"
    ,{2097152, 42})

test:do_execsql_test(
    "boundary3-2.29.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=42"
    ,{2097152, "0000000000200000"})

test:do_execsql_test(
    "boundary3-2.29.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 2097152 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.29.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 2097152 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.29.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=42 ORDER BY t1.rowid"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18})

test:do_execsql_test(
    "boundary3-2.29.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=42 ORDER BY x"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid"
    ,{18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18})

test:do_execsql_test(
    "boundary3-2.29.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 2097152 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.29.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 2097152 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.29.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=42 ORDER BY t1.rowid"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42})

test:do_execsql_test(
    "boundary3-2.29.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=42 ORDER BY x"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.29.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42})

test:do_execsql_test(
    "boundary3-2.29.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 2097152 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.29.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 2097152 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.29.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=42 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15})

test:do_execsql_test(
    "boundary3-2.29.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.29.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=42 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.29.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15})

test:do_execsql_test(
    "boundary3-2.29.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.29.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 2097152 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.29.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 2097152 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.29.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=42 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42})

test:do_execsql_test(
    "boundary3-2.29.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.29.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=42 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.29.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42})

test:do_execsql_test(
    "boundary3-2.29.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=42 ORDER BY t1.rowid DESC"
    ,{42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.30.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=128 AND t2.a=t1.a"
    ,{49, "0000000000000080"})

test:do_execsql_test(
    "boundary3-2.30.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000080'"
    ,{128, 49})

test:do_execsql_test(
    "boundary3-2.30.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=49"
    ,{128, "0000000000000080"})

test:do_execsql_test(
    "boundary3-2.30.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 128 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.30.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 128 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.30.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=49 ORDER BY t1.rowid"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30})

test:do_execsql_test(
    "boundary3-2.30.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=49 ORDER BY x"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30})

test:do_execsql_test(
    "boundary3-2.30.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 128 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.30.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 128 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.30.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=49 ORDER BY t1.rowid"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49})

test:do_execsql_test(
    "boundary3-2.30.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=49 ORDER BY x"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.30.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49})

test:do_execsql_test(
    "boundary3-2.30.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 128 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.30.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 128 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.30.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=49 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4})

test:do_execsql_test(
    "boundary3-2.30.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.30.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=49 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.30.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4})

test:do_execsql_test(
    "boundary3-2.30.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.30.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 128 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.30.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 128 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.30.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=49 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49})

test:do_execsql_test(
    "boundary3-2.30.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.30.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=49 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.30.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49})

test:do_execsql_test(
    "boundary3-2.30.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=49 ORDER BY t1.rowid DESC"
    ,{49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.31.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=255 AND t2.a=t1.a"
    ,{30, "00000000000000ff"})

test:do_execsql_test(
    "boundary3-2.31.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00000000000000ff'"
    ,{255, 30})

test:do_execsql_test(
    "boundary3-2.31.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=30"
    ,{255, "00000000000000ff"})

test:do_execsql_test(
    "boundary3-2.31.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 255 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.31.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 255 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.31.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=30 ORDER BY t1.rowid"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61})

test:do_execsql_test(
    "boundary3-2.31.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=30 ORDER BY x"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid"
    ,{61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61})

test:do_execsql_test(
    "boundary3-2.31.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 255 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.31.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 255 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.31.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=30 ORDER BY t1.rowid"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30})

test:do_execsql_test(
    "boundary3-2.31.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=30 ORDER BY x"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid"
    ,{30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.31.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30})

test:do_execsql_test(
    "boundary3-2.31.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 255 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.31.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 255 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.31.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=30 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49})

test:do_execsql_test(
    "boundary3-2.31.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.31.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=30 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.31.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49})

test:do_execsql_test(
    "boundary3-2.31.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.31.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 255 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.31.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 255 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.31.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=30 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30})

test:do_execsql_test(
    "boundary3-2.31.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.31.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=30 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.31.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30})

test:do_execsql_test(
    "boundary3-2.31.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=30 ORDER BY t1.rowid DESC"
    ,{30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.32.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-2147483648 AND t2.a=t1.a"
    ,{11, "ffffffff80000000"})

test:do_execsql_test(
    "boundary3-2.32.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffff80000000'"
    ,{-2147483648, 11})

test:do_execsql_test(
    "boundary3-2.32.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=11"
    ,{-2147483648, "ffffffff80000000"})

test:do_execsql_test(
    "boundary3-2.32.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -2147483648 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.32.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -2147483648 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.32.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=11 ORDER BY t1.rowid"
    ,{1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.32.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1})

test:do_execsql_test(
    "boundary3-2.32.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=11 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.32.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid"
    ,{1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.32.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1})

test:do_execsql_test(
    "boundary3-2.32.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -2147483648 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.32.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -2147483648 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.32.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=11 ORDER BY t1.rowid"
    ,{11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.32.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11})

test:do_execsql_test(
    "boundary3-2.32.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=11 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.32.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid"
    ,{11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.32.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11})

test:do_execsql_test(
    "boundary3-2.32.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -2147483648 ORDER BY t2.a"
    ,{2, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.32.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -2147483648 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.32.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=11 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.32.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.32.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=11 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.32.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.32.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.32.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -2147483648 ORDER BY t2.a"
    ,{2, 11, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.32.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -2147483648 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 11, 2})

test:do_execsql_test(
    "boundary3-2.32.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=11 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.32.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.32.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=11 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.32.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.32.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=11 ORDER BY t1.rowid DESC"
    ,{11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.33.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=34359738367 AND t2.a=t1.a"
    ,{39, "00000007ffffffff"})

test:do_execsql_test(
    "boundary3-2.33.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00000007ffffffff'"
    ,{34359738367, 39})

test:do_execsql_test(
    "boundary3-2.33.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=39"
    ,{34359738367, "00000007ffffffff"})

test:do_execsql_test(
    "boundary3-2.33.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 34359738367 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.33.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 34359738367 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.33.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=39 ORDER BY t1.rowid"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22})

test:do_execsql_test(
    "boundary3-2.33.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=39 ORDER BY x"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid"
    ,{22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22})

test:do_execsql_test(
    "boundary3-2.33.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 34359738367 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 22, 25, 26, 27, 28, 34, 35, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.33.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 34359738367 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 35, 34, 28, 27, 26, 25, 22, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.33.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=39 ORDER BY t1.rowid"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39})

test:do_execsql_test(
    "boundary3-2.33.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=39 ORDER BY x"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid"
    ,{39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.33.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39})

test:do_execsql_test(
    "boundary3-2.33.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 34359738367 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.33.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 34359738367 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.33.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=39 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36})

test:do_execsql_test(
    "boundary3-2.33.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.33.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=39 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.33.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36})

test:do_execsql_test(
    "boundary3-2.33.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.33.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 34359738367 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.33.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 34359738367 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.33.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=39 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39})

test:do_execsql_test(
    "boundary3-2.33.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.33.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=39 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.33.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39})

test:do_execsql_test(
    "boundary3-2.33.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=39 ORDER BY t1.rowid DESC"
    ,{39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.34.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-549755813889 AND t2.a=t1.a"
    ,{58, "ffffff7fffffffff"})

test:do_execsql_test(
    "boundary3-2.34.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffff7fffffffff'"
    ,{-549755813889, 58})

test:do_execsql_test(
    "boundary3-2.34.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=58"
    ,{-549755813889, "ffffff7fffffffff"})

test:do_execsql_test(
    "boundary3-2.34.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -549755813889 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.34.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -549755813889 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.34.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=58 ORDER BY t1.rowid"
    ,{63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.34.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63})

test:do_execsql_test(
    "boundary3-2.34.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=58 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.34.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid"
    ,{63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.34.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63})

test:do_execsql_test(
    "boundary3-2.34.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -549755813889 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.34.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -549755813889 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.34.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=58 ORDER BY t1.rowid"
    ,{58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.34.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58})

test:do_execsql_test(
    "boundary3-2.34.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=58 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.34.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid"
    ,{58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.34.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58})

test:do_execsql_test(
    "boundary3-2.34.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -549755813889 ORDER BY t2.a"
    ,{2, 21, 44, 55, 64})

test:do_execsql_test(
    "boundary3-2.34.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -549755813889 ORDER BY t1.a DESC"
    ,{64, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.34.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=58 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44})

test:do_execsql_test(
    "boundary3-2.34.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.34.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=58 ORDER BY x"
    ,{55, 2, 64, 21, 44})

test:do_execsql_test(
    "boundary3-2.34.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44})

test:do_execsql_test(
    "boundary3-2.34.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.34.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -549755813889 ORDER BY t2.a"
    ,{2, 21, 44, 55, 58, 64})

test:do_execsql_test(
    "boundary3-2.34.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -549755813889 ORDER BY t1.a DESC"
    ,{64, 58, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.34.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=58 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.34.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.34.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=58 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.34.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.34.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=58 ORDER BY t1.rowid DESC"
    ,{58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.35.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-32768 AND t2.a=t1.a"
    ,{32, "ffffffffffff8000"})

test:do_execsql_test(
    "boundary3-2.35.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffffff8000'"
    ,{-32768, 32})

test:do_execsql_test(
    "boundary3-2.35.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=32"
    ,{-32768, "ffffffffffff8000"})

test:do_execsql_test(
    "boundary3-2.35.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -32768 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.35.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -32768 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.35.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=32 ORDER BY t1.rowid"
    ,{54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.35.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54})

test:do_execsql_test(
    "boundary3-2.35.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=32 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.35.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid"
    ,{54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.35.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54})

test:do_execsql_test(
    "boundary3-2.35.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -32768 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.35.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -32768 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 32, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.35.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=32 ORDER BY t1.rowid"
    ,{32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.35.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32})

test:do_execsql_test(
    "boundary3-2.35.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=32 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.35.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid"
    ,{32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.35.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32})

test:do_execsql_test(
    "boundary3-2.35.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -32768 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.35.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -32768 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.35.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=32 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.35.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.35.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=32 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.35.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29})

test:do_execsql_test(
    "boundary3-2.35.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.35.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -32768 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.35.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -32768 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.35.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=32 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.35.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.35.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=32 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.35.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.35.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=32 ORDER BY t1.rowid DESC"
    ,{32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.36.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=2147483647 AND t2.a=t1.a"
    ,{20, "000000007fffffff"})

test:do_execsql_test(
    "boundary3-2.36.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000000007fffffff'"
    ,{2147483647, 20})

test:do_execsql_test(
    "boundary3-2.36.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=20"
    ,{2147483647, "000000007fffffff"})

test:do_execsql_test(
    "boundary3-2.36.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 2147483647 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.36.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 2147483647 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.36.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=20 ORDER BY t1.rowid"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51})

test:do_execsql_test(
    "boundary3-2.36.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=20 ORDER BY x"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51})

test:do_execsql_test(
    "boundary3-2.36.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 2147483647 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.36.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 2147483647 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.36.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=20 ORDER BY t1.rowid"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20})

test:do_execsql_test(
    "boundary3-2.36.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=20 ORDER BY x"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid"
    ,{20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.36.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20})

test:do_execsql_test(
    "boundary3-2.36.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 2147483647 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.36.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 2147483647 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.36.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=20 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40})

test:do_execsql_test(
    "boundary3-2.36.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.36.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=20 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.36.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40})

test:do_execsql_test(
    "boundary3-2.36.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.36.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 2147483647 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.36.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 2147483647 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.36.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=20 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20})

test:do_execsql_test(
    "boundary3-2.36.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.36.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=20 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.36.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20})

test:do_execsql_test(
    "boundary3-2.36.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=20 ORDER BY t1.rowid DESC"
    ,{20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.37.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-129 AND t2.a=t1.a"
    ,{54, "ffffffffffffff7f"})

test:do_execsql_test(
    "boundary3-2.37.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffffffff7f'"
    ,{-129, 54})

test:do_execsql_test(
    "boundary3-2.37.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=54"
    ,{-129, "ffffffffffffff7f"})

test:do_execsql_test(
    "boundary3-2.37.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -129 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.37.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -129 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.37.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=54 ORDER BY t1.rowid"
    ,{53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.37.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53})

test:do_execsql_test(
    "boundary3-2.37.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=54 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.37.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid"
    ,{53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.37.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53})

test:do_execsql_test(
    "boundary3-2.37.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -129 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.37.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -129 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.37.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=54 ORDER BY t1.rowid"
    ,{54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.37.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54})

test:do_execsql_test(
    "boundary3-2.37.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=54 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.37.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid"
    ,{54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.37.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54})

test:do_execsql_test(
    "boundary3-2.37.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -129 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.37.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -129 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.37.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=54 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.37.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.37.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=54 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.37.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32})

test:do_execsql_test(
    "boundary3-2.37.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.37.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -129 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.37.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -129 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.37.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=54 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.37.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.37.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=54 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.37.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.37.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=54 ORDER BY t1.rowid DESC"
    ,{54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.38.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-128 AND t2.a=t1.a"
    ,{53, "ffffffffffffff80"})

test:do_execsql_test(
    "boundary3-2.38.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffffffff80'"
    ,{-128, 53})

test:do_execsql_test(
    "boundary3-2.38.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=53"
    ,{-128, "ffffffffffffff80"})

test:do_execsql_test(
    "boundary3-2.38.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -128 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.38.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -128 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.38.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=53 ORDER BY t1.rowid"
    ,{52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.38.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52})

test:do_execsql_test(
    "boundary3-2.38.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=53 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.38.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid"
    ,{52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.38.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52})

test:do_execsql_test(
    "boundary3-2.38.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -128 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.38.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -128 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 36, 35, 34, 33, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.38.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=53 ORDER BY t1.rowid"
    ,{53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.38.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53})

test:do_execsql_test(
    "boundary3-2.38.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=53 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.38.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid"
    ,{53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.38.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53})

test:do_execsql_test(
    "boundary3-2.38.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -128 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.38.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -128 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.38.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=53 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.38.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.38.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=53 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.38.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54})

test:do_execsql_test(
    "boundary3-2.38.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.38.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -128 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 37, 44, 47, 53, 54, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.38.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -128 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 54, 53, 47, 44, 37, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.38.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=53 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.38.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.38.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=53 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.38.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53})

test:do_execsql_test(
    "boundary3-2.38.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=53 ORDER BY t1.rowid DESC"
    ,{53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.39.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=72057594037927936 AND t2.a=t1.a"
    ,{28, "0100000000000000"})

test:do_execsql_test(
    "boundary3-2.39.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0100000000000000'"
    ,{72057594037927936LL, 28})

test:do_execsql_test(
    "boundary3-2.39.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=28"
    ,{72057594037927936LL, "0100000000000000"})

test:do_execsql_test(
    "boundary3-2.39.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 72057594037927936 ORDER BY t2.a"
    ,{3})

test:do_execsql_test(
    "boundary3-2.39.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 72057594037927936 ORDER BY t1.a DESC"
    ,{3})

test:do_execsql_test(
    "boundary3-2.39.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=28 ORDER BY t1.rowid"
    ,{3})

test:do_execsql_test(
    "boundary3-2.39.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=28 ORDER BY t1.rowid DESC"
    ,{3})

test:do_execsql_test(
    "boundary3-2.39.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=28 ORDER BY x"
    ,{3})

test:do_execsql_test(
    "boundary3-2.39.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 72057594037927936 ORDER BY t2.a"
    ,{3, 28})

test:do_execsql_test(
    "boundary3-2.39.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 72057594037927936 ORDER BY t1.a DESC"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.39.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=28 ORDER BY t1.rowid"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.39.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=28 ORDER BY t1.rowid DESC"
    ,{3, 28})

test:do_execsql_test(
    "boundary3-2.39.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=28 ORDER BY x"
    ,{28, 3})

test:do_execsql_test(
    "boundary3-2.39.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 72057594037927936 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.39.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 72057594037927936 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.39.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=28 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17})

test:do_execsql_test(
    "boundary3-2.39.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=28 ORDER BY t1.rowid DESC"
    ,{17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.39.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=28 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.39.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 72057594037927936 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.39.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 72057594037927936 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.39.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=28 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28})

test:do_execsql_test(
    "boundary3-2.39.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=28 ORDER BY t1.rowid DESC"
    ,{28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.39.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=28 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.40.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=2147483648 AND t2.a=t1.a"
    ,{51, "0000000080000000"})

test:do_execsql_test(
    "boundary3-2.40.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000080000000'"
    ,{2147483648, 51})

test:do_execsql_test(
    "boundary3-2.40.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=51"
    ,{2147483648, "0000000080000000"})

test:do_execsql_test(
    "boundary3-2.40.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 2147483648 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.40.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 2147483648 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.40.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=51 ORDER BY t1.rowid"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14})

test:do_execsql_test(
    "boundary3-2.40.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=51 ORDER BY x"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid"
    ,{14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14})

test:do_execsql_test(
    "boundary3-2.40.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 2147483648 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 22, 25, 26, 27, 28, 34, 35, 36, 39, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.40.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 2147483648 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 39, 36, 35, 34, 28, 27, 26, 25, 22, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.40.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=51 ORDER BY t1.rowid"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51})

test:do_execsql_test(
    "boundary3-2.40.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=51 ORDER BY x"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid"
    ,{51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.40.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51})

test:do_execsql_test(
    "boundary3-2.40.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 2147483648 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.40.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 2147483648 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.40.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=51 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20})

test:do_execsql_test(
    "boundary3-2.40.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.40.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=51 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.40.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20})

test:do_execsql_test(
    "boundary3-2.40.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.40.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 2147483648 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 20, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.40.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 2147483648 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 20, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.40.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=51 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51})

test:do_execsql_test(
    "boundary3-2.40.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.40.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=51 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.40.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51})

test:do_execsql_test(
    "boundary3-2.40.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=51 ORDER BY t1.rowid DESC"
    ,{51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.41.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=549755813887 AND t2.a=t1.a"
    ,{46, "0000007fffffffff"})

test:do_execsql_test(
    "boundary3-2.41.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000007fffffffff'"
    ,{549755813887, 46})

test:do_execsql_test(
    "boundary3-2.41.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=46"
    ,{549755813887, "0000007fffffffff"})

test:do_execsql_test(
    "boundary3-2.41.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 549755813887 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 35, 43, 45, 56, 57})

test:do_execsql_test(
    "boundary3-2.41.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 549755813887 ORDER BY t1.a DESC"
    ,{57, 56, 45, 43, 35, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.41.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=46 ORDER BY t1.rowid"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35})

test:do_execsql_test(
    "boundary3-2.41.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=46 ORDER BY x"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid"
    ,{35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35})

test:do_execsql_test(
    "boundary3-2.41.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 549755813887 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 19, 25, 26, 27, 28, 34, 35, 43, 45, 46, 56, 57})

test:do_execsql_test(
    "boundary3-2.41.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 549755813887 ORDER BY t1.a DESC"
    ,{57, 56, 46, 45, 43, 35, 34, 28, 27, 26, 25, 19, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.41.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=46 ORDER BY t1.rowid"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46})

test:do_execsql_test(
    "boundary3-2.41.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=46 ORDER BY x"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid"
    ,{46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.41.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46})

test:do_execsql_test(
    "boundary3-2.41.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 549755813887 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.41.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 549755813887 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.41.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=46 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22})

test:do_execsql_test(
    "boundary3-2.41.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.41.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=46 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.41.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22})

test:do_execsql_test(
    "boundary3-2.41.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.41.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 549755813887 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.41.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 549755813887 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.41.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=46 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46})

test:do_execsql_test(
    "boundary3-2.41.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.41.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=46 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.41.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46})

test:do_execsql_test(
    "boundary3-2.41.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=46 ORDER BY t1.rowid DESC"
    ,{46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.42.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-549755813888 AND t2.a=t1.a"
    ,{63, "ffffff8000000000"})

test:do_execsql_test(
    "boundary3-2.42.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffff8000000000'"
    ,{-549755813888, 63})

test:do_execsql_test(
    "boundary3-2.42.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=63"
    ,{-549755813888, "ffffff8000000000"})

test:do_execsql_test(
    "boundary3-2.42.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -549755813888 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.42.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -549755813888 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.42.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=63 ORDER BY t1.rowid"
    ,{47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.42.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47})

test:do_execsql_test(
    "boundary3-2.42.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=63 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.42.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid"
    ,{47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.42.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47})

test:do_execsql_test(
    "boundary3-2.42.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -549755813888 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62, 63})

test:do_execsql_test(
    "boundary3-2.42.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -549755813888 ORDER BY t1.a DESC"
    ,{63, 62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.42.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=63 ORDER BY t1.rowid"
    ,{63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.42.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63})

test:do_execsql_test(
    "boundary3-2.42.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=63 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.42.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid"
    ,{63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.42.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63})

test:do_execsql_test(
    "boundary3-2.42.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -549755813888 ORDER BY t2.a"
    ,{2, 21, 44, 55, 58, 64})

test:do_execsql_test(
    "boundary3-2.42.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -549755813888 ORDER BY t1.a DESC"
    ,{64, 58, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.42.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=63 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.42.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.42.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=63 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.42.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58})

test:do_execsql_test(
    "boundary3-2.42.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.42.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -549755813888 ORDER BY t2.a"
    ,{2, 21, 44, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.42.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -549755813888 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.42.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=63 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.42.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.42.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=63 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.42.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.42.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=63 ORDER BY t1.rowid DESC"
    ,{63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.43.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=281474976710655 AND t2.a=t1.a"
    ,{10, "0000ffffffffffff"})

test:do_execsql_test(
    "boundary3-2.43.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000ffffffffffff'"
    ,{281474976710655LL, 10})

test:do_execsql_test(
    "boundary3-2.43.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=10"
    ,{281474976710655LL, "0000ffffffffffff"})

test:do_execsql_test(
    "boundary3-2.43.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 281474976710655 ORDER BY t2.a"
    ,{3, 13, 17, 26, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.43.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 281474976710655 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 26, 17, 13, 3})

test:do_execsql_test(
    "boundary3-2.43.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=10 ORDER BY t1.rowid"
    ,{26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.43.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=10 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26})

test:do_execsql_test(
    "boundary3-2.43.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=10 ORDER BY x"
    ,{26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.43.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 281474976710655 ORDER BY t2.a"
    ,{3, 10, 13, 17, 26, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.43.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 281474976710655 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 26, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.43.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=10 ORDER BY t1.rowid"
    ,{10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.43.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=10 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10})

test:do_execsql_test(
    "boundary3-2.43.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=10 ORDER BY x"
    ,{10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.43.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 281474976710655 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.43.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 281474976710655 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.43.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=10 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34})

test:do_execsql_test(
    "boundary3-2.43.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=10 ORDER BY t1.rowid DESC"
    ,{34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.43.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=10 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.43.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 281474976710655 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.43.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 281474976710655 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.43.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=10 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10})

test:do_execsql_test(
    "boundary3-2.43.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=10 ORDER BY t1.rowid DESC"
    ,{10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.43.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=10 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.44.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=4398046511103 AND t2.a=t1.a"
    ,{7, "000003ffffffffff"})

test:do_execsql_test(
    "boundary3-2.44.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000003ffffffffff'"
    ,{4398046511103, 7})

test:do_execsql_test(
    "boundary3-2.44.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=7"
    ,{4398046511103, "000003ffffffffff"})

test:do_execsql_test(
    "boundary3-2.44.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 4398046511103 ORDER BY t2.a"
    ,{3, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.44.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 4398046511103 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.44.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=7 ORDER BY t1.rowid"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56})

test:do_execsql_test(
    "boundary3-2.44.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=7 ORDER BY x"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56})

test:do_execsql_test(
    "boundary3-2.44.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 4398046511103 ORDER BY t2.a"
    ,{3, 7, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.44.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 4398046511103 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.44.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=7 ORDER BY t1.rowid"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7})

test:do_execsql_test(
    "boundary3-2.44.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=7 ORDER BY x"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid"
    ,{7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.44.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7})

test:do_execsql_test(
    "boundary3-2.44.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 4398046511103 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.44.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 4398046511103 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.44.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=7 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19})

test:do_execsql_test(
    "boundary3-2.44.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.44.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=7 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.44.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19})

test:do_execsql_test(
    "boundary3-2.44.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.44.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 4398046511103 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.44.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 4398046511103 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.44.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=7 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7})

test:do_execsql_test(
    "boundary3-2.44.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.44.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=7 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.44.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7})

test:do_execsql_test(
    "boundary3-2.44.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=7 ORDER BY t1.rowid DESC"
    ,{7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.45.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=268435455 AND t2.a=t1.a"
    ,{12, "000000000fffffff"})

test:do_execsql_test(
    "boundary3-2.45.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000000000fffffff'"
    ,{268435455, 12})

test:do_execsql_test(
    "boundary3-2.45.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=12"
    ,{268435455, "000000000fffffff"})

test:do_execsql_test(
    "boundary3-2.45.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 268435455 ORDER BY t2.a"
    ,{3, 7, 10, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.45.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 268435455 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.45.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=12 ORDER BY t1.rowid"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40})

test:do_execsql_test(
    "boundary3-2.45.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=12 ORDER BY x"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid"
    ,{40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40})

test:do_execsql_test(
    "boundary3-2.45.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 268435455 ORDER BY t2.a"
    ,{3, 7, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.45.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 268435455 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 7, 3})

test:do_execsql_test(
    "boundary3-2.45.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=12 ORDER BY t1.rowid"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12})

test:do_execsql_test(
    "boundary3-2.45.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=12 ORDER BY x"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid"
    ,{12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.45.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12})

test:do_execsql_test(
    "boundary3-2.45.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 268435455 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.45.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 268435455 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.45.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=12 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6})

test:do_execsql_test(
    "boundary3-2.45.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.45.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=12 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.45.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6})

test:do_execsql_test(
    "boundary3-2.45.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.45.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 268435455 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 8, 9, 11, 12, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.45.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 268435455 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 12, 11, 9, 8, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.45.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=12 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12})

test:do_execsql_test(
    "boundary3-2.45.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.45.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=12 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.45.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12})

test:do_execsql_test(
    "boundary3-2.45.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=12 ORDER BY t1.rowid DESC"
    ,{12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.46.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-9223372036854775808 AND t2.a=t1.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='8000000000000000'"
    ,{-9223372036854775807LL,55})

test:do_execsql_test(
    "boundary3-2.46.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=55"
    ,{-9223372036854775807LL, "8000000000000000"})

test:do_execsql_test(
    "boundary3-2.46.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -9223372036854775808 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.46.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -9223372036854775808 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.46.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=55 ORDER BY t1.rowid"
    ,{2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.46.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=55 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2})

test:do_execsql_test(
    "boundary3-2.46.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=55 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.46.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -9223372036854775808 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.46.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -9223372036854775808 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.46.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=55 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.46.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=55 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.46.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=55 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.46.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -9223372036854775808 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -9223372036854775808 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=55 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=55 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=55 ORDER BY x"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -9223372036854775808 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -9223372036854775808 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.46.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=55 ORDER BY t1.rowid"
    ,{55})

test:do_execsql_test(
    "boundary3-2.46.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=55 ORDER BY t1.rowid DESC"
    ,{55})

test:do_execsql_test(
    "boundary3-2.46.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=55 ORDER BY x"
    ,{55})

test:do_execsql_test(
    "boundary3-2.47.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=562949953421312 AND t2.a=t1.a"
    ,{43, "0002000000000000"})

test:do_execsql_test(
    "boundary3-2.47.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0002000000000000'"
    ,{562949953421312LL, 43})

test:do_execsql_test(
    "boundary3-2.47.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=43"
    ,{562949953421312LL, "0002000000000000"})

test:do_execsql_test(
    "boundary3-2.47.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 562949953421312 ORDER BY t2.a"
    ,{3, 17, 27, 28, 45})

test:do_execsql_test(
    "boundary3-2.47.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 562949953421312 ORDER BY t1.a DESC"
    ,{45, 28, 27, 17, 3})

test:do_execsql_test(
    "boundary3-2.47.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=43 ORDER BY t1.rowid"
    ,{27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.47.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=43 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27})

test:do_execsql_test(
    "boundary3-2.47.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=43 ORDER BY x"
    ,{27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.47.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 562949953421312 ORDER BY t2.a"
    ,{3, 17, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.47.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 562949953421312 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 17, 3})

test:do_execsql_test(
    "boundary3-2.47.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=43 ORDER BY t1.rowid"
    ,{43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.47.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=43 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43})

test:do_execsql_test(
    "boundary3-2.47.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=43 ORDER BY x"
    ,{43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.47.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 562949953421312 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.47.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 562949953421312 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.47.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=43 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13})

test:do_execsql_test(
    "boundary3-2.47.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=43 ORDER BY t1.rowid DESC"
    ,{13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.47.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=43 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.47.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 562949953421312 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.47.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 562949953421312 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.47.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=43 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43})

test:do_execsql_test(
    "boundary3-2.47.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=43 ORDER BY t1.rowid DESC"
    ,{43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.47.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=43 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.48.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-8388609 AND t2.a=t1.a"
    ,{1, "ffffffffff7fffff"})

test:do_execsql_test(
    "boundary3-2.48.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffffff7fffff'"
    ,{-8388609, 1})

test:do_execsql_test(
    "boundary3-2.48.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=1"
    ,{-8388609, "ffffffffff7fffff"})

test:do_execsql_test(
    "boundary3-2.48.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -8388609 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.48.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -8388609 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.48.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=1 ORDER BY t1.rowid"
    ,{37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.48.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37})

test:do_execsql_test(
    "boundary3-2.48.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=1 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.48.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid"
    ,{37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.48.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37})

test:do_execsql_test(
    "boundary3-2.48.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -8388609 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.48.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -8388609 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.48.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=1 ORDER BY t1.rowid"
    ,{1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.48.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1})

test:do_execsql_test(
    "boundary3-2.48.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=1 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.48.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid"
    ,{1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.48.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1})

test:do_execsql_test(
    "boundary3-2.48.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -8388609 ORDER BY t2.a"
    ,{2, 11, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.48.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -8388609 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 11, 2})

test:do_execsql_test(
    "boundary3-2.48.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=1 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.48.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.48.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=1 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.48.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11})

test:do_execsql_test(
    "boundary3-2.48.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.48.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -8388609 ORDER BY t2.a"
    ,{1, 2, 11, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.48.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -8388609 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.48.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=1 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.48.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.48.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=1 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.48.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1})

test:do_execsql_test(
    "boundary3-2.48.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=1 ORDER BY t1.rowid DESC"
    ,{1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.49.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=16777215 AND t2.a=t1.a"
    ,{9, "0000000000ffffff"})

test:do_execsql_test(
    "boundary3-2.49.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000ffffff'"
    ,{16777215, 9})

test:do_execsql_test(
    "boundary3-2.49.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=9"
    ,{16777215, "0000000000ffffff"})

test:do_execsql_test(
    "boundary3-2.49.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 16777215 ORDER BY t2.a"
    ,{3, 6, 7, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.49.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 16777215 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.49.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=9 ORDER BY t1.rowid"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6})

test:do_execsql_test(
    "boundary3-2.49.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=9 ORDER BY x"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid"
    ,{6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6})

test:do_execsql_test(
    "boundary3-2.49.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 16777215 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.49.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 16777215 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.49.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=9 ORDER BY t1.rowid"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9})

test:do_execsql_test(
    "boundary3-2.49.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=9 ORDER BY x"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.49.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9})

test:do_execsql_test(
    "boundary3-2.49.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 16777215 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.49.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 16777215 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.49.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=9 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24})

test:do_execsql_test(
    "boundary3-2.49.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.49.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=9 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.49.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24})

test:do_execsql_test(
    "boundary3-2.49.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.49.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 16777215 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 9, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.49.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 16777215 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 9, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.49.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=9 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9})

test:do_execsql_test(
    "boundary3-2.49.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.49.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=9 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.49.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9})

test:do_execsql_test(
    "boundary3-2.49.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=9 ORDER BY t1.rowid DESC"
    ,{9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.50.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=8388608 AND t2.a=t1.a"
    ,{24, "0000000000800000"})

test:do_execsql_test(
    "boundary3-2.50.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000800000'"
    ,{8388608, 24})

test:do_execsql_test(
    "boundary3-2.50.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=24"
    ,{8388608, "0000000000800000"})

test:do_execsql_test(
    "boundary3-2.50.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 8388608 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 19, 20, 22, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.50.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 8388608 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 22, 20, 19, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.50.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=24 ORDER BY t1.rowid"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9})

test:do_execsql_test(
    "boundary3-2.50.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=24 ORDER BY x"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid"
    ,{9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9})

test:do_execsql_test(
    "boundary3-2.50.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 8388608 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.50.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 8388608 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.50.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=24 ORDER BY t1.rowid"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24})

test:do_execsql_test(
    "boundary3-2.50.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=24 ORDER BY x"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid"
    ,{24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.50.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24})

test:do_execsql_test(
    "boundary3-2.50.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 8388608 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 18, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.50.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 8388608 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 18, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.50.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=24 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18})

test:do_execsql_test(
    "boundary3-2.50.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.50.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=24 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.50.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18})

test:do_execsql_test(
    "boundary3-2.50.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.50.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 8388608 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 18, 21, 23, 24, 29, 30, 31, 32, 33, 37, 38, 41, 42, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.50.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 8388608 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 42, 41, 38, 37, 33, 32, 31, 30, 29, 24, 23, 21, 18, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.50.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=24 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24})

test:do_execsql_test(
    "boundary3-2.50.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.50.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=24 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.50.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24})

test:do_execsql_test(
    "boundary3-2.50.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=24 ORDER BY t1.rowid DESC"
    ,{24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.51.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=16383 AND t2.a=t1.a"
    ,{8, "0000000000003fff"})

test:do_execsql_test(
    "boundary3-2.51.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000003fff'"
    ,{16383, 8})

test:do_execsql_test(
    "boundary3-2.51.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=8"
    ,{16383, "0000000000003fff"})

test:do_execsql_test(
    "boundary3-2.51.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 16383 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.51.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 16383 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.51.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=8 ORDER BY t1.rowid"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16})

test:do_execsql_test(
    "boundary3-2.51.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=8 ORDER BY x"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid"
    ,{16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16})

test:do_execsql_test(
    "boundary3-2.51.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 16383 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.51.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 16383 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.51.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=8 ORDER BY t1.rowid"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8})

test:do_execsql_test(
    "boundary3-2.51.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=8 ORDER BY x"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid"
    ,{8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.51.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8})

test:do_execsql_test(
    "boundary3-2.51.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 16383 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.51.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 16383 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.51.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=8 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61})

test:do_execsql_test(
    "boundary3-2.51.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.51.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=8 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.51.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61})

test:do_execsql_test(
    "boundary3-2.51.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.51.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 16383 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.51.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 16383 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.51.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=8 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8})

test:do_execsql_test(
    "boundary3-2.51.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.51.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=8 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.51.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8})

test:do_execsql_test(
    "boundary3-2.51.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=8 ORDER BY t1.rowid DESC"
    ,{8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.52.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=140737488355328 AND t2.a=t1.a"
    ,{34, "0000800000000000"})

test:do_execsql_test(
    "boundary3-2.52.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000800000000000'"
    ,{140737488355328LL, 34})

test:do_execsql_test(
    "boundary3-2.52.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=34"
    ,{140737488355328LL, "0000800000000000"})

test:do_execsql_test(
    "boundary3-2.52.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 140737488355328 ORDER BY t2.a"
    ,{3, 10, 13, 17, 26, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.52.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 140737488355328 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 26, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.52.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=34 ORDER BY t1.rowid"
    ,{10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.52.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=34 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10})

test:do_execsql_test(
    "boundary3-2.52.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=34 ORDER BY x"
    ,{10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.52.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 140737488355328 ORDER BY t2.a"
    ,{3, 10, 13, 17, 26, 27, 28, 34, 43, 45})

test:do_execsql_test(
    "boundary3-2.52.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 140737488355328 ORDER BY t1.a DESC"
    ,{45, 43, 34, 28, 27, 26, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.52.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=34 ORDER BY t1.rowid"
    ,{34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.52.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=34 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34})

test:do_execsql_test(
    "boundary3-2.52.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=34 ORDER BY x"
    ,{34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.52.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 140737488355328 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.52.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 140737488355328 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.52.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=34 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25})

test:do_execsql_test(
    "boundary3-2.52.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=34 ORDER BY t1.rowid DESC"
    ,{25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.52.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=34 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.52.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 140737488355328 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.52.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 140737488355328 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.52.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=34 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34})

test:do_execsql_test(
    "boundary3-2.52.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=34 ORDER BY t1.rowid DESC"
    ,{34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.52.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=34 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.53.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=2097151 AND t2.a=t1.a"
    ,{15, "00000000001fffff"})

test:do_execsql_test(
    "boundary3-2.53.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00000000001fffff'"
    ,{2097151, 15})

test:do_execsql_test(
    "boundary3-2.53.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=15"
    ,{2097151, "00000000001fffff"})

test:do_execsql_test(
    "boundary3-2.53.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 2097151 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.53.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 2097151 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.53.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=15 ORDER BY t1.rowid"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42})

test:do_execsql_test(
    "boundary3-2.53.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=15 ORDER BY x"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid"
    ,{42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42})

test:do_execsql_test(
    "boundary3-2.53.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 2097151 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 51, 56, 57})

test:do_execsql_test(
    "boundary3-2.53.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 2097151 ORDER BY t1.a DESC"
    ,{57, 56, 51, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.53.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=15 ORDER BY t1.rowid"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15})

test:do_execsql_test(
    "boundary3-2.53.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=15 ORDER BY x"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid"
    ,{15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.53.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15})

test:do_execsql_test(
    "boundary3-2.53.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 2097151 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.53.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 2097151 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.53.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=15 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62})

test:do_execsql_test(
    "boundary3-2.53.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.53.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=15 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.53.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62})

test:do_execsql_test(
    "boundary3-2.53.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.53.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 2097151 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 15, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 48, 49, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.53.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 2097151 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 55, 54, 53, 52, 50, 49, 48, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 15, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.53.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=15 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15})

test:do_execsql_test(
    "boundary3-2.53.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.53.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=15 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.53.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15})

test:do_execsql_test(
    "boundary3-2.53.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=15 ORDER BY t1.rowid DESC"
    ,{15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.54.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=140737488355327 AND t2.a=t1.a"
    ,{25, "00007fffffffffff"})

test:do_execsql_test(
    "boundary3-2.54.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='00007fffffffffff'"
    ,{140737488355327LL, 25})

test:do_execsql_test(
    "boundary3-2.54.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=25"
    ,{140737488355327LL, "00007fffffffffff"})

test:do_execsql_test(
    "boundary3-2.54.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 140737488355327 ORDER BY t2.a"
    ,{3, 10, 13, 17, 26, 27, 28, 34, 43, 45})

test:do_execsql_test(
    "boundary3-2.54.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 140737488355327 ORDER BY t1.a DESC"
    ,{45, 43, 34, 28, 27, 26, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.54.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=25 ORDER BY t1.rowid"
    ,{34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.54.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=25 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34})

test:do_execsql_test(
    "boundary3-2.54.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=25 ORDER BY x"
    ,{34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.54.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 140737488355327 ORDER BY t2.a"
    ,{3, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45})

test:do_execsql_test(
    "boundary3-2.54.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 140737488355327 ORDER BY t1.a DESC"
    ,{45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.54.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=25 ORDER BY t1.rowid"
    ,{25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.54.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=25 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25})

test:do_execsql_test(
    "boundary3-2.54.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=25 ORDER BY x"
    ,{25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.54.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 140737488355327 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.54.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 140737488355327 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.54.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=25 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56})

test:do_execsql_test(
    "boundary3-2.54.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=25 ORDER BY t1.rowid DESC"
    ,{56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.54.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=25 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.54.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 140737488355327 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.54.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 140737488355327 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.54.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=25 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25})

test:do_execsql_test(
    "boundary3-2.54.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=25 ORDER BY t1.rowid DESC"
    ,{25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.54.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=25 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.55.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=281474976710656 AND t2.a=t1.a"
    ,{26, "0001000000000000"})

test:do_execsql_test(
    "boundary3-2.55.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0001000000000000'"
    ,{281474976710656LL, 26})

test:do_execsql_test(
    "boundary3-2.55.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=26"
    ,{281474976710656LL, "0001000000000000"})

test:do_execsql_test(
    "boundary3-2.55.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 281474976710656 ORDER BY t2.a"
    ,{3, 13, 17, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.55.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 281474976710656 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 17, 13, 3})

test:do_execsql_test(
    "boundary3-2.55.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=26 ORDER BY t1.rowid"
    ,{13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.55.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=26 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13})

test:do_execsql_test(
    "boundary3-2.55.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=26 ORDER BY x"
    ,{13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.55.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 281474976710656 ORDER BY t2.a"
    ,{3, 13, 17, 26, 27, 28, 43, 45})

test:do_execsql_test(
    "boundary3-2.55.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 281474976710656 ORDER BY t1.a DESC"
    ,{45, 43, 28, 27, 26, 17, 13, 3})

test:do_execsql_test(
    "boundary3-2.55.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=26 ORDER BY t1.rowid"
    ,{26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.55.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=26 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26})

test:do_execsql_test(
    "boundary3-2.55.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=26 ORDER BY x"
    ,{26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.55.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 281474976710656 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.55.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 281474976710656 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.55.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=26 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10})

test:do_execsql_test(
    "boundary3-2.55.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=26 ORDER BY t1.rowid DESC"
    ,{10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.55.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=26 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.55.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 281474976710656 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.55.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 281474976710656 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.55.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=26 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26})

test:do_execsql_test(
    "boundary3-2.55.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=26 ORDER BY t1.rowid DESC"
    ,{26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.55.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=26 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.56.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=32767 AND t2.a=t1.a"
    ,{23, "0000000000007fff"})

test:do_execsql_test(
    "boundary3-2.56.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000007fff'"
    ,{32767, 23})

test:do_execsql_test(
    "boundary3-2.56.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=23"
    ,{32767, "0000000000007fff"})

test:do_execsql_test(
    "boundary3-2.56.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 32767 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.56.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 32767 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.56.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=23 ORDER BY t1.rowid"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50})

test:do_execsql_test(
    "boundary3-2.56.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=23 ORDER BY x"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid"
    ,{50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50})

test:do_execsql_test(
    "boundary3-2.56.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 32767 ORDER BY t2.a"
    ,{3, 6, 7, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 50, 51, 56, 57, 62})

test:do_execsql_test(
    "boundary3-2.56.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 32767 ORDER BY t1.a DESC"
    ,{62, 57, 56, 51, 50, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 15, 14, 13, 12, 10, 9, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.56.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=23 ORDER BY t1.rowid"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23})

test:do_execsql_test(
    "boundary3-2.56.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=23 ORDER BY x"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid"
    ,{23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.56.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23})

test:do_execsql_test(
    "boundary3-2.56.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 32767 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.56.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 32767 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.56.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=23 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16})

test:do_execsql_test(
    "boundary3-2.56.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.56.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=23 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.56.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16})

test:do_execsql_test(
    "boundary3-2.56.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.56.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 32767 ORDER BY t2.a"
    ,{1, 2, 4, 5, 8, 11, 16, 21, 23, 29, 30, 31, 32, 33, 37, 38, 41, 44, 47, 49, 52, 53, 54, 55, 58, 59, 60, 61, 63, 64})

test:do_execsql_test(
    "boundary3-2.56.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 32767 ORDER BY t1.a DESC"
    ,{64, 63, 61, 60, 59, 58, 55, 54, 53, 52, 49, 47, 44, 41, 38, 37, 33, 32, 31, 30, 29, 23, 21, 16, 11, 8, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.56.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=23 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23})

test:do_execsql_test(
    "boundary3-2.56.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.56.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=23 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.56.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23})

test:do_execsql_test(
    "boundary3-2.56.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=23 ORDER BY t1.rowid DESC"
    ,{23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.57.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=127 AND t2.a=t1.a"
    ,{4, "000000000000007f"})

test:do_execsql_test(
    "boundary3-2.57.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='000000000000007f'"
    ,{127, 4})

test:do_execsql_test(
    "boundary3-2.57.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=4"
    ,{127, "000000000000007f"})

test:do_execsql_test(
    "boundary3-2.57.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 127 ORDER BY t2.a"
    ,{3, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.57.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 127 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 3})

test:do_execsql_test(
    "boundary3-2.57.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=4 ORDER BY t1.rowid"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49})

test:do_execsql_test(
    "boundary3-2.57.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=4 ORDER BY x"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid"
    ,{49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49})

test:do_execsql_test(
    "boundary3-2.57.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 127 ORDER BY t2.a"
    ,{3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.57.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 127 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 4, 3})

test:do_execsql_test(
    "boundary3-2.57.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=4 ORDER BY t1.rowid"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4})

test:do_execsql_test(
    "boundary3-2.57.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=4 ORDER BY x"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid"
    ,{4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.57.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4})

test:do_execsql_test(
    "boundary3-2.57.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 127 ORDER BY t2.a"
    ,{1, 2, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.57.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 127 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 2, 1})

test:do_execsql_test(
    "boundary3-2.57.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=4 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31})

test:do_execsql_test(
    "boundary3-2.57.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.57.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=4 ORDER BY x"
    ,{59, 60, 41, 5, 31, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.57.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31})

test:do_execsql_test(
    "boundary3-2.57.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.57.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 127 ORDER BY t2.a"
    ,{1, 2, 4, 5, 11, 21, 29, 31, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.57.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 127 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 31, 29, 21, 11, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.57.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=4 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4})

test:do_execsql_test(
    "boundary3-2.57.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.57.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=4 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.57.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4})

test:do_execsql_test(
    "boundary3-2.57.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=4 ORDER BY t1.rowid DESC"
    ,{4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.58.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=36028797018963967 AND t2.a=t1.a"
    ,{27, "007fffffffffffff"})

test:do_execsql_test(
    "boundary3-2.58.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='007fffffffffffff'"
    ,{36028797018963967LL, 27})

test:do_execsql_test(
    "boundary3-2.58.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=27"
    ,{36028797018963967LL, "007fffffffffffff"})

test:do_execsql_test(
    "boundary3-2.58.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 36028797018963967 ORDER BY t2.a"
    ,{3, 17, 28, 45})

test:do_execsql_test(
    "boundary3-2.58.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 36028797018963967 ORDER BY t1.a DESC"
    ,{45, 28, 17, 3})

test:do_execsql_test(
    "boundary3-2.58.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=27 ORDER BY t1.rowid"
    ,{45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.58.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=27 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45})

test:do_execsql_test(
    "boundary3-2.58.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=27 ORDER BY x"
    ,{45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.58.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 36028797018963967 ORDER BY t2.a"
    ,{3, 17, 27, 28, 45})

test:do_execsql_test(
    "boundary3-2.58.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 36028797018963967 ORDER BY t1.a DESC"
    ,{45, 28, 27, 17, 3})

test:do_execsql_test(
    "boundary3-2.58.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=27 ORDER BY t1.rowid"
    ,{27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.58.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=27 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27})

test:do_execsql_test(
    "boundary3-2.58.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=27 ORDER BY x"
    ,{27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.58.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 36028797018963967 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.58.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 36028797018963967 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.58.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=27 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43})

test:do_execsql_test(
    "boundary3-2.58.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=27 ORDER BY t1.rowid DESC"
    ,{43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.58.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=27 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.58.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 36028797018963967 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.58.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 36028797018963967 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.58.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=27 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27})

test:do_execsql_test(
    "boundary3-2.58.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=27 ORDER BY t1.rowid DESC"
    ,{27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.58.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=27 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.59.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=4398046511104 AND t2.a=t1.a"
    ,{56, "0000040000000000"})

test:do_execsql_test(
    "boundary3-2.59.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000040000000000'"
    ,{4398046511104, 56})

test:do_execsql_test(
    "boundary3-2.59.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=56"
    ,{4398046511104, "0000040000000000"})

test:do_execsql_test(
    "boundary3-2.59.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 4398046511104 ORDER BY t2.a"
    ,{3, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45})

test:do_execsql_test(
    "boundary3-2.59.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 4398046511104 ORDER BY t1.a DESC"
    ,{45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.59.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=56 ORDER BY t1.rowid"
    ,{25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25})

test:do_execsql_test(
    "boundary3-2.59.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=56 ORDER BY x"
    ,{25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid"
    ,{25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25})

test:do_execsql_test(
    "boundary3-2.59.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 4398046511104 ORDER BY t2.a"
    ,{3, 10, 13, 17, 25, 26, 27, 28, 34, 43, 45, 56})

test:do_execsql_test(
    "boundary3-2.59.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 4398046511104 ORDER BY t1.a DESC"
    ,{56, 45, 43, 34, 28, 27, 26, 25, 17, 13, 10, 3})

test:do_execsql_test(
    "boundary3-2.59.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=56 ORDER BY t1.rowid"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56})

test:do_execsql_test(
    "boundary3-2.59.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=56 ORDER BY x"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid"
    ,{56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.59.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56})

test:do_execsql_test(
    "boundary3-2.59.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 4398046511104 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.59.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 4398046511104 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.59.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=56 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7})

test:do_execsql_test(
    "boundary3-2.59.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.59.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=56 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.59.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7})

test:do_execsql_test(
    "boundary3-2.59.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.59.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 4398046511104 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.59.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 4398046511104 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 12, 11, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.59.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=56 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56})

test:do_execsql_test(
    "boundary3-2.59.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.59.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=56 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.59.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56})

test:do_execsql_test(
    "boundary3-2.59.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=56 ORDER BY t1.rowid DESC"
    ,{56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.60.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=1 AND t2.a=t1.a"
    ,{60, "0000000000000001"})

test:do_execsql_test(
    "boundary3-2.60.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000001'"
    ,{1, 60})

test:do_execsql_test(
    "boundary3-2.60.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=60"
    ,{1, "0000000000000001"})

test:do_execsql_test(
    "boundary3-2.60.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 1 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.60.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 1 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.60.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=60 ORDER BY t1.rowid"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41})

test:do_execsql_test(
    "boundary3-2.60.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=60 ORDER BY x"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid"
    ,{41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41})

test:do_execsql_test(
    "boundary3-2.60.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 1 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.60.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 1 ORDER BY t1.a DESC"
    ,{62, 61, 60, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.60.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=60 ORDER BY t1.rowid"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60})

test:do_execsql_test(
    "boundary3-2.60.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=60 ORDER BY x"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid"
    ,{60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.60.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60})

test:do_execsql_test(
    "boundary3-2.60.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 1 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 59, 63, 64})

test:do_execsql_test(
    "boundary3-2.60.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 1 ORDER BY t1.a DESC"
    ,{64, 63, 59, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.60.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=60 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59})

test:do_execsql_test(
    "boundary3-2.60.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.60.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=60 ORDER BY x"
    ,{59, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.60.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59})

test:do_execsql_test(
    "boundary3-2.60.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.60.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 1 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.60.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 1 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.60.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=60 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60})

test:do_execsql_test(
    "boundary3-2.60.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.60.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=60 ORDER BY x"
    ,{59, 60, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.60.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60})

test:do_execsql_test(
    "boundary3-2.60.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=60 ORDER BY t1.rowid DESC"
    ,{60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.61.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=36028797018963968 AND t2.a=t1.a"
    ,{45, "0080000000000000"})

test:do_execsql_test(
    "boundary3-2.61.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0080000000000000'"
    ,{36028797018963968LL, 45})

test:do_execsql_test(
    "boundary3-2.61.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=45"
    ,{36028797018963968LL, "0080000000000000"})

test:do_execsql_test(
    "boundary3-2.61.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 36028797018963968 ORDER BY t2.a"
    ,{3, 17, 28})

test:do_execsql_test(
    "boundary3-2.61.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 36028797018963968 ORDER BY t1.a DESC"
    ,{28, 17, 3})

test:do_execsql_test(
    "boundary3-2.61.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=45 ORDER BY t1.rowid"
    ,{17, 28, 3})

test:do_execsql_test(
    "boundary3-2.61.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=45 ORDER BY t1.rowid DESC"
    ,{3, 28, 17})

test:do_execsql_test(
    "boundary3-2.61.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=45 ORDER BY x"
    ,{17, 28, 3})

test:do_execsql_test(
    "boundary3-2.61.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 36028797018963968 ORDER BY t2.a"
    ,{3, 17, 28, 45})

test:do_execsql_test(
    "boundary3-2.61.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 36028797018963968 ORDER BY t1.a DESC"
    ,{45, 28, 17, 3})

test:do_execsql_test(
    "boundary3-2.61.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=45 ORDER BY t1.rowid"
    ,{45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.61.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=45 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45})

test:do_execsql_test(
    "boundary3-2.61.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=45 ORDER BY x"
    ,{45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.61.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 36028797018963968 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.61.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 36028797018963968 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.61.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=45 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27})

test:do_execsql_test(
    "boundary3-2.61.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=45 ORDER BY t1.rowid DESC"
    ,{27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.61.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=45 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.61.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 36028797018963968 ORDER BY t2.a"
    ,{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.61.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 36028797018963968 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1})

test:do_execsql_test(
    "boundary3-2.61.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=45 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45})

test:do_execsql_test(
    "boundary3-2.61.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=45 ORDER BY t1.rowid DESC"
    ,{45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.61.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=45 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.62.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-2147483649 AND t2.a=t1.a"
    ,{47, "ffffffff7fffffff"})

test:do_execsql_test(
    "boundary3-2.62.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ffffffff7fffffff'"
    ,{-2147483649, 47})

test:do_execsql_test(
    "boundary3-2.62.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=47"
    ,{-2147483649, "ffffffff7fffffff"})

test:do_execsql_test(
    "boundary3-2.62.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -2147483649 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.62.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -2147483649 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.62.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=47 ORDER BY t1.rowid"
    ,{11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.62.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11})

test:do_execsql_test(
    "boundary3-2.62.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=47 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.62.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid"
    ,{11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.62.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11})

test:do_execsql_test(
    "boundary3-2.62.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -2147483649 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 59, 60, 61, 62})

test:do_execsql_test(
    "boundary3-2.62.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -2147483649 ORDER BY t1.a DESC"
    ,{62, 61, 60, 59, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.62.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=47 ORDER BY t1.rowid"
    ,{47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.62.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47})

test:do_execsql_test(
    "boundary3-2.62.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=47 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.62.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid"
    ,{47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.62.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47})

test:do_execsql_test(
    "boundary3-2.62.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -2147483649 ORDER BY t2.a"
    ,{2, 21, 44, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.62.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -2147483649 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.62.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=47 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.62.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.62.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=47 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.62.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63})

test:do_execsql_test(
    "boundary3-2.62.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.62.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -2147483649 ORDER BY t2.a"
    ,{2, 21, 44, 47, 55, 58, 63, 64})

test:do_execsql_test(
    "boundary3-2.62.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -2147483649 ORDER BY t1.a DESC"
    ,{64, 63, 58, 55, 47, 44, 21, 2})

test:do_execsql_test(
    "boundary3-2.62.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=47 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.62.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.62.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=47 ORDER BY x"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.62.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47})

test:do_execsql_test(
    "boundary3-2.62.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=47 ORDER BY t1.rowid DESC"
    ,{47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.63.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=-36028797018963969 AND t2.a=t1.a"
    ,{2, "ff7fffffffffffff"})

test:do_execsql_test(
    "boundary3-2.63.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='ff7fffffffffffff'"
    ,{-36028797018963969LL, 2})

test:do_execsql_test(
    "boundary3-2.63.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=2"
    ,{-36028797018963969LL, "ff7fffffffffffff"})

test:do_execsql_test(
    "boundary3-2.63.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -36028797018963969 ORDER BY t2.a"
    ,{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.63.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -36028797018963969 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1})

test:do_execsql_test(
    "boundary3-2.63.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=2 ORDER BY t1.rowid"
    ,{64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.63.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=2 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64})

test:do_execsql_test(
    "boundary3-2.63.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=2 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.63.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -36028797018963969 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.63.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -36028797018963969 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.63.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=2 ORDER BY t1.rowid"
    ,{2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.63.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=2 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2})

test:do_execsql_test(
    "boundary3-2.63.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=2 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.63.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -36028797018963969 ORDER BY t2.a"
    ,{55})

test:do_execsql_test(
    "boundary3-2.63.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -36028797018963969 ORDER BY t1.a DESC"
    ,{55})

test:do_execsql_test(
    "boundary3-2.63.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=2 ORDER BY t1.rowid"
    ,{55})

test:do_execsql_test(
    "boundary3-2.63.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=2 ORDER BY t1.rowid DESC"
    ,{55})

test:do_execsql_test(
    "boundary3-2.63.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=2 ORDER BY x"
    ,{55})

test:do_execsql_test(
    "boundary3-2.63.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -36028797018963969 ORDER BY t2.a"
    ,{2, 55})

test:do_execsql_test(
    "boundary3-2.63.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -36028797018963969 ORDER BY t1.a DESC"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.63.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=2 ORDER BY t1.rowid"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.63.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=2 ORDER BY t1.rowid DESC"
    ,{2, 55})

test:do_execsql_test(
    "boundary3-2.63.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=2 ORDER BY x"
    ,{55, 2})

test:do_execsql_test(
    "boundary3-2.64.1",
    "SELECT t1.a, t1.x FROM  t1, t2 WHERE t1.rowid=3 AND t2.a=t1.a"
    ,{5, "0000000000000003"})

test:do_execsql_test(
    "boundary3-2.64.2",
    "SELECT t2.* FROM t1 JOIN t2 USING(a) WHERE x='0000000000000003'"
    ,{3, 5})

test:do_execsql_test(
    "boundary3-2.64.3",
    "SELECT t1.rowid, t1.x FROM  t1 JOIN t2 ON t2.r=t1.rowid WHERE t2.a=5"
    ,{3, "0000000000000003"})

test:do_execsql_test(
    "boundary3-2.64.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 3 ORDER BY t2.a"
    ,{3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.64.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 3 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 4, 3})

test:do_execsql_test(
    "boundary3-2.64.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=5 ORDER BY t1.rowid"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31})

test:do_execsql_test(
    "boundary3-2.64.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=5 ORDER BY x"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.gt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid"
    ,{31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.gt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31})

test:do_execsql_test(
    "boundary3-2.64.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 3 ORDER BY t2.a"
    ,{3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 30, 31, 34, 35, 36, 39, 40, 42, 43, 45, 46, 48, 49, 50, 51, 56, 57, 61, 62})

test:do_execsql_test(
    "boundary3-2.64.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 3 ORDER BY t1.a DESC"
    ,{62, 61, 57, 56, 51, 50, 49, 48, 46, 45, 43, 42, 40, 39, 36, 35, 34, 31, 30, 28, 27, 26, 25, 24, 23, 22, 20, 19, 18, 17, 16, 15, 14, 13, 12, 10, 9, 8, 7, 6, 5, 4, 3})

test:do_execsql_test(
    "boundary3-2.64.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=5 ORDER BY t1.rowid"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5})

test:do_execsql_test(
    "boundary3-2.64.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=5 ORDER BY x"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.ge.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid"
    ,{5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.64.ge.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5})

test:do_execsql_test(
    "boundary3-2.64.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 3 ORDER BY t2.a"
    ,{1, 2, 11, 21, 29, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.64.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 3 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 29, 21, 11, 2, 1})

test:do_execsql_test(
    "boundary3-2.64.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=5 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41})

test:do_execsql_test(
    "boundary3-2.64.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.64.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=5 ORDER BY x"
    ,{59, 60, 41, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.64.lt.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41})

test:do_execsql_test(
    "boundary3-2.64.lt.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.64.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 3 ORDER BY t2.a"
    ,{1, 2, 5, 11, 21, 29, 32, 33, 37, 38, 41, 44, 47, 52, 53, 54, 55, 58, 59, 60, 63, 64})

test:do_execsql_test(
    "boundary3-2.64.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 3 ORDER BY t1.a DESC"
    ,{64, 63, 60, 59, 58, 55, 54, 53, 52, 47, 44, 41, 38, 37, 33, 32, 29, 21, 11, 5, 2, 1})

test:do_execsql_test(
    "boundary3-2.64.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=5 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5})

test:do_execsql_test(
    "boundary3-2.64.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.64.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=5 ORDER BY x"
    ,{59, 60, 41, 5, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.64.le.10",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5})

test:do_execsql_test(
    "boundary3-2.64.le.11",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= CAST(t2.r AS NUMBER) WHERE t2.a=5 ORDER BY t1.rowid DESC"
    ,{5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.65.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > 9.22337303685477580800e+18 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > 9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=65 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=65 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=65 ORDER BY x"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= 9.22337303685477580800e+18 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= 9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=65 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=65 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=65 ORDER BY x"
    ,{})

test:do_execsql_test(
    "boundary3-2.65.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < 9.22337303685477580800e+18 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.65.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < 9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.65.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=65 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.65.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=65 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.65.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=65 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.65.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= 9.22337303685477580800e+18 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.65.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= 9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.65.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=65 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.65.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=65 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.65.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=65 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.66.gt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid > -9.22337303685477580800e+18 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.66.gt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid > -9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.66.gt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=66 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.66.gt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=66 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.66.gt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid > t2.r WHERE t2.a=66 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.66.ge.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid >= -9.22337303685477580800e+18 ORDER BY t2.a"
    ,{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64})

test:do_execsql_test(
    "boundary3-2.66.ge.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid >= -9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1})

test:do_execsql_test(
    "boundary3-2.66.ge.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=66 ORDER BY t1.rowid"
    ,{55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38, 59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3})

test:do_execsql_test(
    "boundary3-2.66.ge.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=66 ORDER BY t1.rowid DESC"
    ,{3, 28, 17, 45, 27, 43, 13, 26, 10, 34, 25, 56, 7, 19, 57, 35, 46, 22, 39, 36, 14, 51, 20, 40, 12, 6, 9, 24, 18, 42, 15, 62, 48, 50, 23, 16, 8, 61, 30, 49, 4, 31, 5, 41, 60, 59, 38, 33, 52, 53, 54, 32, 29, 37, 1, 11, 47, 63, 58, 44, 21, 64, 2, 55})

test:do_execsql_test(
    "boundary3-2.66.ge.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid >= t2.r WHERE t2.a=66 ORDER BY x"
    ,{59, 60, 41, 5, 31, 4, 49, 30, 61, 8, 16, 23, 50, 48, 62, 15, 42, 18, 24, 9, 6, 12, 40, 20, 51, 14, 36, 39, 22, 46, 35, 57, 19, 7, 56, 25, 34, 10, 26, 13, 43, 27, 45, 17, 28, 3, 55, 2, 64, 21, 44, 58, 63, 47, 11, 1, 37, 29, 32, 54, 53, 52, 33, 38})

test:do_execsql_test(
    "boundary3-2.66.lt.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid < -9.22337303685477580800e+18 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.lt.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid < -9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.lt.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=66 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.lt.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=66 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.lt.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid < t2.r WHERE t2.a=66 ORDER BY x"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.le.1",
    "SELECT t2.a FROM t1 JOIN t2 USING(a) WHERE t1.rowid <= -9.22337303685477580800e+18 ORDER BY t2.a"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.le.2",
    "SELECT t2.a FROM t2 NATURAL JOIN t1 WHERE t1.rowid <= -9.22337303685477580800e+18 ORDER BY t1.a DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.le.3",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=66 ORDER BY t1.rowid"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.le.4",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=66 ORDER BY t1.rowid DESC"
    ,{})

test:do_execsql_test(
    "boundary3-2.66.le.5",
    "SELECT t1.a FROM  t1 JOIN t2 ON t1.rowid <= t2.r WHERE t2.a=66 ORDER BY x"
    ,{})

test:finish_test()
