/* fifo.h */

#ifndef FIFO_H_INCLUDED
#define FIFO_H_INCLUDED


#define FIFO_MAGIC "674m"

#define FIFO_FILE_INFO		1
#define FIFO_END		2
#define FIFO_ERROR		3

#define FIFO_FILE		4
#define FIFO_DISK_FULL		5
#define FIFO_CHILD_OK		6
#define FIFO_NO_CHILD		7
#define FIFO_ERROR_WITH_FILE	8

#define fifo_disk_full (&fifo_disk_full_c)


extern char fifo_disk_full_c;

void fifo_send_file_with_info (FILE *fdfifo, const struct file_info *fi,
	const char *file_name, const char *temp_name);
void fifo_send_end (FILE *fdfifo);
void fifo_send_error (FILE *fdfifo);
int fifo_receive_file_with_info (FILE *fdfifo, struct file_info *fi,
	char **file_name, char **temp_name);

void fifo_send_file (FILE *fdfifo, const char *file_name,
	const char *compressed_name);
void fifo_send_error_with_file (FILE *fdfifo, const char *file_name);
void fifo_send_disk_full (FILE *fdfifo);
void fifo_send_child_ok (FILE *fdfifo);
void fifo_send_no_child (FILE *fdfifo);
int fifo_receive_child_status (FILE *fdfifo);
int fifo_receive_file (FILE *fdfifo, char **file_name, char **compressed_name);

#endif
