   var dialogParams, gHideElmParam, gSavedName, gCancelLabel, gOrigName;

   function prompt_init() {
      dialogParams = window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
      document.title = dialogParams.GetString(0);

      // display the main text
      var i, messageText = dialogParams.GetString(1);
      var messageParent = document.getElementById("tm_info");
      var messageParagraphs = messageText.split("\n");
      gHideElmParam = dialogParams.GetInt(1);
      for (i = 0; i < messageParagraphs.length; i++) {
         var descriptionNode = document.createElement("description");
         var text = document.createTextNode(messageParagraphs[i]);
         descriptionNode.appendChild(text);
         messageParent.appendChild(descriptionNode);
      }

      // display the menulist
      gHideElmParam = dialogParams.GetInt(1);
      var menuList = document.getElementById("tm_prompt");
      if (gHideElmParam == SHOW_MENULIST) {
         var index, isDisabled, popup = document.getElementById("tm_prompt_menu");
         SessionManager.createMenuForDialog(popup, dialogParams.GetInt(3));
         switch ( dialogParams.GetInt(3) ) {
            case SELECT_CRASH: index = popup.childNodes.length - 1;
               break;
            case SHOW_CLOSED_WINDOW_LIST: index = 1; // 0 is menuseparator
               break;
            default:
               index = menuList.defaultIndex;
               if (index >= popup.childNodes.length || index < 0) index = 1;
               isDisabled = popup.childNodes[index].getAttribute("disabled") == "true";
               // select the first entry that isn't menuseparator and not "disabled"
               if (!isDisabled) break;
               var item;
               for (i = 1; i < popup.childNodes.length; ++i) {
                  item = popup.childNodes[i];
                  if (item.localName == "menuseparator") continue;
                  if (item.getAttribute("disabled") != "true") {
                     index = i;
                     break;
                  }
               }
         }
         menuList.selectedIndex = index;
      } else menuList.hidden = true;

      // display the textBox
      var textBox = document.getElementById("tm_textbox");
      if (gHideElmParam == SHOW_TEXTBOX) {
         messageParent.lastChild.setAttribute("style","height:3em");
         gSavedName = dialogParams.GetString(2).split("\n");
         textBox.value = gSavedName.shift();
         gOrigName = textBox.value.toLowerCase();
      }
      else textBox.hidden = true;

      // display the checkbox
      var checkBox = document.getElementById("tm_checkbox");
      var check = dialogParams.GetInt(2);
      if (check != HIDE_CHECKBOX) {
         document.getElementById("checkboxContainer").removeAttribute("collapsed");
         checkBox.checked = check == CHECKBOX_CHECKED;
         setLabelForNode(checkBox, dialogParams.GetString(3));
      }

      // display the command buttons
      var aButtons, buttons = ["accept", "cancel", "extra1"];
      var btnLabels = dialogParams.GetString(4).split("\n");
      var maxWidth = 0;
      for (i = 0; i < buttons.length; ++i) {
         aButtons = document.documentElement.getButton(buttons[i]);
         if (i < btnLabels.length && btnLabels[i] != "") {
            setLabelForNode(aButtons, btnLabels[i]);
         }
         else aButtons.hidden = true; // hide extra button
      }

      // Set and focus default button
      var dButton = buttons[dialogParams.GetInt(0)];
      var dialog = document.documentElement;
      dialog.defaultButton = dButton;
      if (gHideElmParam == HIDE_MENUANDTEXT) { // hide menulist & text box and set focus to default Button
         document.getElementById("space_befor_checkbox").hidden = true;
         dialog.getButton(dButton).focus();
      }

      if (gHideElmParam == SHOW_TEXTBOX) {
         dialog.getButton("extra1").hidden = true;
         gCancelLabel = dialog.getButton("cancel").label;
         inputText(textBox);
      }
   }

   function prompt_deinit(button) {
      dialogParams.SetInt(4, button); // ok = 0; cancel = 1; extra1 = 2;
      dialogParams.SetInt(5, document.getElementById("tm_checkbox").checked);
      if (gHideElmParam < HIDE_MENUANDTEXT) {
         if (gHideElmParam == SHOW_MENULIST) {
            var item = document.getElementById("tm_prompt").selectedItem;
            dialogParams.SetString(5, item.session);
            dialogParams.SetInt(6, item.getAttribute("value"));
         }
         else dialogParams.SetString(5, document.getElementById("tm_textbox").value);
      }
   }

   function prompt_extra1(button) {
      prompt_deinit(button);
      window.close();
   }

   function inputText(textBox) {
      var btnOK = document.documentElement.getButton("accept");
      var btnCancel = document.documentElement.getButton("cancel");
      var btnExt = document.documentElement.getButton("extra1");
      var msg = [];
      var bundle_session = document.getElementById("bundle_session_manager");
      msg[0] = "";
/*
      var msg1 = "Name must be at least one letter or number."
      var msg2 = "This name already in use!"
      var msg3 = "Are you sure you want to replace the session?"
      var cLabel = "&Don't Replace";
*/
      msg[1] = bundle_session.getString("sm.sessionName.msg1");
      msg[2] = bundle_session.getString("sm.sessionName.msg2");
      msg[3] = msg[2] + ", " + bundle_session.getString("sm.sessionName.msg3");
      var cLabel = SessionManager.setLabel("sm.replaceStartup.button1");

      var description = document.getElementById("tm_info").lastChild.firstChild;
      textBox.value = textBox.value.replace(/^[\s]+/g,"");
      var name = textBox.value.toLowerCase();
      var msgReplace, validName = 0;
      if (name == "") validName = 1;
      if (validName==0) {
         for (var i = 0; i < gSavedName.length; i++) {
            if (name == gSavedName[i].toLowerCase() && gSavedName[i] != "" ) {
               if (dialogParams.GetInt(3) == DLG_RENAME) {
                  if (gOrigName != name) validName = 2;
                  continue;
               }
               validName = 3;
               dialogParams.SetInt(6, i);
               break;
            }
         }
      }
      switch ( validName ) {
         case 0:
            if (btnOK.disabled) btnOK.disabled = false;
            if (btnOK.hidden) btnOK.hidden = false;
            if (!btnExt.hidden) {
               btnExt.hidden = true;
               if (dialogParams.GetInt(3) == DLG_SAVE) setLabelForNode(btnCancel,gCancelLabel);
            }
            description.replaceData(0,description.length, "");
            document.documentElement.defaultButton = "accept";
            break;
         case 1:
         case 2:
            if (btnOK.hidden) btnOK.hidden = false;
            if (!btnOK.disabled) btnOK.disabled = true;
            if (!btnExt.hidden) {
               btnExt.hidden = true;
               if (dialogParams.GetInt(3) == DLG_SAVE) setLabelForNode(btnCancel,gCancelLabel);
            }
            document.documentElement.defaultButton = "cancel";
            break;
         case 3:
            if (!btnOK.hidden) btnOK.hidden = true;
            btnExt.hidden = false;
            if (dialogParams.GetInt(3) == DLG_SAVE) setLabelForNode(btnCancel,cLabel);
            document.documentElement.defaultButton = "cancel";
            break;
      }
      description.replaceData(0,description.length, msg[validName]);
   }

   function TM_PromptService(intParam, strParam, aWindow) {
      var dpb = Components.classes["@mozilla.org/embedcomp/dialogparam;1"]
                          .createInstance(Components.interfaces.nsIDialogParamBlock);
      // intParam[0] - default button accept=0, cancel=1, extra1=2
      // intParam[1] - show menuList= 1 , show textBox= 0, hide_both= 2
      // intParam[2] - set checkbox checked  true=1 , false=0, hide=2
      // intParam[3] - flag  - for menuList contents: flag to set menu selected item
      //                     - for textBox rename: 1 , save: 0
      var i;
      for (i = 0; i < intParam.length; i++)
         dpb.SetInt(i, intParam[i]);
      // strParam labels for: title, msg, testbox.value, checkbox.label, buttons[]
      // buttons[]: labels array for each button
      for (i = 0; i < strParam.length; i++)
         dpb.SetString(i, strParam[i]);

      var ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                           .getService(Components.interfaces.nsIWindowWatcher);
      if (typeof(aWindow) == "undefined") {
         try { aWindow = window;
         }
         catch (e) { aWindow = null;
         }
      }
      ww.openWindow(aWindow,
               "chrome://tabmixplus/content/session/promptservice.xul","",'centerscreen,modal',dpb);
      return {button: dpb.GetInt(4), checked: (dpb.GetInt(5) == CHECKBOX_CHECKED), label: dpb.GetString(5), value: dpb.GetInt(6)};
   }
