# coding: UTF-8
"""
Copyright (c) 2009 Marian Tietz
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
"""

import urwid
import logging

class ExtendedListBox(urwid.ListBox):

	__metaclass__ = urwid.MetaSignals
	signals = ["set_auto_scroll"]

	def set_auto_scroll(self, switch):
		if type(switch) != bool:
			return
		self._auto_scroll = switch
		urwid.emit_signal(self, "set_auto_scroll", switch)

	auto_scroll = property(lambda s: s._auto_scroll, set_auto_scroll)

	def __init__(self, body):
		urwid.ListBox.__init__(self, body)
		self.auto_scroll = True

	def switch_body(self, body):
		if self.body:
			urwid.disconnect_signal(body, "modified", self._invalidate)

		self.body = body
		self._invalidate()

		urwid.connect_signal(body, "modified", self._invalidate)

	def keypress(self, size, key):
		urwid.ListBox.keypress(self, size, key)

		if key in ("page up", "page down"):
			logging.debug("focus = %d, len = %d" % (self.get_focus()[1], len(self.body)))
			if self.get_focus()[1] == len(self.body)-1:
				self.auto_scroll = True
			else:
				self.auto_scroll = False
			logging.debug("auto_scroll = %s" % (self.auto_scroll))

	def scroll_to_bottom(self):
		logging.debug("current_focus = %s, len(self.body) = %d" % (self.get_focus()[1], len(self.body)))

		if self.auto_scroll:
			# at bottom -> scroll down
			self.set_focus(len(self.body))



