/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.ConicProjection;
import java.awt.geom.Point2D;

class STSProjection
extends ConicProjection {
    private double C_x;
    private double C_y;
    private double C_p;
    private boolean tan_mode;

    protected STSProjection(double p, double q, boolean mode) {
        this.es = 0.0;
        this.C_x = q / p;
        this.C_y = p;
        this.C_p = 1.0 / q;
        this.tan_mode = mode;
        this.initialize();
    }

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double xy) {
        xy.x = this.C_x * lplam * Math.cos(lpphi);
        xy.y = this.C_y;
        double c = Math.cos(lpphi *= this.C_p);
        if (this.tan_mode) {
            xy.x *= c * c;
            xy.y *= Math.tan(lpphi);
        } else {
            xy.x /= c;
            xy.y *= Math.sin(lpphi);
        }
        return xy;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double lp) {
        lp.y = this.tan_mode ? Math.atan(xyy) : MapMath.asin(xyy /= this.C_y);
        double c = Math.cos(lp.y);
        lp.y /= this.C_p;
        lp.x = xyx / (this.C_x * Math.cos(lp.y /= this.C_p));
        lp.x = this.tan_mode ? (lp.x /= c * c) : (lp.x *= c);
        return lp;
    }

    public boolean hasInverse() {
        return true;
    }
}

