/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simulation.VehicleType;

public class DlgAddEditVehicleType
extends JDialog {
    private static final long serialVersionUID = 1L;
    private VehicleType currentVehicleType = null;
    private int answer = 2;
    private JButton btnCancel = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private JLabel lblAcceleration = null;
    private JLabel lblDeceleration = null;
    private JLabel lblDriverImperfection = null;
    private JLabel lblLength = null;
    private JLabel lblMaximumSpeed = null;
    private JLabel lblName = null;
    private JTextField txtAcceleration = null;
    private JTextField txtDeceleration = null;
    private JTextField txtDriverImperfection = null;
    private JTextField txtLength = null;
    private JTextField txtMaximumSpeed = null;
    private JTextField txtName = null;
    private JLabel lblMeters = null;
    private JLabel lblMs = null;
    private JLabel lblImp = null;
    private JLabel lblMs2 = null;
    private JLabel lblMs21 = null;

    public DlgAddEditVehicleType(Dialog owner) {
        super(owner);
        this.initialize();
        this.currentVehicleType = null;
        this.setTitle("Create vehicle type");
        this.setVisible(true);
    }

    public DlgAddEditVehicleType(Dialog owner, VehicleType vehicleTypeToEdit) {
        super(owner);
        this.initialize();
        this.currentVehicleType = vehicleTypeToEdit;
        this.txtName.setText(vehicleTypeToEdit.getName());
        this.txtAcceleration.setText(String.valueOf(vehicleTypeToEdit.getAcceleration()));
        this.txtDeceleration.setText(String.valueOf(vehicleTypeToEdit.getDeceleration()));
        this.txtDriverImperfection.setText(String.valueOf(vehicleTypeToEdit.getDriverImperfection()));
        this.txtLength.setText(String.valueOf(vehicleTypeToEdit.getLength()));
        this.txtMaximumSpeed.setText(String.valueOf(vehicleTypeToEdit.getMaximumSpeed()));
        this.setTitle("Edit vehicle type");
        if (vehicleTypeToEdit.getName().equals("Default")) {
            this.DisableDialog();
        }
        this.setVisible(true);
    }

    public int getAnswer() {
        return this.answer;
    }

    public VehicleType getVehicleType() {
        return this.currentVehicleType;
    }

    private void DisableDialog() {
        this.txtName.setEnabled(false);
        this.txtAcceleration.setEnabled(false);
        this.txtDeceleration.setEnabled(false);
        this.txtDriverImperfection.setEnabled(false);
        this.txtMaximumSpeed.setEnabled(false);
        this.txtLength.setEnabled(false);
        this.btnOK.setEnabled(false);
        this.setTitle("Default vehicle type");
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(155, 172, 76, 21));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgAddEditVehicleType.this.Cancel();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(240, 172, 71, 21));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgAddEditVehicleType.this.OK();
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblMs21 = new JLabel();
            this.lblMs21.setBounds(new Rectangle(206, 63, 38, 16));
            this.lblMs21.setText("m/s2");
            this.lblMs2 = new JLabel();
            this.lblMs2.setBounds(new Rectangle(206, 36, 41, 16));
            this.lblMs2.setText("m/s2");
            this.lblImp = new JLabel();
            this.lblImp.setBounds(new Rectangle(206, 91, 38, 16));
            this.lblImp.setText("0-1");
            this.lblMs = new JLabel();
            this.lblMs.setBounds(new Rectangle(206, 117, 38, 16));
            this.lblMs.setText("m/s");
            this.lblMeters = new JLabel();
            this.lblMeters.setBounds(new Rectangle(206, 145, 53, 16));
            this.lblMeters.setText("meters");
            this.lblLength = new JLabel();
            this.lblLength.setBounds(new Rectangle(34, 144, 97, 16));
            this.lblLength.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblLength.setText("Length:");
            this.lblDriverImperfection = new JLabel();
            this.lblDriverImperfection.setBounds(new Rectangle(11, 89, 121, 16));
            this.lblDriverImperfection.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblDriverImperfection.setText("Driver imperfection:");
            this.lblDeceleration = new JLabel();
            this.lblDeceleration.setBounds(new Rectangle(47, 63, 85, 16));
            this.lblDeceleration.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblDeceleration.setText("Deceleration:");
            this.lblAcceleration = new JLabel();
            this.lblAcceleration.setBounds(new Rectangle(49, 37, 83, 16));
            this.lblAcceleration.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblAcceleration.setText("Acceleration:");
            this.lblMaximumSpeed = new JLabel();
            this.lblMaximumSpeed.setBounds(new Rectangle(23, 117, 109, 16));
            this.lblMaximumSpeed.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblMaximumSpeed.setText("Maximum speed:");
            this.lblName = new JLabel();
            this.lblName.setBounds(new Rectangle(48, 9, 84, 18));
            this.lblName.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.lblName.setText("Name:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getTxtName(), null);
            this.jContentPane.add((Component)this.lblName, null);
            this.jContentPane.add((Component)this.lblMaximumSpeed, null);
            this.jContentPane.add((Component)this.lblAcceleration, null);
            this.jContentPane.add((Component)this.lblDeceleration, null);
            this.jContentPane.add((Component)this.lblDriverImperfection, null);
            this.jContentPane.add((Component)this.lblLength, null);
            this.jContentPane.add((Component)this.getTxtAcceleration(), null);
            this.jContentPane.add((Component)this.getTxtDeceleration(), null);
            this.jContentPane.add((Component)this.getTxtDriverImperfection(), null);
            this.jContentPane.add((Component)this.getTxtMaximumSpeed(), null);
            this.jContentPane.add((Component)this.getTxtLength(), null);
            this.jContentPane.add((Component)this.lblMeters, null);
            this.jContentPane.add((Component)this.lblMs, null);
            this.jContentPane.add((Component)this.lblImp, null);
            this.jContentPane.add((Component)this.lblMs2, null);
            this.jContentPane.add((Component)this.lblMs21, null);
        }
        return this.jContentPane;
    }

    private JTextField getTxtAcceleration() {
        if (this.txtAcceleration == null) {
            this.txtAcceleration = new JTextField();
            this.txtAcceleration.setBounds(new Rectangle(139, 35, 61, 20));
        }
        return this.txtAcceleration;
    }

    private JTextField getTxtDeceleration() {
        if (this.txtDeceleration == null) {
            this.txtDeceleration = new JTextField();
            this.txtDeceleration.setBounds(new Rectangle(138, 62, 62, 20));
        }
        return this.txtDeceleration;
    }

    private JTextField getTxtDriverImperfection() {
        if (this.txtDriverImperfection == null) {
            this.txtDriverImperfection = new JTextField();
            this.txtDriverImperfection.setBounds(new Rectangle(138, 89, 64, 20));
        }
        return this.txtDriverImperfection;
    }

    private JTextField getTxtLength() {
        if (this.txtLength == null) {
            this.txtLength = new JTextField();
            this.txtLength.setBounds(new Rectangle(137, 143, 66, 20));
        }
        return this.txtLength;
    }

    private JTextField getTxtMaximumSpeed() {
        if (this.txtMaximumSpeed == null) {
            this.txtMaximumSpeed = new JTextField();
            this.txtMaximumSpeed.setBounds(new Rectangle(138, 116, 65, 20));
        }
        return this.txtMaximumSpeed;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.setBounds(new Rectangle(139, 8, 176, 20));
        }
        return this.txtName;
    }

    private void initialize() {
        this.setSize(332, 233);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setTitle("Vehicle type");
        this.setContentPane(this.getJContentPane());
    }

    protected void Cancel() {
        this.answer = 2;
        this.setVisible(false);
    }

    protected void OK() {
        if (this.txtName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a name");
            return;
        }
        if (this.txtAcceleration.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter the vehicle's acceleration rate");
            return;
        }
        if (this.txtDeceleration.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter the vehicle's deceleration rate");
            return;
        }
        if (this.txtDriverImperfection.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter the driver's imperfection");
            return;
        }
        if (this.txtLength.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter the vehicle's length");
            return;
        }
        if (this.txtMaximumSpeed.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter the vehicle's maximum speed");
            return;
        }
        if (this.currentVehicleType == null) {
            this.currentVehicleType = new VehicleType(this.txtName.getText(), Float.parseFloat(this.txtAcceleration.getText()), Float.parseFloat(this.txtDeceleration.getText()), Float.parseFloat(this.txtDriverImperfection.getText()), Integer.parseInt(this.txtLength.getText()), Integer.parseInt(this.txtMaximumSpeed.getText()));
        } else {
            this.currentVehicleType.setName(this.txtName.getText());
            this.currentVehicleType.setAcceleration(Float.parseFloat(this.txtAcceleration.getText()));
            this.currentVehicleType.setDeceleration(Float.parseFloat(this.txtDeceleration.getText()));
            this.currentVehicleType.setDriverImperfection(Float.parseFloat(this.txtDriverImperfection.getText()));
            this.currentVehicleType.setLength(Integer.parseInt(this.txtLength.getText()));
            this.currentVehicleType.setMaximumSpeed(Integer.parseInt(this.txtMaximumSpeed.getText()));
        }
        this.answer = 0;
        this.setVisible(false);
    }
}

